/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.builder.CreateReleaseTaskBuilder;
import com.xebialabs.xlrelease.builder.CustomScriptTaskBuilder;
import com.xebialabs.xlrelease.builder.DefaultTaskBuilder;
import com.xebialabs.xlrelease.builder.GateTaskBuilder;
import com.xebialabs.xlrelease.builder.NotificationTaskBuilder;
import com.xebialabs.xlrelease.builder.ParallelGroupBuilder;
import com.xebialabs.xlrelease.builder.ScriptTaskBuilder;
import com.xebialabs.xlrelease.builder.SequentialGroupBuilder;
import com.xebialabs.xlrelease.builder.UserInputTaskBuilder;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.recover.PhaseRecoverOp;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class TaskBuilder<T extends Task, S extends TaskBuilder<T, S>> {
    private String id;
    private String title;
    private String precondition;
    private String failureHandler;
    private boolean taskFailureHandlerEnabled;
    private TaskRecoverOp taskRecoverOp;
    private PhaseRecoverOp phaseRecoverOp;
    private TaskStatus status = TaskStatus.PLANNED;
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private String owner;
    private String team;
    private TaskContainer container;
    private String description;
    private Date dueDate;
    private Date scheduledStartDate;
    private Date originalScheduledStartDate;
    private Date startDate;
    private Date endDate;
    private Integer plannedDuration;
    private boolean overdueNotified;
    private boolean dueSoonNotified;
    private List<Comment> comments = Collections.emptyList();
    private boolean waitForScheduledStartDate = true;
    private boolean delayDuringBlackout = false;
    private boolean postponedDueToBlackout = false;
    private List<Attachment> attachments = Lists.newArrayList();
    private int failuresCount = 0;
    private boolean hasBeenDelayed = false;
    private boolean hasBeenFlagged = false;
    private Map<String, String> variableMapping = Maps.newHashMap();
    private List<String> tags = Lists.newArrayList();
    private boolean locked = false;

    public static DefaultTaskBuilder newTask() {
        return new DefaultTaskBuilder();
    }

    public static GateTaskBuilder newGateTask() {
        return new GateTaskBuilder();
    }

    public static NotificationTaskBuilder newNotificationTask() {
        return new NotificationTaskBuilder();
    }

    public static ScriptTaskBuilder newScriptTask() {
        return new ScriptTaskBuilder();
    }

    public static ParallelGroupBuilder newParallelGroup() {
        return new ParallelGroupBuilder();
    }

    public static SequentialGroupBuilder newSequentialGroup() {
        return new SequentialGroupBuilder();
    }

    public static CustomScriptTaskBuilder newCustomScript(String scriptDefinitionType) {
        return new CustomScriptTaskBuilder(scriptDefinitionType);
    }

    public static PythonScript pythonScript(CustomScriptTask task) {
        PythonScript pythonScript = (PythonScript)((Object)task.getProperty("pythonScript"));
        pythonScript.setId(task.getId() + "/" + "PythonScript");
        pythonScript.setCustomScriptTask(task);
        return pythonScript;
    }

    public static CustomScriptTaskBuilder newCustomScript(String scriptDefinitionType, String type) {
        return new CustomScriptTaskBuilder(scriptDefinitionType, type);
    }

    public static UserInputTaskBuilder newUserInputTask() {
        return new UserInputTaskBuilder();
    }

    public static CreateReleaseTaskBuilder newCreateReleaseTask() {
        return new CreateReleaseTaskBuilder();
    }

    protected final S self() {
        return (S)this;
    }

    public S withId(String id) {
        this.id = id;
        return this.self();
    }

    public S withTitle(String title) {
        this.title = title;
        return this.self();
    }

    public S withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this.self();
    }

    public S withStatus(TaskStatus status) {
        this.status = status;
        if (status == TaskStatus.IN_PROGRESS) {
            this.startDate = new Date();
        } else if (status != null && status.isDone()) {
            this.endDate = new Date();
        }
        return this.self();
    }

    public S withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this.self();
    }

    public S withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this.self();
    }

    public S withOwner(String owner) {
        this.owner = owner;
        return this.self();
    }

    public S withTeam(String team) {
        this.team = team;
        return this.self();
    }

    public S withContainer(TaskContainer item) {
        this.container = item;
        return this.self();
    }

    public S withDescription(String description) {
        this.description = description;
        return this.self();
    }

    public S withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this.self();
    }

    public S withStartDate(Date startDate) {
        this.startDate = startDate;
        return this.self();
    }

    public S withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this.self();
    }

    public S withOriginalScheduledStartDate(Date originalScheduledStartDate) {
        this.originalScheduledStartDate = originalScheduledStartDate;
        return this.self();
    }

    public S withEndDate(Date endDate) {
        this.endDate = endDate;
        return this.self();
    }

    public S withPlannedDuration(Integer plannedDuration) {
        this.plannedDuration = plannedDuration;
        return this.self();
    }

    public S withComments(Comment ... comments) {
        this.comments = Lists.newArrayList((Object[])comments);
        return this.self();
    }

    public S withOverdueNotified(boolean isNotified) {
        this.overdueNotified = isNotified;
        return this.self();
    }

    public S withDueSoonNotified(boolean isNotified) {
        this.dueSoonNotified = isNotified;
        return this.self();
    }

    public S withWaitForScheduledStartDate(boolean waitForScheduledStartDate) {
        this.waitForScheduledStartDate = waitForScheduledStartDate;
        return this.self();
    }

    public S withDelayDuringBlackout(boolean delayDuringBlackout) {
        this.delayDuringBlackout = delayDuringBlackout;
        return this.self();
    }

    public S beenPostponedDueToBlackout() {
        this.postponedDueToBlackout = true;
        return this.self();
    }

    public S withAttachments(Attachment ... attachments) {
        this.attachments = Lists.newArrayList((Object[])attachments);
        return this.self();
    }

    public S withFailuresCount(int failuresCount) {
        this.failuresCount = failuresCount;
        return this.self();
    }

    public S beenDelayed() {
        this.hasBeenDelayed = true;
        return this.self();
    }

    public S beenFlagged() {
        this.hasBeenFlagged = true;
        return this.self();
    }

    public S withPrecondition(String script) {
        this.precondition = script;
        return this.self();
    }

    public S withFailureHandler(String script) {
        this.failureHandler = script;
        return this.self();
    }

    public S withTaskFailureHandlerEnabled(boolean enabled) {
        this.taskFailureHandlerEnabled = enabled;
        return this.self();
    }

    public S withTaskRecoverOp(TaskRecoverOp recoverOp) {
        this.taskRecoverOp = recoverOp;
        return this.self();
    }

    public S withPhaseRecoverOp(PhaseRecoverOp recoverOp) {
        this.phaseRecoverOp = this.phaseRecoverOp;
        return this.self();
    }

    public S withVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = Maps.newHashMap(variableMapping);
        return this.self();
    }

    public S withTags(String ... tags) {
        this.tags = Lists.newArrayList((Object[])tags);
        return this.self();
    }

    public S withLocked(boolean locked) {
        this.locked = locked;
        return this.self();
    }

    public S isLocked() {
        this.locked = true;
        return this.self();
    }

    public TaskBuilder completed() {
        if (this.startDate == null) {
            this.startDate = new Date();
        }
        if (this.endDate == null) {
            this.endDate = new Date();
        }
        this.status = TaskStatus.COMPLETED;
        return this.self();
    }

    protected void setFields(T task) {
        task.setId(this.id);
        ((Task)task).setStatus(this.status);
        ((Task)task).setFlagStatus(this.flagStatus);
        ((PlanItem)task).setFlagComment(this.flagComment);
        ((PlanItem)task).setTitle(this.title);
        ((PlanItem)task).setOwner(this.owner);
        ((Task)task).setTeam(this.team);
        ((Task)task).setContainer(this.container);
        ((PlanItem)task).setDescription(this.description);
        ((PlanItem)task).setDueDate(this.dueDate);
        ((PlanItem)task).setStartDate(this.startDate);
        ((Task)task).setScheduledStartDate(this.scheduledStartDate);
        ((Task)task).setOriginalScheduledStartDate(this.originalScheduledStartDate);
        ((PlanItem)task).setEndDate(this.endDate);
        ((PlanItem)task).setPlannedDuration(this.plannedDuration);
        ((PlanItem)task).setOverdueNotified(this.overdueNotified);
        ((Task)task).setDueSoonNotified(this.dueSoonNotified);
        ((Task)task).setAttachments(this.attachments);
        ((Task)task).getComments().addAll(this.comments);
        ((Task)task).setWaitForScheduledStartDate(this.waitForScheduledStartDate);
        ((Task)task).setDelayDuringBlackout(this.delayDuringBlackout);
        ((Task)task).setPostponedDueToBlackout(this.postponedDueToBlackout);
        ((Task)task).setFailuresCount(this.failuresCount);
        ((Task)task).setHasBeenDelayed(this.hasBeenDelayed);
        ((Task)task).setHasBeenFlagged(this.hasBeenFlagged);
        ((Task)task).setPrecondition(this.precondition);
        ((Task)task).setFailureHandler(this.failureHandler);
        ((Task)task).setTaskFailureHandlerEnabled(this.taskFailureHandlerEnabled);
        ((Task)task).setTaskRecoverOp(this.taskRecoverOp);
        ((Task)task).setPhaseRecoverOp(this.phaseRecoverOp);
        ((Task)task).setVariableMapping(this.variableMapping);
        ((Task)task).setTags(this.tags);
        ((Task)task).setLocked(this.locked);
    }

    public abstract T build();
}

