/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.db.AttachmentInfo;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\r=r!B\u0001\u0003\u0011\u0003Y\u0011\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012A\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\f%o\u00195jm\u0016$'+\u001a7fCN,Gc\u0001\u000f#_A\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004B\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0005r\"a\u0002*fY\u0016\f7/\u001a\u0005\u0006Ge\u0001\r\u0001J\u0001\fe\u0016dW-Y:f\u0015N|g\u000e\u0005\u0002&Y9\u0011aE\u000b\t\u0003OIi\u0011\u0001\u000b\u0006\u0003S)\ta\u0001\u0010:p_Rt\u0014BA\u0016\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u0012\u0002\"\u0002\u0019\u001a\u0001\u0004\t\u0014A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011!GN\u0007\u0002g)\u0011\u0001\u0007\u000e\u0006\u0003k\u0019\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003oM\u0012\u0011CU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0011\u0015IT\u0002\"\u0001;\u000319W\r^'p]RD\u0017,Z1s)\t!3\bC\u0003=q\u0001\u0007Q(A\u0005ti\u0006\u0014H\u000fR1uKB\u0011a(R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005i&lWM\u0003\u0002C\u0007\u0006!!n\u001c3b\u0015\u0005!\u0015aA8sO&\u0011ai\u0010\u0002\t\t\u0006$X\rV5nK\u001a!aB\u0001\u0001I'\r9\u0005#\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bQa\u001d7gi)T\u0011AT\u0001\tOJL'P\u001f7fI&\u0011\u0001k\u0013\u0002\b\u0019><w-\u001b8h\u0011!\u0011vI!A!\u0002\u0013\u0019\u0016\u0001E1sG\"Lg/\u001a3SK2,\u0017m]3t!\t!v+D\u0001V\u0015\t1F!\u0001\u0002eE&\u0011\u0001,\u0016\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKND\u0001BW$\u0003\u0002\u0003\u0006IaW\u0001\u0017CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u001cV-\u0019:dQB\u0011A\u000bX\u0005\u0003;V\u0013a#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:TK\u0006\u00148\r\u001b\u0005\t?\u001e\u0013\t\u0011)A\u0005A\u0006q\u0012M]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM\u001d\t\u0003\u0019\u0005L!A\u0019\u0002\u0003=\u0005\u00138\r[5wK\u0012\f5\r^5wSRLHj\\4t'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002\u00033H\u0005\u0003\u0005\u000b\u0011B\u0019\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\u0003\u0005g\u000f\n\u0005\t\u0015!\u0003h\u0003y\u0019w.\u001c9mKR,GMU3mK\u0006\u001cXm]#ya>\u0014HoU3sm&\u001cW\r\u0005\u0002\rQ&\u0011\u0011N\u0001\u0002\u001e\u0007>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016,\u0005\u0010]8siN+'O^5dK\"A1n\u0012B\u0001B\u0003%A.A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"!\\8\u000e\u00039T!\u0001\r\u0003\n\u0005At'!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\"A!o\u0012B\u0001B\u0003%1/\u0001\u000beKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\t\u0003[RL!!\u001e8\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z\u0011!9xI!A!\u0002\u0013A\u0018a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007CA=}\u001b\u0005Q(BA>\u0005\u0003\u0019\t7\r^8sg&\u0011QP\u001f\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0005\u0006/\u001d#\ta \u000b\u0013\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\u0002\u0005\u0002\r\u000f\")!K a\u0001'\")!L a\u00017\")qL a\u0001A\")AM a\u0001c!)aM a\u0001O\")1N a\u0001Y\")!O a\u0001g\")qO a\u0001q\"\u001aa0!\u0006\u0011\t\u0005]\u0011\u0011F\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005}\u0011\u0011E\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\u0019#!\n\u0002\u000b\t,\u0017M\\:\u000b\u0007\u0005\u001d2)A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\u0011\tY#!\u0007\u0003\u0013\u0005+Ho\\<je\u0016$\u0007bBA\u0018\u000f\u0012\u0005\u0011\u0011G\u0001\u000fCJ\u001c\u0007.\u001b<f%\u0016dW-Y:f)\u0019\t\u0019$!\u000f\u0002>A\u0019\u0011#!\u000e\n\u0007\u0005]\"C\u0001\u0003V]&$\bbBA\u001e\u0003[\u0001\r\u0001H\u0001\be\u0016dW-Y:f\u0011!\ty$!\fA\u0002\u0005\u0005\u0013A\u0005:fY\u0016\f7/Z!ui\u0006\u001c\u0007.\\3oiN\u0004b!a\u0011\u0002N\u0005ESBAA#\u0015\u0011\t9%!\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0017\nAA[1wC&!\u0011qJA#\u0005\u0011a\u0015n\u001d;\u0011\u0007u\t\u0019&C\u0002\u0002Vy\u0011!\"\u0011;uC\u000eDW.\u001a8uQ\u0011\ti#!\u0017\u0011\t\u0005m\u0013qM\u0007\u0003\u0003;RA!a\u0007\u0002`)!\u0011\u0011MA2\u0003\u001diW\r\u001e:jGNT1!!\u001a\t\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA5\u0003;\u0012Q\u0001V5nK\u0012Dq!!\u001cH\t\u0003\ty'\u0001\u0006hKR\u0014V\r\\3bg\u0016$2\u0001HA9\u0011\u001d\t\u0019(a\u001bA\u0002\u0011\n\u0011B]3mK\u0006\u001cX-\u00133)\t\u0005-\u0014\u0011\f\u0005\b\u0003s:E\u0011AA>\u0003=9W\r\u001e*fY\u0016\f7/\u001a+ji2,Gc\u0001\u0013\u0002~!9\u00111OA<\u0001\u0004!\u0003\u0006BA<\u00033Bq!a!H\t\u0003\t))\u0001\u0005hKR\u0004\u0006.Y:f)\u0011\t9)!$\u0011\u0007u\tI)C\u0002\u0002\fz\u0011Q\u0001\u00155bg\u0016Dq!a$\u0002\u0002\u0002\u0007A%A\u0004qQ\u0006\u001cX-\u00133)\t\u0005\u0005\u0015\u0011\f\u0005\b\u0003+;E\u0011AAL\u0003\u001d9W\r\u001e+bg.$B!!'\u0002 B\u0019Q$a'\n\u0007\u0005ueD\u0001\u0003UCN\\\u0007bBAQ\u0003'\u0003\r\u0001J\u0001\u0007i\u0006\u001c8.\u00133)\t\u0005M\u0015\u0011\f\u0005\b\u0003O;E\u0011AAU\u0003-9W\r\u001e,be&\f'\r\\3\u0015\t\u0005-\u0016q\u0017\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011\u0017\u0010\u0002\u0013Y\f'/[1cY\u0016\u001c\u0018\u0002BA[\u0003_\u0013\u0001BV1sS\u0006\u0014G.\u001a\u0005\b\u0003s\u000b)\u000b1\u0001%\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0005\u0003K\u000bI\u0006C\u0004\u0002@\u001e#\t!!1\u0002\r\u0015D\u0018n\u001d;t)\u0011\t\u0019-!3\u0011\u0007E\t)-C\u0002\u0002HJ\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002L\u0006u\u0006\u0019\u0001\u0013\u0002\t\rL\u0017\n\u001a\u0015\u0005\u0003{\u000bI\u0006C\u0004\u0002R\u001e#\t!a5\u0002\u0019\u0015D\u0018n\u001d;t\u0005ft\u0015-\\3\u0015\t\u0005\r\u0017Q\u001b\u0005\b\u0003/\fy\r1\u0001%\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3)\t\u0005=\u0017\u0011\f\u0005\b\u0003;<E\u0011AAp\u0003A\u0019\u0007.Z2l\u001d>$\u0018I]2iSZ,G\r\u0006\u0003\u00024\u0005\u0005\bbBAf\u00037\u0004\r\u0001\n\u0015\u0005\u00037\fI\u0006C\u0004\u0002h\u001e#\t!!;\u0002!\u0005$H/Y2i[\u0016tG/\u0012=jgR\u001cH\u0003BAb\u0003WDq!!<\u0002f\u0002\u0007A%\u0001\u0007biR\f7\r[7f]RLE\r\u000b\u0003\u0002f\u0006e\u0003bBAz\u000f\u0012\u0005\u0011Q_\u0001\u000eO\u0016$\u0018\t\u001e;bG\"lWM\u001c;\u0015\t\u0005E\u0013q\u001f\u0005\b\u0003[\f\t\u00101\u0001%Q\u0011\t\t0!\u0017\t\u000f\u0005ux\t\"\u0001\u0002\u0000\u0006\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!!\u0011\u0001B\u0004!\u0015\t\"1AA)\u0013\r\u0011)A\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u00055\u00181 a\u0001I!\"\u00111`A-\u0011\u001d\u0011ia\u0012C\u0001\u0005\u001f\tab]3be\u000eD'+\u001a7fCN,7\u000f\u0006\u0003\u0003\u0012\tM\u0001#BA\"\u0003\u001bb\u0002\u0002\u0003B\u000b\u0005\u0017\u0001\rAa\u0006\u0002\u000f\u0019LG\u000e^3sgB!!\u0011\u0004B\u0014\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011!\u00024pe6\u001c(\u0002\u0002B\u0011\u0005G\t!A^\u0019\u000b\u0007\t\u0015B!A\u0002ba&LAA!\u000b\u0003\u001c\ty!+\u001a7fCN,7OR5mi\u0016\u00148\u000f\u000b\u0003\u0003\f\u0005e\u0003b\u0002B\u0007\u000f\u0012\u0005!q\u0006\u000b\t\u0005#\u0011\tDa\r\u0003>!A!Q\u0003B\u0017\u0001\u0004\u00119\u0002\u0003\u0005\u00036\t5\u0002\u0019\u0001B\u001c\u0003\u0015a\u0017.\\5u!\r\t\"\u0011H\u0005\u0004\u0005w\u0011\"\u0001\u0002'p]\u001eD\u0001Ba\u0010\u0003.\u0001\u0007!qG\u0001\u0007_\u001a47/\u001a;)\t\t5\u0012\u0011\f\u0005\b\u0005\u000b:E\u0011\u0001B$\u0003a1\u0017N\u001c3Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0007\u0005\u0013\u0012YF!\u001a\u0011\u000b\t-#Q\u000b\u0013\u000f\t\t5#\u0011\u000b\b\u0004O\t=\u0013\"A\n\n\u0007\tM##A\u0004qC\u000e\\\u0017mZ3\n\t\t]#\u0011\f\u0002\u0004'\u0016\f(b\u0001B*%!A!Q\fB\"\u0001\u0004\u0011y&\u0001\u0003eCR,\u0007\u0003BA\"\u0005CJAAa\u0019\u0002F\t!A)\u0019;f\u0011!\u00119Ga\u0011A\u0002\t%\u0014\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\t\t-$\u0011O\u0007\u0003\u0005[RAAa\u001c\u0002J\u0005!A.\u00198h\u0013\u0011\u0011\u0019H!\u001c\u0003\u000f%sG/Z4fe\"\"!1IA-\u0011\u001d\u0011Ih\u0012C\u0001\u0005w\na$\u0019:dQ&4X-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005M\"Q\u0010\u0005\b\u0003g\u00129\b1\u0001%Q\u0011\u00119(!\u0017\t\u000f\t\ru\t\"\u0001\u0003\u0006\u0006Qq-\u001a;BY2$\u0016mZ:\u0015\t\t\u001d%Q\u0012\t\u0006\u0003\u0007\u0012I\tJ\u0005\u0005\u0005\u0017\u000b)EA\u0002TKRD\u0001Ba$\u0003\u0002\u0002\u0007!\u0011S\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fE\u0002\u0012\u0005'K1A!&\u0013\u0005\rIe\u000e\u001e\u0015\u0005\u0005\u0003\u000bI\u0006C\u0004\u0003\u001c\u001e#\tA!(\u0002\r\u0011,G.\u001a;f)\u0011\t\u0019Da(\t\u000f\u0005M$\u0011\u0014a\u0001I!\"!\u0011TA-\u0011\u001d\u0011ia\u0012C\u0005\u0005K#\u0002B!\u0005\u0003(\n%&Q\u0016\u0005\t\u0005+\u0011\u0019\u000b1\u0001\u0003\u0018!A!Q\u0007BR\u0001\u0004\u0011Y\u000bE\u0003\u0012\u0005\u0007\u00119\u0004\u0003\u0005\u0003@\t\r\u0006\u0019\u0001BV\u0011\u001d\u0011\tl\u0012C\u0005\u0005g\u000b\u0001cZ3u%\u0016dW-Y:f\u001fB$\u0018n\u001c8\u0015\t\tU&q\u0017\t\u0005#\t\rA\u0004C\u0004\u0002t\t=\u0006\u0019\u0001\u0013\t\u000f\tmv\t\"\u0003\u0003>\u0006qq-\u001a;QQ\u0006\u001cXm\u00149uS>tG\u0003\u0002B`\u0005\u0003\u0004R!\u0005B\u0002\u0003\u000fCq!a$\u0003:\u0002\u0007A\u0005C\u0004\u0003F\u001e#IAa2\u0002\u001b\u001d,G\u000fV1tW>\u0003H/[8o)\u0011\u0011IMa3\u0011\u000bE\u0011\u0019!!'\t\u000f\u0005\u0005&1\u0019a\u0001I!9!qZ$\u0005\n\tE\u0017!E4fiZ\u000b'/[1cY\u0016|\u0005\u000f^5p]R!!1\u001bBk!\u0015\t\"1AAV\u0011\u001d\tIL!4A\u0002\u0011BqA!7H\t\u0013\u0011Y.\u0001\u0010be\u000eD\u0017N^3BY2|U\u000f^4pS:<G)\u001a9f]\u0012,gnY5fgR!!Q\u001cBs!\u0019\u0011YE!\u0016\u0003`B\u0019QD!9\n\u0007\t\rhD\u0001\u0006EKB,g\u000eZ3oGfDq!a\u000f\u0003X\u0002\u0007A\u0004K\nH\u0005S\u00149P!?\u0003~\n}8\u0011BB\u0006\u0007+\u00199\u0002\u0005\u0003\u0003l\nMXB\u0001Bw\u0015\u0011\tYBa<\u000b\t\tE\u0018QE\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0003v\n5(!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.A\u0003wC2,X-\t\u0002\u0003|\u0006Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\f1\u0002\u001d:pa\u0006<\u0017\r^5p]\u0012\u00121\u0011A\u0005\u0005\u0007\u0007\u0019)!\u0001\u0005S\u000bF+\u0016JU#E\u0015\u0011\u00199A!<\u0002\u0017A\u0013x\u000e]1hCRLwN\\\u0001\nSN|G.\u0019;j_:$#a!\u0004\n\t\r=1\u0011C\u0001\u000f%\u0016\u000bEiX\"P\u001b6KE\u000bV#E\u0015\u0011\u0019\u0019B!<\u0002\u0013%\u001bx\u000e\\1uS>t\u0017a\u0003:pY2\u0014\u0017mY6G_Jd#a!\u0007$\u0005\rm\u0001\u0003\u0002B&\u0007;IAaa\b\u0003Z\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0015\u0004\u000f\u000e\r\u0002\u0003BB\u0013\u0007Wi!aa\n\u000b\t\r%\u0012QE\u0001\u000bgR,'/Z8usB,\u0017\u0002BB\u0017\u0007O\u0011qaU3sm&\u001cW\r")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void archiveRelease(Release release, java.util.List<Attachment> releaseAttachments) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
        String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
        if (!release.isTutorial()) {
            String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
            this.archivedReleases.insert(release, serializedRelease, activityLogsJson);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releaseAttachments).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
                ArchivingService.$anonfun$archiveRelease$1(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        if (this.releaseRepository.exists(release.getId())) {
            this.releaseRepository.delete(release.getId());
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running release ", " through export hooks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
        this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
    }

    @Timed
    public Release getRelease(String releaseId) {
        return (Release)this.getReleaseOption(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases.getReleaseTitle(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getPhaseOption(phaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)phaseId)})), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getTaskOption(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)taskId)})), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)variableId)})), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases.exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getPhaseOption(ciId).isDefined() : (Ids.isTaskId((String)ciId) ? this.getTaskOption(ciId).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases.existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases.exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot perform this operation on archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)ciId)})), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases.attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived attachment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentId})), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)release -> $this.archivedReleases.getAttachment(attachmentId).flatMap((Function1 & Serializable & scala.Serializable)overthereFile -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).map((Function1 & Serializable & scala.Serializable)attachment -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.releaseRepository.findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases.findAllTags(limitNumber)).asJava();
    }

    @Timed
    public void delete(String releaseId) {
        this.archivedReleases.delete(releaseId);
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        filters.checkConsistency();
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    private Option<Release> getReleaseOption(String releaseId) {
        return this.archivedReleases.getRelease(releaseId).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = $this.archivedReleases.getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find attachment ", " of release ", " in the attachments table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), releaseId})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private Option<Phase> getPhaseOption(String phaseId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)phaseId)).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getPhase(phaseId)));
    }

    private Option<Task> getTaskOption(String taskId) {
        return this.getPhaseOption(Ids.phaseIdFrom((String)taskId)).flatMap((Function1 & Serializable & scala.Serializable)phase -> Option$.MODULE$.apply((Object)phase.getTask(taskId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId)).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$2))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$4)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$3(ArchivingService $this, Release release$1, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases.insertAttachment(release$1.getId(), new AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$1(ArchivingService $this, Release release$1, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveRelease$3($this, release$1, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$2) {
        String string = x$2.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$4) {
        return !x$4.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
    }
}

