/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.JVMController;

public class ControllerHandler
extends ChannelInboundHandlerAdapter
implements Constants {
    JVMController _controller;

    ControllerHandler(JVMController controller) {
        this._controller = controller;
    }

    public void channelRead(ChannelHandlerContext ctx, Object in) throws Exception {
        if (this._controller.getState() == 6) {
            this._controller._channel.set(ctx.channel());
            this._controller.stop(6, "INTERNAL");
            return;
        }
        Message message = (Message)in;
        switch (message.getCode()) {
            case 110: {
                if (this._controller._key.equals(message.getMessage())) {
                    this._controller._channel.set(ctx.channel());
                    this._controller.setState(3);
                    this._controller.startupOK();
                    ctx.channel().writeAndFlush((Object)new Message(116, "" + this._controller._wrappedProcess.getAppPid()));
                    if (this._controller.getDebug() <= 2) break;
                    this._controller.getLog().info("Correct key");
                    break;
                }
                if (this._controller.getDebug() > 0) {
                    this._controller.getLog().info("Wrong key -> closing session");
                }
                ctx.channel().writeAndFlush((Object)new Message(111, null));
                ctx.channel().close();
                break;
            }
            case 101: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.stop("APPLICATION");
                break;
            }
            case 117: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.stopTimer();
                break;
            }
            case 102: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.restartInternal();
                break;
            }
            case 103: {
                String[] values;
                this._controller.pingReceived();
                String msg = message.getMessage();
                if (msg == null || (values = msg.split(";")).length != 4) break;
                try {
                    float heap = Float.parseFloat(values[0]);
                    long minGC = Long.parseLong(values[1]);
                    long fullGC = Long.parseLong(values[2]);
                    long heapInBytes = Long.parseLong(values[3]);
                    this._controller.setHeap(heap, minGC, fullGC, heapInBytes);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 119: {
                this._controller.serviceStartup();
                break;
            }
            case 104: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.signalStopping(Long.valueOf(message.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        JVMController jVMController = this._controller;
        synchronized (jVMController) {
            if (this._controller._channel.get() != null && !this._controller._channel.get().remoteAddress().equals(ctx.channel().remoteAddress())) {
                if (this._controller.getDebug() > 2) {
                    this._controller.getLog().info("session already established -> ignore further sessions");
                }
                ctx.channel().close();
            } else if (this._controller._channel.get() == null && this._controller.getState() != 6) {
                this._controller.setState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        JVMController jVMController = this._controller;
        synchronized (jVMController) {
            if (this._controller._channel.get() == ctx.channel()) {
                this._controller.closeChannel();
            } else if (this._controller.getDebug() > 2) {
                this._controller.getLog().info("unexpected connection closed: " + ctx.channel().remoteAddress());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        if (this._controller.getDebug() > 1) {
            this._controller.getLog().info(e.getMessage());
        }
    }
}

