/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.generator.TypeGenerators;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class TypeSystemBootstrapper {
    private final TypeGenerators typeGenerators;
    private static final String PLUGINS = File.separator + "plugins" + File.separator;
    private static final Logger logger = LoggerFactory.getLogger(TypeSystemBootstrapper.class);

    TypeSystemBootstrapper(TypeGenerators typeGenerators) {
        this.typeGenerators = typeGenerators;
    }

    void bootstrap(TypeDefinitions typeDefs) {
        logger.info("Bootstrapping the Type System.");
        this.scanClasses(typeDefs);
        this.scanSynthetics(typeDefs);
        this.createTypeTree(typeDefs);
        this.registerTypeDefinitions(typeDefs);
        this.typeGenerators.generateTypeDefinitions(typeDefs);
        this.createTypeTree(typeDefs);
        this.registerTypeDefinitions(typeDefs);
    }

    private void createTypeTree(TypeDefinitions typeDefs) {
        typeDefs.getDefinitions().forEach(TypeDefinitions.TypeDefinition::registerTypeTree);
    }

    void verifyTypes(Verifications verifications) {
        DescriptorRegistry.getDescriptors().stream().filter(input -> !input.isVirtual()).forEach(d -> ((LocalDescriptor)d).verify(verifications));
    }

    private void scanClasses(TypeDefinitions typeDefs) {
        typeDefs.defineType(ConfigurationItem.class);
        Set cis = Scannit.getInstance().getSubTypesOf(ConfigurationItem.class);
        for (Class ci : cis) {
            typeDefs.defineType(ci);
        }
    }

    private void scanSynthetics(TypeDefinitions typeDefs) {
        try {
            ArrayList<Element> types = new ArrayList<Element>();
            ArrayList<Element> typeModifications = new ArrayList<Element>();
            this.readSynthetics("synthetic.xml", types, typeModifications);
            this.readSynthetics("synthetic-test.xml", types, typeModifications);
            this.parseAllTypeDefinitions(types, typeDefs);
            this.parseAllTypeModifications(typeDefs, typeModifications);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read synthetic type definitions.", ex);
        }
    }

    private void registerTypeDefinitions(TypeDefinitions typeDefs) {
        for (TypeDefinitions.TypeDefinition typeDefinition : typeDefs.getDefinitions()) {
            typeDefinition.register(typeDefs);
        }
    }

    private void parseAllTypeDefinitions(List<Element> types, TypeDefinitions typeDefs) {
        for (Element type : types) {
            typeDefs.defineType(type);
            Iterator<Element> generatedTypes = XmlUtils.childByName(type, "generate-deployable"::equals);
            if (generatedTypes.hasNext()) {
                typeDefs.defineGeneratedType(generatedTypes.next(), type);
            }
            this.findAllGeneratedParameterTypes(typeDefs, type);
        }
    }

    private void findAllGeneratedParameterTypes(TypeDefinitions typeDefs, Element type) {
        Iterator<Element> methodDefs = XmlUtils.childByName(type, "method"::equals);
        while (methodDefs.hasNext()) {
            Element methodDef = methodDefs.next();
            Iterator<Element> parameters = XmlUtils.childByName(methodDef, "parameters"::equals);
            if (!parameters.hasNext()) continue;
            typeDefs.defineGeneratedParameterType(methodDef, type);
        }
    }

    private void parseAllTypeModifications(TypeDefinitions typeDefs, List<Element> typeModifications) {
        for (Element typeModification : typeModifications) {
            typeDefs.modifyType(typeModification);
            this.findAllGeneratedParameterTypes(typeDefs, typeModification);
        }
    }

    private void readSynthetics(String name, List<Element> typeDefinitionCollector, List<Element> typeModificationsCollector) throws IOException {
        Enumeration<URL> syntheticXMLs = ClassLoaderUtils$.MODULE$.classLoader().getResources(name);
        for (URL syntheticXML : this.sortedResources(syntheticXMLs)) {
            logger.debug("Scanning synthetic XML: {}", (Object)syntheticXML);
            Element docElement = SyntheticHelper.readSyntheticDocument(syntheticXML).getDocumentElement();
            XmlUtils.childByName(docElement, "type"::equals).forEachRemaining(typeDefinitionCollector::add);
            XmlUtils.childByName(docElement, "type-modification"::equals).forEachRemaining(typeModificationsCollector::add);
        }
    }

    private List<URL> sortedResources(Enumeration<URL> syntheticXMLs) {
        ArrayList<URL> files = Collections.list(syntheticXMLs);
        return Stream.concat(this.allButPlugins(files), this.sortedPlugins(files)).collect(Collectors.toList());
    }

    private Stream<URL> allButPlugins(List<URL> files) {
        return files.stream().filter(this.filterByFolder(PLUGINS).negate());
    }

    private Predicate<URL> filterByFolder(String s) {
        return p -> this.decode((URL)p).contains(s);
    }

    private String decode(URL url) {
        String decodedString = "";
        try {
            decodedString = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedString;
    }

    private Stream<URL> sortedPlugins(List<URL> files) {
        return files.stream().filter(this.filterByFolder(PLUGINS)).sorted(this::sortByPluginFolderName);
    }

    private int sortByPluginFolderName(URL url1, URL url2) {
        return this.getPluginFolderName(url1).compareTo(this.getPluginFolderName(url2));
    }

    private String getPluginFolderName(URL url) {
        String path = this.decode(url);
        return path.substring(path.lastIndexOf(PLUGINS) + PLUGINS.length());
    }
}

