/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.aeron;

import akka.Done;
import akka.Done$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.event.Logging$;
import akka.remote.RemoteActorRefProvider;
import akka.remote.RemoteTransportException;
import akka.remote.artery.ArteryTransport;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.ArteryTransport$ShuttingDown$;
import akka.remote.artery.Decoder;
import akka.remote.artery.DuplicateHandshakeReq;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.EnvelopeBufferPool;
import akka.remote.artery.FixedSizePartitionHub;
import akka.remote.artery.FlightRecorderEvents$;
import akka.remote.artery.InboundControlJunction;
import akka.remote.artery.InboundEnvelope;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.aeron.AeronErrorLog;
import akka.remote.artery.aeron.AeronSink;
import akka.remote.artery.aeron.AeronSource;
import akka.remote.artery.aeron.ArteryAeronUdpTransport$;
import akka.remote.artery.aeron.TaskRunner;
import akka.remote.artery.aeron.TaskRunner$;
import akka.remote.artery.compress.NoInboundCompressions$;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0001\u0003\u0001\u0019Q!aF!si\u0016\u0014\u00180Q3s_:,F\r\u001d+sC:\u001c\bo\u001c:u\u0015\t\u0019A!A\u0003bKJ|gN\u0003\u0002\u0006\r\u00051\u0011M\u001d;fefT!a\u0002\u0005\u0002\rI,Wn\u001c;f\u0015\u0005I\u0011\u0001B1lW\u0006\u001c\"\u0001A\u0006\u0011\u00051iQ\"\u0001\u0003\n\u00059!!aD!si\u0016\u0014\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u0013A\u0001!\u0011!Q\u0001\nIA\u0012aB0tsN$X-\\\u0002\u0001!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0003bGR|'/\u0003\u0002\u0018)\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[&\u0011\u0011DG\u0001\u0007gf\u001cH/Z7\n\u0005m1!a\u0004*f[>$X\r\u0016:b]N\u0004xN\u001d;\t\u0013u\u0001!\u0011!Q\u0001\ny\u0011\u0013!C0qe>4\u0018\u000eZ3s!\ty\u0002%D\u0001\u0007\u0013\t\tcA\u0001\fSK6|G/Z!di>\u0014(+\u001a4Qe>4\u0018\u000eZ3s\u0013\t\u0019#$\u0001\u0005qe>4\u0018\u000eZ3s\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0019q%\u000b\u0016\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000bA!\u0003\u0019\u0001\n\t\u000bu!\u0003\u0019\u0001\u0010\u0006\t1\u0002\u0001%\f\u0002\n\u0019&4WmQ=dY\u0016\u0004\"AL\u0019\u000f\u0005!z\u0013B\u0001\u0019\u0003\u0003-\tUM]8o'>,(oY3\n\u0005I\u001a$AD!fe>tG*\u001b4fGf\u001cG.\u001a\u0006\u0003a\tAa!\u000e\u0001!\u0002\u00131\u0014aC7fI&\fGI]5wKJ\u00042a\u000e!C\u001b\u0005A$BA\u001d;\u0003\u0019\tGo\\7jG*\u00111\bP\u0001\u000bG>t7-\u001e:sK:$(BA\u001f?\u0003\u0011)H/\u001b7\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u000f\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u00191I\u0012%\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013aa\u00149uS>t\u0007CA%P\u001b\u0005Q%BA&M\u0003\u0019!'/\u001b<fe*\u00111!\u0014\u0006\u0002\u001d\u0006\u0011\u0011n\\\u0005\u0003!*\u00131\"T3eS\u0006$%/\u001b<fe\"I1\u0001\u0001a\u0001\u0002\u0003\u0006KA\u0015\t\u0003'Rk\u0011\u0001T\u0005\u0003+2\u0013Q!Q3s_:D#!U,\u0011\u0005\rC\u0016BA-E\u0005!1x\u000e\\1uS2,\u0007\"C.\u0001\u0001\u0004\u0005\t\u0015)\u0003]\u0003A\tWM]8o\u0007>,h\u000e^3s)\u0006\u001c8\u000e\u0005\u0002\u0014;&\u0011a\f\u0006\u0002\f\u0007\u0006t7-\u001a7mC\ndW\r\u000b\u0002[/\"I\u0011\r\u0001a\u0001\u0002\u0003\u0006K\u0001X\u0001\u0012C\u0016\u0014xN\\#se>\u0014Hj\\4UCN\\\u0007F\u00011X\u0011%!\u0007\u00011A\u0001B\u0003&Q-A\u0007bKJ|g.\u0012:s_Jdun\u001a\t\u0003Q\u0019L!a\u001a\u0002\u0003\u001b\u0005+'o\u001c8FeJ|'\u000fT8hQ\t\u0019w\u000bC\u0004k\u0001\t\u0007I\u0011B6\u0002\u0015Q\f7o\u001b*v]:,'/F\u0001m!\tAS.\u0003\u0002o\u0005\tQA+Y:l%Vtg.\u001a:\t\rA\u0004\u0001\u0015!\u0003m\u0003-!\u0018m]6Sk:tWM\u001d\u0011\t\u000bI\u0004A\u0011B:\u0002\u001d%t'm\\;oI\u000eC\u0017M\u001c8fYV\tA\u000f\u0005\u0002vy:\u0011aO\u001f\t\u0003o\u0012k\u0011\u0001\u001f\u0006\u0003sF\ta\u0001\u0010:p_Rt\u0014BA>E\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m$\u0005bBA\u0001\u0001\u0011%\u00111A\u0001\u0010_V$(m\\;oI\u000eC\u0017M\u001c8fYR\u0019A/!\u0002\t\u000f\u0005\u001dq\u00101\u0001\u0002\n\u0005\t\u0011\rE\u0002\u0014\u0003\u0017I1!!\u0004\u0015\u0005\u001d\tE\r\u001a:fgNDq!!\u0005\u0001\t#\n\u0019\"\u0001\bti\u0006\u0014H\u000f\u0016:b]N\u0004xN\u001d;\u0015\u0005\u0005U\u0001cA\"\u0002\u0018%\u0019\u0011\u0011\u0004#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003;\u0001A\u0011BA\n\u0003A\u0019H/\u0019:u\u001b\u0016$\u0017.\u0019#sSZ,'\u000f\u0003\u0004\u0002\"\u0001!Ia]\u0001\tC\u0016\u0014xN\u001c#je\"9\u0011Q\u0005\u0001\u0005\n\u0005M\u0011aD:u_BlU\rZ5b\tJLg/\u001a:\t\u000f\u0005%\u0002\u0001\"\u0003\u0002\u0014\u0005Q1\u000f^1si\u0006+'o\u001c8\t\u000f\u00055\u0002\u0001\"\u0003\u0002\u0014\u00059\"\r\\8dWVsG/\u001b7DQ\u0006tg.\u001a7BGRLg/\u001a\u0005\b\u0003c\u0001A\u0011BA\n\u0003I\u0019H/\u0019:u\u0003\u0016\u0014xN\\#se>\u0014Hj\\4\t\u000f\u0005U\u0002\u0001\"\u0003\u0002\u0014\u0005!2\u000f^1si\u0006+'o\u001c8D_VtG/\u001a:M_\u001eDq!!\u000f\u0001\t#\nY$A\u000bpkR\u0014w.\u001e8e)J\fgn\u001d9peR\u001c\u0016N\\6\u0015\u0011\u0005u\u0012QMA8\u0003s\u0002\u0002\"a\u0010\u0002J\u00055\u00131K\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005A1oY1mC\u0012\u001cHNC\u0002\u0002H!\taa\u001d;sK\u0006l\u0017\u0002BA&\u0003\u0003\u0012AaU5oWB\u0019A\"a\u0014\n\u0007\u0005ECA\u0001\bF]Z,Gn\u001c9f\u0005V4g-\u001a:\u0011\r\u0005U\u0013\u0011LA/\u001b\t\t9F\u0003\u0002<\t&!\u00111LA,\u0005\u00191U\u000f^;sKB!\u0011qLA1\u001b\u0005A\u0011bAA2\u0011\t!Ai\u001c8f\u0011!\t9'a\u000eA\u0002\u0005%\u0014aD8vi\n|WO\u001c3D_:$X\r\u001f;\u0011\u00071\tY'C\u0002\u0002n\u0011\u0011qbT;uE>,h\u000eZ\"p]R,\u0007\u0010\u001e\u0005\t\u0003c\n9\u00041\u0001\u0002t\u0005A1\u000f\u001e:fC6LE\rE\u0002D\u0003kJ1!a\u001eE\u0005\rIe\u000e\u001e\u0005\t\u0003w\n9\u00041\u0001\u0002~\u0005Q!-\u001e4gKJ\u0004vn\u001c7\u0011\u00071\ty(C\u0002\u0002\u0002\u0012\u0011!#\u00128wK2|\u0007/\u001a\"vM\u001a,'\u000fU8pY\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015aC1fe>t7k\\;sG\u0016$b!!#\u0002\u0010\u0006E\u0005cBA \u0003\u0017\u000bi%L\u0005\u0005\u0003\u001b\u000b\tE\u0001\u0004T_V\u00148-\u001a\u0005\t\u0003c\n\u0019\t1\u0001\u0002t!A\u00111SAB\u0001\u0004\ti(\u0001\u0003q_>d\u0007bBAL\u0001\u0011%\u0011\u0011T\u0001\u001cC\u0016\u0014xN\\*pkJ\u001cWm\u00159j]:LgnZ*ue\u0006$XmZ=\u0016\u0005\u0005M\u0004bBAO\u0001\u0011E\u00131C\u0001\u0012eVt\u0017J\u001c2pk:$7\u000b\u001e:fC6\u001c\bbBAQ\u0001\u0011%\u00111C\u0001\u0018eVt\u0017J\u001c2pk:$7i\u001c8ue>d7\u000b\u001e:fC6Dq!!*\u0001\t\u0013\t\u0019\"\u0001\u0011sk:LeNY8v]\u0012|%\u000fZ5oCJLX*Z:tC\u001e,7o\u0015;sK\u0006l\u0007bBAU\u0001\u0011%\u00111C\u0001\u001eeVt\u0017J\u001c2pk:$G*\u0019:hK6+7o]1hKN\u001cFO]3b[\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0016!F;qI\u0006$Xm\u0015;sK\u0006lW*\u0019;WC2,Xm\u001d\u000b\t\u0003+\t\t,a-\u00028\"A\u0011\u0011OAV\u0001\u0004\t\u0019\bC\u0004\u00026\u0006-\u0006\u0019A\u0017\u0002)\u0005,'o\u001c8T_V\u00148-\u001a'jM\u0016\u001c\u0017p\u00197f\u0011!\tI,a+A\u0002\u0005M\u0013!C2p[BdW\r^3e\u0011\u001d\ti\f\u0001C)\u0003\u007f\u000b\u0011c\u001d5vi\u0012|wO\u001c+sC:\u001c\bo\u001c:u)\t\t\u0019\u0006")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    private final TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().IdleCpuLevel());

    public TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String inboundChannel() {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(this.bindAddress().address().host().get()).append(":").append(this.bindAddress().address().port().get()).toString();
    }

    private String outboundChannel(Address a) {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(a.host().get()).append(":").append(a.port().get()).toString();
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
        if (this.settings().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_TaskRunnerStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (new StringOps(Predef$.MODULE$.augmentString(this.settings().Advanced().AeronDirectoryName())).nonEmpty()) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringBuilder(2).append(CommonContext.AERON_DIR_PROP_DEFAULT).append("-").append(this.system().name()).append("-").append(uniquePart).toString();
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().ClientLivenessTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel))));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaDriverStarted(), driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)new Some((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
        }
    }

    private String aeronDir() {
        String string;
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            Some some = (Some)option;
            MediaDriver driver = (MediaDriver)some.value();
            string = driver.aeronDirectoryName();
        } else if (None$.MODULE$.equals(option)) {
            string = this.settings().Advanced().AeronDirectoryName();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private void stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$);
        maybeDriver.foreach((Function1 & Serializable & scala.Serializable)driver -> {
            ArteryAeronUdpTransport.$anonfun$stopMediaDriver$1(this, driver);
            return BoxedUnit.UNIT;
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                block0: {
                    if (!this.$outer.log().isDebugEnabled()) break block0;
                    this.$outer.log().debug(new StringBuilder(31).append("onAvailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(33).append("onUnavailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
                ((MapLike)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$1(img, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$1(Image img$1, ArteryTransport.InboundStreamMatValues x0$1) {
                ArteryTransport.InboundStreamMatValues inboundStreamMatValues = x0$1;
                if (inboundStreamMatValues == null) {
                    throw new MatchError((Object)inboundStreamMatValues);
                }
                AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)inboundStreamMatValues.lifeCycle();
                resourceLife.onUnavailableImage(img$1.sessionId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onUnavailableImage$1$adapted(io.aeron.Image akka.remote.artery.ArteryTransport$InboundStreamMatValues )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)throwable;
                    this.handleFatalError(driverTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof ArteryTransport.AeronTerminated) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.log().error(cause, new StringBuilder(13).append("Aeron error, ").append(cause).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        Object object = this.$outer.settings().LogAeronCounters() ? BoxesRunTime.boxToBoolean((boolean)this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel()) : BoxedUnit.UNIT;
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                } else {
                    throw new ArteryTransport.AeronTerminated(cause);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapLike)this.streamMatValues().get()).apply((Object)BoxesRunTime.boxToInteger((int)ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, aeronLifecyle, waitInterval);
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.isShutdown()) break block0;
                long newLastTimestamp = $this.aeronErrorLog.logErrors(this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    private void startAeronCounterLog() {
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.isShutdown() || !this.log().isDebugEnabled()) break block0;
                $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, (Duration)giveUpAfter, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1())));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(this.inboundChannel(), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1()), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        return this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().IdleCpuLevel() < 5 ? 0 : 50 * this.settings().Advanced().IdleCpuLevel() - 240;
    }

    @Override
    public void runInboundStreams() {
        this.runInboundControlStream();
        this.runInboundOrdinaryMessagesStream();
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream();
        }
        this.blockUntilChannelActive();
    }

    private void runInboundControlStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool()).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2;
            AeronSource.AeronLifecycle a;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$1);
                    if (tuple22 == null) break block2;
                    a = (AeronSource.AeronLifecycle)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple2._1();
            Future d = (Future)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)a, (Object)c, (Object)d);
            return tuple3;
        }).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)resourceLife, (Object)ctrl, (Object)completed);
        Tuple3 tuple33 = tuple32;
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple33._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple33._2();
        Future completed2 = (Future)tuple33._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundControlStream());
    }

    private void runInboundOrdinaryMessagesStream() {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            tuple32 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> {
                Future c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$3, x1$2);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Future)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2 & Serializable & scala.Serializable)(x0$4, x1$3) -> {
                Source c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$4, x1$3);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Source)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3 tuple34 = new Tuple3((Object)resourceLife, (Object)compressionAccess, (Object)laneHub);
            Tuple3 tuple35 = tuple34;
            AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple35._1();
            Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
            Source laneHub2 = (Source)tuple35._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).map((Function1 & Serializable & scala.Serializable)x$3 -> ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3(this, laneHub2, lane, BoxesRunTime.unboxToInt((Object)x$3)), scala.collection.package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
            Future$.MODULE$.firstCompletedOf((TraversableOnce)completedValues, (ExecutionContext)this.system().dispatcher()).failed().foreach((Function1 & Serializable & scala.Serializable)reason -> {
                laneKillSwitch.abort(reason);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system().dispatcher());
            Future allCompleted = Future$.MODULE$.sequence((TraversableOnce)completedValues, Vector$.MODULE$.canBuildFrom(), (ExecutionContext)this.system().dispatcher()).map((Function1 & Serializable & scala.Serializable)x$4 -> Done$.MODULE$, (ExecutionContext)this.system().dispatcher());
            tuple32 = tuple3 = new Tuple3((Object)resourceLife2, (Object)compressionAccess2, (Object)allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple36 = new Tuple3((Object)resourceLife, (Object)inboundCompressionAccess, (Object)completed);
        Tuple3 tuple37 = tuple36;
        AeronSource.AeronLifecycle resourceLife3 = (AeronSource.AeronLifecycle)tuple37._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple37._2();
        Future completed2 = (Future)tuple37._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundOrdinaryMessagesStream());
    }

    private void runInboundLargeMessagesStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool()).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resourceLife, (Object)completed);
        Tuple2 tuple23 = tuple22;
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple23._1();
        Future completed2 = (Future)tuple23._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundLargeMessagesStream());
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues<Object>(aeronSourceLifecycle, (Future<Done>)completed.recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Done$ done$ = Done$.MODULE$;
                return (B1)done$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1 & Serializable & scala.Serializable)x$7 -> {
            block3: {
                this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_Stopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogTaskStopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                }
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
                }
                if ($this.aeronErrorLog != null) {
                    $this.aeronErrorLog.close();
                }
                if (!$this.mediaDriver.get().isDefined()) break block3;
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, (ExecutionContext)this.system().dispatcher());
    }

    public static final /* synthetic */ void $anonfun$stopMediaDriver$1(ArteryAeronUdpTransport $this, MediaDriver driver) {
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            if ($this.settings().Advanced().DeleteAeronDirectory()) {
                IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                $this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaFileDeleted(), FlightRecorderEvents$.MODULE$.NoMetaData());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private final void retry$1(long retries, AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1) {
        block2: {
            while (true) {
                long status;
                if ((status = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), (Duration)this.settings().Bind().BindTimeout()))) == 1L) break block2;
                if (status == -1L) {
                    this.aeronErrorLog.logErrors(this.log(), 0L);
                    this.stopMediaDriver();
                    throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
                }
                if (status != 0L || retries <= 0L) break;
                Thread.sleep(waitInterval$1);
                --retries;
            }
            this.aeronErrorLog.logErrors(this.log(), 0L);
            this.stopMediaDriver();
            throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
        }
        this.log().debug("Inbound channel is now active");
    }

    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, int x$3) {
        return (Future)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right()).run($this.materializer());
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }
}

