/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.encryption;

import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.encryption.IPasswordEncrypter;
import com.xebialabs.deployit.encryption.PasswordEncrypterBase;
import com.xebialabs.deployit.security.SecretKeyHolder;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class LegacyPasswordEncrypter
extends PasswordEncrypterBase
implements IPasswordEncrypter {
    public LegacyPasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        super(encryptionKeyHolder);
        this.coder = new Base64Coder();
    }

    public LegacyPasswordEncrypter(SecretKey passwordEncryptionKey) {
        this(new SecretKeyHolder(passwordEncryptionKey));
    }

    @Override
    public String doEncrypt(String plaintext) throws GeneralSecurityException {
        Cipher aes = this.encryptionKeyHolder.getEncryption();
        return new String(this.coder.encode(aes.doFinal(plaintext.getBytes())));
    }

    @Override
    public String doDecodeAndDecrypt(String text) throws GeneralSecurityException {
        Cipher aes = this.encryptionKeyHolder.getDecryption();
        return new String(aes.doFinal(this.coder.decode(text.getBytes())));
    }
}

