/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001-\u0011\u0001$\u0011:dQ&4\u0018N\\4TG\",G-\u001e7f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0012\u0001C4sSjTH.\u001a3\n\u0005e!\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005\tB-\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017pU3sm&\u001cW\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001e\u0003I!W\r]3oI\u0016t7-_*feZL7-\u001a\u0011\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001'!\tqr%\u0003\u0002)\u0005\tq!+\u001a7fCN,7+\u001a:wS\u000e,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001fI,G.Z1tKN+'O^5dK\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!L\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\u0007\r\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\t\u0005\to\u0001\u0011)\u0019!C\u0001q\u0005\u0001\u0012M]2iSZLgnZ*feZL7-Z\u000b\u0002sA\u0011aDO\u0005\u0003w\t\u0011\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\t\u0011u\u0002!\u0011!Q\u0001\ne\n\u0011#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3!\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0015a\u0003;fC6\u001cVM\u001d<jG\u0016,\u0012!\u0011\t\u0003=\tK!a\u0011\u0002\u0003\u0017Q+\u0017-\\*feZL7-\u001a\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0003\u0006aA/Z1n'\u0016\u0014h/[2fA!Aq\t\u0001BC\u0002\u0013\u0005\u0001*A\bbe\u000eD\u0017N^5oO\u000e{gNZ5h+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0005\u0003\u0019\u0019wN\u001c4jO&\u0011aj\u0013\u0002\u0019\u0003J\u001c\u0007.\u001b<j]\u001e\u001cV\r\u001e;j]\u001e\u001cX*\u00198bO\u0016\u0014\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B%\u0002!\u0005\u00148\r[5wS:<7i\u001c8gS\u001e\u0004\u0003\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011A*\u0002#\u0005$H/Y2i[\u0016tGoU3sm&\u001cW-F\u0001U!\tqR+\u0003\u0002W\u0005\t\t\u0012\t\u001e;bG\"lWM\u001c;TKJ4\u0018nY3\t\u0011a\u0003!\u0011!Q\u0001\nQ\u000b!#\u0019;uC\u000eDW.\u001a8u'\u0016\u0014h/[2fA!)!\f\u0001C\u00017\u00061A(\u001b8jiz\"\u0002\u0002X/_?\u0002\f'm\u0019\t\u0003=\u0001AQaG-A\u0002uAQ\u0001J-A\u0002\u0019BQ\u0001L-A\u00029BQaN-A\u0002eBQaP-A\u0002\u0005CQaR-A\u0002%CQAU-A\u0002QC#!W3\u0011\u0005\u0019\fX\"A4\u000b\u0005!L\u0017AC1o]>$\u0018\r^5p]*\u0011!n[\u0001\bM\u0006\u001cGo\u001c:z\u0015\taW.A\u0003cK\u0006t7O\u0003\u0002o_\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001q\u0003\ry'oZ\u0005\u0003e\u001e\u0014\u0011\"Q;u_^L'/\u001a3\t\u000fQ\u0004!\u0019!C\u0005k\u0006\t\u0012n]\"b]\u000e,GNU3rk\u0016\u001cH/\u001a3\u0016\u0003Y\u00042a^A\u0001\u001b\u0005A(BA={\u0003\u0019\tGo\\7jG*\u00111\u0010`\u0001\u000bG>t7-\u001e:sK:$(BA?\u007f\u0003\u0011)H/\u001b7\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001=\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u001d\t9\u0001\u0001Q\u0001\nY\f!#[:DC:\u001cW\r\u001c*fcV,7\u000f^3eA!I\u00111\u0002\u0001C\u0002\u0013%\u0011QB\u0001\u0016CJ\u001c\u0007.\u001b<f\u0013:\u0004&o\\4sKN\u001cHj\\2l+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)B`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001a\u0005M!AB(cU\u0016\u001cG\u000f\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\b\u0003Y\t'o\u00195jm\u0016Le\u000e\u0015:pOJ,7o\u001d'pG.\u0004\u0003bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u001cO\u0016$\u0018I]2iSZLgn\u001a&pE\u000e\u0013xN\\*dQ\u0016$W\u000f\\3\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003kqA!!\u000b\u00022A\u0019\u00111\u0006\b\u000e\u0005\u00055\"bAA\u0018\u0015\u00051AH]8pizJ1!a\r\u000f\u0003\u0019\u0001&/\u001a3fM&!\u0011qGA\u001d\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0007\b\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u00051\u0012M]2iSZ,W\t\u001f9je\u0016$'+\u001a7fCN,7\u000f\u0006\u0003\u0002B\u0005\u001d\u0003cA\u0007\u0002D%\u0019\u0011Q\t\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013\nY\u00041\u0001\u0002L\u0005\u0019\"/\u001a7fCN,\u0017iZ3U_\u0006\u00138\r[5wKB!\u0011\u0011CA'\u0013\u0011\ty%a\u0005\u0003\u000f%sG/Z4fe\"\"\u00111HA*!\u0011\t)&!\u0019\u000e\u0005\u0005]#b\u00015\u0002Z)!\u00111LA/\u0003\u001diW\r\u001e:jGNT1!a\u0018\t\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA2\u0003/\u0012Q\u0001V5nK\u0012Dq!!\u0010\u0001\t\u0003\t9\u0007\u0006\u0002\u0002B!\"\u0011QMA*\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\n\u0001EZ5oI\u0006sG\r\u0015:pG\u0016\u001c8/\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:fgR!\u0011\u0011OAB)\u0011\t\u0019(!\u001f\u0011\u00075\t)(C\u0002\u0002x9\u00111!\u00138u\u0011!\tY(a\u001bA\u0002\u0005u\u0014AB1di&|g\u000eE\u0004\u000e\u0003\u007f\n)#!\u0011\n\u0007\u0005\u0005eBA\u0005Gk:\u001cG/[8oc!A\u0011QQA6\u0001\u0004\t9)\u0001\u0003eCR,\u0007\u0003BAE\u0003\u0017k\u0011\u0001`\u0005\u0004\u0003\u001bc(\u0001\u0002#bi\u0016Dq!!%\u0001\t\u0013\t\u0019*A\bqe>\u001cWm]:SK2,\u0017m]3t)!\t)*a(\u00026\u0006}F\u0003BAL\u0003;\u00032!DAM\u0013\r\tYJ\u0004\u0002\b\u0005>|G.Z1o\u0011!\tY(a$A\u0002\u0005u\u0004\u0002CAQ\u0003\u001f\u0003\r!a)\u0002\u0015I,G.Z1tK&#7\u000f\u0005\u0004\u0002&\u0006=\u0016Q\u0005\b\u0005\u0003O\u000bYK\u0004\u0003\u0002,\u0005%\u0016\"A\b\n\u0007\u00055f\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00161\u0017\u0002\t\u0013R,'/\u00192mK*\u0019\u0011Q\u0016\b\t\u0011\u0005]\u0016q\u0012a\u0001\u0003s\u000bQaY8v]R\u00042a^A^\u0013\r\ti\f\u001f\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u0011\u0005\u0005\u0017q\u0012a\u0001\u0003\u0007\f!C];o'R\f'\u000f\u001e+j[\u0016l\u0015\u000e\u001c7jgB\u0019Q\"!2\n\u0007\u0005\u001dgB\u0001\u0003M_:<\u0007bBAf\u0001\u0011%\u0011QZ\u0001\u000faJ|7-Z:t%\u0016dW-Y:f)\u0011\t\t%a4\t\u0011\u0005E\u0017\u0011\u001aa\u0001\u0003K\t\u0011B]3mK\u0006\u001cX-\u00133\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u00069\u0012M]2iSZ,7i\\7qY\u0016$X\r\u001a*fY\u0016\f7/\u001a\u000b\u0005\u00033\f\u0019\u000f\u0005\u0004\u0002\\\u0006}\u0017\u0011I\u0007\u0003\u0003;T!! \b\n\t\u0005\u0005\u0018Q\u001c\u0002\u0004)JL\b\u0002CAi\u0003'\u0004\r!!\n\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\u0006\tr-\u001a;TK\u0006\u00148\r\u001b)bO\u0016\u001c\u0016N_3\u0016\u0005\u0005M\u0004bBAw\u0001\u0011%\u0011qM\u0001\u000eg2,W\r]%g\u001d\u0016,G-\u001a3\t\u000f\u0005E\b\u0001\"\u0003\u0002t\u0006Q!/\u00198U_>duN\\4\u0015\t\u0005]\u0015Q\u001f\u0005\t\u0003\u0003\fy\u000f1\u0001\u0002D\"9\u0011\u0011 \u0001\u0005\n\u0005\u001d\u0014aA8gM\"9\u0011Q \u0001\u0005\n\u0005\u001d\u0014A\u00039sK\u0012+7\u000f\u001e:ps\"\"\u00111 B\u0001!\u0011\u0011\u0019Aa\u0003\u000e\u0005\t\u0015!b\u00015\u0003\b)\u0011!\u0011B\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005\u001b\u0011)A\u0001\u0006Qe\u0016$Um\u001d;s_fD3\u0001\u0001B\t!\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!b\u0001B\f[\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\tm!Q\u0003\u0002\b'\u0016\u0014h/[2f\u0001")
public class ArchivingScheduleService
implements Logging {
    private final DependencyService dependencyService;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingService archivingService;
    private final TeamService teamService;
    private final ArchivingSettingsManager archivingConfig;
    private final AttachmentService attachmentService;
    private final AtomicBoolean isCancelRequested;
    private final Object archiveInProgressLock;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingScheduleService archivingScheduleService = this;
        synchronized (archivingScheduleService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public DependencyService dependencyService() {
        return this.dependencyService;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public TeamService teamService() {
        return this.teamService;
    }

    public ArchivingSettingsManager archivingConfig() {
        return this.archivingConfig;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    private AtomicBoolean isCancelRequested() {
        return this.isCancelRequested;
    }

    private Object archiveInProgressLock() {
        return this.archiveInProgressLock;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingConfig().getArchivingJobCronSchedule();
    }

    @Timed
    public void archiveExpiredReleases(Integer releaseAgeToArchive) {
        if (this.archivingConfig().getEnabled()) {
            long startArchiving = System.currentTimeMillis();
            Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving completed releases older than ", " hours (completed before ", ")..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseAgeToArchive, expirationDate})));
            Object object = this.archiveInProgressLock();
            synchronized (object) {
                int archivedReleasesCount = this.findAndProcessArchivableReleases(expirationDate, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                    this.processRelease(s);
                    return BoxedUnit.UNIT;
                });
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivedReleasesCount), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startArchiving))})));
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Archiving is not enabled.");
        }
    }

    @Timed
    public void archiveExpiredReleases() {
        this.archiveExpiredReleases(this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    private int findAndProcessArchivableReleases(Date date, Function1<String, BoxedUnit> action) {
        AtomicInteger count;
        block3: {
            long runStartTimeMillis = System.currentTimeMillis();
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int archivingPageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " completed or aborted releases from repository"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivingPageSize)})));
                Seq<String> releaseIds = this.archivingService().findArchivableReleaseIds(date, Predef$.MODULE$.int2Integer(archivingPageSize));
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{date})));
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, action)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed only ", " finished releases on this page: we're done."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size())})));
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ", fetching the next ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.get()), date, BoxesRunTime.boxToInteger((int)archivingPageSize)})));
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.get()), date})));
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Function1<String, BoxedUnit> action) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
                ArchivingScheduleService.$anonfun$processReleases$1(this, count, runStartTimeMillis, action, object, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void processRelease(String releaseId) {
        WorkDirContext.initWorkdir();
        WorkDir workDir = WorkDirContext.get();
        try {
            this.archiveCompletedRelease(releaseId);
        }
        finally {
            workDir.delete();
            WorkDirContext.clear();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Completed cleanup after the archiving");
        }
    }

    private Try<BoxedUnit> archiveCompletedRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.archivingService().exists(releaseId)) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                long s = System.currentTimeMillis();
                Release release = this.releaseService().findById(releaseId);
                release.setTeams(this.teamService().getEffectiveTeams(release));
                Buffer releaseAttachments = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).map((Function1 & Serializable & scala.Serializable)attachment -> this.attachmentService().findById(attachment.getId()), Buffer$.MODULE$.canBuildFrom());
                this.archivingService().archiveRelease(release, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(releaseAttachments).asJava());
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived release [", "] in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - s))})));
            } else {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release [", "] was already archived before, skipping the archiving and deleting it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                this.releaseRepository().delete(releaseId);
            }
        }).recoverWith((PartialFunction)new scala.Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not archive release [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.releaseId$1, exception.getMessage()})), (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$1 = releaseId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$archiveCompletedRelease$6 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) > 0 ? Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) : 20;
    }

    private void sleepIfNeeded() {
        block2: {
            if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) <= 0) break block2;
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds before archiving the next release"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archivingConfig().getSleepSecondsBetweenReleases()})));
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds was interrupted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archivingConfig().getSleepSecondsBetweenReleases()})));
            }
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) > 0 ? System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) * 1000) : false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Waiting until no archiving is in progress");
        Object object = this.archiveInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Archiving done, destroying ArchivingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static final /* synthetic */ void $anonfun$processReleases$1(ArchivingScheduleService $this, AtomicInteger count$2, long runStartTimeMillis$1, Function1 action$1, Object nonLocalReturnKey1$1, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (count$2.get() > 0) {
            $this.sleepIfNeeded();
        }
        action$1.apply((Object)releaseId);
        count$2.incrementAndGet();
        if ($this.ranTooLong(runStartTimeMillis$1)) {
            $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving paused because it ran for more than ", " seconds. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.archivingConfig().getMaxSecondsPerRun()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving will continue in the next run"})).s((Seq)Nil$.MODULE$));
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    @Autowired
    public ArchivingScheduleService(DependencyService dependencyService, ReleaseService releaseService, ReleaseRepository releaseRepository, ArchivingService archivingService, TeamService teamService, ArchivingSettingsManager archivingConfig, AttachmentService attachmentService) {
        this.dependencyService = dependencyService;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.archivingService = archivingService;
        this.teamService = teamService;
        this.archivingConfig = archivingConfig;
        this.attachmentService = attachmentService;
        Logging.$init$((Logging)this);
        this.isCancelRequested = new AtomicBoolean(false);
        this.archiveInProgressLock = new Object();
    }
}

