/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.plugin.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.plugin.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.plugin.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.plugin.versioning.templates.views.VersionView;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001=\u0011!\u0004V3na2\fG/\u001a,feNLwN\\5oOJ+7o\\;sG\u0016T!a\u0001\u0003\u0002\u0013Q,W\u000e\u001d7bi\u0016\u001c(BA\u0003\u0007\u0003)1XM]:j_:Lgn\u001a\u0006\u0003\u000f!\ta\u0001\u001d7vO&t'BA\u0005\u000b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\f\u0019\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011]\u0001!\u0011!Q\u0001\na\t1\u0002Z:m\u000bb\u0004xN\u001d;feB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\bg\u0016\u0014h/[2f\u0015\ti\u0002\"A\u0002eg2L!a\b\u000e\u0003\u0017\u0011\u001bH.\u0012=q_J$XM\u001d\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005QB/Z7qY\u0006$XMU3wSNLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u00111EJ\u0007\u0002I)\u0011QEA\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0014%\u0005i!V-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z\u0011!I\u0003A!A!\u0002\u0013Q\u0013A\u0006;f[Bd\u0017\r^3Ti>\u0014\u0018mZ3TKJ4\u0018nY3\u0011\u0005-bS\"\u0001\u0002\n\u00055\u0012!A\u0006+f[Bd\u0017\r^3Ti>\u0014\u0018mZ3TKJ4\u0018nY3\t\u0011=\u0002!\u0011!Q\u0001\nA\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0005\u0002\r\u0005\u001cGo\u001c:t\u0013\t)$GA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0003E\u0001XM]7jgNLwN\\\"iK\u000e\\WM\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003w!\t\u0001b]3dkJLG/_\u0005\u0003{i\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0011!y\u0004A!A!\u0002\u0013\u0001\u0015A\u0004:fY\u0016\f7/Z*feZL7-\u001a\t\u0003\u0003\u000ek\u0011A\u0011\u0006\u00037!I!\u0001\u0012\"\u0003\u001dI+G.Z1tKN+'O^5dK\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"r\u0001S%K\u00172ke\n\u0005\u0002,\u0001!)q#\u0012a\u00011!)\u0011%\u0012a\u0001E!)\u0011&\u0012a\u0001U!)q&\u0012a\u0001a!)q'\u0012a\u0001q!)q(\u0012a\u0001\u0001\"\u0012Q\t\u0015\t\u0003#rk\u0011A\u0015\u0006\u0003'R\u000b!\"\u00198o_R\fG/[8o\u0015\t)f+A\u0004gC\u000e$xN]=\u000b\u0005]C\u0016!\u00022fC:\u001c(BA-[\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A.\u0002\u0007=\u0014x-\u0003\u0002^%\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006?\u0002!\t\u0001Y\u0001\rO\u0016$(+\u001a<jg&|gn\u001d\u000b\u0003C6\u0004\"AY6\u000e\u0003\rT!\u0001Z3\u0002\t\r|'/\u001a\u0006\u0003M\u001e\f!A]:\u000b\u0005!L\u0017AA<t\u0015\u0005Q\u0017!\u00026bm\u0006D\u0018B\u00017d\u0005!\u0011Vm\u001d9p]N,\u0007\"\u00028_\u0001\u0004y\u0017A\u0003;f[Bd\u0017\r^3JIB\u0011\u0001o\u001e\b\u0003cV\u0004\"A\u001d\n\u000e\u0003MT!\u0001\u001e\b\u0002\rq\u0012xn\u001c;?\u0013\t1(#\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<\u0013Q\ti7\u0010E\u0002}\u0003\u000fi\u0011! \u0006\u0003}~\f!!\u001b3\u000b\t\u0005\u0005\u00111A\u0001\ta2,XNY5oO*\u0019\u0011Q\u0001\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRL1!!\u0003~\u0005\u001dIE\rU1sC6Ds!\\A\u0007\u0003+\t9\u0002\u0005\u0003\u0002\u0010\u0005EQ\"A3\n\u0007\u0005MQMA\u0005QCRD\u0007+\u0019:b[\u0006)a/\u00197vK\u0006\na\u000eK\u0004_\u00037\t)\"!\t\u0011\t\u0005=\u0011QD\u0005\u0004\u0003?)'\u0001\u0002)bi\"\f#!a\t\u0002O=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn\u001d\u0015\u0004=\u0006\u001d\u0002\u0003BA\b\u0003SI1!a\u000bf\u0005\r9U\t\u0016\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003I9W\r\u001e*fm&\u001c\u0018n\u001c8D_:$XM\u001c;\u0015\u000b\u0005\f\u0019$!\u000f\t\r9\fi\u00031\u0001pQ\r\t\u0019d\u001f\u0015\t\u0003g\ti!!\u0006\u0002\u0018!A\u00111HA\u0017\u0001\u0004\ti$\u0001\u0006sKZL7/[8o\u0013\u0012\u00042!EA \u0013\r\t\tE\u0005\u0002\u0004\u0013:$\b\u0006CA\u001d\u0003\u001b\t)\"!\u0012\"\u0005\u0005m\u0002\u0006CA\u0017\u00037\t)\"!\u0013\"\u0005\u0005-\u0013\u0001P\u0018|i\u0016l\u0007\u000f\\1uK&#'H\f\u0016SK2,\u0017m]3\\=>jSLK?0e\u00164\u0018n]5p]N|3P]3wSNLwN\\%e{>\u001awN\u001c;f]RDC!!\f\u0002(!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013!D2sK\u0006$XMV3sg&|g\u000eF\u0003b\u0003+\nY\u0006\u0003\u0004o\u0003\u001f\u0002\ra\u001c\u0015\u0004\u0003+Z\b\u0006CA+\u0003\u001b\t)\"a\u0006\t\u0011\u0005u\u0013q\na\u0001\u0003?\n1B^3sg&|gNV5foB!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\t\tQA^5foNLA!!\u001b\u0002d\tYa+\u001a:tS>tg+[3xQ!\ty%a\u0007\u0002\u0016\u00055\u0014EAA8\u0003\u0019z3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*jxF^3sg&|gn\u001d\u0015\u0005\u0003\u001f\n\u0019\b\u0005\u0003\u0002\u0010\u0005U\u0014bAA<K\n!\u0001kT*U\u0011\u001d\tY\b\u0001C\u0001\u0003{\nqB]3ti>\u0014XMU3wSNLwN\u001c\u000b\u0006C\u0006}\u0014Q\u0011\u0005\u0007]\u0006e\u0004\u0019A8)\u0007\u0005}4\u0010\u000b\u0005\u0002\u0000\u00055\u0011QCA\f\u0011!\tY$!\u001fA\u0002\u0005u\u0002\u0006CAC\u0003\u001b\t)\"!\u0012)\u0011\u0005e\u00141DA\u000b\u0003\u0017\u000b#!!$\u0002y=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn]\u0018|e\u00164\u0018n]5p]&#Wp\f:fgR|'/\u001a\u0015\u0005\u0003s\n\t\n\u0005\u0003\u0002\u0010\u0005M\u0015bAAKK\n\u0019\u0001+\u0016+\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\u000691m\\7qCJ,G\u0003CAO\u0003G\u000bI+!,\u0011\t\u0005\u0005\u0014qT\u0005\u0005\u0003C\u000b\u0019G\u0001\u000eUK6\u0004H.\u0019;f\u0007>tG/\u001a8u\u0003:$\u0007K]3wS>,8\u000f\u0003\u0004o\u0003/\u0003\ra\u001c\u0015\u0004\u0003G[\b\u0006CAR\u0003\u001b\t)\"a\u0006\t\u0011\u0005m\u0012q\u0013a\u0001\u0003{A\u0003\"!+\u0002\u000e\u0005U\u0011Q\t\u0005\t\u0003_\u000b9\n1\u0001\u0002>\u0005aAo\u001c*fm&\u001c\u0018n\u001c8JI\"B\u0011QVA\u0007\u0003+\t\u0019,\t\u0002\u00020\"B\u0011qSA\u000e\u0003+\t9,\t\u0002\u0002:\u0006\u0019uf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSpL2p[B\f'/Z\u0018|e\u00164\u0018n]5p]&#WP\f\u0018/wR|'+\u001a<jg&|g.\u00133~Q\u0011\t9*a\n\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\u0006\u0001r-\u001a;UK6\u0004H.\u0019;f\u0003N$5\u000f\u001c\u000b\u0004_\u0006\r\u0007\u0002CAc\u0003{\u0003\r!a2\u0002\u0011Q,W\u000e\u001d7bi\u0016\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001bD\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002R\u0006-'a\u0002*fY\u0016\f7/\u001a\u0015\u0004\u0001\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\u0007\u0005m\u0007,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a8\u0002Z\nQ1i\u001c8ue>dG.\u001a:)\u000f\u0001\t\u0019/!\u0006\u0002jB!\u0011qBAs\u0013\r\t9/\u001a\u0002\t\u0007>t7/^7fg2\u0012\u00111^\u0011\u0003\u0003[\f\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\u000f\u0001\t\t0!\u0006\u0002xB!\u0011qBAz\u0013\r\t)0\u001a\u0002\t!J|G-^2fg2\u0012\u00111\u001e\u0015\b\u0001\u0005m\u0011QCA~C\t\ti0A\u00060m\u0016\u00148/[8oS:<\u0007")
public class TemplateVersioningResource {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0)));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId);
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion(versionView.name(), versionView.description(), Permissions.getAuthenticatedUserName()));
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        Release template = this.releaseService.findById(templateId);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, template);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TRIGGERS, template);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, template);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare/{revisionId}...{toRevisionId}")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId, @PathParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = this.templateStorageService.load(revisionId);
        Release toRevision = this.templateStorageService.load(toRevisionId);
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    private String getTemplateAsDsl(Release template) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.dslExporter.exportTemplate(template, (OutputStream)os, this.dslExporter.exportTemplate$default$3());
        return os.toString(StandardCharsets.UTF_8.name());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
    }
}

