/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.SequentialGroup;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedOrTypeChangedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskMovedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TasksLockedEvent;
import com.xebialabs.xlrelease.domain.events.TasksUnlockedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdater;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskTypeConversion;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.MovementIndexes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    private TaskRepository taskRepository;
    private ExecutionService executionService;
    private ReleaseService releaseService;
    private CommentService commentService;
    private PermissionChecker permissions;
    private TaskAccessService taskAccessService;
    private TaskTypeConversion taskTypeConversionService;
    private TeamService teamService;
    private InternalMetadataDecoratorService decoratorService;
    private CiIdService ciIdService;
    private ArchivingService archivingService;
    private XLReleaseEventBus eventBus;
    private PhaseService phaseService;
    private ConfigurationRepository configurationRepository;
    private Map<Class<? extends Task>, TaskUpdater> taskUpdatersPerType = new HashMap<Class<? extends Task>, TaskUpdater>();

    @Autowired
    public TaskService(TaskRepository taskRepository, ExecutionService executionService, ReleaseService releaseService, CommentService commentService, PermissionChecker permissions, TaskAccessService taskAccessService, TaskTypeConversion taskTypeConversionService, TeamService teamService, InternalMetadataDecoratorService decoratorService, CiIdService ciIdService, ArchivingService archivingService, XLReleaseEventBus eventBus, PhaseService phaseService, ConfigurationRepository configurationRepository) {
        this.taskRepository = taskRepository;
        this.executionService = executionService;
        this.releaseService = releaseService;
        this.commentService = commentService;
        this.permissions = permissions;
        this.taskAccessService = taskAccessService;
        this.taskTypeConversionService = taskTypeConversionService;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.eventBus = eventBus;
        this.phaseService = phaseService;
        this.configurationRepository = configurationRepository;
    }

    @Autowired
    public void setTaskUpdaters(List<? extends TaskUpdater> taskUpdaters) {
        taskUpdaters.forEach(updater -> {
            Class<? extends Task> taskType = updater.getTaskClass();
            if (this.taskUpdatersPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two updaters are registered for the same task type %s: %s and %s", taskType, this.taskUpdatersPerType.get(taskType), updater));
            }
            this.taskUpdatersPerType.put(taskType, (TaskUpdater)updater);
        });
    }

    @Timed
    public Task getTaskWithoutDecoration(String taskId) {
        return this.taskRepository.findById(taskId);
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        Object task = this.taskRepository.findById(taskId);
        this.teamService.decorateWithEffectiveTeams(task.getRelease());
        this.decoratorService.decorate((ConfigurationItem)task.getRelease(), Collections.singletonList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES()));
        return task;
    }

    @Timed
    public List<Task> findById(List<String> taskIds) {
        return taskIds.stream().map(this::findById).collect(Collectors.toList());
    }

    @Timed
    public List<Task> findByIdIncludingArchived(List<String> taskIds) {
        return taskIds.stream().map(this::findByIdIncludingArchived).collect(Collectors.toList());
    }

    @Timed
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.taskRepository.findTasksForPolling(taskIds);
    }

    @Timed
    public Task findByIdIncludingArchived(String taskId) {
        if (this.exists(taskId)) {
            return this.findById(taskId);
        }
        if (this.archivingService.exists(taskId)) {
            Task task = this.archivingService.getTask(taskId);
            this.decoratorService.decorate((ConfigurationItem)task.getRelease(), Collections.singletonList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES()));
            return task;
        }
        throw new NotFoundException(String.format("Task [%s] does not exist in the repository or archive", taskId), new Object[0]);
    }

    @Timed
    public String getUniqueId(String parent) {
        return this.ciIdService.getUniqueId(Type.valueOf(Task.class), parent);
    }

    @Timed
    public boolean exists(String taskId) {
        return this.taskRepository.exists(taskId);
    }

    @Timed
    public Task create(String containerId, Task task) {
        return this.create(containerId, task, null);
    }

    @Timed
    public Task create(String containerId, Task task, Integer position) {
        TaskContainer container = this.findContainerById(containerId);
        return this.create(container, null, task, position, TaskCreatedEvent::new);
    }

    @Timed
    public Task create(TaskContainer taskContainer, @Nullable String generatedTaskId, Task task, Integer position, Function<Task, TaskCreatedOrTypeChangedEvent> eventBuilder) {
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask(task);
        this.checkContainerConditionsForAdding(taskContainer, position);
        this.addToContainerAtPosition(taskContainer, task, position);
        if (generatedTaskId == null) {
            String id = this.getUniqueId(task.getContainer().getId());
            task.setId(id);
        }
        return this.createTask(task, eventBuilder);
    }

    private void checkAreTaskPropertiesUpdatable(Task oldTask, Task newTask) {
        if (newTask.ownerHasBeenReassigned(oldTask)) {
            this.permissions.checkReassignTaskToUser(oldTask, newTask.getOwner());
        }
        if (newTask.teamHasBeenReassigned(oldTask)) {
            this.permissions.checkReassignTaskPermission(oldTask.getRelease());
        }
        if (newTask.delayDuringBlackoutHasChanged(oldTask)) {
            this.permissions.checkEditBlackoutPermission(oldTask.getRelease());
        }
        this.checkTaskIsUpdatable(oldTask);
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(oldTask, newTask), (String)"Can't update scheduled start date of task '%s' that is neither planned or pending", (Object[])new Object[]{oldTask.getTitle()});
    }

    public Task updateTaskWith(String taskId, Task updated) {
        return this.updateTaskWith(taskId, updated, false);
    }

    @Timed
    public Task updateTaskWith(String taskId, Task updated, boolean overrideLock) {
        Preconditions.checkArgument((updated.getFlagStatus() != null ? 1 : 0) != 0, (Object)"Flag status is required.");
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask(updated);
        Object task = this.findById(taskId);
        this.checkAreTaskPropertiesUpdatable((Task)task, updated);
        TaskUpdater taskUpdater = this.getTaskUpdater(task.getClass());
        Preconditions.checkArgument((null != taskUpdater ? 1 : 0) != 0, (String)"Cannot update task because there is no updater defined for task type '%s'", (Object[])new Object[]{task.getType().toString()});
        Task original = (Task)CiCloneHelper.cloneCi(task);
        taskUpdater.update((Task)task, updated);
        VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), task, this.ciIdService);
        Release release = task.getRelease();
        release.updateRealFlagStatus();
        if (!overrideLock) {
            LockedTaskOperationChecks.checkTaskUpdate(original, task);
        }
        this.taskRepository.updateTaskAndReleaseFlagStatus((Task)task, release);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        return this.findById(original.getId());
    }

    @Timed
    public Task changeTaskType(String taskId, Type newTaskType) {
        Object task = this.taskRepository.findById(taskId);
        LockedTaskOperationChecks.checkTaskTypeChange(task);
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        return this.taskTypeConversionService.changeActiveTaskType(taskId, newTaskType);
    }

    @Timed
    public Task completeTask(String taskId, String commentText) {
        Object task = this.findById(taskId);
        Release release = task.getRelease();
        if (task.isPlanned()) {
            this.checkIsStatusCompletableInAdvance((Task)task);
            this.checkReleaseIsInProgress(task.getRelease());
            this.executionService.markTaskAsDone(release, TaskStatus.COMPLETED_IN_ADVANCE, taskId, commentText, User.AUTHENTICATED_USER);
        } else {
            this.checkIsStatusUpdatable((Task)task, "complete");
            this.executionService.markTaskAsDone(release, TaskStatus.COMPLETED, taskId, commentText, User.AUTHENTICATED_USER);
        }
        return this.findById(taskId);
    }

    @Timed
    public List<String> completeTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.completeTask((String)taskId, commentText));
    }

    @Timed
    public Task skipTask(String taskId, String commentText) {
        Object task = this.findById(taskId);
        LockedTaskOperationChecks.checkSkipTask(task);
        Release release = task.getRelease();
        if (task.isPlanned()) {
            this.checkIsTaskSkippableInAdvance((Task)task);
            this.checkReleaseIsInProgress(task.getRelease());
            this.executionService.markTaskAsDone(release, TaskStatus.SKIPPED_IN_ADVANCE, taskId, commentText, User.AUTHENTICATED_USER);
        } else {
            this.checkIsTaskSkippable((Task)this.findById(taskId));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when skipping a task.");
            this.executionService.markTaskAsDone(release, TaskStatus.SKIPPED, taskId, commentText, User.AUTHENTICATED_USER);
        }
        return this.findById(taskId);
    }

    @Timed
    public List<String> skipTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(Lists.reverse(taskIds), taskId -> this.skipTask((String)taskId, commentText));
    }

    @Timed
    public Task failTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when failing a task.");
        Object task = this.findById(taskId);
        Preconditions.checkArgument((!this.isScriptOrCustomScriptTask((Task)task) ? 1 : 0) != 0, (Object)"Script tasks can't be failed, they can be aborted");
        this.checkIsStatusUpdatable((Task)task, "fail");
        this.executionService.fail((Task)task, commentText, User.AUTHENTICATED_USER, task.getRelease());
        return task;
    }

    @Timed
    public List<String> failTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.failTask((String)taskId, commentText));
    }

    @Timed
    public Task abortTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when aborting a task.");
        Object task = this.findById(taskId);
        this.checkCanTaskBeAborted((Task)task);
        this.executionService.abortTask((Task)task, commentText);
        return this.findById(taskId);
    }

    @Timed
    public List<String> abortTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.abortTask((String)taskId, commentText));
    }

    @Timed
    public List<String> reopenTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.reopenTask((String)taskId, commentText));
    }

    @Timed
    public Task reopenTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when starting a pending task.");
        Object task = this.findById(taskId);
        this.checkCanTaskBeReopen((Task)task);
        this.executionService.reopenTask((Task)task, commentText);
        return this.findById(taskId);
    }

    @Timed
    public Task retryTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when retrying a task.");
        Object task = this.findById(taskId);
        this.checkCanTaskBeRetried((Task)task);
        this.executionService.retry((Task)task, commentText);
        return task;
    }

    @Timed
    public List<String> retryTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.retryTask((String)taskId, commentText));
    }

    @Timed
    public Task startPendingTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when starting a pending task.");
        Object task = this.findById(taskId);
        this.executionService.startPendingTask(taskId, task.getRelease(), commentText, User.AUTHENTICATED_USER);
        return this.findById(taskId);
    }

    @Timed
    public Task startWithInput(String taskId, List<Variable> variables) {
        return this.executionService.startWithInput(taskId, variables);
    }

    @Timed
    public Comment addComment(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"A commentText is required.");
        return this.commentService.create(taskId, commentText, User.AUTHENTICATED_USER, true);
    }

    @Timed
    public List<String> addComments(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.addComment((String)taskId, commentText));
    }

    @Timed
    public void applyNewTeam(String newTeam, Task task) {
        this.applyNewTeam(newTeam, task, true);
    }

    @Timed
    public void applyNewTeam(String newTeam, Task task, boolean doTaskLockOperationCheck) {
        String previousTeam;
        if (doTaskLockOperationCheck) {
            LockedTaskOperationChecks.checkUpdateTeams(task);
        }
        if (!Objects.equal((Object)newTeam, (Object)(previousTeam = task.getTeam()))) {
            this.checkTaskIsUpdatable(task);
            Task original = CiCloneHelper.cloneCi(task);
            task.setTeam(newTeam);
            this.taskRepository.update(task);
            this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        }
    }

    @Timed
    public Task reassignToOwner(String taskId, String newOwner) {
        Object task = this.taskRepository.findById(taskId);
        LockedTaskOperationChecks.checkUpdateOwner(task, newOwner, this.permissions);
        this.applyNewOwner(newOwner, (Task)task);
        return task;
    }

    @Timed
    public List<String> reassignTasks(List<String> taskIds, String newTeam, String newOwner) {
        return this.executeBulkActionSilently(taskIds, taskId -> {
            this.applyNewTeam(newTeam, (Task)this.taskRepository.findById((String)taskId));
            this.reassignToOwner((String)taskId, newOwner);
            return null;
        });
    }

    @Timed
    public List<String> deleteTasks(List<String> taskIds) {
        return this.executeBulkActionSilently(taskIds, taskId -> {
            this.delete((String)taskId);
            return null;
        });
    }

    @Timed
    public void delete(String taskId) {
        Object task = this.findById(taskId);
        Preconditions.checkArgument((boolean)task.isPlanned(), (String)"Only planned tasks can be deleted. Task '%s' is %s.", (Object[])new Object[]{task.getTitle(), task.getStatus()});
        LockedTaskOperationChecks.checkDeleteTask(task);
        Release release = task.getRelease();
        release.deleteTask(task);
        release.updateRealFlagStatus();
        this.clearLinks(task.getContainer(), (Task)task);
        this.taskRepository.delete((Task)task);
        this.eventBus.publish((XLReleaseEvent)new TaskDeletedEvent(task));
    }

    @Timed
    public List<Attachment> getAttachments(String taskId) {
        Object task = this.taskRepository.findById(taskId);
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)("Task not found for taskId " + taskId));
        return task.getAttachments();
    }

    @Timed
    public Task copyTask(String taskToCopyId, String targetContainerId, int targetPosition) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)taskToCopyId), (Object)"Id of task to copy must be provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)targetContainerId), (Object)"Target container id must be provided");
        Object taskToCopy = this.findById(taskToCopyId);
        TaskContainer taskContainer = this.findContainerById(targetContainerId);
        Preconditions.checkArgument((targetPosition <= taskContainer.getTasks().size() ? 1 : 0) != 0, (String)"Target position must be between 0 and %s.", (Object[])new Object[]{taskContainer.getTasks().size()});
        return this.copyTask((Task)taskToCopy, taskContainer, targetPosition);
    }

    @Timed
    public void notifyOverdueTask(Task task) {
        this.eventBus.publish((XLReleaseEvent)new TaskOverdueEvent(task));
        task.setOverdueNotified(true);
        this.taskRepository.update(task);
    }

    @Timed
    public void notifyTaskDueSoon(Task task) {
        this.eventBus.publish((XLReleaseEvent)new TaskDueSoonEvent(task));
        task.setDueSoonNotified(true);
        this.taskRepository.update(task);
    }

    @Timed
    public Task duplicateTask(String originTaskId) {
        Object taskToCopy = this.findById(originTaskId);
        TaskContainer container = taskToCopy.getContainer();
        int targetPosition = container.getTasks().indexOf(taskToCopy) + 1;
        return this.copyTask((Task)taskToCopy, container, targetPosition);
    }

    @Timed
    public Task moveTask(MovementIndexes movementIndexes) {
        if (this.isTaskMovedWithinSameContainer(movementIndexes)) {
            return this.moveTaskWithinContainer(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        }
        return this.moveTaskBetweenContainers(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetContainerId(), movementIndexes.getTargetIndex());
    }

    @Timed
    public String getTitle(String id) {
        return this.taskRepository.getTitle(id);
    }

    @Timed
    public Task lockTask(String id) {
        return this.setLock(id, true);
    }

    @Timed
    public Task unlockTask(String id) {
        return this.setLock(id, false);
    }

    private Task setLock(String id, boolean lock) {
        Object task = this.taskRepository.findById(id);
        this.checkTaskIsUpdatable((Task)task);
        ArrayList updatedTasks = new ArrayList();
        task.getAllTasks().stream().filter(candidateTask -> candidateTask.isLocked() != lock).forEach(taskToUpdate -> {
            taskToUpdate.setLocked(lock);
            this.taskRepository.updateTaskProperties((Task)taskToUpdate);
            updatedTasks.add(taskToUpdate);
        });
        this.releaseService.updateReleaseProperties(null, task.getRelease());
        String releaseId = task.getRelease().getId();
        TasksLockedEvent event = lock ? new TasksLockedEvent(releaseId, updatedTasks) : new TasksUnlockedEvent(releaseId, updatedTasks);
        this.eventBus.publish((XLReleaseEvent)event);
        return task;
    }

    private void applyNewOwner(String newOwner, Task task) {
        String previousOwner = task.getOwner();
        if (!Objects.equal((Object)newOwner, (Object)previousOwner)) {
            this.checkTaskIsUpdatable(task);
            Task original = CiCloneHelper.cloneCi(task);
            task.setOwner(newOwner);
            task.setOverdueNotified(false);
            task.setDueSoonNotified(false);
            VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
            this.taskRepository.update(task);
            this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        }
    }

    private Task moveTaskWithinContainer(String containerId, Integer originIndex, Integer targetIndex) {
        TaskContainer taskContainer = this.findContainerById(containerId);
        List tasks = taskContainer.getTasks();
        Task taskToMove = (Task)tasks.get(originIndex);
        Preconditions.checkArgument((((PlanItem)taskContainer).isUpdatable() && taskToMove.isMovable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        LockedTaskOperationChecks.checkMoveTask(taskToMove, taskContainer, taskContainer);
        tasks.remove(taskToMove);
        tasks.add(targetIndex, taskToMove);
        Task savedTask = this.taskRepository.moveTask(taskToMove, taskToMove, taskContainer, taskContainer);
        this.eventBus.publish((XLReleaseEvent)new TaskMovedEvent(savedTask, originIndex.intValue(), targetIndex.intValue(), containerId, containerId));
        return savedTask;
    }

    private boolean isTaskMovedWithinSameContainer(MovementIndexes movementIndexes) {
        return movementIndexes.getOriginContainerId().equals(movementIndexes.getTargetContainerId());
    }

    private Task moveTaskBetweenContainers(String originContainerId, Integer originIndex, String targetContainerId, Integer targetIndex) {
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)originContainerId));
        TaskContainer originContainer = this.getTaskContainer(release, originContainerId);
        TaskContainer targetContainer = this.getTaskContainer(release, targetContainerId);
        List originContainerTasks = originContainer.getTasks();
        Task taskToMove = (Task)originContainerTasks.get(originIndex);
        Preconditions.checkArgument((taskToMove.isMovable() && ((PlanItem)originContainer).isUpdatable() && ((PlanItem)targetContainer).isUpdatable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        LockedTaskOperationChecks.checkMoveTask(taskToMove, originContainer, targetContainer);
        String newId = this.getUniqueId(targetContainer.getId());
        this.clearLinks(originContainer, taskToMove);
        Task movedTask = CiCloneHelper.cloneCi(taskToMove);
        CiHelper.rewriteWithNewId((ConfigurationItem)movedTask, (String)newId);
        originContainer.getTasks().remove(taskToMove);
        targetContainer.addTask(movedTask, targetIndex.intValue());
        movedTask.setContainer(targetContainer);
        Task savedTask = this.taskRepository.moveTask(taskToMove, movedTask, originContainer, targetContainer);
        this.eventBus.publish((XLReleaseEvent)new TaskMovedEvent(savedTask, originIndex.intValue(), targetIndex.intValue(), originContainerId, targetContainerId));
        return savedTask;
    }

    private void clearLinks(TaskContainer originContainer, Task task) {
        if (originContainer instanceof ParallelGroup) {
            Set allLinks = ((ParallelGroup)task.getContainer()).getLinks();
            Set links = allLinks.stream().filter(l -> !((ParallelGroup)task.getContainer()).getLinksOf(task).contains(l)).collect(Collectors.toSet());
            ((ParallelGroup)task.getContainer()).setLinks(links);
        }
    }

    private TaskContainer getTaskContainer(Release release, String containerId) {
        if (Ids.isPhaseId((String)containerId)) {
            return release.getPhase(containerId);
        }
        return (TaskContainer)release.getTask(containerId);
    }

    private Task copyTask(Task taskToCopy, TaskContainer taskContainer, int targetPosition) {
        LockedTaskOperationChecks.checkCopyTask(taskToCopy);
        boolean isInProgressParallelGroup = taskContainer instanceof ParallelGroup && ((ParallelGroup)taskContainer).isInProgress();
        boolean isUpdatableOrDoneInAdvance = taskToCopy.isUpdatable() || taskToCopy.isDoneInAdvance();
        Preconditions.checkArgument((!isInProgressParallelGroup ? 1 : 0) != 0, (Object)"Can't copy task within 'in progress' parallel group.");
        Preconditions.checkArgument((boolean)isUpdatableOrDoneInAdvance, (String)"Can't copy task '%s' because it is %s.", (Object[])new Object[]{taskToCopy.getTitle(), taskToCopy.getStatus()});
        Preconditions.checkArgument((targetPosition >= 0 ? 1 : 0) != 0, (Object)"Target position must be greater or equal to 0.");
        String newTaskId = this.getUniqueId(taskContainer.getId());
        Task copiedTaskTemplate = CiCloneHelper.cloneCi(taskToCopy);
        copiedTaskTemplate.setTitle(copiedTaskTemplate.getTitle() + " (copy)");
        copiedTaskTemplate.resetToPlanned();
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedTaskTemplate, (String)newTaskId);
        return this.create(taskContainer, newTaskId, copiedTaskTemplate, targetPosition, TaskCopiedEvent::new);
    }

    private boolean isScriptOrCustomScriptTask(Task task) {
        return task instanceof ScriptTask || task instanceof CustomScriptTask;
    }

    private void checkIsStatusUpdatable(Task task, String action) {
        if (!this.canUpdateInProgressStatus(task)) {
            throw new IllegalArgumentException("You can not " + action + " a task that is : not in progress, automated, or unassigned");
        }
        if (task.isTaskGroup()) {
            throw new IllegalArgumentException("You can not " + action + " a task group");
        }
    }

    private void checkIsStatusCompletableInAdvance(Task task) {
        LockedTaskOperationChecks.checkCompleteTaskInAdvance(task);
        boolean isAutomated = (Boolean)task.getProperty("automated");
        if (!this.canUpdatePlannedStatus(task) || isAutomated) {
            throw new IllegalArgumentException("You can not complete in advance a task that is : not planned or unassigned or automated");
        }
    }

    private void checkIsTaskSkippable(Task task) {
        LockedTaskOperationChecks.checkSkipTask(task);
        if (!this.canUpdateInProgressStatus(task) && !this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not skip a task that is : (in progress and automated or unassigned) or (failed and not automated or unassigned)");
        }
        if (task.isTaskGroup() && !((TaskGroup)task).isSkippableOrRetriable()) {
            throw new IllegalArgumentException("You can not skip this task group");
        }
    }

    private void checkIsTaskSkippableInAdvance(Task task) {
        LockedTaskOperationChecks.checkSkipTask(task);
        if (!this.canUpdatePlannedStatus(task)) {
            throw new IllegalArgumentException("You can not skip in advance a task that is : not planned or unassigned");
        }
    }

    private void checkCanTaskBeRetried(Task task) {
        if (!this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not retry a task that is : failed and not automated or unassigned");
        }
        if (task instanceof TaskGroup && !((TaskGroup)task).isSkippableOrRetriable()) {
            throw new IllegalArgumentException("You can not retry this task group");
        }
    }

    private void checkCanTaskBeReopen(Task task) {
        if (!task.isDoneInAdvance()) {
            throw new IllegalArgumentException("You can not reopen a task that is not done in advance");
        }
        Release release = task.getRelease();
        this.checkReleaseIsInProgress(release);
    }

    private void checkCanTaskBeAborted(Task task) {
        if (task.isInProgress()) {
            Preconditions.checkArgument((boolean)(task instanceof BaseScriptTask), (Object)"When a task in running, only ScriptTask or CustomScriptTask may be cancelled");
        } else {
            Preconditions.checkArgument((boolean)task.isPreconditionInProgress(), (Object)"Only task currently evaluating a precondition may be cancelled");
        }
    }

    private boolean canUpdateInProgressStatus(Task task) {
        return task.isInProgress() && !task.isAutomated() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdatePlannedStatus(Task task) {
        return task.isPlanned() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdateFailedStatus(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        return task.isFailed() && (isAutomated || task.hasOwner() || task.hasTeam());
    }

    private void checkReleaseIsInProgress(Release release) {
        Preconditions.checkState((boolean)release.isInProgress(), (String)"The release '%s' must be in progress.", (Object[])new Object[]{release.getTitle()});
    }

    private List<String> executeBulkActionSilently(List<String> taskIds, Function<String, ?> action) {
        return taskIds.stream().filter(taskId -> {
            try {
                action.apply((String)taskId);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    private void checkTaskIsUpdatable(Task task) {
        Preconditions.checkArgument((boolean)task.isUpdatable(), (String)"Can't update task '%s' because it is in state %s", (Object[])new Object[]{task.getTitle(), task.getStatus()});
    }

    private boolean isScheduledStartDateUpdatable(Task original, Task updated) {
        return original.isPlanned() || original.isPending() || Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate());
    }

    private TaskUpdater getTaskUpdater(Class<? extends Task> taskType) {
        TaskUpdater updater = this.taskUpdatersPerType.get(taskType);
        return updater != null ? updater : this.taskUpdatersPerType.get(Task.class);
    }

    private TaskContainer findContainerById(String containerId) {
        if (Ids.isPhaseId((String)containerId)) {
            return this.phaseService.findById(containerId);
        }
        Object container = this.findById(containerId);
        if (!(container instanceof TaskGroup)) {
            throw new IllegalArgumentException("Task can only be added to phases or task groups");
        }
        return (TaskGroup)container;
    }

    private Task createTask(Task task, Function<Task, TaskCreatedOrTypeChangedEvent> eventBuilder) {
        task.checkDatesValidity();
        task.setStatus(TaskStatus.PLANNED);
        if (task instanceof CustomScriptTask) {
            PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
            Preconditions.checkArgument((pythonScript != null ? 1 : 0) != 0, (Object)"Missing pythonScript definition");
            pythonScript.setId(task.getId() + "/" + "PythonScript");
            pythonScript.setCustomScriptTask((CustomScriptTask)task);
            this.populateCIReference(pythonScript);
        } else if (task instanceof CreateReleaseTask) {
            List variables = ((CreateReleaseTask)task).getTemplateVariables();
            VariablePersistenceHelper.fixUpVariableIds(task.getId(), variables, this.ciIdService);
        }
        VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
        Task createdTask = this.taskRepository.create(task);
        this.eventBus.publish((XLReleaseEvent)eventBuilder.apply(createdTask));
        return createdTask;
    }

    private void populateCIReference(PythonScript pythonScript) {
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            Type referencedType;
            if (propertyDescriptor.getKind() != PropertyKind.CI || !propertyDescriptor.isRequired() || propertyDescriptor.get((ConfigurationItem)pythonScript) != null || !(referencedType = propertyDescriptor.getReferencedType()).isSubTypeOf(Type.valueOf(Configuration.class))) continue;
            Configuration configuration = this.configurationRepository.findFirstByType(referencedType).orElse(null);
            propertyDescriptor.set((ConfigurationItem)pythonScript, (Object)configuration);
        }
    }

    private void checkContainerConditionsForAdding(TaskContainer container, Integer position) {
        LockedTaskOperationChecks.checkCreateTaskInContainer(container);
        String message = "Can't add a task to the %s '%s' because it is in state %s.";
        if (container instanceof Phase) {
            Phase phase = (Phase)container;
            Preconditions.checkArgument((boolean)phase.isUpdatable(), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object[])new Object[]{"phase", phase.getTitle(), phase.getStatus()});
            if (position != null) {
                Preconditions.checkArgument((position >= 0 && position <= phase.getTasks().size() ? 1 : 0) != 0, (Object)"Task index out of bounds");
                if (position < phase.getTasks().size()) {
                    Task taskAfterPosition = (Task)phase.getTasks().get(position);
                    Preconditions.checkArgument((taskAfterPosition.isPlanned() || taskAfterPosition.isDoneInAdvance() ? 1 : 0) != 0, (Object)"Can't add a task before a task that is active or done");
                }
            }
        } else if (container instanceof SequentialGroup) {
            SequentialGroup group = (SequentialGroup)container;
            Preconditions.checkArgument((boolean)group.isUpdatable(), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object[])new Object[]{"sequential group", group.getTitle(), group.getStatus()});
        } else if (container instanceof ParallelGroup) {
            ParallelGroup group = (ParallelGroup)container;
            Preconditions.checkArgument((boolean)group.getStatus().isOneOf(new TaskStatus[]{TaskStatus.PLANNED, TaskStatus.PENDING, TaskStatus.WAITING_FOR_INPUT}), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object[])new Object[]{"parallel group", group.getTitle(), group.getStatus()});
        }
    }

    private void addToContainerAtPosition(TaskContainer container, Task task, Integer position) {
        container.addTask(task, position != null ? position.intValue() : container.getTasks().size());
        task.setContainer(container);
    }
}

