/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.versioning.templates;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseRestoredEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugin.versioning.templates.ReleaseVersioningSerialization;
import com.xebialabs.xlrelease.plugin.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.TemplateRevisionDataRepository;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.persistence.data.TemplateRevisionData;
import com.xebialabs.xlrelease.plugin.versioning.templates.repository.persistence.data.TemplateRevisionType$;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.upgrade.Components;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Service
@Primary
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001=\u0011\u0001\u0004\u00122UK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0005uK6\u0004H.\u0019;fg*\u0011QAB\u0001\u000bm\u0016\u00148/[8oS:<'BA\u0004\t\u0003\u0019\u0001H.^4j]*\u0011\u0011BC\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011AA\u0005\u00033\t\u0011a\u0003V3na2\fG/Z*u_J\fw-Z*feZL7-\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005QB/Z7qY\u0006$XMU3wSNLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011Q\u0004I\u0007\u0002=)\u0011qDA\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0011\u001f\u0005i!V-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013A\b;f[Bd\u0017\r^3SKZL7/[8o\t\u0006$\u0018MU3q_NLGo\u001c:z!\tiR%\u0003\u0002'=\tqB+Z7qY\u0006$XMU3wSNLwN\u001c#bi\u0006\u0014V\r]8tSR|'/\u001f\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005q\"/\u001a7fCN,g+\u001a:tS>t\u0017N\\4TKJL\u0017\r\\5{CRLwN\u001c\t\u0003/)J!a\u000b\u0002\u0003=I+G.Z1tKZ+'o]5p]&twmU3sS\u0006d\u0017N_1uS>t\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u001dI,G.Z1tKN+'O^5dKB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007C\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\u0004G\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\t\u0011U\u0002!\u0011!Q\u0001\nY\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t9\u0014(D\u00019\u0015\ty\u0002\"\u0003\u0002;q\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\t\u0011q\u0002!\u0011!Q\u0001\nu\n1\u0002^1tWN+'O^5dKB\u0011qFP\u0005\u0003\u007fA\u00121\u0002V1tWN+'O^5dK\"A\u0011\t\u0001B\u0001B\u0003%!)A\u0006uK\u0006l7+\u001a:wS\u000e,\u0007CA\u0018D\u0013\t!\u0005GA\u0006UK\u0006l7+\u001a:wS\u000e,\u0007\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\u00021I,\u0007o\\:ji>\u0014\u0018PV3sg&|gnU3sm&\u001cW\r\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u00069Q\u000f]4sC\u0012,'B\u0001'\u000b\u0003)AH\u000e\u001d7bi\u001a|'/\\\u0005\u0003\u001d&\u0013\u0001DU3q_NLGo\u001c:z-\u0016\u00148/[8o'\u0016\u0014h/[2f\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0016\u0001C3wK:$()^:\u0011\u0005I+V\"A*\u000b\u0005QC\u0011AB3wK:$8/\u0003\u0002W'\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u0011a\u0003!\u0011!Q\u0001\ne\u000b\u0001\u0004Z3qK:$WM\\2z)\u0006\u0014x-\u001a;SKN|GN^3s!\t9$,\u0003\u0002\\q\tAB)\u001a9f]\u0012,gnY=UCJ<W\r\u001e*fg>dg/\u001a:\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)-y\u0006-\u00192dI\u00164w\r[5\u0011\u0005]\u0001\u0001\"B\u000e]\u0001\u0004a\u0002\"B\u0012]\u0001\u0004!\u0003\"\u0002\u0015]\u0001\u0004I\u0003\"B\u0017]\u0001\u0004q\u0003\"B\u001b]\u0001\u00041\u0004\"\u0002\u001f]\u0001\u0004i\u0004\"B!]\u0001\u0004\u0011\u0005\"\u0002$]\u0001\u00049\u0005\"\u0002)]\u0001\u0004\t\u0006\"\u0002-]\u0001\u0004I\u0006F\u0001/l!\taw/D\u0001n\u0015\tqw.\u0001\u0006b]:|G/\u0019;j_:T!\u0001]9\u0002\u000f\u0019\f7\r^8ss*\u0011!o]\u0001\u0006E\u0016\fgn\u001d\u0006\u0003iV\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002m\u0006\u0019qN]4\n\u0005al'!C!vi><\u0018N]3e\u0011\u0015Q\b\u0001\"\u0011|\u0003\u0011\u0019\u0018M^3\u0015\rq|\u0018qBA\u0015!\t\tR0\u0003\u0002\u007f%\t!QK\\5u\u0011\u001d\t\t!\u001fa\u0001\u0003\u0007\t\u0001\u0002^3na2\fG/\u001a\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0005\u0002\r\u0011|W.Y5o\u0013\u0011\ti!a\u0002\u0003\u000fI+G.Z1tK\"9\u0011\u0011C=A\u0002\u0005M\u0011\u0001B;tKJ\u0004B!!\u0006\u0002$9!\u0011qCA\u0010!\r\tIBE\u0007\u0003\u00037Q1!!\b\u000f\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0005\n\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#a\n\u0003\rM#(/\u001b8h\u0015\r\t\tC\u0005\u0005\b\u0003WI\b\u0019AA\n\u0003-!Wm]2sSB$\u0018n\u001c8\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\u0005\u00012M]3bi\u0016tUm\u001e,feNLwN\u001c\u000b\u000b\u0003g\tI$!\u0010\u0002B\u0005\r\u0003cA\t\u00026%\u0019\u0011q\u0007\n\u0003\u0007%sG\u000f\u0003\u0005\u0002<\u00055\u0002\u0019AA\n\u0003)!X-\u001c9mCR,\u0017\n\u001a\u0005\t\u0003\u007f\ti\u00031\u0001\u0002\u0014\u00059a/\u001a:tS>t\u0007\u0002CA\u0016\u0003[\u0001\r!a\u0005\t\u0011\u0005E\u0011Q\u0006a\u0001\u0003'Aq!a\u0012\u0001\t\u0013\tI%\u0001\bde\u0016\fG/\u001a*fm&\u001c\u0018n\u001c8\u0015\u0019\u0005-\u00131LA/\u0003K\n9'!\u001b\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005!A-\u0019;b\u0015\r\t)FH\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0003\u0002Z\u0005=#\u0001\u0005+f[Bd\u0017\r^3SKZL7/[8o\u0011!\t\t!!\u0012A\u0002\u0005\r\u0001\u0002CA \u0003\u000b\u0002\r!a\u0018\u0011\u000bE\t\t'a\u0005\n\u0007\u0005\r$C\u0001\u0004PaRLwN\u001c\u0005\t\u0003W\t)\u00051\u0001\u0002\u0014!A\u0011\u0011CA#\u0001\u0004\t\u0019\u0002\u0003\u0005\u0002l\u0005\u0015\u0003\u0019AA7\u00031\u0011XM^5tS>tG+\u001f9f!\u0011\ty'!'\u000f\t\u0005E\u0014Q\u0013\b\u0005\u0003g\n\u0019J\u0004\u0003\u0002v\u0005Ee\u0002BA<\u0003\u001fsA!!\u001f\u0002\u000e:!\u00111PAF\u001d\u0011\ti(!#\u000f\t\u0005}\u0014q\u0011\b\u0005\u0003\u0003\u000b)I\u0004\u0003\u0002\u001a\u0005\r\u0015\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003?\tI1!!\u0016\u001f\u0013\u0011\t\t&a\u0015\n\t\u0005]\u0015qJ\u0001\u0015)\u0016l\u0007\u000f\\1uKJ+g/[:j_:$\u0016\u0010]3\n\t\u0005m\u0015Q\u0014\u0002\u0015)\u0016l\u0007\u000f\\1uKJ+g/[:j_:$\u0016\u0010]3\u000b\t\u0005]\u0015q\n\u0005\b\u0003C\u0003A\u0011IAR\u0003\u001d\u0011Xm\u001d;pe\u0016$b!a\u0001\u0002&\u0006\u001d\u0006\u0002CA\u001e\u0003?\u0003\r!a\u0005\t\u0011\u0005%\u0016q\u0014a\u0001\u0003g\t!B]3wSNLwN\\%e\u0011\u001d\ti\u000b\u0001C!\u0003_\u000bA\u0001\\8bIR!\u00111AAY\u0011!\tI+a+A\u0002\u0005M\u0002bBA[\u0001\u0011%\u0011qW\u0001\u0018aJ|7-Z:t%\u0016\u001cHo\u001c:fIR+W\u000e\u001d7bi\u0016$R\u0001`A]\u0003{C\u0001\"a/\u00024\u0002\u0007\u00111A\u0001\u0011e\u0016\u001cHo\u001c:fIR+W\u000e\u001d7bi\u0016D\u0001\"a0\u00024\u0002\u0007\u00111A\u0001\u0010GV\u0014(/\u001a8u)\u0016l\u0007\u000f\\1uK\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0017a\u00059s_\u000e,7o\u001d#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003BA\u0002\u0003\u000fD\u0001\"a/\u0002B\u0002\u0007\u00111\u0001\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003)AHN\u001d,feNLwN\\\u000b\u0003\u0003'A3\u0001AAi!\u0011\t\u0019.!9\u000e\u0005\u0005U'\u0002BAl\u00033\f1\u0002\u001e:b]N\f7\r^5p]*!\u00111\\Ao\u0003\r\u0019\u0018\u000f\u001c\u0006\u0004\u0003?D\u0011A\u00013c\u0013\u0011\t\u0019/!6\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2D3\u0001AAt!\u0011\tI/!=\u000e\u0005\u0005-(b\u00018\u0002n*\u0019\u0011q^:\u0002\u000f\r|g\u000e^3yi&!\u00111_Av\u0005\u001d\u0001&/[7befD3\u0001AA|!\u0011\tI0a@\u000e\u0005\u0005m(bAA\u007fg\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\u0005\u00111 \u0002\b'\u0016\u0014h/[2f\u0001")
public class DbTemplateStorageService
implements TemplateStorageService {
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateRevisionDataRepository templateRevisionDataRepository;
    private final ReleaseVersioningSerialization releaseVersioningSerialization;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final RepositoryVersionService repositoryVersionService;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;

    @Override
    public void save(Release template, String user, String description) {
        this.createRevision(template, (Option<String>)None$.MODULE$, description, user, TemplateRevisionType$.MODULE$.REVISION());
    }

    @Override
    public int createNewVersion(String templateId, String version, String description, String user) {
        Release template = this.releaseService.findById(templateId);
        TemplateRevision savedTr = this.createRevision(template, (Option<String>)new Some((Object)version), description, user, TemplateRevisionType$.MODULE$.VERSION());
        return savedTr.id();
    }

    private TemplateRevision createRevision(Release template, Option<String> version, String description, String user, int revisionType) {
        TemplateRevision templateRevision = new TemplateRevision();
        templateRevision.ciUid_$eq(Predef$.MODULE$.Integer2int(template.getCiUid()));
        templateRevision.revisionType_$eq(revisionType);
        if (version.isDefined()) {
            templateRevision.version_$eq((String)version.get());
        }
        templateRevision.description_$eq(description);
        templateRevision.username_$eq(user);
        templateRevision.revisionTime_$eq(new Date());
        TemplateRevision savedTr = this.templateRevisionRepository.create(templateRevision);
        TemplateRevisionData trd = new TemplateRevisionData(savedTr.id(), this.xlrVersion(), this.releaseVersioningSerialization.toBytes(template));
        this.templateRevisionDataRepository.create(trd);
        return savedTr;
    }

    @Override
    public Release restore(String templateId, int revisionId) {
        block0: {
            TemplateRevision latestRevision = this.templateRevisionRepository.latest(templateId);
            if (revisionId == latestRevision.id()) break block0;
            Release currentTemplate = this.releaseService.findById(templateId);
            Release previousTemplate = this.load(revisionId);
            this.processRestoredTemplate(previousTemplate, currentTemplate);
            Release updatedTemplate = this.releaseRepository.replace(currentTemplate, previousTemplate);
            this.eventBus.publish((XLReleaseEvent)new ReleaseRestoredEvent(currentTemplate, updatedTemplate, revisionId));
        }
        return this.releaseService.findById(templateId);
    }

    @Override
    public Release load(int revisionId) {
        Release release;
        Option<TemplateRevisionData> option = this.templateRevisionDataRepository.findById(revisionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateRevisionData trd = (TemplateRevisionData)some.value();
            Option<Release> option2 = this.releaseVersioningSerialization.fromBytes(trd.content(), trd.dataModelVersion());
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading ", ", see logs for more details"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)revisionId)})), new Object[0]);
                }
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            Release template = (Release)some2.value();
            release = this.processDependencies(template);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Revision id ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)revisionId)})), new Object[0]);
            }
            throw new MatchError(option);
        }
        Release release2 = release;
        return release2;
    }

    private void processRestoredTemplate(Release restoredTemplate, Release currentTemplate) {
        restoredTemplate.setCiUid(currentTemplate.getCiUid());
        CiHelper.rewriteWithNewId((ConfigurationItem)restoredTemplate, (String)currentTemplate.getId());
        restoredTemplate.setRunningTriggeredReleasesCount(currentTemplate.getRunningTriggeredReleasesCount());
        this.processDependencies(restoredTemplate);
    }

    private Release processDependencies(Release restoredTemplate) {
        restoredTemplate.getAllGates().forEach(gateTask -> {
            List validDependencies = gateTask.getDependencies().stream().filter(d -> d.hasResolvedTarget() || Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dependencyTargetResolver.resolveTarget(d)).isSuccess()).collect(Collectors.toList());
            gateTask.setDependencies(validDependencies);
        });
        return restoredTemplate;
    }

    private String xlrVersion() {
        Version version = this.repositoryVersionService.readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
        return version == null ? "0.0.0" : version.getVersion();
    }

    @Autowired
    public DbTemplateStorageService(TemplateRevisionRepository templateRevisionRepository, TemplateRevisionDataRepository templateRevisionDataRepository, ReleaseVersioningSerialization releaseVersioningSerialization, ReleaseService releaseService, ReleaseRepository releaseRepository, TaskService taskService, TeamService teamService, RepositoryVersionService repositoryVersionService, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateRevisionDataRepository = templateRevisionDataRepository;
        this.releaseVersioningSerialization = releaseVersioningSerialization;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.repositoryVersionService = repositoryVersionService;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
    }
}

