/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ObjectMBean
implements DynamicMBean {
    private static final Logger LOG = Log.getLogger(ObjectMBean.class);
    private static final Class<?>[] OBJ_ARG = new Class[]{Object.class};
    private static final String OBJECT_NAME_CLASS = ObjectName.class.getName();
    private static final String OBJECT_NAME_ARRAY_CLASS = ObjectName[].class.getName();
    protected Object _managed;
    private MBeanInfo _info;
    private Map<String, Method> _getters = new HashMap<String, Method>();
    private Map<String, Method> _setters = new HashMap<String, Method>();
    private Map<String, Method> _methods = new HashMap<String, Method>();
    private Set<String> _attributes = new HashSet<String>();
    private Set<String> _convert = new HashSet<String>();
    private ClassLoader _loader;
    private MBeanContainer _mbeanContainer;

    public static Object mbeanFor(Object o) {
        try {
            for (Class<Object> oClass = o.getClass(); oClass != null; oClass = oClass.getSuperclass()) {
                String pName = oClass.getPackage().getName();
                String cName = oClass.getName().substring(pName.length() + 1);
                String mName = pName + ".jmx." + cName + "MBean";
                try {
                    Object mbean;
                    block14: {
                        Class mClass;
                        try {
                            mClass = Object.class.equals(oClass) ? (oClass = ObjectMBean.class) : Loader.loadClass(oClass, (String)mName);
                        }
                        catch (ClassNotFoundException e) {
                            if (Thread.currentThread().getContextClassLoader() == oClass.getClassLoader()) {
                                throw e;
                            }
                            LOG.ignore((Throwable)e);
                            mClass = Loader.loadClass(oClass, (String)mName);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ObjectMBean: mbeanFor {} mClass={}", new Object[]{o, mClass});
                        }
                        mbean = null;
                        try {
                            Constructor constructor = mClass.getConstructor(OBJ_ARG);
                            mbean = constructor.newInstance(o);
                        }
                        catch (Exception e) {
                            LOG.ignore((Throwable)e);
                            if (!ModelMBean.class.isAssignableFrom(mClass)) break block14;
                            mbean = mClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            ((ModelMBean)mbean).setManagedResource(o, "objectReference");
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("mbeanFor {} is {}", new Object[]{o, mbean});
                    }
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    if (e.getMessage().contains(mName)) {
                        LOG.ignore((Throwable)e);
                        continue;
                    }
                    LOG.warn((Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
        return null;
    }

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            if (this._info == null) {
                ManagedObject primary;
                String desc = null;
                ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
                ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
                Class<?> o_class = this._managed.getClass();
                List<Class<?>> influences = new ArrayList();
                influences.add(this.getClass());
                influences = ObjectMBean.findInfluences(influences, this._managed.getClass());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Influence Count: {}", (long)influences.size());
                }
                if ((primary = o_class.getAnnotation(ManagedObject.class)) != null) {
                    desc = primary.value();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("No @ManagedObject declared on {}", new Object[]{this._managed.getClass()});
                }
                for (Class<?> oClass : influences) {
                    ManagedObject typeAnnotation = oClass.getAnnotation(ManagedObject.class);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Influenced by: " + oClass.getCanonicalName(), new Object[0]);
                    }
                    if (typeAnnotation == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Annotations not found for: {}", new Object[]{oClass.getCanonicalName()});
                        continue;
                    }
                    for (Method method : oClass.getDeclaredMethods()) {
                        MBeanOperationInfo oi;
                        ManagedOperation methodOperationAnnotation;
                        ManagedAttribute methodAttributeAnnotation = method.getAnnotation(ManagedAttribute.class);
                        if (methodAttributeAnnotation != null) {
                            MBeanAttributeInfo mai;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Attribute Annotation found for: {}", new Object[]{method.getName()});
                            }
                            if ((mai = this.defineAttribute(method, methodAttributeAnnotation)) != null) {
                                attributes.add(mai);
                            }
                        }
                        if ((methodOperationAnnotation = method.getAnnotation(ManagedOperation.class)) == null) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Method Annotation found for: {}", new Object[]{method.getName()});
                        }
                        if ((oi = this.defineOperation(method, methodOperationAnnotation)) == null) continue;
                        operations.add(oi);
                    }
                }
                this._info = new MBeanInfo(o_class.getName(), desc, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), new MBeanConstructorInfo[0], operations.toArray(new MBeanOperationInfo[operations.size()]), new MBeanNotificationInfo[0]);
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            throw e;
        }
        return this._info;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, ReflectionException {
        Method getter = this._getters.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            ObjectName[] r;
            Object o = this._managed;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((r = getter.invoke(o, (Object[])null)) != null) {
                if (r.getClass().isArray()) {
                    if (r.getClass().getComponentType().isAnnotationPresent(ManagedObject.class)) {
                        ObjectName[] on = new ObjectName[Array.getLength(r)];
                        for (int i = 0; i < on.length; ++i) {
                            on[i] = this._mbeanContainer.findMBean(Array.get(r, i));
                        }
                        r = on;
                    }
                } else if (r instanceof Collection) {
                    Collection c = (Collection)r;
                    if (!c.isEmpty() && c.iterator().next().getClass().isAnnotationPresent(ManagedObject.class)) {
                        ObjectName[] on = new ObjectName[c.size()];
                        int i = 0;
                        for (Object obj : c) {
                            on[i++] = this._mbeanContainer.findMBean(obj);
                        }
                        r = on;
                    }
                } else {
                    for (Class<?> clazz = r.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        if (!clazz.isAnnotationPresent(ManagedObject.class)) continue;
                        ObjectName mbean = this._mbeanContainer.findMBean(r);
                        if (mbean != null) {
                            return mbean;
                        }
                        return null;
                    }
                }
            }
            return r;
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        for (String name : names) {
            try {
                results.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
            }
        }
        return results;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setAttribute " + this._managed + ":" + attr.getName() + "=" + attr.getValue(), new Object[0]);
        }
        if ((setter = this._setters.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object value;
            Object o = this._managed;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((value = attr.getValue()) != null && this._convert.contains(attr.getName())) {
                if (value.getClass().isArray()) {
                    Class<?> t = setter.getParameterTypes()[0].getComponentType();
                    Object na = Array.newInstance(t, Array.getLength(value));
                    int i = Array.getLength(value);
                    while (i-- > 0) {
                        Array.set(na, i, this._mbeanContainer.findBean((ObjectName)Array.get(value, i)));
                    }
                    value = na;
                } else {
                    value = this._mbeanContainer.findBean((ObjectName)value);
                }
            }
            setter.invoke(o, value);
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setAttributes", new Object[0]);
        }
        AttributeList results = new AttributeList(attrs.size());
        for (Object element : attrs) {
            try {
                Attribute attr = (Attribute)element;
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ObjectMBean:invoke " + name, new Object[0]);
        }
        StringBuilder builder = new StringBuilder(name);
        builder.append("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                builder.append(i > 0 ? "," : "").append(signature[i]);
            }
        }
        builder.append(")");
        String methodKey = builder.toString();
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Method method = this._methods.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o = this._managed;
            if (method.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            Object object = method.invoke(o, params);
            return object;
        }
        catch (NoSuchMethodException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static List<Class<?>> findInfluences(List<Class<?>> influences, Class<?> aClass) {
        if (aClass != null) {
            if (!influences.contains(aClass)) {
                influences.add(aClass);
            }
            influences = ObjectMBean.findInfluences(influences, aClass.getSuperclass());
            Class<?>[] ifs = aClass.getInterfaces();
            for (int i = 0; ifs != null && i < ifs.length; ++i) {
                influences = ObjectMBean.findInfluences(influences, ifs[i]);
            }
        }
        return influences;
    }

    private MBeanAttributeInfo defineAttribute(Method method, ManagedAttribute attributeAnnotation) {
        Class<?> oClass;
        Class<?> return_type;
        String name = attributeAnnotation.name();
        if ("".equals(name)) {
            name = this.toVariableName(method.getName());
        }
        if (this._attributes.contains(name)) {
            return null;
        }
        String description = attributeAnnotation.value();
        boolean readonly = attributeAnnotation.readonly();
        boolean onMBean = attributeAnnotation.proxied();
        Class<?> component_type = return_type = method.getReturnType();
        while (component_type.isArray()) {
            component_type = component_type.getComponentType();
        }
        boolean convert = this.isAnnotationPresent(component_type, ManagedObject.class);
        String uName = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        Class<?> clazz = oClass = onMBean ? this.getClass() : this._managed.getClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("defineAttribute {} {}:{}:{}:{}", new Object[]{name, onMBean, readonly, oClass, description});
        }
        Method setter = null;
        if (!readonly) {
            String declaredSetter = attributeAnnotation.setter();
            if (LOG.isDebugEnabled()) {
                LOG.debug("DeclaredSetter: {}", new Object[]{declaredSetter});
            }
            for (Method method1 : oClass.getMethods()) {
                if (!Modifier.isPublic(method1.getModifiers())) continue;
                if (!"".equals(declaredSetter) && method1.getName().equals(declaredSetter) && method1.getParameterCount() == 1) {
                    if (setter != null) {
                        LOG.warn("Multiple setters for mbean attr {} in {}", new Object[]{name, oClass});
                        continue;
                    }
                    setter = method1;
                    if (!component_type.equals(method1.getParameterTypes()[0])) {
                        LOG.warn("Type conflict for mbean attr {} in {}", new Object[]{name, oClass});
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Declared Setter: " + declaredSetter, new Object[0]);
                    }
                }
                if (!method1.getName().equals("set" + uName) || method1.getParameterCount() != 1) continue;
                if (setter != null) {
                    LOG.warn("Multiple setters for mbean attr {} in {}", new Object[]{name, oClass});
                    continue;
                }
                setter = method1;
                if (return_type.equals(method1.getParameterTypes()[0])) continue;
                LOG.warn("Type conflict for mbean attr {} in {}", new Object[]{name, oClass});
            }
        }
        if (convert) {
            if (component_type.isPrimitive() && !component_type.isArray()) {
                LOG.warn("Cannot convert mbean primitive {}", new Object[]{name});
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("passed convert checks {} for type {}", new Object[]{name, component_type});
            }
        }
        try {
            MBeanAttributeInfo info;
            this._getters.put(name, method);
            this._setters.put(name, setter);
            if (convert) {
                this._convert.add(name);
                info = new MBeanAttributeInfo(name, component_type.isArray() ? OBJECT_NAME_ARRAY_CLASS : OBJECT_NAME_CLASS, description, true, setter != null, method.getName().startsWith("is"));
            } else {
                info = new MBeanAttributeInfo(name, description, method, setter);
            }
            this._attributes.add(name);
            return info;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    private MBeanOperationInfo defineOperation(Method method, ManagedOperation methodAnnotation) {
        String description = methodAnnotation.value();
        boolean onMBean = methodAnnotation.proxied();
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("returnType is array, get component type", new Object[0]);
            }
            returnType = returnType.getComponentType();
        }
        boolean convert = false;
        if (returnType.isAnnotationPresent(ManagedObject.class)) {
            convert = true;
        }
        String impactName = methodAnnotation.impact();
        if (LOG.isDebugEnabled()) {
            LOG.debug("defineOperation {} {}:{}:{}", new Object[]{method.getName(), onMBean, impactName, description});
        }
        try {
            int impact = 3;
            if ("UNKNOWN".equals(impactName)) {
                impact = 3;
            } else if ("ACTION".equals(impactName)) {
                impact = 1;
            } else if ("INFO".equals(impactName)) {
                impact = 0;
            } else if ("ACTION_INFO".equals(impactName)) {
                impact = 2;
            } else {
                LOG.warn("Unknown impact '" + impactName + "' for " + method, new Object[0]);
            }
            Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
            Class<?>[] methodTypes = method.getParameterTypes();
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[allParameterAnnotations.length];
            for (int i = 0; i < allParameterAnnotations.length; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation anno : parameterAnnotations = allParameterAnnotations[i]) {
                    if (!(anno instanceof Name)) continue;
                    Name nameAnnotation = (Name)anno;
                    pInfo[i] = new MBeanParameterInfo(nameAnnotation.value(), methodTypes[i].getName(), nameAnnotation.description());
                }
            }
            StringBuilder builder = new StringBuilder(method.getName());
            builder.append("(");
            for (int i = 0; i < methodTypes.length; ++i) {
                builder.append(methodTypes[i].getName());
                if (i == methodTypes.length - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            String signature = builder.toString();
            Class<?> returnClass = method.getReturnType();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method Cache: " + signature, new Object[0]);
            }
            if (this._methods.containsKey(signature)) {
                return null;
            }
            this._methods.put(signature, method);
            if (convert) {
                this._convert.add(signature);
            }
            return new MBeanOperationInfo(method.getName(), description, pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact);
        }
        catch (Exception e) {
            LOG.warn("Operation '" + method + "'", (Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    protected String toVariableName(String methodName) {
        String variableName = methodName;
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            variableName = variableName.substring(3);
        } else if (methodName.startsWith("is")) {
            variableName = variableName.substring(2);
        }
        return variableName.substring(0, 1).toLowerCase(Locale.ENGLISH) + variableName.substring(1);
    }

    protected boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        for (Class<?> test = clazz; test != null; test = test.getSuperclass()) {
            if (!test.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }
}

