/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.util.Collections;
import java.util.Map;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.security.CredentialsCallbackHandler;
import org.apache.jackrabbit.core.security.authentication.JAASAuthContext;

public abstract class AuthContext
implements org.apache.jackrabbit.core.security.authentication.AuthContext {

    public static class Local
    extends AuthContext {
        private final LoginModule module;
        private final Map options;
        private Subject subject;
        private Credentials creds;

        public Local(LoginModule module, Map options, Credentials creds) {
            this.module = module;
            this.options = options;
            this.creds = creds;
        }

        public void login() throws LoginException {
            this.subject = new Subject();
            this.module.initialize(this.subject, new CredentialsCallbackHandler(this.creds), Collections.EMPTY_MAP, this.options);
            LoginException failure = null;
            try {
                if (!this.module.login()) {
                    failure = new LoginException("Login not confirmed");
                }
            }
            catch (LoginException e) {
                failure = e;
            }
            if (failure != null) {
                this.module.abort();
                throw failure;
            }
            this.module.commit();
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void logout() throws LoginException {
            if (this.subject == null) {
                throw new LoginException("Logout called before login");
            }
            this.module.logout();
        }
    }

    public static class JAAS
    extends JAASAuthContext {
        public JAAS(String name, Credentials creds) throws LoginException {
            super(name, new CredentialsCallbackHandler(creds), null);
        }
    }
}

