/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables.reference;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class VariableMappingUsagePoint
implements UsagePoint {
    private final CiProperty targetProperty;
    private ConfigurationItem ci;
    private String fqPropertyName;

    public VariableMappingUsagePoint(ConfigurationItem ci, String fqPropertyName, CiProperty targetProperty) {
        this.ci = ci;
        this.fqPropertyName = fqPropertyName;
        this.targetProperty = targetProperty;
    }

    @Override
    public Map<String, VariableReference.VariableUsageType> collectVariables() {
        PropertyUsagePoint propertyUsagePoint = new PropertyUsagePoint(this.targetProperty);
        return VariableHelper.collectVariables(this.getVariableMapping(this.ci).get(this.fqPropertyName)).stream().collect(Collectors.toMap(Function.identity(), propertyUsagePoint::getVariableUsageType));
    }

    @Override
    public Set<ConfigurationItem> replaceVariable(Variable variable, VariableOrValue replacement) {
        HashSet updatedItems = Sets.newHashSet((Object[])new ConfigurationItem[]{this.ci});
        Map<String, String> variableMapping = this.getVariableMapping(this.ci);
        if (replacement.getVariable() != null) {
            variableMapping.put(this.fqPropertyName, replacement.getVariable());
        } else {
            this.targetProperty.setValue(replacement.getValue());
            updatedItems.add(this.targetProperty.getParentCi());
            variableMapping.remove(this.fqPropertyName);
        }
        return updatedItems;
    }

    private Map<String, String> getVariableMapping(ConfigurationItem ci) {
        if (ci.hasProperty("variableMapping")) {
            return (Map)ci.getProperty("variableMapping");
        }
        return new HashMap<String, String>();
    }

    @Override
    public CiProperty getTargetProperty() {
        return this.targetProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableMappingUsagePoint that = (VariableMappingUsagePoint)o;
        return this.ci.getType().equals((Object)this.ci.getType()) && this.ci.equals(that.ci) && this.fqPropertyName.equals(that.fqPropertyName);
    }

    public int hashCode() {
        int result = this.ci.hashCode();
        result = 31 * result + this.fqPropertyName.hashCode();
        return result;
    }
}

