/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.util.StringUtils;
import liquibase.util.csv.opencsv.CSVReader;
import liquibase.util.csv.opencsv.bean.BeanField;
import liquibase.util.csv.opencsv.bean.CsvBind;
import liquibase.util.csv.opencsv.bean.MappingStrategy;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Map<String, BeanField> fieldMap = null;
    protected Class<T> type;
    protected boolean annotationDriven;
    protected boolean determinedIfAnnotationDriven;

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
        this.header = reader.readNext();
    }

    protected void createIndexLookup(String[] values) {
        if (this.indexLookup.isEmpty()) {
            for (int i = 0; i < values.length; ++i) {
                this.indexLookup.put(values[i], i);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (null == this.header) {
            throw new IllegalStateException("The header row hasn't been read yet.");
        }
        this.createIndexLookup(this.header);
        return this.indexLookup.get(name);
    }

    @Override
    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return StringUtils.trimToNull(columnName) != null ? this.findDescriptor(columnName) : null;
    }

    @Override
    public BeanField findField(int col) {
        String columnName = this.getColumnName(col);
        return StringUtils.trimToNull(columnName) != null ? this.findField(columnName) : null;
    }

    public String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap();
        }
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    protected BeanField findField(String name) {
        if (null == this.fieldMap) {
            this.fieldMap = this.loadFieldMap();
        }
        return this.fieldMap.get(name.toUpperCase().trim());
    }

    protected boolean matches(String name, PropertyDescriptor desc) {
        return desc.getName().equals(name.trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors = this.loadDescriptors(this.getType())) {
            map.put(descriptor.getName().toUpperCase().trim(), descriptor);
        }
        return map;
    }

    protected Map<String, BeanField> loadFieldMap() {
        HashMap<String, BeanField> map = new HashMap<String, BeanField>();
        for (Field field : this.loadFields(this.getType())) {
            boolean required = field.getAnnotation(CsvBind.class).required();
            map.put(field.getName().toUpperCase().trim(), new BeanField(field, required));
        }
        return map;
    }

    private PropertyDescriptor[] loadDescriptors(Class<T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    private List<Field> loadFields(Class<T> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CsvBind.class)) continue;
            fields.add(field);
        }
        return fields;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    @Override
    public boolean isAnnotationDriven() {
        if (!this.determinedIfAnnotationDriven) {
            for (Field field : this.type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(CsvBind.class)) continue;
                this.annotationDriven = true;
                break;
            }
            this.determinedIfAnnotationDriven = true;
        }
        return this.annotationDriven;
    }
}

