/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.io;

import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.io.ByteChunkProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileByteChunkProvider
extends ByteChunkProvider {
    private File file;
    private BufferedInputStream fis;

    public FileByteChunkProvider(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new BufferedInputStream(new FileInputStream(file), 65536);
    }

    public FileByteChunkProvider(File file, long offset) throws IOException {
        this.file = file;
        this.fis = new BufferedInputStream(new FileInputStream(file), 65536);
        this.ensureSkipped(this.fis, offset);
        this.offset = offset;
    }

    private void ensureSkipped(BufferedInputStream fis, long offset) throws IOException {
        long skipped;
        for (skipped = 0L; skipped < offset && fis.available() > 0; skipped += fis.skip(offset)) {
        }
        if (skipped < offset) {
            throw new IOException("Was unable to go to the requested offset of " + offset + " of file " + this.file);
        }
    }

    @Override
    protected int getChunk(byte[] chunk) throws IOException {
        int count;
        int read = 0;
        for (count = 0; count < 65536 && (read = this.fis.read(chunk, count, 65536 - count)) != -1; count += read) {
        }
        return count;
    }

    @Override
    public int bytesLeft() {
        try {
            return this.fis.available();
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.bytesLeft() > 0;
    }
}

