/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.protocol.commons;

public class ByteArrayUtils {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean equals(byte[] a1, int a1Offset, byte[] a2, int a2Offset, int length) {
        if (a1.length < a1Offset + length || a2.length < a2Offset + length) {
            return false;
        }
        for (int l = 0; l < length; ++l) {
            if (a1[a1Offset + l] == a2[a2Offset + l]) continue;
            return false;
        }
        return true;
    }

    public static String printHex(byte[] array) {
        return ByteArrayUtils.printHex(array, 0, array.length);
    }

    public static String printHex(byte[] array, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = array[offset + i];
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(digits[b >> 4 & 0xF]);
            sb.append(digits[b & 0xF]);
        }
        return sb.toString();
    }

    public static String toHex(byte[] array) {
        return ByteArrayUtils.toHex(array, 0, array.length);
    }

    public static String toHex(byte[] array, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = array[offset + i];
            sb.append(digits[b >> 4 & 0xF]);
            sb.append(digits[b & 0xF]);
        }
        return sb.toString();
    }
}

