/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.PlatformEx;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import jnacontrib.jna.Advapi32;
import org.rzo.yajsw.os.ServiceInfo;
import org.rzo.yajsw.os.ServiceInfoImpl;
import org.rzo.yajsw.util.MyReentrantLock;

public abstract class Win32Service {
    protected String serviceName;
    private ServiceMain serviceMain;
    private ServiceControl serviceControl;
    private Pointer serviceStatusHandle;
    protected Object waitObject = new Object();
    private int stopTimeout = 5000;
    private int startupTimeout = 30000;
    protected volatile int checkPoint = 0;
    private boolean autoReportStartup = true;
    private Lock startupLock = new MyReentrantLock();
    private Condition startupCondition = this.startupLock.newCondition();
    private volatile boolean _stopping = false;
    public volatile String _stopReason = null;
    private static int lastWinError = -1;
    protected int _debug = 3;

    public Win32Service(String serviceName) {
        this.serviceName = serviceName;
    }

    public Win32Service() {
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setDebug(int value) {
        this._debug = value;
    }

    public boolean install(String displayName, String description, String[] dependencies, String account, String password, boolean delayedAutostart) {
        return this.install(displayName, description, dependencies, account, password, "java.exe -cp \"" + System.getProperty("java.class.path") + "\" -Xrs " + this.getClass().getName(), "AUTO_START", false, null);
    }

    public boolean install(String displayName, String description, String[] dependencies, String account, String password, String command, String startType, boolean interactive, Object failureActions) {
        boolean success = false;
        String dep = "";
        if (dependencies != null) {
            for (String s : dependencies) {
                dep = dep + s + "\u0000";
            }
        }
        dep = dep + "\u0000";
        Advapi32.SERVICE_DESCRIPTION desc = new Advapi32.SERVICE_DESCRIPTION();
        desc.lpDescription = description;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE serviceManager = Win32Service.openServiceControlManager(null, 983103);
        int winStartType = "DEMAND_START".equals(startType) ? 3 : 2;
        int dwServiceType = 16;
        if (interactive) {
            dwServiceType |= 0x100;
        }
        if (serviceManager != null) {
            int err;
            System.out.println("service cmd: " + command);
            Pointer service = advapi32.CreateService(serviceManager, this.serviceName, displayName, 983551, dwServiceType, winStartType, 1, command, null, null, dep, account, password);
            if (service != null) {
                if (failureActions != null && !(success = advapi32.ChangeServiceConfig2(service, 2, (Advapi32.SERVICE_FAILURE_ACTIONS)((Object)failureActions)))) {
                    err = Native.getLastError();
                    System.out.println("ERROR Setting failure actions #" + err + " " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
                }
                success = advapi32.ChangeServiceConfig2(service, 1, desc);
                if (PlatformEx.isWinVista() && "DELAYED_AUTO_START".equals(startType)) {
                    Advapi32.SERVICE_DELAYED_AUTO_START_INFO delayedDesc = new Advapi32.SERVICE_DELAYED_AUTO_START_INFO();
                    delayedDesc.fDelayedAutostart = true;
                    success = advapi32.ChangeServiceConfig2(service, 3, delayedDesc);
                }
                advapi32.CloseServiceHandle(service);
            } else {
                err = Kernel32.INSTANCE.GetLastError();
                System.out.println("error during install " + err);
                System.out.println(Kernel32Util.formatMessageFromLastErrorCode((int)err));
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean uninstall() {
        boolean success = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE serviceManager = Win32Service.openServiceControlManager(null, 983103);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = advapi32.OpenService(serviceManager, this.serviceName, 983551);
            if (service != null) {
                success = advapi32.DeleteService(service);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public static ServiceInfo serviceInfo(String name) {
        ServiceInfoImpl result = new ServiceInfoImpl();
        result.setName(name);
        int state = 128;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE serviceManager = Win32Service.openServiceControlManager(null, Integer.MIN_VALUE);
        if (serviceManager != null) {
            state = 0;
            Winsvc.SC_HANDLE service = advapi32.OpenService(serviceManager, name, Integer.MIN_VALUE);
            if (service != null) {
                Memory buffer;
                int cbBufSize;
                IntByReference pcbBytesNeeded = new IntByReference();
                state |= 1;
                if (!advapi32.QueryServiceConfig(service, null, 0, pcbBytesNeeded)) {
                    cbBufSize = pcbBytesNeeded.getValue();
                    buffer = new Memory((long)cbBufSize);
                    buffer.clear();
                    if (advapi32.QueryServiceConfig(service, buffer, cbBufSize, pcbBytesNeeded)) {
                        Advapi32.QUERY_SERVICE_CONFIG lpServiceConfig = new Advapi32.QUERY_SERVICE_CONFIG();
                        lpServiceConfig.init((Pointer)buffer);
                        if (lpServiceConfig.dwStartType == 4) {
                            state |= 0x20;
                        }
                        if (lpServiceConfig.dwStartType == 0 | lpServiceConfig.dwStartType == 1 | lpServiceConfig.dwStartType == 2) {
                            state |= 8;
                        }
                        if (lpServiceConfig.dwStartType == 3) {
                            state |= 0x10;
                        }
                        if ((lpServiceConfig.dwServiceType & 0x100) != 0) {
                            state |= 4;
                        }
                        result.setAccount(lpServiceConfig.lpServiceStartName);
                        result.setCommand(lpServiceConfig.lpBinaryPathName);
                        result.setDependencies(lpServiceConfig.getDependencies());
                        result.setDisplayName(lpServiceConfig.lpDisplayName);
                    } else {
                        state |= 0x80;
                        System.out.println("Error in QueryServiceConfig: " + Native.getLastError());
                    }
                } else {
                    state |= 0x80;
                    System.out.println("Error in QueryServiceConfig: " + Native.getLastError());
                }
                if (!advapi32.QueryServiceStatusEx(service, 0, null, 0, pcbBytesNeeded)) {
                    cbBufSize = pcbBytesNeeded.getValue();
                    buffer = new Winsvc.SERVICE_STATUS_PROCESS(cbBufSize);
                    buffer.clear();
                    if (advapi32.QueryServiceStatusEx(service, 0, (Winsvc.SERVICE_STATUS_PROCESS)buffer, cbBufSize, pcbBytesNeeded)) {
                        buffer.read();
                        if (buffer.dwCurrentState == 4) {
                            state |= 2;
                        }
                        if (buffer.dwCurrentState == 7) {
                            state |= 0x40;
                        }
                        if (buffer.dwCurrentState == 2) {
                            state |= 0x30;
                        }
                        if (buffer.dwCurrentState == 3) {
                            state |= 0x28;
                        }
                        result.setPid(buffer.dwProcessId);
                    } else {
                        state |= 0x80;
                        System.out.println("Error in QueryServiceStatusEx: " + Native.getLastError());
                    }
                }
                if (!advapi32.QueryServiceConfig2(service, (short)1, null, 0, pcbBytesNeeded)) {
                    cbBufSize = pcbBytesNeeded.getValue();
                    buffer = new Memory((long)cbBufSize);
                    buffer.clear();
                    if (advapi32.QueryServiceConfig2(service, (short)1, buffer, cbBufSize, pcbBytesNeeded)) {
                        Advapi32.SERVICE_DESCRIPTION lpBuffer = new Advapi32.SERVICE_DESCRIPTION();
                        lpBuffer.init(buffer);
                        result.setDescription(lpBuffer.lpDescription);
                    } else {
                        state |= 0x80;
                        System.out.println("Error in QueryServiceStatusEx: " + Native.getLastError());
                    }
                } else {
                    state |= 0x80;
                    System.out.println("Error in QueryServiceStatusEx: " + Native.getLastError());
                }
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        result.setState(state);
        return result;
    }

    public int state() {
        int result = 128;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE serviceManager = Win32Service.openServiceControlManager(null, Integer.MIN_VALUE);
        if (serviceManager != null) {
            result = 0;
            Winsvc.SC_HANDLE service = advapi32.OpenService(serviceManager, this.serviceName, Integer.MIN_VALUE);
            if (service != null) {
                int error;
                Memory buffer;
                int cbBufSize;
                IntByReference pcbBytesNeeded = new IntByReference();
                result |= 1;
                if (!advapi32.QueryServiceConfig(service, null, 0, pcbBytesNeeded)) {
                    cbBufSize = pcbBytesNeeded.getValue();
                    if (cbBufSize > 8192) {
                        cbBufSize = 8192;
                    }
                    buffer = new Memory((long)cbBufSize);
                    buffer.clear();
                    if (advapi32.QueryServiceConfig(service, buffer, cbBufSize, pcbBytesNeeded)) {
                        Advapi32.QUERY_SERVICE_CONFIG lpServiceConfig = new Advapi32.QUERY_SERVICE_CONFIG();
                        lpServiceConfig.init((Pointer)buffer);
                        if (lpServiceConfig.dwStartType == 4) {
                            result |= 0x20;
                        }
                        if (lpServiceConfig.dwStartType == 0 | lpServiceConfig.dwStartType == 1 | lpServiceConfig.dwStartType == 2) {
                            result |= 8;
                        }
                        if (lpServiceConfig.dwStartType == 3) {
                            result |= 0x10;
                        }
                        if ((lpServiceConfig.dwServiceType & 0x100) != 0) {
                            result |= 4;
                        }
                    } else {
                        result |= 0x80;
                        int error2 = Native.getLastError();
                        System.out.println("Error getting buffer size in QueryServiceConfig: " + error2 + " " + Kernel32Util.formatMessageFromLastErrorCode((int)error2));
                    }
                } else {
                    result |= 0x80;
                    error = Native.getLastError();
                    System.out.println("Error in QueryServiceConfig: " + error + " " + Kernel32Util.formatMessageFromLastErrorCode((int)error));
                }
                if (!advapi32.QueryServiceStatusEx(service, 0, null, 0, pcbBytesNeeded)) {
                    cbBufSize = pcbBytesNeeded.getValue();
                    buffer = new Winsvc.SERVICE_STATUS_PROCESS(cbBufSize);
                    buffer.clear();
                    if (advapi32.QueryServiceStatusEx(service, 0, (Winsvc.SERVICE_STATUS_PROCESS)buffer, cbBufSize, pcbBytesNeeded)) {
                        buffer.read();
                        if (buffer.dwCurrentState == 4) {
                            result |= 2;
                        }
                        if (buffer.dwCurrentState == 7) {
                            result |= 0x40;
                        }
                    } else {
                        result |= 0x80;
                        int error3 = Native.getLastError();
                        System.out.println("Error getting buffer size in QueryServiceStatusEx: " + error3 + " " + Kernel32Util.formatMessageFromLastErrorCode((int)error3));
                    }
                } else {
                    result |= 0x80;
                    error = Native.getLastError();
                    System.out.println("Error in QueryServiceStatusEx: " + error + " " + Kernel32Util.formatMessageFromLastErrorCode((int)error));
                }
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return result;
    }

    public boolean start() {
        boolean success = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE serviceManager = Win32Service.openServiceControlManager(null, 0x20000000);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = advapi32.OpenService(serviceManager, this.serviceName, 0x20000000);
            if (service != null) {
                success = advapi32.StartService(service, 0, null);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean stop() throws Exception {
        boolean success = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE serviceManager = Win32Service.openServiceControlManager(null, 0x20000000);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = advapi32.OpenService(serviceManager, this.serviceName, 0x20000000);
            if (service != null) {
                Winsvc.SERVICE_STATUS serviceStatus = new Winsvc.SERVICE_STATUS();
                success = advapi32.ControlService(service, 1, serviceStatus);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public void init() {
        this.serviceMain = new ServiceMain();
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Advapi32.SERVICE_TABLE_ENTRY entry = new Advapi32.SERVICE_TABLE_ENTRY();
        entry.size();
        entry.lpServiceName = this.serviceName;
        entry.lpServiceProc = this.serviceMain;
        entry.write();
        if (!advapi32.StartServiceCtrlDispatcher(entry.toArray(2))) {
            int err;
            this.log("error in StartServiceCtrlDispatcher", 0);
            lastWinError = err = Native.getLastError();
            this.log(err + ":" + Kernel32Util.formatMessageFromLastErrorCode((int)err), 0);
        }
    }

    public void setStopTimeout(int t) {
        this.stopTimeout = t;
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportStartup() {
        this.reportStatus(4, 0, 0);
        this.onStart();
        try {
            Object object = this.waitObject;
            synchronized (object) {
                this.waitObject.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.reportStatus(1, 0, 0);
    }

    private static Winsvc.SC_HANDLE openServiceControlManager(String machine, int access) {
        Winsvc.SC_HANDLE handle = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        handle = advapi32.OpenSCManager(machine, null, access);
        if (handle == null) {
            int err;
            lastWinError = err = Native.getLastError();
            System.out.println("Error in OpenSCManager: " + Integer.toHexString(err));
            if (err == 5) {
                System.out.println("Access denied: please check the user credentials");
            }
        }
        return handle;
    }

    public static Map<String, Advapi32.ENUM_SERVICE_STATUS_PROCESS> enumerateServices(String machine) {
        HashMap<String, Advapi32.ENUM_SERVICE_STATUS_PROCESS> result = new HashMap<String, Advapi32.ENUM_SERVICE_STATUS_PROCESS>();
        Winsvc.SC_HANDLE sc = Win32Service.openServiceControlManager(machine, 4);
        if (sc != null && !sc.equals(null)) {
            Memory service_data = null;
            int service_data_size = 0;
            int infoLevel = 0;
            IntByReference bytesNeeded = new IntByReference(0);
            IntByReference srvCount = new IntByReference(0);
            IntByReference resumeHandle = new IntByReference(0);
            int srvType = 48;
            int srvState = 3;
            boolean retVal = Advapi32.INSTANCE.EnumServicesStatusExW(sc, infoLevel, srvType, srvState, service_data, service_data_size, bytesNeeded, srvCount, resumeHandle, null);
            int err = Native.getLastError();
            if (!retVal || err == 234) {
                int bytesCount = bytesNeeded.getValue();
                service_data = new Memory((long)bytesCount);
                service_data.clear();
                service_data_size = bytesCount;
                resumeHandle.setValue(0);
                retVal = Advapi32.INSTANCE.EnumServicesStatusExW(sc, infoLevel, srvType, srvState, service_data, service_data_size, bytesNeeded, srvCount, resumeHandle, null);
                if (!retVal) {
                    err = Native.getLastError();
                    System.out.println("Error in EnumServicesStatusExA " + Integer.toHexString(err));
                    return null;
                }
            } else {
                return null;
            }
            Advapi32.ENUM_SERVICE_STATUS_PROCESS serviceStatus = new Advapi32.ENUM_SERVICE_STATUS_PROCESS();
            serviceStatus.init((Pointer)service_data);
            for (int i = 0; i < srvCount.getValue(); ++i) {
                result.put(serviceStatus.getServiceName().toLowerCase(), serviceStatus);
                serviceStatus = serviceStatus.next();
            }
        }
        Advapi32.INSTANCE.CloseServiceHandle(sc);
        return result;
    }

    protected void reportStatus(int status, int win32ExitCode, int waitHint) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Winsvc.SERVICE_STATUS serviceStatus = new Winsvc.SERVICE_STATUS();
        serviceStatus.dwServiceType = 16;
        serviceStatus.dwControlsAccepted = 5;
        serviceStatus.dwWin32ExitCode = win32ExitCode;
        serviceStatus.dwWaitHint = waitHint;
        serviceStatus.dwCurrentState = status;
        serviceStatus.dwCheckPoint = this.checkPoint;
        this.log("reporting status " + this.checkPoint, 2);
        advapi32.SetServiceStatus(this.serviceStatusHandle, serviceStatus);
    }

    public abstract void onStart();

    public abstract void onStop();

    public abstract void log(String var1, int var2);

    public int getStartupTimeout() {
        return this.startupTimeout;
    }

    public boolean isAutoReportStartup() {
        return this.autoReportStartup;
    }

    public void setStartupTimeout(int startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public void setAutoReportStartup(boolean autoReportStartup) {
        this.autoReportStartup = autoReportStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStartup() {
        try {
            this.startupLock.lock();
            this.startupCondition.signal();
        }
        finally {
            this.startupLock.unlock();
        }
    }

    public void signalStopping(long waitHint) {
        if (this._stopping) {
            this.reportStatus(3, 0, (int)waitHint);
        }
    }

    public boolean requestElevation() {
        return lastWinError == 5;
    }

    static /* synthetic */ ServiceControl access$102(Win32Service x0, ServiceControl x1) {
        x0.serviceControl = x1;
        return x0.serviceControl;
    }

    static /* synthetic */ Pointer access$302(Win32Service x0, Pointer x1) {
        x0.serviceStatusHandle = x1;
        return x0.serviceStatusHandle;
    }

    static /* synthetic */ ServiceControl access$100(Win32Service x0) {
        return x0.serviceControl;
    }

    static /* synthetic */ boolean access$400(Win32Service x0) {
        return x0.autoReportStartup;
    }

    static /* synthetic */ int access$500(Win32Service x0) {
        return x0.startupTimeout;
    }

    static /* synthetic */ Lock access$600(Win32Service x0) {
        return x0.startupLock;
    }

    static /* synthetic */ Condition access$700(Win32Service x0) {
        return x0.startupCondition;
    }

    private class ServiceControl
    implements Advapi32.HandlerEx {
        private ServiceControl() {
        }

        @Override
        public int callback(int dwControl, int dwEventType, Pointer lpEventData, Pointer lpContext) {
            Win32Service.this.log("received service control " + dwControl, 2);
            switch (dwControl) {
                case 1: 
                case 5: {
                    Win32Service.this.checkPoint = 1;
                    Win32Service.this.reportStatus(3, 0, Win32Service.this.stopTimeout);
                    Win32Service.this._stopping = true;
                    if (dwControl == 1) {
                        Win32Service.this._stopReason = "SERVICE";
                    }
                    if (dwControl == 5) {
                        Win32Service.this._stopReason = "COMPUTER";
                    }
                    Win32Service.this.onStop();
                }
            }
            return 0;
        }
    }

    private class ServiceMain
    implements Advapi32.SERVICE_MAIN_FUNCTION {
        private ServiceMain() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void callback(int dwArgc, Pointer lpszArgv) {
            advapi32 = Advapi32.INSTANCE;
            Win32Service.this.log("+ ServiceMain callback", 2);
            Win32Service.access$102(Win32Service.this, new ServiceControl());
            Win32Service.access$302(Win32Service.this, advapi32.RegisterServiceCtrlHandlerEx(Win32Service.this.serviceName, Win32Service.access$100(Win32Service.this), null));
            if (!Win32Service.access$400(Win32Service.this)) {
                try {
                    Win32Service.this.reportStatus(2, 0, Win32Service.access$500(Win32Service.this));
                    Win32Service.access$600(Win32Service.this).lock();
                    if (Win32Service.access$700(Win32Service.this).await(Win32Service.access$500(Win32Service.this), TimeUnit.MILLISECONDS)) ** GOTO lbl22
                    Win32Service.this.log("service startup timeout -> aborting", 0);
                    System.exit(999);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    Win32Service.access$600(Win32Service.this).unlock();
                }
            } else {
                Win32Service.this.reportStatus(2, 0, 5000);
            }
lbl22:
            // 4 sources

            Win32Service.this.reportStartup();
        }
    }
}

