/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$InfoLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetector;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rMq!B\u0001\u0003\u0011\u00039\u0011aB\"mkN$XM\u001d\u0006\u0003\u0007\u0011\tqa\u00197vgR,'OC\u0001\u0006\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t91\t\\;ti\u0016\u00148#B\u0005\r%\t\r\bCA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00015M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001C:fiRLgnZ:\u0016\u00035\u0002\"\u0001\u0003\u0018\n\u0005=\u0012!aD\"mkN$XM]*fiRLgnZ:\t\rEJ\u0002\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u000443\t\u0007I\u0011\u0001\u001b\u0002#M,GNZ+oSF,X-\u00113ee\u0016\u001c8/F\u00016!\tAa'\u0003\u00028\u0005\tiQK\\5rk\u0016\fE\r\u001a:fgNDa!O\r!\u0002\u0013)\u0014AE:fY\u001a,f.[9vK\u0006#GM]3tg\u0002BQaO\r\u0005\u0002q\n1b]3mM\u0006#GM]3tgV\tQ\b\u0005\u0002\u0014}%\u0011q\b\u0006\u0002\b\u0003\u0012$'/Z:t\u0011\u0015\t\u0015\u0004\"\u0001C\u0003%\u0019X\r\u001c4S_2,7/F\u0001D!\r!5J\u0014\b\u0003\u000b&\u0003\"A\u0012\b\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\tQe\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u00131aU3u\u0015\tQe\u0002\u0005\u0002E\u001f&\u0011\u0001+\u0014\u0002\u0007'R\u0014\u0018N\\4\t\u000bIKB\u0011A*\u0002\u0019\u001d,GoU3mMJ{G.Z:\u0016\u0003Q\u00032!\u0016.O\u001b\u00051&BA,Y\u0003\u0011)H/\u001b7\u000b\u0003e\u000bAA[1wC&\u0011AJ\u0016\u0005\b9f\u0011\r\u0011\"\u0003^\u00035y\u0016n\u001d+fe6Lg.\u0019;fIV\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u00061\u0011\r^8nS\u000eT!a\u0019,\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002fA\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:DaaZ\r!\u0002\u0013q\u0016AD0jgR+'/\\5oCR,G\r\t\u0005\bSf\u0011\r\u0011\"\u0003k\u0003\rawnZ\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011a\u000eB\u0001\u0006KZ,g\u000e^\u0005\u0003a6\u0014a\u0002T8hO&tw-\u00113baR,'\u000f\u0003\u0004s3\u0001\u0006Ia[\u0001\u0005Y><\u0007\u0005C\u0004u3\u0001\u0007I\u0011B;\u0002\u0015\rdWo\u001d;fe*k\u00070F\u0001w!\riq/_\u0005\u0003q:\u0011aa\u00149uS>t\u0007C\u0001\u0005{\u0013\tY(A\u0001\u0006DYV\u001cH/\u001a:K[bDq!`\rA\u0002\u0013%a0\u0001\bdYV\u001cH/\u001a:K[b|F%Z9\u0015\u0007}\f)\u0001E\u0002\u000e\u0003\u0003I1!a\u0001\u000f\u0005\u0011)f.\u001b;\t\u0011\u0005\u001dA0!AA\u0002Y\f1\u0001\u001f\u00132\u0011\u001d\tY!\u0007Q!\nY\f1b\u00197vgR,'OS7yA!I\u0011qB\rC\u0002\u0013\u0005\u0011\u0011C\u0001\u0010M\u0006LG.\u001e:f\t\u0016$Xm\u0019;peV\u0011\u00111\u0003\t\u0006\u0003+\tY\"P\u0007\u0003\u0003/Q1!!\u0007\u0005\u0003\u0019\u0011X-\\8uK&!\u0011QDA\f\u0005]1\u0015-\u001b7ve\u0016$U\r^3di>\u0014(+Z4jgR\u0014\u0018\u0010\u0003\u0005\u0002\"e\u0001\u000b\u0011BA\n\u0003A1\u0017-\u001b7ve\u0016$U\r^3di>\u0014\b\u0005\u0003\u0006\u0002&eA)\u0019!C\u0001\u0003O\tq\u0002Z8x]&tw\r\u0015:pm&$WM]\u000b\u0003\u0003S\u00012\u0001CA\u0016\u0013\r\tiC\u0001\u0002\u0010\t><h.\u001b8h!J|g/\u001b3fe\"Q\u0011\u0011G\rC\u0002\u0013\u0005!!a\r\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u001b!\r\u0019\u0012qG\u0005\u0004\u0003s!\"!C*dQ\u0016$W\u000f\\3s\u0011!\ti$\u0007Q\u0001\n\u0005U\u0012AC:dQ\u0016$W\u000f\\3sA!I\u0011\u0011I\rC\u0002\u0013%\u00111I\u0001\u000fG2,8\u000f^3s\t\u0006,Wn\u001c8t+\t\t)\u0005E\u0002\u0014\u0003\u000fJ1!!\u0013\u0015\u0005!\t5\r^8s%\u00164\u0007\u0002CA'3\u0001\u0006I!!\u0012\u0002\u001f\rdWo\u001d;fe\u0012\u000bW-\\8og\u0002B!\"!\u0015\u001a\u0005\u0004%\tAAA\"\u0003-\u0019G.^:uKJ\u001cuN]3\t\u0011\u0005U\u0013\u0004)A\u0005\u0003\u000b\nAb\u00197vgR,'oQ8sK\u0002B!\"!\u0017\u001a\u0005\u0004%\tAAA.\u0003!\u0011X-\u00193WS\u0016<XCAA/!\rA\u0011qL\u0005\u0004\u0003C\u0012!aD\"mkN$XM\u001d*fC\u00124\u0016.Z<\t\u0011\u0005\u0015\u0014\u0004)A\u0005\u0003;\n\u0011B]3bIZKWm\u001e\u0011\t\u000f\u0005%\u0014\u0004\"\u0001\u0002l\u0005a\u0011n\u001d+fe6Lg.\u0019;fIV\u0011\u0011Q\u000e\t\u0004\u001b\u0005=\u0014bAA9\u001d\t9!i\\8mK\u0006t\u0007bBA;3\u0011\u0005\u0011qO\u0001\u0006gR\fG/Z\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u0002:\u0019\u0001\"! \n\u0007\u0005}$!\u0001\u0007DYV\u001cH/\u001a:Fm\u0016tG/\u0003\u0003\u0002\u0004\u0006\u0015%aE\"veJ,g\u000e^\"mkN$XM]*uCR,'bAA@\u0005!9\u0011\u0011R\r\u0005\u0002\u0005-\u0015!C:vEN\u001c'/\u001b2f)\u0015y\u0018QRAI\u0011!\ty)a\"A\u0002\u0005\u0015\u0013AC:vEN\u001c'/\u001b2fe\"A\u00111SAD\u0001\u0004\t)*\u0001\u0002u_B)Q\"a&\u0002\u001c&\u0019\u0011\u0011\u0014\b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\r\u0003\u0002\u001e\u0006\u001d\u0006#\u0002#\u0002 \u0006\r\u0016bAAQ\u001b\n)1\t\\1tgB!\u0011QUAT\u0019\u0001!A\"!+\u0002\u0012\u0006\u0005\t\u0011!B\u0001\u0003W\u00131a\u0018\u00132#\u0011\ti+a-\u0011\u00075\ty+C\u0002\u00022:\u0011qAT8uQ&tw\rE\u0002\u000e\u0003kK1!a.\u000f\u0005\r\te.\u001f\u0015\u0005\u0003\u000f\u000bY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tMD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAc\u0003\u007f\u0013qA^1sCJ<7\u000fC\u0004\u0002\nf!\t!!3\u0015\u000f}\fY-!4\u0002X\"A\u0011qRAd\u0001\u0004\t)\u0005\u0003\u0005\u0002P\u0006\u001d\u0007\u0019AAi\u0003AIg.\u001b;jC2\u001cF/\u0019;f\u001b>$W\r\u0005\u0003\u0002|\u0005M\u0017\u0002BAk\u0003\u000b\u0013AdU;cg\u000e\u0014\u0018\u000e\u001d;j_:Le.\u001b;jC2\u001cF/\u0019;f\u001b>$W\r\u0003\u0005\u0002\u0014\u0006\u001d\u0007\u0019AAm!\u0015i\u0011qSAna\u0011\ti.!9\u0011\u000b\u0011\u000by*a8\u0011\t\u0005\u0015\u0016\u0011\u001d\u0003\r\u0003G\f9.!A\u0001\u0002\u000b\u0005\u00111\u0016\u0002\u0004?\u0012\u0012\u0004\u0006BAd\u0003wCq!!;\u001a\t\u0003\tY/A\u0006v]N,(m]2sS\n,GcA@\u0002n\"A\u0011qRAt\u0001\u0004\t)\u0005C\u0004\u0002jf!\t!!=\u0015\u000b}\f\u00190!>\t\u0011\u0005=\u0015q\u001ea\u0001\u0003\u000bB\u0001\"a%\u0002p\u0002\u0007\u0011q\u001f\u0019\u0005\u0003s\fi\u0010E\u0003E\u0003?\u000bY\u0010\u0005\u0003\u0002&\u0006uH\u0001DA\u0000\u0003k\f\t\u0011!A\u0003\u0002\u0005-&aA0%g!9!1A\r\u0005\u0002\t\u0015\u0011aF:f]\u0012\u001cUO\u001d:f]R\u001cE.^:uKJ\u001cF/\u0019;f)\ry(q\u0001\u0005\t\u0005\u0013\u0011\t\u00011\u0001\u0002F\u0005A!/Z2fSZ,'\u000fC\u0004\u0003\u000ee!\tAa\u0004\u0002\t)|\u0017N\u001c\u000b\u0004\u007f\nE\u0001b\u0002B\n\u0005\u0017\u0001\r!P\u0001\bC\u0012$'/Z:t\u0011\u001d\u00119\"\u0007C\u0005\u00053\t\u0011BZ5mY2{7-\u00197\u0015\u0007u\u0012Y\u0002C\u0004\u0003\u0014\tU\u0001\u0019A\u001f\t\u000f\t}\u0011\u0004\"\u0001\u0003\"\u0005i!n\\5o'\u0016,GMT8eKN$2a B\u0012\u0011!\u0011)C!\bA\u0002\t\u001d\u0012!C:fK\u0012tu\u000eZ3t!\u0015\u0011ICa\r>\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012!C5n[V$\u0018M\u00197f\u0015\r\u0011\tDD\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u001b\u0005W\u00111aU3r\u0011\u001d\u0011y\"\u0007C\u0001\u0005s!2a B\u001e\u0011!\u0011)Ca\u000eA\u0002\tu\u0002\u0003B+\u0003@uJ1A!\u0011W\u0005\u0011a\u0015n\u001d;\t\u000f\t\u0015\u0013\u0004\"\u0001\u0003H\u0005)A.Z1wKR\u0019qP!\u0013\t\u000f\tM!1\ta\u0001{!9!QJ\r\u0005\u0002\t=\u0013\u0001\u00023po:$2a B)\u0011\u001d\u0011\u0019Ba\u0013A\u0002uBqA!\u0016\u001a\t\u0003\u00119&\u0001\nsK\u001eL7\u000f^3s\u001f:lU-\u001c2feV\u0003X\u0003\u0002B-\u0005O\"2a B.\u0011%\u0011iFa\u0015\u0005\u0002\u0004\u0011y&\u0001\u0003d_\u0012,\u0007#B\u0007\u0003b\t\u0015\u0014b\u0001B2\u001d\tAAHY=oC6,g\b\u0005\u0003\u0002&\n\u001dD\u0001\u0003B5\u0005'\u0012\r!a+\u0003\u0003QCqA!\u0016\u001a\t\u0003\u0011i\u0007F\u0002\u0000\u0005_B\u0001B!\u001d\u0003l\u0001\u0007!1O\u0001\tG\u0006dGNY1dWB!!Q\u000fB>\u001b\t\u00119HC\u0002\u0003za\u000bA\u0001\\1oO&!!Q\u0010B<\u0005!\u0011VO\u001c8bE2,\u0007b\u0002BA3\u0011\u0005!1Q\u0001\u0018e\u0016<\u0017n\u001d;fe>sW*Z7cKJ\u0014V-\\8wK\u0012,BA!\"\u0003\u000eR\u0019qPa\"\t\u0013\tu#q\u0010CA\u0002\t%\u0005#B\u0007\u0003b\t-\u0005\u0003BAS\u0005\u001b#\u0001B!\u001b\u0003\u0000\t\u0007\u00111\u0016\u0005\b\u0005\u0003KB\u0011\u0001BI)\ry(1\u0013\u0005\t\u0005c\u0012y\t1\u0001\u0003t!9!qS\r\u0005\u0002\te\u0015\u0001\u0004:f[>$X\rU1uQ>3G\u0003\u0002BN\u0005C\u00032a\u0005BO\u0013\r\u0011y\n\u0006\u0002\n\u0003\u000e$xN\u001d)bi\"D\u0001Ba)\u0003\u0016\u0002\u0007\u0011QI\u0001\tC\u000e$xN\u001d*fM\"A!qU\r\u0005\u0002\t\u0011I+\u0001\u0005tQV$Hm\\<o)\u0005y\bb\u0002BW3\u0011%!\u0011V\u0001\u000fG2|7/Z*dQ\u0016$W\u000f\\3s\u000f!\u0011\t,\u0007E\u0001\u0005\tM\u0016AC%oM>dunZ4feB!!Q\u0017B\\\u001b\u0005Ib\u0001\u0003B]3!\u0005!Aa/\u0003\u0015%sgm\u001c'pO\u001e,'oE\u0002\u000382Aqa\nB\\\t\u0003\u0011y\f\u0006\u0002\u00034\"A!1\u0019B\\\t\u0003\u0011)-A\u0004m_\u001eLeNZ8\u0015\u0007}\u00149\rC\u0004\u0003J\n\u0005\u0007\u0019\u0001(\u0002\u000f5,7o]1hK\"A!1\u0019B\\\t\u0003\u0011i\rF\u0003\u0000\u0005\u001f\u0014\u0019\u000eC\u0004\u0003R\n-\u0007\u0019\u0001(\u0002\u0011Q,W\u000e\u001d7bi\u0016D\u0001B!6\u0003L\u0002\u0007\u00111W\u0001\u0005CJ<\u0017\u0007\u0003\u0005\u0003D\n]F\u0011\u0001Bm)\u001dy(1\u001cBo\u0005?DqA!5\u0003X\u0002\u0007a\n\u0003\u0005\u0003V\n]\u0007\u0019AAZ\u0011!\u0011\tOa6A\u0002\u0005M\u0016\u0001B1sOJ\u00022a\u0005Bs\u0013\r\u00119\u000f\u0006\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u0005\u0007O%!\tAa;\u0015\u0003\u001dAqAa<\n\t\u0003\u0012\t0A\u0002hKR$2\u0001\u0007Bz\u0011\u001dy\"Q\u001ea\u0001\u0005k\u00042a\u0005B|\u0013\r\u0011I\u0010\u0006\u0002\f\u0003\u000e$xN]*zgR,W\u000eC\u0004\u0003~&!\tEa@\u0002\r1|wn[;q)\t\u0019\tA\u0004\u0002\t\u0001!91QA\u0005\u0005B\r\u001d\u0011aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007a\u0019I\u0001\u0003\u0004 \u0007\u0007\u0001\r!\t\u0005\u000b\u0007\u001bI!\u0019!C\u0003\u0005\u0005-\u0014!G5t\u0003N\u001cXM\u001d;J]Z\f'/[1oiN,e.\u00192mK\u0012D\u0001b!\u0005\nA\u00035\u0011QN\u0001\u001bSN\f5o]3si&sg/\u0019:jC:$8/\u00128bE2,G\r\t")
public class Cluster
implements Extension {
    private DowningProvider downingProvider;
    private volatile Cluster$InfoLogger$ InfoLogger$module;
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile boolean bitmap$0;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public Cluster$InfoLogger$ InfoLogger() {
        if (this.InfoLogger$module == null) {
            this.InfoLogger$lzycompute$1();
        }
        return this.InfoLogger$module;
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.downingProvider;
    }

    public DowningProvider downingProvider() {
        return !this.bitmap$0 ? this.downingProvider$lzycompute() : this.downingProvider;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0 & Serializable & scala.Serializable)() -> "at least one `ClusterDomainEvent` class is required");
        Predef$.MODULE$.require(to.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cluster.$anonfun$subscribe$3(x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)to.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$6 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$7 = qual$2.$bang$default$2((Object)x$6);
        qual$2.$bang((Object)x$6, x$7);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$8 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$9 = qual$3.$bang$default$2((Object)x$8);
        qual$3.$bang((Object)x$8, x$9);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$10 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$11 = qual$4.$bang$default$2((Object)x$10);
        qual$4.$bang((Object)x$10, x$11);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.SendCurrentClusterState x$12 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$13 = qual$5.$bang$default$2((Object)x$12);
        qual$5.$bang((Object)x$12, x$13);
    }

    public void join(Address address) {
        ScalaActorRef qual$6 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$14 = new ClusterUserAction.JoinTo(this.fillLocal(address));
        ActorRef x$15 = qual$6.$bang$default$2((Object)x$14);
        qual$6.$bang((Object)x$14, x$15);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Address fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$7 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$16 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable & scala.Serializable)address -> this.fillLocal((Address)address), Vector$.MODULE$.canBuildFrom())));
        ActorRef x$17 = qual$7.$bang$default$2((Object)x$16);
        qual$7.$bang((Object)x$16, x$17);
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((scala.collection.immutable.Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ScalaActorRef qual$8 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$18 = new ClusterUserAction.Leave(this.fillLocal(address));
        ActorRef x$19 = qual$8.$bang$default$2((Object)x$18);
        qual$8.$bang((Object)x$18, x$19);
    }

    public void down(Address address) {
        ScalaActorRef qual$9 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$20 = new ClusterUserAction.Down(this.fillLocal(address));
        ActorRef x$21 = qual$9.$bang$default$2((Object)x$20);
        qual$9.$bang((Object)x$20, x$21);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$10 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$22 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$23 = qual$10.$bang$default$2((Object)x$22);
        qual$10.$bang((Object)x$22, x$23);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(null, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            ScalaActorRef qual$11 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
            InternalClusterAction.AddOnMemberRemovedListener x$24 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$25 = qual$11.$bang$default$2((Object)x$24);
            qual$11.$bang((Object)x$24, x$25);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$12 = path.root();
            Address x$26 = this.selfAddress();
            String x$27 = qual$12.copy$default$2();
            actorPath = qual$12.copy(x$26, x$27).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    public void shutdown() {
        block1: {
            if (!this._isTerminated().compareAndSet(false, true)) break block1;
            this.InfoLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.unregisterMBean();
                return BoxedUnit.UNIT;
            });
            this.InfoLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void InfoLogger$lzycompute$1() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.InfoLogger$module == null) {
                this.InfoLogger$module = new Cluster$InfoLogger$(this);
            }
        }
    }

    private final FailureDetector createFailureDetector$1() {
        return FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$3 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$4 = timeout$1;
            ActorRef x$5 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$3);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$3, x$4, x$5).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            ActorRef actorRef2 = this.system().deadLetters();
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public static final /* synthetic */ boolean $anonfun$subscribe$3(Class x$1) {
        return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
    }

    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSystem [", "] needs to have a 'ClusterActorRefProvider' enabled in the configuration, currently uses [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system, actorRefProvider.getClass().getName()})));
        }
        ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
        UniqueAddress uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
        this.selfUniqueAddress = uniqueAddress;
        this._isTerminated = new AtomicBoolean(false);
        this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.clusterJmx = None$.MODULE$;
        this.InfoLogger().logInfo("Starting up...");
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0 & Serializable & scala.Serializable)() -> this.createFailureDetector$1());
        package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.InfoLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.scheduler.tick-duration=", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis())}))).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                threadFactory = monitorableThreadFactory.withName(monitorableThreadFactory.name() + "-cluster-scheduler");
            } else {
                threadFactory = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(null, systemScheduler){
                private final Scheduler systemScheduler$1;

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                }

                public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.schedule$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleOnce$default$5$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
                {
                    this.systemScheduler$1 = systemScheduler$1;
                    Scheduler.$init$((Scheduler)this);
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.shutdown());
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
            jmx.createMBean();
            this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
        }
        this.InfoLogger().logInfo("Started up successfully");
    }
}

