/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CiHelper {
    public static final Function<ConfigurationItem, String> TO_ID = ConfigurationItem::getId;

    public static List<ConfigurationItem> getNestedCis(Collection<? extends ConfigurationItem> cis) {
        ArrayList listWithNested = Lists.newArrayList();
        for (ConfigurationItem configurationItem : cis) {
            listWithNested.addAll(CiHelper.getNestedCis(configurationItem));
        }
        return listWithNested;
    }

    public static List<ConfigurationItem> getNestedCis(ConfigurationItem ci) {
        ArrayList listWithNested = Lists.newArrayList((Object[])new ConfigurationItem[]{ci});
        List<ConfigurationItem> children = CiHelper.getChildren(ci);
        for (ConfigurationItem child : children) {
            listWithNested.addAll(CiHelper.getNestedCis(child));
        }
        return listWithNested;
    }

    public static void eraseTokens(ConfigurationItem ci) {
        CiHelper.getNestedCis(ci).forEach(bci -> {
            if (bci instanceof BaseConfigurationItem) {
                ((BaseConfigurationItem)bci).set$token(null);
            }
        });
    }

    public static void rewriteWithNewId(ConfigurationItem ci, String newId) {
        String rewrittenId;
        String oldId = ci.getId();
        String oldIdPattern = String.format("%s(?=/|$)", oldId);
        CiHelper.eraseTokens(ci);
        for (ConfigurationItem nestedCi : CiHelper.getNestedCis(ci)) {
            if (nestedCi.getId() == null) continue;
            rewrittenId = nestedCi.getId().replaceFirst(oldIdPattern, newId);
            nestedCi.setId(rewrittenId);
        }
        for (ConfigurationItem referencedCi : CiHelper.getExternalReferences(ci)) {
            if (referencedCi.getId() == null || !referencedCi.getId().startsWith(oldId)) continue;
            rewrittenId = referencedCi.getId().replaceFirst(oldIdPattern, newId);
            referencedCi.setId(rewrittenId);
        }
    }

    public static Set<ConfigurationItem> getExternalReferences(ConfigurationItem parentCi) {
        HashSet references = Sets.newHashSet();
        for (ConfigurationItem ci : CiHelper.getNestedCis(parentCi)) {
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                Object value;
                if (property.isAsContainment() || (value = property.get(ci)) == null) continue;
                PropertyKind kind = property.getKind();
                if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                    references.addAll((Collection)value);
                }
                if (kind != PropertyKind.CI || CiHelper.isChildViaOneOfChildProperties((ConfigurationItem)value, ci)) continue;
                references.add((ConfigurationItem)value);
            }
        }
        return references;
    }

    public static void stripChildrenCis(ConfigurationItem ci) {
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
            Collection references = (Collection)property.get(ci);
            references.clear();
        }
    }

    public static void removeCisWithId(Collection<? extends ConfigurationItem> fromCis, String idToRemove) {
        fromCis.removeIf(ci -> idToRemove.equals(ci.getId()));
    }

    public static void fixUpInternalReferences(ConfigurationItem parent) {
        List<ConfigurationItem> children = CiHelper.getChildren(parent);
        for (ConfigurationItem child : children) {
            for (PropertyDescriptor property : child.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.CI || !property.isAsContainment() || property.get(child) != null) continue;
                property.set(child, (Object)parent);
            }
            CiHelper.fixUpInternalReferences(child);
        }
    }

    private static List<ConfigurationItem> getChildren(ConfigurationItem ci) {
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child;
            PropertyKind kind = property.getKind();
            if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                children.addAll(CiHelper.getChildrenForProperty(ci, property));
            }
            if (kind != PropertyKind.CI || (child = (ConfigurationItem)property.get(ci)) == null || !CiHelper.isChildViaOneToOneRelationship(child, ci, property)) continue;
            children.add(child);
        }
        return children;
    }

    private static Collection<ConfigurationItem> getChildrenForProperty(ConfigurationItem parent, PropertyDescriptor property) {
        Collection references = (Collection)property.get(parent);
        Collection nonNullReferences = references.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (property.isAsContainment()) {
            return nonNullReferences;
        }
        return nonNullReferences.stream().filter(ci -> CiHelper.isChildViaOneOfChildProperties(ci, parent)).collect(Collectors.toList());
    }

    public static boolean isChildViaOneOfChildProperties(ConfigurationItem possibleChild, ConfigurationItem parent) {
        for (PropertyDescriptor property : possibleChild.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(possibleChild))) continue;
            return true;
        }
        return false;
    }

    private static boolean isChildViaOneToOneRelationship(ConfigurationItem possibleChild, ConfigurationItem parent, PropertyDescriptor parentProperty) {
        if (parent.getType().instanceOf(Type.valueOf(CustomScriptTask.class)) && possibleChild.getType().instanceOf(Type.valueOf(PythonScript.class)) && "pythonScript".equals(parentProperty.getName())) {
            return true;
        }
        return parent.getType().instanceOf(Type.valueOf(Variable.class)) && possibleChild.getType().instanceOf(Type.valueOf(ValueProviderConfiguration.class)) && "valueProvider".equals(parentProperty.getName());
    }

    public static ConfigurationItem forFields(ConfigurationItem ci, PropertyFilter filter, PropertyAction action) {
        ci.getType().getDescriptor().getPropertyDescriptors().stream().filter(filter).forEach(pd -> action.execute(ci, (PropertyDescriptor)pd));
        return ci;
    }

    @FunctionalInterface
    public static interface PropertyAction {
        public void execute(ConfigurationItem var1, PropertyDescriptor var2);
    }

    @FunctionalInterface
    public static interface PropertyFilter
    extends Predicate<PropertyDescriptor> {
    }
}

