/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u00111\u0001B\u0001\u0007e\u0016lw\u000e^3\u000b\u0003\u0015\tA!Y6lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JD\u0001b\u0005\u0001\u0003\u0006\u0004%\t\u0001F\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\r\u0011{WO\u00197f\u0011!I\u0002A!A!\u0002\u0013)\u0012A\u0003;ie\u0016\u001c\bn\u001c7eA!A1\u0004\u0001BC\u0002\u0013\u0005A$A\u0007nCb\u001c\u0016-\u001c9mKNK'0Z\u000b\u0002;A\u0011\u0011BH\u0005\u0003?)\u00111!\u00138u\u0011!\t\u0003A!A!\u0002\u0013i\u0012AD7bqN\u000bW\u000e\u001d7f'&TX\r\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005yQ.\u001b8Ti\u0012$UM^5bi&|g.F\u0001&!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0005ekJ\fG/[8o\u0015\tQ#\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0014\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"Aa\u0006\u0001B\u0001B\u0003%Q%\u0001\tnS:\u001cF\u000f\u001a#fm&\fG/[8oA!A\u0001\u0007\u0001BC\u0002\u0013\u0005A%\u0001\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u001aC\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u0001%\u0003Y1\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR,5\u000f^5nCR,\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002/\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0017\u00154XM\u001c;TiJ,\u0017-\u001c\t\u0004\u0013ib\u0014BA\u001e\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q\bQ\u0007\u0002})\u0011q\bB\u0001\u0006KZ,g\u000e^\u0005\u0003\u0003z\u00121\"\u0012<f]R\u001cFO]3b[\"A1\t\u0001B\u0001B\u0003-A)A\u0003dY>\u001c7\u000e\u0005\u0002F\u001f:\u0011a)\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0002\u0005\u0013\tq%!A\bGC&dWO]3EKR,7\r^8s\u0013\t\u0001\u0016KA\u0003DY>\u001c7N\u0003\u0002O\u0005!)1\u000b\u0001C\u0001)\u00061A(\u001b8jiz\"r!\u0016-Z5ncV\f\u0006\u0002W/B\u0011q\u0002\u0001\u0005\u0006\u0007J\u0003\u001d\u0001\u0012\u0005\u0006'I\u0003\r!\u0006\u0005\u00067I\u0003\r!\b\u0005\u0006GI\u0003\r!\n\u0005\u0006aI\u0003\r!\n\u0005\u0006iI\u0003\r!\n\u0005\u0006qI\u0003\r!\u000f\u0005\u0006'\u0002!\ta\u0018\u000b\u0007A\n\u001cG-\u001a4\u0015\u0005Y\u000b\u0007\"B\"_\u0001\b!\u0005\"B\n_\u0001\u0004)\u0002\"B\u000e_\u0001\u0004i\u0002\"B\u0012_\u0001\u0004)\u0003\"\u0002\u0019_\u0001\u0004)\u0003\"\u0002\u001b_\u0001\u0004)\u0003\"B*\u0001\t\u0003AGc\u0001,ji\")!n\u001aa\u0001W\u000611m\u001c8gS\u001e\u0004\"\u0001\u001c:\u000e\u00035T!A\u001b8\u000b\u0005=\u0004\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003E\f1aY8n\u0013\t\u0019XN\u0001\u0004D_:4\u0017n\u001a\u0005\u0006k\u001e\u0004\r\u0001P\u0001\u0003KZDqa\u001e\u0001C\u0002\u0013%\u00010\u0001\bgSJ\u001cH\u000fS3beR\u0014W-\u0019;\u0016\u0003e\u0004\"a\u0004>\n\u0005m\u0014!\u0001\u0005%fCJ$(-Z1u\u0011&\u001cHo\u001c:z\u0011\u0019i\b\u0001)A\u0005s\u0006ya-\u001b:ti\"+\u0017M\u001d;cK\u0006$\b\u0005\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0003y\t7mY3qi\u0006\u0014G.\u001a%fCJ$(-Z1u!\u0006,8/Z'jY2L7/\u0006\u0002\u0002\u0004A\u0019\u0011\"!\u0002\n\u0007\u0005\u001d!B\u0001\u0003M_:<\u0007\u0002CA\u0006\u0001\u0001\u0006I!a\u0001\u0002?\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-T5mY&\u001c\bE\u0002\u0004\u0002\u0010\u00011\u0015\u0011\u0003\u0002\u0006'R\fG/Z\n\b\u0003\u001bA\u00111CA\r!\rI\u0011QC\u0005\u0004\u0003/Q!a\u0002)s_\u0012,8\r\u001e\t\u0004\u0013\u0005m\u0011bAA\u000f\u0015\ta1+\u001a:jC2L'0\u00192mK\"Q\u0011\u0011EA\u0007\u0005+\u0007I\u0011\u0001=\u0002\u000f!L7\u000f^8ss\"Q\u0011QEA\u0007\u0005#\u0005\u000b\u0011B=\u0002\u0011!L7\u000f^8ss\u0002B1\"!\u000b\u0002\u000e\tU\r\u0011\"\u0001\u0002,\u0005IA/[7fgR\fW\u000e]\u000b\u0003\u0003[\u0001B!\u0003\u001e\u0002\u0004!Y\u0011\u0011GA\u0007\u0005#\u0005\u000b\u0011BA\u0017\u0003)!\u0018.\\3ti\u0006l\u0007\u000f\t\u0005\b'\u00065A\u0011AA\u001b)\u0019\t9$a\u000f\u0002>A!\u0011\u0011HA\u0007\u001b\u0005\u0001\u0001bBA\u0011\u0003g\u0001\r!\u001f\u0005\t\u0003S\t\u0019\u00041\u0001\u0002.!Q\u0011\u0011IA\u0007\u0003\u0003%\t!a\u0011\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003o\t)%a\u0012\t\u0013\u0005\u0005\u0012q\bI\u0001\u0002\u0004I\bBCA\u0015\u0003\u007f\u0001\n\u00111\u0001\u0002.!Q\u00111JA\u0007#\u0003%\t!!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\n\u0016\u0004s\u0006E3FAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u#\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0019\u0002X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0015\u0014QBI\u0001\n\u0003\t9'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%$\u0006BA\u0017\u0003#B!\"!\u001c\u0002\u000e\u0005\u0005I\u0011IA8\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0014\u0001\u00026bm\u0006LA!a \u0002v\t11\u000b\u001e:j]\u001eD\u0011\"a!\u0002\u000e\u0005\u0005I\u0011\u0001\u000f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005\u001d\u0015QBA\u0001\n\u0003\tI)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0015\u0011\u0013\t\u0004\u0013\u00055\u0015bAAH\u0015\t\u0019\u0011I\\=\t\u0013\u0005M\u0015QQA\u0001\u0002\u0004i\u0012a\u0001=%c!Q\u0011qSA\u0007\u0003\u0003%\t%!'\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a'\u0011\r\u0005u\u00151UAF\u001b\t\tyJC\u0002\u0002\"*\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)+a(\u0003\u0011%#XM]1u_JD!\"!+\u0002\u000e\u0005\u0005I\u0011AAV\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAW\u0003g\u00032!CAX\u0013\r\t\tL\u0003\u0002\b\u0005>|G.Z1o\u0011)\t\u0019*a*\u0002\u0002\u0003\u0007\u00111\u0012\u0005\u000b\u0003o\u000bi!!A\u0005B\u0005e\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003uA!\"!0\u0002\u000e\u0005\u0005I\u0011IA`\u0003!!xn\u0015;sS:<GCAA9\u0011)\t\u0019-!\u0004\u0002\u0002\u0013\u0005\u0013QY\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u0016q\u0019\u0005\u000b\u0003'\u000b\t-!AA\u0002\u0005-u!CAf\u0001\u0005\u0005\t\u0012BAg\u0003\u0015\u0019F/\u0019;f!\u0011\tI$a4\u0007\u0013\u0005=\u0001!!A\t\n\u0005E7CBAh\u0003'\fI\u0002E\u0005\u0002V\u0006m\u00170!\f\u000285\u0011\u0011q\u001b\u0006\u0004\u00033T\u0011a\u0002:v]RLW.Z\u0005\u0005\u0003;\f9NA\tBEN$(/Y2u\rVt7\r^5p]JBqaUAh\t\u0003\t\t\u000f\u0006\u0002\u0002N\"Q\u0011QXAh\u0003\u0003%)%a0\t\u0015\u0005\u001d\u0018qZA\u0001\n\u0003\u000bI/A\u0003baBd\u0017\u0010\u0006\u0004\u00028\u0005-\u0018Q\u001e\u0005\b\u0003C\t)\u000f1\u0001z\u0011!\tI#!:A\u0002\u00055\u0002BCAy\u0003\u001f\f\t\u0011\"!\u0002t\u00069QO\\1qa2LH\u0003BA{\u0003{\u0004B!\u0003\u001e\u0002xB1\u0011\"!?z\u0003[I1!a?\u000b\u0005\u0019!V\u000f\u001d7fe!Q\u0011q`Ax\u0003\u0003\u0005\r!a\u000e\u0002\u0007a$\u0003\u0007C\u0005\u0003\u0004\u0001\u0011\r\u0011\"\u0003\u0003\u0006\u0005)1\u000f^1uKV\u0011!q\u0001\t\u0007\u0005\u0013\u0011)\"a\u000e\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\ta!\u0019;p[&\u001c'b\u0001\u0016\u0003\u0012)!!1CA=\u0003\u0011)H/\u001b7\n\t\t]!1\u0002\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dK\"A!1\u0004\u0001!\u0002\u0013\u00119!\u0001\u0004ti\u0006$X\r\t\u0005\b\u0005?\u0001A\u0011\tB\u0011\u0003-I7/\u0011<bS2\f'\r\\3\u0016\u0005\u00055\u0006b\u0002B\u0010\u0001\u0011%!Q\u0005\u000b\u0005\u0003[\u00139\u0003\u0003\u0005\u0002*\t\r\u0002\u0019AA\u0002\u0011\u001d\u0011Y\u0003\u0001C!\u0005C\tA\"[:N_:LGo\u001c:j]\u001eDqAa\f\u0001\t\u000b\u0012\t$A\u0005iK\u0006\u0014HOY3biR\u0011!1\u0007\t\u0004\u0013\tU\u0012b\u0001B\u001c\u0015\t!QK\\5uQ\u0011\u0011iCa\u000f\u0011\t\tu\"qH\u0007\u0003\u00037JAA!\u0011\u0002\\\t9A/Y5me\u0016\u001c\u0007B\u0002B#\u0001\u0011\u0005A#A\u0002qQ&DqA!\u0012\u0001\t\u0013\u0011I\u0005F\u0002\u0016\u0005\u0017B\u0001\"!\u000b\u0003H\u0001\u0007\u00111\u0001\u0005\t\u0005\u000b\u0002A\u0011\u0001\u0003\u0003PQ9QC!\u0015\u0003V\te\u0003\u0002\u0003B*\u0005\u001b\u0002\r!a\u0001\u0002\u0011QLW.\u001a#jM\u001aDqAa\u0016\u0003N\u0001\u0007Q#\u0001\u0003nK\u0006t\u0007b\u0002B.\u0005\u001b\u0002\r!F\u0001\rgR$G)\u001a<jCRLwN\u001c\u0005\n\u0005?\u0002!\u0019!C\u0005\u0003\u0003\tQ#\\5o'R$G)\u001a<jCRLwN\\'jY2L7\u000f\u0003\u0005\u0003d\u0001\u0001\u000b\u0011BA\u0002\u0003Yi\u0017N\\*uI\u0012+g/[1uS>tW*\u001b7mSN\u0004\u0003b\u0002B4\u0001\u0011%!\u0011N\u0001\u0018K:\u001cXO]3WC2LGm\u0015;e\t\u00164\u0018.\u0019;j_:$2!\u0006B6\u0011\u001d\u0011YF!\u001aA\u0002U\u0001")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private final AtomicReference<State> state;
    private final long minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                HeartbeatHistory heartbeatHistory2;
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish((Object)new Logging.Warning(this.toString(), this.getClass(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"heartbeat interval is growing too large: ", " millis"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)interval)}))));
                    }
                    heartbeatHistory2 = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory2 = oldState.history();
                }
                heartbeatHistory = heartbeatHistory2;
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private long minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, (double)this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable & scala.Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable & scala.Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    public final class State
    implements Product,
    scala.Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        private final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.$outer, history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Object> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.history();
                    break;
                }
                case 1: {
                    option = this.timestamp();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (!true) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

