/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.membership.storage;

import akka.actor.Address;
import akka.actor.Address$;
import akka.cluster.Cluster;
import com.xebialabs.xlplatform.cluster.DataSourceConfig;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement$Success$;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipSQLManagement$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f!B\u0001\u0003\u0003\u0003y!AH\"mkN$XM]'f[\n,'o\u001d5jaN\u000bF*T1oC\u001e,W.\u001a8u\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011AC7f[\n,'o\u001d5ja*\u0011q\u0001C\u0001\bG2,8\u000f^3s\u0015\tI!\"\u0001\u0006yYBd\u0017\r\u001e4pe6T!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001\u0001bC\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!aG\"mkN$XM]'f[\n,'o\u001d5ja6\u000bg.Y4f[\u0016tG\u000f\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)1\u000f\u001c45U*\tq$\u0001\u0005he&T(\u0010\\3e\u0013\t\tCDA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n\u0001\u0002Z:D_:4\u0017n\u001a\t\u0003K\u0019j\u0011AB\u0005\u0003O\u0019\u0011\u0001\u0003R1uCN{WO]2f\u0007>tg-[4\t\u0011%\u0002!\u0011!Q\u0001\n)\n1\u0001\u001e;m!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0005ekJ\fG/[8o\u0015\ty##\u0001\u0006d_:\u001cWO\u001d:f]RL!!\r\u0017\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\u0005gC&dg)Y:u!\t\tR'\u0003\u00027%\t9!i\\8mK\u0006t\u0007\"\u0002\u001d\u0001\t\u0003I\u0014A\u0002\u001fj]&$h\b\u0006\u0003;wqj\u0004CA\f\u0001\u0011\u0015\u0019s\u00071\u0001%\u0011\u0015Is\u00071\u0001+\u0011\u001d\u0019t\u0007%AA\u0002QBQa\u0010\u0001\u0007\u0002\u0001\u000b!\u0002\u001a:jm\u0016\u0014h*Y7f+\u0005\t\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002E%5\tQI\u0003\u0002G\u001d\u00051AH]8pizJ!\u0001\u0013\n\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011JAq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0006eCR\f7o\\;sG\u0016,\u0012a\u0014\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b1a]9m\u0015\u0005!\u0016!\u00026bm\u0006D\u0018B\u0001,R\u0005)!\u0015\r^1T_V\u00148-\u001a\u0005\u00071\u0002\u0001\u000b\u0011B(\u0002\u0017\u0011\fG/Y:pkJ\u001cW\r\t\u0005\u00075\u0002\u0001K\u0011B.\u0002)%t\u0017\u000e^5bY&TX\rR1uCN{WO]2f)\u0005y\u0005\"B/\u0001\t\u0003r\u0016\u0001\u0004:fO&\u001cH/\u001a:TK24GCA0})\t\u0001w\u000fE\u0002bE\u0012l\u0011AL\u0005\u0003G:\u0012aAR;ukJ,\u0007CA3u\u001d\t1'O\u0004\u0002hc:\u0011\u0001\u000e\u001d\b\u0003S>t!A\u001b8\u000f\u0005-lgB\u0001#m\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!a\u001d\u0002\u00027\rcWo\u001d;fe6+WNY3sg\"L\u0007/T1oC\u001e,W.\u001a8u\u0013\t)hO\u0001\u0004SKN,H\u000e\u001e\u0006\u0003g\nAQ\u0001\u001f/A\u0004e\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005\u0005T\u0018BA>/\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003~9\u0002\u0007a0\u0001\u0003tK24\u0007cA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0003bGR|'O\u0003\u0002\u0002\b\u0005!\u0011m[6b\u0013\u0011\tY!!\u0001\u0003\u000f\u0005#GM]3tg\"1\u0011q\u0002\u0001\u0007\u0002\u0001\u000bqB]3hSN$XM]*fY\u001a\u001c\u0016\u000f\u001c\u0005\b\u0003'\u0001A\u0011IA\u000b\u0003%AW-\u0019:uE\u0016\fG\u000f\u0006\u0003\u0002\u0018\u0005mAc\u00011\u0002\u001a!1\u00010!\u0005A\u0004eDa!`A\t\u0001\u0004q\bBBA\u0010\u0001\u0019\u0005\u0001)\u0001\u0007iK\u0006\u0014HOY3biN\u000bH\u000eC\u0004\u0002$\u0001!\t%!\n\u0002\u001f1L7\u000f^!di&4XmU3fIN$B!a\n\u0002,Q\u0019\u0001-!\u000b\t\ra\f\t\u0003q\u0001z\u0011\u001d9\u0011\u0011\u0005a\u0001\u0003[\u0001B!a\f\u000245\u0011\u0011\u0011\u0007\u0006\u0004\u000f\u0005\u0015\u0011\u0002BA\u001b\u0003c\u0011qa\u00117vgR,'\u000f\u0003\u0004\u0002:\u0001!\t\u0001Q\u0001\u0013Y&\u001cH/Q2uSZ,7+Z3egN\u000bH\u000eC\u0004\u0002>\u0001!\t%a\u0010\u0002\u001d\u0011,'/Z4jgR,'oU3fIR!\u0011\u0011IA#)\r\u0001\u00171\t\u0005\u0007q\u0006m\u00029A=\t\u000f\u0005\u001d\u00131\ba\u0001}\u0006!1/Z3e\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\nab^5uQ\u000e{gN\\3di&|g.\u0006\u0003\u0002P\u0005UC\u0003BA)\u0003C\u0002B!a\u0015\u0002V1\u0001A\u0001CA,\u0003\u0013\u0012\r!!\u0017\u0003\u0003\u0005\u000b2\u0001ZA.!\r\t\u0012QL\u0005\u0004\u0003?\u0012\"aA!os\"A\u00111MA%\u0001\u0004\t)'A\u0001c!\u001d\t\u0012qMA6\u0003#J1!!\u001b\u0013\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002n\u0005UTBAA8\u0015\r\u0011\u0016\u0011\u000f\u0006\u0003\u0003g\nAA[1wC&!\u0011qOA8\u0005)\u0019uN\u001c8fGRLwN\\\u0004\n\u0003w\u0012\u0011\u0011!E\u0001\u0003{\nad\u00117vgR,'/T3nE\u0016\u00148\u000f[5q'FcU*\u00198bO\u0016lWM\u001c;\u0011\u0007]\tyH\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAA'\r\ty\b\u0005\u0005\bq\u0005}D\u0011AAC)\t\ti\b\u0003\u0006\u0002\n\u0006}\u0014\u0013!C\u0001\u0003\u0017\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAAGU\r!\u0014qR\u0016\u0003\u0003#\u0003B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0014\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0006U%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public abstract class ClusterMembershipSQLManagement
implements ClusterMembershipManagement,
Logging {
    private final DataSourceConfig dsConfig;
    private final FiniteDuration ttl;
    private final boolean failFast;
    private final DataSource datasource;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return ClusterMembershipSQLManagement$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ClusterMembershipSQLManagement clusterMembershipSQLManagement = this;
        synchronized (clusterMembershipSQLManagement) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public abstract String driverName();

    public DataSource datasource() {
        return this.datasource;
    }

    private DataSource initializeDataSource() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting DataSource for cluster management: ", " (driverName = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.dsConfig, this.driverName()})));
        HikariConfig cfg = new HikariConfig();
        cfg.setInitializationFailTimeout(this.failFast ? 1L : -1L);
        cfg.setDriverClassName((String)this.dsConfig.driver().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.driverName()));
        cfg.setJdbcUrl(this.dsConfig.url());
        cfg.setUsername(this.dsConfig.username());
        cfg.setPassword(this.dsConfig.password());
        return new HikariDataSource(cfg);
    }

    @Override
    public Future<ClusterMembershipManagement.Result> registerSelf(Address self, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable & scala.Serializable)con -> {
            PreparedStatement ps = con.prepareStatement(this.registerSelfSql());
            ps.setString(1, self.protocol());
            ps.setString(2, self.system());
            ps.setString(3, (String)self.host().get());
            ps.setInt(4, BoxesRunTime.unboxToInt((Object)self.port().get()));
            ps.setLong(5, $this.ttl.toSeconds());
            ps.executeUpdate();
            con.commit();
            return ClusterMembershipManagement$Success$.MODULE$;
        }), executionContext);
    }

    public abstract String registerSelfSql();

    @Override
    public Future<ClusterMembershipManagement.Result> heartbeat(Address self, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable & scala.Serializable)con -> {
            PreparedStatement ps = con.prepareStatement(this.heartbeatSql());
            ps.setLong(1, $this.ttl.toSeconds());
            ps.setString(2, (String)self.host().get());
            ps.setInt(3, BoxesRunTime.unboxToInt((Object)self.port().get()));
            ps.executeUpdate();
            con.commit();
            return ClusterMembershipManagement$Success$.MODULE$;
        }), executionContext);
    }

    public abstract String heartbeatSql();

    @Override
    public Future<ClusterMembershipManagement.Result> listActiveSeeds(Cluster cluster, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable & scala.Serializable)con -> {
            PreparedStatement call = con.prepareStatement(this.listActiveSeedsSql());
            call.setString(1, cluster.selfAddress().protocol());
            call.setString(2, cluster.selfAddress().system());
            ResultSet set = call.executeQuery();
            Nil$ l = Nil$.MODULE$;
            while (set.next()) {
                ClusterMembershipManagement.Seed seed = new ClusterMembershipManagement.Seed(Address$.MODULE$.apply(cluster.selfAddress().protocol(), cluster.selfAddress().system(), set.getString("host"), set.getInt("port")), set.getTimestamp("ttl").toInstant());
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found Seed ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seed})));
                ClusterMembershipManagement.Seed seed2 = seed;
                l = l.$colon$colon((Object)seed2);
            }
            return new ClusterMembershipManagement.Data<Nil$>(l);
        }), executionContext);
    }

    public String listActiveSeedsSql() {
        return new StringOps(Predef$.MODULE$.augmentString("\n      |SELECT host, port, ttl\n      |FROM cluster_members\n      |WHERE protocol = ? AND system = ? AND ttl > CURRENT_TIMESTAMP ORDER BY ttl")).stripMargin();
    }

    @Override
    public Future<ClusterMembershipManagement.Result> deregisterSeed(Address seed, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable & scala.Serializable)con -> {
            PreparedStatement call = con.prepareStatement("DELETE FROM cluster_members WHERE host = ? AND port = ?");
            call.setString(1, (String)seed.host().get());
            call.setInt(2, BoxesRunTime.unboxToInt((Object)seed.port().get()));
            call.execute();
            con.commit();
            return ClusterMembershipManagement$Success$.MODULE$;
        }), executionContext);
    }

    public <A> A withConnection(Function1<Connection, A> b) {
        Object object;
        c.setAutoCommit(false);
        try (Connection c = this.datasource().getConnection();){
            try {
                object = b.apply((Object)c);
            }
            catch (SQLException e) {
                c.rollback();
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Error", (Function0 & Serializable & scala.Serializable)() -> e);
                object = new ClusterMembershipManagement.Failure(e.getMessage());
            }
        }
        return (A)object;
    }

    public ClusterMembershipSQLManagement(DataSourceConfig dsConfig, FiniteDuration ttl, boolean failFast) {
        this.dsConfig = dsConfig;
        this.ttl = ttl;
        this.failFast = failFast;
        Logging.$init$((Logging)this);
        this.datasource = this.initializeDataSource();
    }
}

