/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u00015\u0011qcU9m\t\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M)\u0001A\u0004\u000b\u00199A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z!\tI\"$D\u0001\u0003\u0013\tY\"AA\rCCN,'+\u001a7fCN,\u0017\n^3n%\u0016\u0004xn]5u_JL\bCA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\t\u0013\u0001C4sSjTH.\u001a3\n\u0005\rr\"a\u0002'pO\u001eLgn\u001a\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0003\u0003-\u0001XM]:jgR,gnY3\n\u00051J#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016D\u0001B\f\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0014e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\t\u0005\ta\u0001\u0011)\u0019!C\u0001c\u0005)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001\u001a\u0011\u0005!\u001a\u0014B\u0001\u001b*\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011(A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\u0012A\u000f\t\u0003w}j\u0011\u0001\u0010\u0006\u0003\u000buR!A\u0010\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001\u0011\u001f\u0003#I+\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003;\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\t\u000b\u0011\u0003A\u0011A#\u0002\rqJg.\u001b;?)\u00111u\tS%\u0011\u0005e\u0001\u0001\"B\u0013D\u0001\u00049\u0003\"\u0002\u0019D\u0001\u0004\u0011\u0004\"\u0002\u001dD\u0001\u0004Q\u0004\"B&\u0001\t\u0003b\u0015\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u00055\u001b\u0006C\u0001(R\u001b\u0005y%B\u0001)\u0007\u0003\u0019!w.\\1j]&\u0011!k\u0014\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\b\"\u0002+K\u0001\u0004)\u0016AA5e!\t1VL\u0004\u0002X7B\u0011\u0001\fE\u0007\u00023*\u0011!\fD\u0001\u0007yI|w\u000e\u001e \n\u0005q\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001\u0018\t)\u0005)\u000b\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003M\u001e\fq!\\3ue&\u001c7O\u0003\u0002i\u0015\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002kG\n)A+[7fI\")A\u000e\u0001C![\u000611M]3bi\u0016$2!\u00148t\u0011\u0015y7\u000e1\u0001q\u0003\u001d\u0011X\r\\3bg\u0016\u0004\"AT9\n\u0005I|%a\u0002*fY\u0016\f7/\u001a\u0005\u0006i.\u0004\r!T\u0001\u000bI\u0016\u0004XM\u001c3f]\u000eL\bFA6b\u0011\u00159\b\u0001\"\u0011y\u0003\u0019)\b\u000fZ1uKR\u0019Q*\u001f>\t\u000b=4\b\u0019\u00019\t\u000bQ4\b\u0019A')\u0005Y\f\u0007\"B?\u0001\t\u0003r\u0018A\u00023fY\u0016$X\rF\u0002\u0000\u0003\u000b\u00012aDA\u0001\u0013\r\t\u0019\u0001\u0005\u0002\u0005+:LG\u000fC\u0003uy\u0002\u0007Q\n\u000b\u0002}C\"9\u00111\u0002\u0001\u0005B\u00055\u0011aB1sG\"Lg/\u001a\u000b\u0006\u007f\u0006=\u0011\u0011\u0003\u0005\u0007_\u0006%\u0001\u0019\u00019\t\u0011\u0005M\u0011\u0011\u0002a\u0001\u0003+\tA#\u0019:dQ&4X\r\u001a#fa\u0016tG-\u001a8dS\u0016\u001c\b#BA\f\u0003Cie\u0002BA\r\u0003;q1\u0001WA\u000e\u0013\u0005\t\u0012bAA\u0010!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003K\u00111aU3r\u0015\r\ty\u0002\u0005\u0015\u0004\u0003\u0013\t\u0007bBA\u0016\u0001\u0011\u0005\u0013QF\u0001\u0010M&tGMQ=SK2,\u0017m]3JIR!\u0011qFA !\u0015\t\t$a\u000fN\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001B;uS2T!!!\u000f\u0002\t)\fg/Y\u0005\u0005\u0003{\t\u0019D\u0001\u0003MSN$\bbBA!\u0003S\u0001\r!V\u0001\ne\u0016dW-Y:f\u0013\u0012D3!!\u000bb\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\n\u0011DZ5oI\u0006sGMU3t_24XMQ=SK2,\u0017m]3JIR!\u0011qFA&\u0011\u001d\t\t%!\u0012A\u0002UC3!!\u0012b\u0011\u001d\t\t\u0006\u0001C!\u0003'\n1DZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003CA\u000b\u0003+\nY&a\u0018\t\u0011\u0005]\u0013q\na\u0001\u00033\n\u0011\u0002^1sO\u0016$\u0018\nZ:\u0011\u000b\u0005]\u0011\u0011E+\t\u0011\u0005u\u0013q\na\u0001\u00033\n\u0001b\u001d;biV\u001cXm\u001d\u0005\t\u0003C\ny\u00051\u0001\u0002d\u0005\u0019\"/\u001a4fe\u0016t7-\u001b8h\u0007\"LG\u000e\u001a:f]B\u0019q\"!\u001a\n\u0007\u0005\u001d\u0004CA\u0004C_>dW-\u00198)\u0007\u0005=\u0013\rC\u0004\u0002n\u0001!\t!a\u001c\u0002\u001dI,7o\u001c7wKR\u000b'oZ3ugR!\u0011QCA9\u0011!\t\u0019(a\u001bA\u0002\u0005U\u0011\u0001\u00043fa\u0016tG-\u001a8dS\u0016\u001c\bbBA<\u0001\u0011%\u0011\u0011P\u0001\u001ce\u0016\u001cx\u000e\u001c<f)\u0006\u0014x-\u001a;Ge>l7)\u00198eS\u0012\fG/Z:\u0015\u000b5\u000bY(a#\t\u0011\u0005u\u0014Q\u000fa\u0001\u0003\u007f\na\u0003^1sO\u0016$(+\u001a7fCN,\u0007\u000b\\1o\u0013R,Wn\u001d\t\u0006-\u0006\u0005\u0015QQ\u0005\u0004\u0003\u0007{&aA*fiB\u0019a*a\"\n\u0007\u0005%uJ\u0001\u0005QY\u0006t\u0017\n^3n\u0011\u0019!\u0018Q\u000fa\u0001\u001b\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0015\u0001\u00067pC\u0012\u0014V\r\\3bg\u0016\u0004F.\u00198Ji\u0016l7\u000f\u0006\u0003\u0002\u0000\u0005M\u0005bBAK\u0003\u001b\u0003\r!V\u0001\u0010i\u0006\u0014x-\u001a;SK2,\u0017m]3JI\"\u001a\u0001!!'\u0011\t\u0005m\u0015qU\u0007\u0003\u0003;SA!a(\u0002\"\u0006YAO]1og\u0006\u001cG/[8o\u0015\r\u0019\u00111\u0015\u0006\u0004\u0003K3\u0011A\u00013c\u0013\u0011\tI+!(\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlDependencyRepository
implements DependencyRepository,
BaseReleaseItemRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final RepositoryAdapter repositoryAdapter;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependency(Release release, Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, release, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDependencyRepository sqlDependencyRepository = this;
        synchronized (sqlDependencyRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Dependency findById(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        Release release = this.getRelease(releaseId, id);
        Option maybeDependency = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findById$2(id, x$2)));
        return (Dependency)maybeDependency.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), new Object[0]);
        });
    }

    @Timed
    public Dependency create(Release release, Dependency dependency) {
        this.insertDependency(release, dependency);
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public Dependency update(Release release, Dependency dependency) {
        if (!dependency.isArchived()) {
            this.dependencyPersistence().updateDependency(release.getCiUid(), dependency);
        }
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public void delete(Dependency dependency) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)dependency.getId()), dependency.getId());
        Option maybeGateTask = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$1(dependency, x$3)));
        maybeGateTask.map((Function1 & Serializable & scala.Serializable)gateTask -> {
            gateTask.setDependencies((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$3(dependency, x$4)))).asJava());
            this.releasePersistence().update(release);
            this.dependencyPersistence().deleteDependency(dependency);
            return dependency;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GateTask ", " not found while deleting dependency ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getGateTask().getId(), dependency.getId()})), new Object[0]);
        });
    }

    @Timed
    public void archive(Release release, Seq<Dependency> archivedDependencies) {
        block0: {
            if (!archivedDependencies.nonEmpty()) break block0;
            archivedDependencies.foreach((Function1 & Serializable & scala.Serializable)dependency -> {
                SqlDependencyRepository.$anonfun$archive$1(this, dependency);
                return BoxedUnit.UNIT;
            });
            this.releasePersistence().update(release);
        }
    }

    @Timed
    public List<Dependency> findByReleaseId(String releaseId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByGateReleaseId(CiId$.MODULE$.RichCiId(releaseId).normalized())).asDependencies()).asJava();
    }

    @Timed
    public List<Dependency> findAndResolveByReleaseId(String releaseId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.resolveTargets(DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByGateReleaseId(CiId$.MODULE$.RichCiId(releaseId).normalized())).asDependencies())).asJava();
    }

    @Timed
    public Seq<Dependency> findAllIncomingDependencies(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return referencingChildren ? DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByPartialTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies() : DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies();
    }

    public Seq<Dependency> resolveTargets(Seq<Dependency> dependencies) {
        ((TraversableLike)((TraversableLike)dependencies.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.hasVariableTarget()))).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargets$2(d)))).groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.releaseIdFrom((String)d.getTargetId())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlDependencyRepository.$anonfun$resolveTargets$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        return dependencies;
    }

    private Dependency resolveTargetFromCandidates(Set<PlanItem> targetReleasePlanItems, Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (!dependency.hasVariableTarget()) {
            Option option = targetReleasePlanItems.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargetFromCandidates$1(targetId, x$6)));
            if (option instanceof Some) {
                Some some = (Some)option;
                PlanItem target = (PlanItem)some.value();
                dependency.setTarget(target);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target '", "' of the Dependency '", "' could not be resolved"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getTargetId(), dependency.getId()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return dependency;
    }

    private Set<PlanItem> loadReleasePlanItems(String targetReleaseId) {
        Set set;
        try {
            Release releaseOrNull = (Release)this.repositoryAdapter().read(targetReleaseId);
            set = (Set)Option$.MODULE$.apply((Object)releaseOrNull).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getAllPlanItems()).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (NotFoundException notFoundException) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find release by ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetReleaseId})));
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public static final /* synthetic */ boolean $anonfun$findById$2(String id$1, Dependency x$2) {
        String string = x$2.getId();
        String string2 = CiId$.MODULE$.RichCiId(id$1).normalized();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(Dependency dependency$1, GateTask x$3) {
        String string = x$3.getId();
        String string2 = CiId$.MODULE$.RichCiId(dependency$1.getGateTask().getId()).normalized();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$3(Dependency dependency$1, Dependency x$4) {
        String string = x$4.getId();
        String string2 = CiId$.MODULE$.RichCiId(dependency$1.getId()).normalized();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archive$1(SqlDependencyRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    private static final Option status$1(Seq statuses$1) {
        return statuses$1.isEmpty() ? None$.MODULE$ : new Some((Object)statuses$1.toSet());
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargets$2(Dependency d) {
        return Ids.isReleaseId((String)d.getTargetId()) || Ids.isInRelease((String)d.getTargetId());
    }

    public static final /* synthetic */ void $anonfun$resolveTargets$4(SqlDependencyRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String targetReleaseId = (String)tuple2._1();
        Seq releaseDependencies = (Seq)tuple2._2();
        Set<PlanItem> targetReleasePlanItems = $this.loadReleasePlanItems(targetReleaseId);
        releaseDependencies.foreach((Function1 & Serializable & scala.Serializable)d -> $this.resolveTargetFromCandidates(targetReleasePlanItems, (Dependency)d));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargetFromCandidates$1(String targetId$1, PlanItem x$6) {
        String string = x$6.getId();
        String string2 = targetId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDependencyRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, RepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        Logging.$init$((Logging)this);
    }
}

