/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xldeploy.packager.StreamFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class RepositoryResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.RepositoryService {
    public static final Predicate<String> canRead = input -> PlatformPermissions.READ.getPermissionHandler().hasPermission(input);
    public static final Predicate<ConfigurationItemData> hasReadRight = input -> PlatformPermissions.READ.getPermissionHandler().hasPermission(input.getId());
    public static final Predicate<ConfigurationItem> canEdit = input -> PlatformPermissions.EDIT_REPO.getPermissionHandler().hasPermission(input.getId());
    public final List<Type> allowedConvertibleTypes;
    private final RepositoryService repositoryService;
    private final Validator validator;
    private final RoleService roleService;
    private final WorkDirFactory workDirFactory;
    private SourceArtifactEnricher sourceArtifactEnricher;
    @Value(value="#{serverConfiguration.uploadFileBufferSize}")
    private Integer uploadFileBufferSize;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryResource.class);

    public RepositoryResource(RepositoryService repositoryService, Validator validator, RoleService roleService, WorkDirFactory workDirFactory, SourceArtifactEnricher sourceArtifactEnricher) {
        this(repositoryService, validator, roleService, workDirFactory, sourceArtifactEnricher, Collections.emptyList());
    }

    public RepositoryResource(RepositoryService repositoryService, Validator validator, RoleService roleService, WorkDirFactory workDirFactory, SourceArtifactEnricher sourceArtifactEnricher, List<Type> allowedConvertibleTypes) {
        this.repositoryService = repositoryService;
        this.validator = validator;
        this.roleService = roleService;
        this.workDirFactory = workDirFactory;
        this.sourceArtifactEnricher = sourceArtifactEnricher;
        this.allowedConvertibleTypes = allowedConvertibleTypes;
    }

    public ConfigurationItem read(String id) {
        this.checkPermission(PlatformPermissions.READ, id);
        return this.repositoryService.read(id, 1);
    }

    public List<ConfigurationItem> read(List<String> ids) {
        ArrayList<ConfigurationItem> result = new ArrayList<ConfigurationItem>();
        ids.stream().filter(canRead).forEach(ciId -> {
            try {
                ConfigurationItem entity = this.repositoryService.read(ciId, 1);
                result.add(entity);
            }
            catch (NotFoundException nfe) {
                logger.error("No configuration item with ID [{}] exists in the repository", ciId);
                logger.debug("Exception was:", (Throwable)nfe);
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", ciId);
                logger.error("Exception was: ", (Throwable)re);
            }
        });
        return result;
    }

    public List<ConfigurationItemId> query(Type type, String parent, String ancestor, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        return this.list(SearchParametersFactory.createSearchParams(type, page, resultPerPage, parent, ancestor, namePattern, lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null, lastModifiedAfter != null ? lastModifiedAfter.toGregorianCalendar() : null, 0));
    }

    public List<ConfigurationItemId> candidateValues(String propertyName, String namePattern, long page, long resultPerPage, ConfigurationItem ci) {
        return WorkDirTemplate.cleanOnFinally(workDir -> this.list(SearchParametersFactory.createSearchParamsForCandidateValues(propertyName, namePattern, page, resultPerPage, ci)));
    }

    private List<ConfigurationItemId> list(SearchParameters searchParams) {
        return this.repositoryService.list(searchParams).stream().filter(hasReadRight).map(DtoReader.ciDataToCiId).collect(Collectors.toList());
    }

    public ConfigurationItem create(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.createInternal(ci, null);
    }

    @Workdir(prefix="artifact")
    public ConfigurationItem create(String id, ArtifactAndData aad) {
        return WorkDirTemplate.cleanOnFinally(workDir -> {
            this.checkPermission(PlatformPermissions.EDIT_REPO, id);
            Artifact artifact = aad.getArtifact();
            Checks.checkArgument((boolean)id.equals(artifact.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{artifact.getId(), id});
            artifact.setFile((OverthereFile)this.readArtifactData(aad, workDir));
            if (artifact instanceof FolderArtifact) {
                Checks.checkTrue((boolean)TFiles.isArchive((String)artifact.getFile().getPath()), (String)"Folder artifact [%s] is not a valid ZIP archive", (Object[])new Object[]{artifact.getFile().getName()});
            }
            return this.createInternal((ConfigurationItem)artifact, workDir);
        });
    }

    private ConfigurationItem createInternal(ConfigurationItem ci, WorkDir workDir) {
        if (ci instanceof SourceArtifact) {
            this.handleArtifact((SourceArtifact)ci, workDir);
        }
        this.validator.validateCi(ci);
        ArrayList<String> ids = new ArrayList<String>();
        this.checkReadAccessOnRelations(null, ci, ids);
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        Set<ConfigurationItem> ciSet = new CiCollector(Collections.singletonList(ci)).collect();
        this.publishCommand((RepositoryBaseCommand)new CreateCisCommand(new ArrayList<ConfigurationItem>(ciSet)));
        return this.repositoryService.read(ci.getId(), 1);
    }

    private void handleArtifact(SourceArtifact artifact, WorkDir workDir) {
        boolean hasFileUri = StringUtils.isNotBlank((String)artifact.getFileUri());
        boolean hasUploadedFile = ArtifactFileUtils.hasRealOrResolvedFile((Artifact)artifact);
        Checks.checkTrue((hasFileUri || hasUploadedFile ? 1 : 0) != 0, (String)"Artifacts need to have either a %s set or an uploaded file", (Object[])new Object[]{"fileUri"});
        Checks.checkTrue((!hasFileUri || !hasUploadedFile ? 1 : 0) != 0, (String)"Artifacts must not have both a %s set and an uploaded file", (Object[])new Object[]{"fileUri"});
        if (hasUploadedFile) {
            this.sourceArtifactEnricher.enrichArtifact(artifact);
        } else {
            ResolvedArtifactFile resolve = ArtifactResolverRegistry.resolve((SourceArtifact)artifact);
            try (InputStream is = resolve.openStream();){
                this.sourceArtifactEnricher.enrichArtifact(artifact, new StreamFile(resolve.getFileName(), is));
                artifact.setFile(LocalFile.valueOf((File)new File(resolve.getFileName())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private <T> T getOrNull(ConfigurationItem ci, PropertyDescriptor pd) {
        if (ci == null) {
            return null;
        }
        return (T)pd.get(ci);
    }

    private void checkReadAccessOnRelations(ConfigurationItem existingCi, ConfigurationItem updatedCi, List<String> nonReadIdAggregator) {
        Collection propertyDescriptors = updatedCi.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.isAsContainment()) continue;
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case DATE: 
                case SET_OF_STRING: 
                case LIST_OF_STRING: 
                case MAP_STRING_STRING: {
                    break;
                }
                case CI: {
                    ConfigurationItem linkedCi = (ConfigurationItem)propertyDescriptor.get(updatedCi);
                    if (linkedCi == null) break;
                    String id = linkedCi.getId();
                    ConfigurationItem existingLinkedCi = (ConfigurationItem)this.getOrNull(existingCi, propertyDescriptor);
                    if (existingLinkedCi != null && existingLinkedCi.getId().equals(id) || this.hasPermission(PlatformPermissions.READ, id)) break;
                    nonReadIdAggregator.add(id);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    Collection cis = (Collection)propertyDescriptor.get(updatedCi);
                    Collection existingCis = (Collection)this.getOrNull(existingCi, propertyDescriptor);
                    ArrayList existingLinkedCiIds = existingCis == null ? new ArrayList() : (Collection)existingCis.stream().map(ConfigurationItem::getId).collect(Collectors.toList());
                    for (ConfigurationItem configurationItem : cis) {
                        if (configurationItem == null || existingLinkedCiIds.contains(configurationItem.getId()) || this.hasPermission(PlatformPermissions.READ, configurationItem.getId())) continue;
                        nonReadIdAggregator.add(configurationItem.getId());
                    }
                    break;
                }
            }
        }
    }

    @Workdir(prefix="artifact")
    public List<ConfigurationItem> create(List<ConfigurationItem> cis) {
        return WorkDirTemplate.cleanOnFinally(workDir -> {
            cis.stream().map(ConfigurationItem::getId).forEach(id -> this.checkPermission(PlatformPermissions.EDIT_REPO, (String)id));
            this.validator.validateCis(cis);
            ArrayList<String> ids = new ArrayList<String>();
            for (ConfigurationItem ci : cis) {
                if (ci instanceof SourceArtifact) {
                    this.handleArtifact((SourceArtifact)ci, workDir);
                }
                this.checkReadAccessOnRelations(null, ci, ids);
            }
            if (!ids.isEmpty()) {
                throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
            }
            Set<ConfigurationItem> ciSet = new CiCollector(cis).collect();
            CreateCisCommand event = new CreateCisCommand(new ArrayList<ConfigurationItem>(ciSet));
            this.publishCommand((RepositoryBaseCommand)event);
            return this.reloadEntityAndCreateSuccessResponse(cis);
        });
    }

    public ConfigurationItem update(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.updateInternal(ci);
    }

    @Workdir(prefix="artifact")
    public ConfigurationItem update(String id, ArtifactAndData aad) {
        return WorkDirTemplate.cleanOnFinally(workDir -> {
            this.checkPermission(PlatformPermissions.EDIT_REPO, id);
            Checks.checkArgument((boolean)id.equals(aad.getArtifact().getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{aad.getArtifact().getId(), id});
            aad.getArtifact().setFile((OverthereFile)this.readArtifactData(aad, workDir));
            return this.updateInternal((ConfigurationItem)aad.getArtifact());
        });
    }

    private ConfigurationItem updateInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        ConfigurationItem previous = this.repositoryService.read(ci.getId(), false);
        this.checkIfConvertibleType(ci, previous);
        ArrayList<String> ids = new ArrayList<String>();
        this.checkReadAccessOnRelations(previous, ci, ids);
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        this.publishCommand((RepositoryBaseCommand)new UpdateCiCommand(previous, ci));
        return this.repositoryService.read(ci.getId(), 1);
    }

    private void checkIfConvertibleType(ConfigurationItem ci, ConfigurationItem previous) {
        if (!previous.getType().equals((Object)ci.getType())) {
            Predicate<Type> instanceOfAllowedType = type -> previous.getType().instanceOf(type) && ci.getType().instanceOf(type);
            Checks.checkArgument((boolean)this.allowedConvertibleTypes.stream().anyMatch(instanceOfAllowedType), (String)"Type of the Configuration Item cannot be changed from [%s] to [%s]", (Object[])new Object[]{previous.getType(), ci.getType()});
        }
    }

    public List<ConfigurationItem> update(List<ConfigurationItem> cis) {
        ArrayList updates = new ArrayList();
        ArrayList aggregator = new ArrayList();
        Collection filteredCis = cis.stream().filter(canEdit).map(configurationItem -> {
            if (this.repositoryService.exists(configurationItem.getId())) {
                ConfigurationItem previous = this.repositoryService.read(configurationItem.getId(), 1, null, false);
                this.checkIfConvertibleType((ConfigurationItem)configurationItem, previous);
                this.checkReadAccessOnRelations(previous, (ConfigurationItem)configurationItem, aggregator);
                updates.add(new Update(previous, configurationItem));
            } else {
                this.checkReadAccessOnRelations(null, (ConfigurationItem)configurationItem, aggregator);
                updates.add(new Update(null, configurationItem));
            }
            return configurationItem;
        }).collect(Collectors.toList());
        if (!aggregator.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + aggregator);
        }
        UpdateCisCommand command = new UpdateCisCommand(updates);
        this.publishCommand((RepositoryBaseCommand)command);
        return this.reloadEntityAndCreateSuccessResponse(filteredCis);
    }

    public ConfigurationItem move(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.checkPermission(PlatformPermissions.EDIT_REPO, targetId);
        String idRoot = id.split("/")[0];
        String targetRoot = targetId.split("/")[0];
        Checks.checkArgument((boolean)idRoot.equals(targetRoot), (String)"Cannot move ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.publishCommand((RepositoryBaseCommand)new MoveCiCommand(id, targetId));
        return this.read(targetId);
    }

    public ConfigurationItem copy(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.checkPermission(PlatformPermissions.EDIT_REPO, targetId);
        String idRoot = id.split("/")[0];
        String targetRoot = targetId.split("/")[0];
        Checks.checkArgument((boolean)idRoot.equals(targetRoot), (String)"Cannot copy ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.publishCommand((RepositoryBaseCommand)new CopyCiCommand(id, targetId, this.read(id).getType()));
        return this.read(targetId);
    }

    public ConfigurationItem rename(String id, String targetName) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.publishCommand((RepositoryBaseCommand)new RenameCiCommand(id, targetName, this.read(id).getType()));
        String targetId = id.substring(0, id.lastIndexOf(47) + 1) + targetName;
        return this.read(targetId);
    }

    public List<ConfigurationItem> validate(List<ConfigurationItem> cis) {
        this.validator.validateCis(cis);
        return cis;
    }

    public void delete(String id) {
        this.checkDeletePermission(id);
        this.publishCommand((RepositoryBaseCommand)new DeleteCiCommand(id));
    }

    public void deleteList(List<String> ids) {
        this.publishCommand((RepositoryBaseCommand)new DeleteCisCommand(ids));
    }

    protected void checkDeletePermission(String id) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
    }

    public Boolean exists(String id) {
        return this.repositoryService.exists(id);
    }

    private List<ConfigurationItem> reloadEntityAndCreateSuccessResponse(Collection<ConfigurationItem> cis) {
        ArrayList<ConfigurationItem> reloaded = new ArrayList<ConfigurationItem>();
        cis.forEach(ci -> {
            ConfigurationItem reloadedCi = this.repositoryService.read(ci.getId(), 1);
            reloaded.add(reloadedCi);
        });
        return reloaded;
    }

    private LocalFile readArtifactData(ArtifactAndData aad, WorkDir workDir) {
        Checks.checkArgument((aad.getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        LocalFile localFile = workDir.newFile(aad.getFilename());
        try (OutputStream outputStream = localFile.getOutputStream();
             InputStream inputStream = aad.getDataInputStream();){
            this.copy(inputStream, outputStream);
        }
        catch (IOException e) {
            String message = "Could not write Artifact data for [" + aad.getArtifact().getId() + "] to [" + localFile + "]";
            logger.error(message, (Throwable)e);
            throw new DeployitException(message);
        }
        return localFile;
    }

    private void publishCommand(RepositoryBaseCommand event) {
        List roles = this.roleService.listMyRoles();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), roles);
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[this.uploadFileBufferSize.intValue()];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    static class CiCollector {
        private Collection<? extends ConfigurationItem> cis;

        public CiCollector(Collection<? extends ConfigurationItem> cis) {
            this.cis = cis;
        }

        public Set<ConfigurationItem> collect() {
            HashSet<ConfigurationItem> collector = new HashSet<ConfigurationItem>();
            this.collectNestedCis(this.cis, collector);
            return collector;
        }

        private Set<ConfigurationItem> collectNestedCis(Collection<? extends ConfigurationItem> cis, Set<ConfigurationItem> collector) {
            for (ConfigurationItem configurationItem : cis) {
                collector.add(configurationItem);
                for (PropertyDescriptor property : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
                    Collection<ConfigurationItem> children;
                    PropertyKind kind = property.getKind();
                    if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                        children = this.getChildren(configurationItem, property);
                        this.collectNestedCis(children, collector);
                        continue;
                    }
                    if (kind != PropertyKind.CI) continue;
                    children = this.getChildrenForCI(configurationItem, property);
                    this.collectNestedCis(children, collector);
                }
            }
            return collector;
        }

        private Collection<ConfigurationItem> getChildrenForCI(ConfigurationItem parent, PropertyDescriptor property) {
            ConfigurationItem ci = (ConfigurationItem)property.get(parent);
            ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
            if (ci != null && this.isChild(ci, parent)) {
                children.add(ci);
            }
            return children;
        }

        private Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
            Collection references = (Collection)property.get(parent);
            if (property.isAsContainment()) {
                return references;
            }
            ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
            for (ConfigurationItem ci : references) {
                if (!this.isChild(ci, parent)) continue;
                children.add(ci);
            }
            return children;
        }

        private boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(ci))) continue;
                return true;
            }
            return false;
        }
    }
}

