/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.services;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@PublicApiRef
public class SearchParameters {
    Type type;
    String parent;
    String ancestor;
    String name;
    Map<String, String> properties = new HashMap<String, String>();
    Map<String, Set<String>> orPropertiesExpression = new HashMap<String, Set<String>>();
    Map<String, String> textSearchQueries = new HashMap<String, String>();
    Calendar before;
    Calendar after;
    long page = 0L;
    long resultsPerPage = 0L;
    int depth = Integer.MAX_VALUE;
    boolean isExactNameSearch;

    public SearchParameters setType(Type type) {
        this.type = type;
        return this;
    }

    public SearchParameters addProperty(String property, String value) {
        this.properties.put(property, value);
        return this;
    }

    public SearchParameters addTextSearch(String property, String searchQuery) {
        this.textSearchQueries.put(property, searchQuery);
        return this;
    }

    public SearchParameters addOrPropertiesExpression(String property, Set<String> values) {
        this.orPropertiesExpression.put(property, values);
        return this;
    }

    public SearchParameters setParent(String parent) {
        this.parent = parent;
        return this;
    }

    public SearchParameters setAncestor(String ancestor) {
        this.ancestor = ancestor;
        return this;
    }

    public SearchParameters setName(String name) {
        this.name = name;
        return this;
    }

    public void setBefore(Calendar before) {
        this.before = before;
    }

    public void setAfter(Calendar after) {
        this.after = after;
    }

    public SearchParameters setPage(long page) {
        this.page = page;
        return this;
    }

    public SearchParameters setResultsPerPage(long nrOfResults) {
        this.resultsPerPage = nrOfResults;
        return this;
    }

    public SearchParameters setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public SearchParameters setExactNameSearch(boolean isExactNameSearch) {
        this.isExactNameSearch = isExactNameSearch;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public String getParent() {
        return this.parent;
    }

    public String getAncestor() {
        return this.ancestor;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getTextSearchQueries() {
        return this.textSearchQueries;
    }

    public Map<String, Set<String>> getOrPropertiesExpression() {
        return this.orPropertiesExpression;
    }

    public Calendar getBefore() {
        return this.before;
    }

    public Calendar getAfter() {
        return this.after;
    }

    public long getPage() {
        return this.page;
    }

    public long getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExactNameSearch() {
        return this.isExactNameSearch;
    }

    public String toString() {
        return String.format("SearchParameters [type=%s, parent=%s, ancestor=%s, name=%s, properties=%s, textSearchQueries=%s, before=%s, after=%s, page=%d, resultsPerPage=%d, depth = %d]", this.type, this.parent, this.ancestor, this.name, this.properties, this.textSearchQueries, this.before, this.after, this.page, this.resultsPerPage, this.depth);
    }
}

