/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.LinkHeader;

public class LinkHeaders {
    private Map<String, Link> linksByRelationship = new HashMap<String, Link>();
    private Map<String, Link> linksByTitle = new HashMap<String, Link>();
    private List<Link> links = new ArrayList<Link>();

    public LinkHeaders addLinks(MultivaluedMap<String, String> headers) {
        List values = (List)headers.get((Object)"Link");
        if (values == null) {
            return this;
        }
        for (String val : values) {
            LinkHeader linkHeader = new LinkHeaderDelegate().fromString(val);
            for (Link link : linkHeader.getLinks()) {
                this.addLink(link);
            }
        }
        return this;
    }

    public LinkHeaders addLinkObjects(MultivaluedMap<String, Object> headers, HeaderValueProcessor factory) {
        List values = (List)headers.get((Object)"Link");
        if (values == null) {
            return this;
        }
        for (Object val : values) {
            if (val instanceof Link) {
                this.addLink((Link)val);
                continue;
            }
            String str = factory.toHeaderString(val);
            this.addLink(Link.valueOf((String)str));
        }
        return this;
    }

    public LinkHeaders addLink(Link link) {
        this.links.add(link);
        for (String rel : link.getRels()) {
            this.linksByRelationship.put(rel, link);
        }
        if (link.getTitle() != null) {
            this.linksByTitle.put(link.getTitle(), link);
        }
        return this;
    }

    public Link getLinkByTitle(String title) {
        return this.linksByTitle.get(title);
    }

    public Link getLinkByRelationship(String rel) {
        return this.linksByRelationship.get(rel);
    }

    public Map<String, Link> getLinksByRelationship() {
        return this.linksByRelationship;
    }

    public Map<String, Link> getLinksByTitle() {
        return this.linksByTitle;
    }

    public List<Link> getLinks() {
        return this.links;
    }
}

