/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Map;
import org.python.bouncycastle.pqc.crypto.xmss.BDS;
import org.python.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import org.python.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.python.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import org.python.bouncycastle.pqc.crypto.xmss.XMSS;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSNode;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMSSMT {
    private XMSSMTParameters params;
    private XMSS xmss;
    private SecureRandom prng;
    private KeyedHashFunctions khf;
    private XMSSMTPrivateKeyParameters privateKey;
    private XMSSMTPublicKeyParameters publicKey;

    public XMSSMT(XMSSMTParameters xMSSMTParameters) {
        if (xMSSMTParameters == null) {
            throw new NullPointerException("params == null");
        }
        this.params = xMSSMTParameters;
        this.xmss = xMSSMTParameters.getXMSS();
        this.prng = xMSSMTParameters.getXMSS().getParams().getPRNG();
        this.khf = this.xmss.getKhf();
        try {
            this.privateKey = new XMSSMTPrivateKeyParameters.Builder(xMSSMTParameters).build();
            this.publicKey = new XMSSMTPublicKeyParameters.Builder(xMSSMTParameters).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void generateKeys() {
        this.privateKey = this.generatePrivateKey();
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = null;
        XMSSPublicKeyParameters xMSSPublicKeyParameters = null;
        try {
            xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.xmss.getParams()).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withBDSState(new BDS(this.xmss)).build();
            xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.xmss.getParams()).withPublicSeed(this.getPublicSeed()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.xmss.importState(xMSSPrivateKeyParameters.toByteArray(), xMSSPublicKeyParameters.toByteArray());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = this.params.getLayers() - 1;
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n)).build();
        BDS bDS = new BDS(this.xmss);
        XMSSNode xMSSNode = bDS.initialize(oTSHashAddress);
        this.getBDSState().put(n, bDS);
        this.xmss.setRoot(xMSSNode.getValue());
        try {
            this.privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(this.xmss.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
            this.publicKey = new XMSSMTPublicKeyParameters.Builder(this.params).withRoot(xMSSNode.getValue()).withPublicSeed(this.getPublicSeed()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private XMSSMTPrivateKeyParameters generatePrivateKey() {
        int n = this.params.getDigestSize();
        byte[] byArray = new byte[n];
        this.prng.nextBytes(byArray);
        byte[] byArray2 = new byte[n];
        this.prng.nextBytes(byArray2);
        byte[] byArray3 = new byte[n];
        this.prng.nextBytes(byArray3);
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = null;
        try {
            xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(this.privateKey.getBDSState()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return xMSSMTPrivateKeyParameters;
    }

    public void importState(byte[] byArray, byte[] byArray2) throws ParseException, ClassNotFoundException, IOException {
        if (byArray == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.params).withPrivateKey(byArray, this.xmss).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.params).withPublicKey(byArray2).build();
        if (!XMSSUtil.compareByteArray(xMSSMTPrivateKeyParameters.getRoot(), xMSSMTPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!XMSSUtil.compareByteArray(xMSSMTPrivateKeyParameters.getPublicSeed(), xMSSMTPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.xmss.getParams()).withSecretKeySeed(xMSSMTPrivateKeyParameters.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKeyParameters.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).withRoot(xMSSMTPrivateKeyParameters.getRoot()).withBDSState(new BDS(this.xmss)).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.xmss.getParams()).withRoot(xMSSMTPrivateKeyParameters.getRoot()).withPublicSeed(this.getPublicSeed()).build();
        this.xmss.importState(xMSSPrivateKeyParameters.toByteArray(), xMSSPublicKeyParameters.toByteArray());
        this.privateKey = xMSSMTPrivateKeyParameters;
        this.publicKey = xMSSMTPublicKeyParameters;
    }

    public byte[] sign(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (this.getBDSState().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        long l = this.getIndex();
        int n = this.params.getHeight();
        int n2 = this.xmss.getParams().getHeight();
        if (!XMSSUtil.isIndexValid(n, l)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = this.khf.PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(l, 32));
        byte[] byArray3 = XMSSUtil.concat(byArray2, this.privateKey.getRoot(), XMSSUtil.toBytesBigEndian(l, this.params.getDigestSize()));
        byte[] byArray4 = this.khf.HMsg(byArray3, byArray);
        XMSSMTSignature xMSSMTSignature = null;
        try {
            xMSSMTSignature = new XMSSMTSignature.Builder(this.params).withIndex(l).withRandom(byArray2).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        long l2 = XMSSUtil.getTreeIndex(l, n2);
        int n3 = XMSSUtil.getLeafIndex(l, n2);
        this.xmss.setIndex(n3);
        this.xmss.setPublicSeed(this.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l2)).withOTSAddress(n3).build();
        WOTSPlusSignature wOTSPlusSignature = this.xmss.wotsSign(byArray4, oTSHashAddress);
        if (this.getBDSState().get(0) == null || n3 == 0) {
            this.getBDSState().put(0, new BDS(this.xmss));
            this.getBDSState().get(0).initialize(oTSHashAddress);
        }
        XMSSReducedSignature xMSSReducedSignature = null;
        try {
            xMSSReducedSignature = new XMSSReducedSignature.Builder(this.xmss.getParams()).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(this.getBDSState().get(0).getAuthenticationPath()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        if (n3 < (1 << n2) - 1) {
            this.getBDSState().get(0).nextAuthenticationPath(oTSHashAddress);
        }
        for (int i = 1; i < this.params.getLayers(); ++i) {
            XMSSNode xMSSNode = this.getBDSState().get(i - 1).getRoot();
            n3 = XMSSUtil.getLeafIndex(l2, n2);
            l2 = XMSSUtil.getTreeIndex(l2, n2);
            this.xmss.setIndex(n3);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i)).withTreeAddress(l2)).withOTSAddress(n3).build();
            wOTSPlusSignature = this.xmss.wotsSign(xMSSNode.getValue(), oTSHashAddress);
            if (this.getBDSState().get(i) == null || XMSSUtil.isNewBDSInitNeeded(l, n2, i)) {
                this.getBDSState().put(i, new BDS(this.xmss));
                this.getBDSState().get(i).initialize(oTSHashAddress);
            }
            try {
                xMSSReducedSignature = new XMSSReducedSignature.Builder(this.xmss.getParams()).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(this.getBDSState().get(i).getAuthenticationPath()).build();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
            if (n3 >= (1 << n2) - 1 || !XMSSUtil.isNewAuthenticationPathNeeded(l, n2, i)) continue;
            this.getBDSState().get(i).nextAuthenticationPath(oTSHashAddress);
        }
        try {
            this.privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withIndex(l + 1L).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(this.privateKey.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return xMSSMTSignature.toByteArray();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) throws ParseException {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("signature == null");
        }
        if (byArray3 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.params).withSignature(byArray2).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.params).withPublicKey(byArray3).build();
        byte[] byArray4 = XMSSUtil.concat(xMSSMTSignature.getRandom(), xMSSMTPublicKeyParameters.getRoot(), XMSSUtil.toBytesBigEndian(xMSSMTSignature.getIndex(), this.params.getDigestSize()));
        byte[] byArray5 = this.khf.HMsg(byArray4, byArray);
        long l = xMSSMTSignature.getIndex();
        int n = this.xmss.getParams().getHeight();
        long l2 = XMSSUtil.getTreeIndex(l, n);
        int n2 = XMSSUtil.getLeafIndex(l, n);
        this.xmss.setIndex(n2);
        this.xmss.setPublicSeed(xMSSMTPublicKeyParameters.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l2)).withOTSAddress(n2).build();
        XMSSReducedSignature xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(0);
        XMSSNode xMSSNode = this.xmss.getRootNodeFromSignature(byArray5, xMSSReducedSignature, oTSHashAddress);
        for (int i = 1; i < this.params.getLayers(); ++i) {
            xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(i);
            n2 = XMSSUtil.getLeafIndex(l2, n);
            l2 = XMSSUtil.getTreeIndex(l2, n);
            this.xmss.setIndex(n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i)).withTreeAddress(l2)).withOTSAddress(n2).build();
            xMSSNode = this.xmss.getRootNodeFromSignature(xMSSNode.getValue(), xMSSReducedSignature, oTSHashAddress);
        }
        return XMSSUtil.compareByteArray(xMSSNode.getValue(), xMSSMTPublicKeyParameters.getRoot());
    }

    public byte[] exportPrivateKey() {
        return this.privateKey.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.publicKey.toByteArray();
    }

    public XMSSMTParameters getParams() {
        return this.params;
    }

    public long getIndex() {
        return this.privateKey.getIndex();
    }

    public byte[] getPublicSeed() {
        return this.privateKey.getPublicSeed();
    }

    protected Map<Integer, BDS> getBDSState() {
        return this.privateKey.getBDSState();
    }

    protected XMSS getXMSS() {
        return this.xmss;
    }
}

