/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SqlReleasesFilterSupport;
import com.xebialabs.xlrelease.service.SqlTemplatesFilterSupport;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u0001-\u0011qcU9m%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011c\u0002\u0001\r)a\u0001\u0003f\u000b\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012!B:mMRR'\"A\u000f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\b\u000e\u0003\u000f1{wmZ5oOB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0004gFd'BA\u0013\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003O\t\u0012a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003+%J!A\u000b\u0002\u00031M\u000bHNU3mK\u0006\u001cXm\u001d$jYR,'oU;qa>\u0014H\u000f\u0005\u0002\u0016Y%\u0011QF\u0001\u0002\u001a'FdG+Z7qY\u0006$Xm\u001d$jYR,'oU;qa>\u0014H\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\u0012\u0013a\u00039feNL7\u000f^3oG\u0016L!!\u000e\u001a\u0003%I+G.Z1tKB+'o]5ti\u0016t7-\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003+eJ!A\u000f\u0002\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0007\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001?!\t\ts(\u0003\u0002AE\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJD\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0005\u0003\u0005E\u0001\t\u0015\r\u0011\"\u0001F\u0003-!X-Y7TKJ4\u0018nY3\u0016\u0003\u0019\u0003\"!F$\n\u0005!\u0013!a\u0003+fC6\u001cVM\u001d<jG\u0016D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IAR\u0001\ri\u0016\fWnU3sm&\u001cW\r\t\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\u0006\u0001B-Z2pe\u0006$xN]*feZL7-\u001a\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003%\u0012\t1!\u00199j\u0013\t!vJ\u0001\u0011J]R,'O\\1m\u001b\u0016$\u0018\rZ1uC\u0012+7m\u001c:bi>\u00148+\u001a:wS\u000e,\u0007\u0002\u0003,\u0001\u0005\u000b\u0007I1A,\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001Y!\tIFN\u0004\u0002[S:\u00111l\u001a\b\u00039\u0016t!!\u00183\u000f\u0005y\u001bgBA0c\u001b\u0005\u0001'BA1\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003M\u0012\t!\u0001\u001a2\n\u0005\rB'B\u00014\u0005\u0013\tQ7.\u0001\u0006Tc2\u0014U/\u001b7eKJT!a\t5\n\u00055t'a\u0002#jC2,7\r\u001e\u0006\u0003U.D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I\u0001W\u0001\fgFdG)[1mK\u000e$\b\u0005\u0003\u0005s\u0001\t\u0015\r\u0011b\u0001t\u0003I\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0011M,7-\u001e:jifT!!\u001f\u0004\u0002\u0011\u0011,\u0007\u000f\\8zSRL!a\u001f<\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0005\t{\u0002\u0011\t\u0011)A\u0005i\u0006\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA!Iq\u0010\u0001BC\u0002\u0013\u0005\u0011\u0011A\u0001\fe>dWmU3sm&\u001cW-\u0006\u0002\u0002\u0004A\u0019Q/!\u0002\n\u0007\u0005\u001daOA\u0006S_2,7+\u001a:wS\u000e,\u0007BCA\u0006\u0001\t\u0005\t\u0015!\u0003\u0002\u0004\u0005a!o\u001c7f'\u0016\u0014h/[2fA!Q\u0011q\u0002\u0001\u0003\u0006\u0004%\t!!\u0005\u0002\u0015M,7-\u001e:fI\u000eK7/\u0006\u0002\u0002\u0014A!\u0011QCA\f\u001b\u0005!\u0013bAA\rI\tQ1+Z2ve\u0016$7)[:\t\u0015\u0005u\u0001A!A!\u0002\u0013\t\u0019\"A\u0006tK\u000e,(/\u001a3DSN\u0004\u0003bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0012QGA\u001c!\t)\u0002\u0001\u0003\u00040\u0003?\u0001\r\u0001\r\u0005\u0007o\u0005}\u0001\u0019\u0001\u001d\t\rq\ny\u00021\u0001?\u0011\u0019!\u0015q\u0004a\u0001\r\"1A*a\bA\u00025CaAVA\u0010\u0001\bA\u0006B\u0002:\u0002 \u0001\u000fA\u000fC\u0004\u0000\u0003?\u0001\r!a\u0001\t\u0011\u0005=\u0011q\u0004a\u0001\u0003'Aq!a\u000f\u0001\t\u0003\ni$\u0001\u0004tK\u0006\u00148\r\u001b\u000b\r\u0003\u007f\tI%!\u0018\u0002n\u0005E\u00141\u0010\t\u0005\u0003\u0003\n)%\u0004\u0002\u0002D)\u0019\u00111\b\u0003\n\t\u0005\u001d\u00131\t\u0002\u0014%\u0016dW-Y:f'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\t\u0003\u0017\nI\u00041\u0001\u0002N\u0005y!/\u001a7fCN,7OR5mi\u0016\u00148\u000f\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u000b\u0019|'/\\:\u000b\u0007\u0005]\u0013+\u0001\u0002wc%!\u00111LA)\u0005=\u0011V\r\\3bg\u0016\u001ch)\u001b7uKJ\u001c\b\u0002CA0\u0003s\u0001\r!!\u0019\u0002\tA\fw-\u001a\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0011\u0011qM\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003W\n)G\u0001\u0003M_:<\u0007\u0002CA8\u0003s\u0001\r!!\u0019\u0002\u00199,XNY3s\u0005f\u0004\u0016mZ3\t\u0011\u0005M\u0014\u0011\ba\u0001\u0003k\nQ\u0001Z3qi\"\u0004B!a\u0019\u0002x%!\u0011\u0011PA3\u0005\rIe\u000e\u001e\u0005\t\u0003{\nI\u00041\u0001\u0002\u0000\u0005\u0019b-\u001b7uKJ|e\u000eU3s[&\u001c8/[8ogB!\u00111MAA\u0013\u0011\t\u0019)!\u001a\u0003\u000f\t{w\u000e\\3b]\"\"\u0011\u0011HAD!\u0011\tI)a&\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\t\t*a%\u0002\u000f5,GO]5dg*\u0019\u0011Q\u0013\u0005\u0002\u0011\r|G-\u00195bY\u0016LA!!'\u0002\f\n)A+[7fI\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0015aD:fCJ\u001c\u0007\u000eV3na2\fG/Z:\u0015\u0015\u0005}\u0012\u0011UAY\u0003g\u000b)\f\u0003\u0005\u0002$\u0006m\u0005\u0019AAS\u0003=!X-\u001c9mCR,g)\u001b7uKJ\u001c\b\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-F!A\u0003wS\u0016<8/\u0003\u0003\u00020\u0006%&a\u0004+f[Bd\u0017\r^3GS2$XM]:\t\u0011\u0005}\u00131\u0014a\u0001\u0003CB\u0001\"a\u001c\u0002\u001c\u0002\u0007\u0011\u0011\r\u0005\t\u0003g\nY\n1\u0001\u0002v!\"\u00111TAD\u0011\u001d\tY\f\u0001C!\u0003{\u000bQc]3be\u000eD'+\u001a7fCN,7OQ=USRdW\r\u0006\u0006\u0002@\u0006]\u00171^Aw\u0003_\u0004b!!1\u0002H\u0006-WBAAb\u0015\r\t)\rE\u0001\u0005kRLG.\u0003\u0003\u0002J\u0006\r'\u0001\u0002'jgR\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#$\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002V\u0006='a\u0002*fY\u0016\f7/\u001a\u0005\t\u00033\fI\f1\u0001\u0002\\\u0006a!/\u001a7fCN,G+\u001b;mKB!\u0011Q\\As\u001d\u0011\ty.!9\u0011\u0007}\u000b)'\u0003\u0003\u0002d\u0006\u0015\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002h\u0006%(AB*ue&twM\u0003\u0003\u0002d\u0006\u0015\u0004\u0002CA0\u0003s\u0003\r!!\u0019\t\u0011\u0005=\u0014\u0011\u0018a\u0001\u0003CB\u0001\"a\u001d\u0002:\u0002\u0007\u0011Q\u000f\u0015\u0005\u0003s\u000b9\tC\u0004\u0002v\u0002!\t%a>\u0002%\u0019Lg\u000eZ!mYR+W\u000e\u001d7bi\u0016LEm\u001d\u000b\u0003\u0003s\u0004b!!1\u0002H\u0006m\u0007\u0006BAz\u0003\u000fCq!a@\u0001\t\u0003\n90A\fgS:$\u0017\t\u001c7BGRLg/\u001a*fY\u0016\f7/Z%eg\"\"\u0011Q`AD\u0011\u001d\u0011)\u0001\u0001C!\u0003o\f\u0001DZ5oI\u0006cG\u000eU3oI&twMU3mK\u0006\u001cX-\u00133tQ\u0011\u0011\u0019!a\"\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005i\u0011/^3ssJ+G.Z1tKN$\"Ba\u0004\u0003\"\tM\"Q\u0007B\u001c!\u0019\u0011\tBa\u0007\u0002L:!!1\u0003B\f\u001d\ry&QC\u0005\u0003\u0003OJAA!\u0007\u0002f\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u000f\u0005?\u00111aU3r\u0015\u0011\u0011I\"!\u001a\t\u0011\t\r\"\u0011\u0002a\u0001\u0005K\t\u0011b]3be\u000eD\u0017\nZ:\u0011\u0011\u0005\r$q\u0005B\u0016\u0005cIAA!\u000b\u0002f\tIa)\u001e8di&|g.\r\t\u0005\u0003+\u0011i#C\u0002\u00030\u0011\u0012A\u0001U1hKB1!\u0011\u0003B\u000e\u00037D\u0001\"a\u0018\u0003\n\u0001\u0007\u0011\u0011\r\u0005\t\u0003_\u0012I\u00011\u0001\u0002b!A!\u0011\bB\u0005\u0001\u0004\u0011Y$\u0001\u0006qKJl\u0017n]:j_:\u0004BA!\u0010\u0003B5\u0011!q\b\u0006\u0004\u0005s1\u0018\u0002\u0002B\"\u0005\u007f\u0011!\u0002U3s[&\u001c8/[8o\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013\n\u0001DZ5oIJ+G.Z1tKN\u0014\u00150\u00133t\u0013:|%\u000fZ3s)\u0011\u0011yAa\u0013\t\u0011\t5#Q\ta\u0001\u0005c\t!B]3mK\u0006\u001cX-\u00133t\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'\na\u0002^8TK\u0006\u00148\r\u001b*fgVdG\u000f\u0006\u0004\u0002@\tU#q\u000b\u0005\t\u0003?\u0012y\u00051\u0001\u0002b!A!\u0011\fB(\u0001\u0004\u0011y!\u0001\u0005sK2,\u0017m]3t\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005;\"BAa\u0018\u0003dQ!!\u0011\u0007B1\u0011!\tyFa\u0017A\u0002\t-\u0002\u0002CA&\u00057\u0002\r!!\u0014\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j\u000592/Z1sG\"\u001cu.\u001c9mKR,GMU3mK\u0006\u001cXm\u001d\u000b\u0005\u0005W\u0012)\b\u0006\u0005\u0003\u0010\t5$\u0011\u000fB:\u0011!\u0011yG!\u001aA\u0002\t\u0015\u0012AB4fi&#7\u000f\u0003\u0005\u0002`\t\u0015\u0004\u0019AA1\u0011!\tyG!\u001aA\u0002\u0005\u0005\u0004\u0002CA&\u0005K\u0002\r!!\u0014\t\u000f\te\u0004\u0001\"\u0003\u0003|\u0005y1/Z1sG\"Le.\u0011:dQ&4X\r\u0006\u0005\u0002@\nu$q\u0010BA\u0011!\tYEa\u001eA\u0002\u00055\u0003\u0002CA8\u0005o\u0002\r!!\u0019\t\u0011\t\r%q\u000fa\u0001\u0003C\naa\u001c4gg\u0016$\bb\u0002BD\u0001\u0011\u0005#\u0011R\u0001\rKbL7\u000f^:Cs:\u000bW.\u001a\u000b\u0005\u0003\u007f\u0012Y\t\u0003\u0005\u0003\u000e\n\u0015\u0005\u0019AAn\u00035\u0019\u0017M\u001c3jI\u0006$XMT1nK\"\"!QQAD\u0011\u001d\u0011\u0019\n\u0001C\u0005\u0005+\u000b\u0011cY;se\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197t+\t\u00119\n\u0005\u0004\u0003\u0012\te\u00151\\\u0005\u0005\u00057\u0013yB\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011y\n\u0001C\u0005\u0005C\u000babY;se\u0016tGOU8mK&#7/\u0006\u0002\u0003$B1!Q\u0015BX\u0005gk!Aa*\u000b\t\t%&1V\u0001\b[V$\u0018M\u00197f\u0015\u0011\u0011i+!\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00032\n\u001d&A\u0002\"vM\u001a,'\u000fE\u0002\u000e\u0005kK1!a:\u000f\u0001")
public class SqlReleaseSearchService
implements ReleaseSearchService,
Logging,
DeserializationSupport,
SqlReleasesFilterSupport,
SqlTemplatesFilterSupport {
    private final ReleasePersistence releasePersistence;
    private final ArchivingService archivingService;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TeamService teamService;
    private final InternalMetadataDecoratorService decoratorService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public ReleasesSqlBuilder sqlBuilderByTemplateFilters(TemplateFilters filters, Iterable<String> principals, Iterable<String> roleIds) {
        return SqlTemplatesFilterSupport.sqlBuilderByTemplateFilters$(this, filters, principals, roleIds);
    }

    @Override
    public ReleasesSqlBuilder sqlBuilderByReleaseFilters(ReleasesFilters filters, Iterable<String> principals, Iterable<String> roleIds) {
        return SqlReleasesFilterSupport.sqlBuilderByReleaseFilters$(this, filters, principals, roleIds);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ReleaseSearchResult search(ReleasesFilters x$1, long x$2, long x$3) {
        return super.search(x$1, x$2, x$3);
    }

    public ReleaseSearchResult search(ReleasesFilters x$1, long x$2, long x$3, int x$4) {
        return super.search(x$1, x$2, x$3, x$4);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseSearchService sqlReleaseSearchService = this;
        synchronized (sqlReleaseSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TeamService teamService() {
        return this.teamService;
    }

    @Override
    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page2, long numberByPage, int depth, boolean filterOnPermissions) {
        Seq<Release> seq;
        releasesFilters.checkConsistency();
        if (releasesFilters.hasASelectedFilter()) {
            Function1 & Serializable & scala.Serializable getIds = (Function1 & Serializable & scala.Serializable)page -> this.searchIds(releasesFilters, (Page)page);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by filters"})).s((Seq)Nil$.MODULE$));
            seq = releasesFilters.withOnlyArchived() ? (Seq<Release>)JavaConverters$.MODULE$.asScalaBufferConverter(this.searchInArchive(releasesFilters, numberByPage, numberByPage * page2)).asScala() : (releasesFilters.withInactive() || releasesFilters.withAborted() || releasesFilters.withCompleted() ? this.searchCompletedReleases(releasesFilters, (Function1<Page, Seq<String>>)getIds, page2, numberByPage) : this.queryReleases((Function1<Page, Seq<String>>)getIds, page2, numberByPage, XLReleasePermissions.VIEW_RELEASE));
        } else {
            seq = List$.MODULE$.empty();
        }
        Seq<Release> results = seq;
        return this.toSearchResult(page2, results);
    }

    @Timed
    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for templates by filters"})).s((Seq)Nil$.MODULE$));
        Seq<Release> templates = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$1((Page)page, templateFilters), page2, numberByPage, XLReleasePermissions.VIEW_TEMPLATE);
        return this.toSearchResult(page2, templates);
    }

    @Timed
    public List<Release> searchReleasesByTitle(String releaseTitle, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by title ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseTitle})));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.getIds$1((Page)page, releaseTitle), page2, numberByPage, XLReleasePermissions.VIEW_RELEASE)).asJava();
    }

    @Timed
    public List<String> findAllTemplateIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public List<String> findAllActiveReleaseIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public List<String> findAllPendingReleaseIds() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for all pending releases"})).s((Seq)Nil$.MODULE$));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED})))).withAutoStart().build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    private Seq<Release> queryReleases(Function1<Page, Seq<String>> searchIds, long page, long numberByPage, Permission permission) {
        Seq releaseIds = (Seq)searchIds.apply((Object)new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Seq releases = releaseIds.nonEmpty() ? this.findReleasesByIdsInOrder((Seq<String>)releaseIds) : (Seq)Seq$.MODULE$.empty();
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            SqlReleaseSearchService.$anonfun$queryReleases$1(this, release);
            return BoxedUnit.UNIT;
        });
        this.decoratorService.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    private Seq<Release> findReleasesByIdsInOrder(Seq<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds(releaseIds).build();
        Seq releasesUnordered = (Seq)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
        return (Seq)releasesUnordered.sortBy((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)r.getId())), (Ordering)Ordering.Int$.MODULE$);
    }

    private ReleaseSearchResult toSearchResult(long page, Seq<Release> releases) {
        ReleaseSearchResult searchResult = new ReleaseSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.addReleases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava());
        return searchResult;
    }

    private Seq<String> searchIds(ReleasesFilters releasesFilters, Page page) {
        Tuple2 sqlWithParams = this.sqlBuilderByReleaseFilters(releasesFilters, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of releases by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private Seq<Release> searchCompletedReleases(ReleasesFilters releasesFilters, Function1<Page, Seq<String>> getIds, long page, long numberByPage) {
        Seq seq;
        Seq releases = this.queryReleases(getIds, page, numberByPage, XLReleasePermissions.VIEW_RELEASE);
        if (releases.nonEmpty()) {
            if ((long)releases.length() >= numberByPage) {
                seq = releases;
            } else {
                List<Release> archivedReleases = this.searchInArchive(releasesFilters, numberByPage - (long)releases.length(), 0L);
                seq = (Seq)releases.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(archivedReleases).asScala(), Seq$.MODULE$.canBuildFrom());
            }
        } else {
            int numOfNonArchivedReleases = ((SeqLike)getIds.apply((Object)new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0)))).length();
            long offset = numberByPage * page - (long)numOfNonArchivedReleases;
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.searchInArchive(releasesFilters, numberByPage, offset)).asScala();
        }
        return seq;
    }

    private List<Release> searchInArchive(ReleasesFilters releasesFilters, long numberByPage, long offset) {
        List releases = this.archivingService.searchReleases(releasesFilters, numberByPage, offset);
        this.decoratorService.decorate((Collection)releases, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    @Timed
    public boolean existsByName(String candidateName) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withReleaseName(candidateName).withPage(new Page(0L, 1L, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).nonEmpty();
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    private final Seq searchIds$1(Page page, TemplateFilters templateFilters$1) {
        Tuple2 sqlWithParams = this.sqlBuilderByTemplateFilters(templateFilters$1, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of templates by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private final Seq getIds$1(Page page, String releaseTitle$1) {
        ReleasesSqlBuilder sqlWithParams = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withTitle(releaseTitle$1).withPage(page);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlWithParams.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams.build());
    }

    public static final /* synthetic */ void $anonfun$queryReleases$1(SqlReleaseSearchService $this, Release release) {
        $this.teamService().decorateWithEffectiveTeams(release);
    }

    public SqlReleaseSearchService(ReleasePersistence releasePersistence, ArchivingService archivingService, SqlRepositoryAdapter repositoryAdapter, TeamService teamService, InternalMetadataDecoratorService decoratorService, SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, RoleService roleService, SecuredCis securedCis) {
        this.releasePersistence = releasePersistence;
        this.archivingService = archivingService;
        this.repositoryAdapter = repositoryAdapter;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.securedCis = securedCis;
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        SqlReleasesFilterSupport.$init$(this);
        SqlTemplatesFilterSupport.$init$(this);
    }
}

