/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0001\u0003\u00015\u0011\u0011cU9m)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019r\u0001\u0001\b\u00151qy\"\u0005\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011a\u0002V1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\tI\")Y:f%\u0016dW-Y:f\u0013R,WNU3q_NLGo\u001c:z!\tIR$\u0003\u0002\u001f\u0005\t1B)Z:fe&\fG.\u001b>bi&|gnU;qa>\u0014H\u000f\u0005\u0002\u001aA%\u0011\u0011E\u0001\u0002\u001f\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKN\u001cV\u000f\u001d9peR\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n\u0001b\u001a:jujdW\rZ\u0005\u0003S\u0011\u0012q\u0001T8hO&tw\r\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001-\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0002\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003e=\u0012!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\"AA\u0007\u0001B\u0001B\u0003%Q&A\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012\u0001\u000f\t\u0003]eJ!AO\u0018\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\"AA\b\u0001B\u0001B\u0003%\u0001(\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0011!q\u0004A!b\u0001\n\u0003y\u0014a\u0004;bg.\u0004VM]:jgR,gnY3\u0016\u0003\u0001\u0003\"AL!\n\u0005\t{#a\u0004+bg.\u0004VM]:jgR,gnY3\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0001\u000b\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\t\u0011\u0019\u0003!Q1A\u0005\u0002\u001d\u000b\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s+\u0005A\u0005CA\rJ\u0013\tQ%A\u0001\u000bTc2\u0014V\r]8tSR|'/_!eCB$XM\u001d\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0011\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0011!q\u0005A!b\u0001\n\u0003y\u0015\u0001G2p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dKV\t\u0001\u000b\u0005\u0002/#&\u0011!k\f\u0002\u0019\u0007>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\u00023\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW\r\t\u0005\t-\u0002\u0011)\u0019!C\u0002/\u00069A-[1mK\u000e$X#\u0001-\u0011\u0005ecgB\u0001.j\u001d\tYvM\u0004\u0002]K:\u0011Q\f\u001a\b\u0003=\u000et!a\u00182\u000e\u0003\u0001T!!\u0019\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002g\r\u0005\u0011AMY\u0005\u0003\u0007!T!A\u001a\u0004\n\u0005)\\\u0017AC*rY\n+\u0018\u000e\u001c3fe*\u00111\u0001[\u0005\u0003[:\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002kW\"A\u0001\u000f\u0001B\u0001B\u0003%\u0001,\u0001\u0005eS\u0006dWm\u0019;!\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0019a\u0014N\\5u}Q9A/\u001e<xqfT\bCA\r\u0001\u0011\u0015Y\u0013\u000f1\u0001.\u0011\u00151\u0014\u000f1\u00019\u0011\u0015q\u0014\u000f1\u0001A\u0011\u00151\u0015\u000f1\u0001I\u0011\u0015q\u0015\u000f1\u0001Q\u0011\u00151\u0016\u000fq\u0001Y\u0011\u0015a\b\u0001\"\u0011~\u0003!1\u0017N\u001c3Cs&#Wc\u0001@\u0002\u0004Q\u0019q0a\u0007\u0011\t\u0005\u0005\u00111\u0001\u0007\u0001\t\u001d\t)a\u001fb\u0001\u0003\u000f\u0011\u0011\u0001V\t\u0005\u0003\u0013\ty\u0001E\u0002\u0010\u0003\u0017I1!!\u0004\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+1\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002\u001a\u0005M!\u0001\u0002+bg.Dq!!\b|\u0001\u0004\ty\"\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u0003C\tIC\u0004\u0003\u0002$\u0005\u0015\u0002CA0\u0011\u0013\r\t9\u0003E\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0002\u0003K\u0002|\u0003c\u0001B!a\r\u0002B5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0006b]:|G/\u0019;j_:TA!a\u000f\u0002>\u00059Q.\u001a;sS\u000e\u001c(bAA \u0015\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002D\u0005U\"!\u0002+j[\u0016$\u0007bBA$\u0001\u0011\u0005\u0013\u0011J\u0001\u0014M&tG\rV1tWN4uN\u001d)pY2Lgn\u001a\u000b\u0005\u0003\u0017\n9\u0007\u0005\u0004\u0002N\u0005]\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005!Q\u000f^5m\u0015\t\t)&\u0001\u0003kCZ\f\u0017\u0002BA-\u0003\u001f\u0012A\u0001T5tiB!\u0011QLA2\u001b\t\tyFC\u0002\u0002b\u0011\tQ!];fefLA!!\u001a\u0002`\tiA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006D\u0001\"!\u001b\u0002F\u0001\u0007\u00111N\u0001\bi\u0006\u001c8.\u00133t!\u0019\ti%a\u0016\u0002 !\"\u0011QIA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;W\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\tI(a\u001d\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010\u000b\u0003\u0002F\u0005E\u0002bBA@\u0001\u0011\u0005\u0013\u0011Q\u0001\u0007KbL7\u000f^:\u0015\t\u0005\r\u0015\u0011\u0012\t\u0004\u001f\u0005\u0015\u0015bAAD!\t9!i\\8mK\u0006t\u0007\u0002CA\u000f\u0003{\u0002\r!a\b)\t\u0005u\u0014q\u000e\u0015\u0005\u0003{\n\t\u0004C\u0004\u0002\u0012\u0002!\t%a%\u0002\rU\u0004H-\u0019;f)\u0011\ty!!&\t\u0011\u0005]\u0015q\u0012a\u0001\u0003\u001f\tA\u0001^1tW\"\"\u0011qRA\u0019\u0011\u001d\ti\n\u0001C!\u0003?\u000bA#\u001e9eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001cH\u0003BAQ\u0003O\u00032aDAR\u0013\r\t)\u000b\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0018\u0006m\u0005\u0019AA\bQ\u0011\tY*!\r\t\u000f\u00055\u0006\u0001\"\u0011\u00020\u0006qR\u000f\u001d3bi\u0016$\u0016m]6B]\u0012\u0014V\r\\3bg\u00164E.Y4Ti\u0006$Xo\u001d\u000b\u0007\u0003\u001f\t\t,a-\t\u0011\u0005]\u00151\u0016a\u0001\u0003\u001fA\u0001\"!.\u0002,\u0002\u0007\u0011qW\u0001\be\u0016dW-Y:f!\u0011\t\t\"!/\n\t\u0005m\u00161\u0003\u0002\b%\u0016dW-Y:fQ\u0011\tY+!\r\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\u0006QQ\u000f\u001d3bi\u0016$\u0016\u0010]3\u0015\t\u0005=\u0011Q\u0019\u0005\t\u0003/\u000by\f1\u0001\u0002\u0010!\"\u0011qXA\u0019\u0011\u001d\tY\r\u0001C!\u0003\u001b\fa\u0001Z3mKR,G\u0003BAQ\u0003\u001fD\u0001\"a&\u0002J\u0002\u0007\u0011q\u0002\u0015\u0005\u0003\u0013\f\t\u0004C\u0004\u0002V\u0002!I!a6\u0002;]LG\u000f[!mYVsG-\u001a:ms&tw\rR3qK:$WM\\2jKN$B!!7\u0002rR!\u0011\u0011UAn\u0011!\ti.a5A\u0002\u0005}\u0017AB1di&|g\u000eE\u0004\u0010\u0003C\f)/a;\n\u0007\u0005\r\bCA\u0005Gk:\u001cG/[8ocA!\u0011\u0011CAt\u0013\u0011\tI/a\u0005\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010E\u0002\u0010\u0003[L1!a<\u0011\u0005\r\te.\u001f\u0005\t\u0003/\u000b\u0019\u000e1\u0001\u0002\u0010!9\u0011Q\u001f\u0001\u0005\n\u0005]\u0018AC2sK\u0006$X\rV1tWR!\u0011qBA}\u0011!\tY0a=A\u0002\u0005=\u0011a\u00028foR\u000b7o\u001b\u0005\b\u0003\u007f\u0004A\u0011\tB\u0001\u0003\u0019\u0019'/Z1uKR!\u0011q\u0002B\u0002\u0011!\tY0!@A\u0002\u0005=\u0001\u0006BA\u007f\u0003cAqA!\u0003\u0001\t\u0003\u0012Y!\u0001\u0005n_Z,G+Y:l))\tyA!\u0004\u0003\u0012\tU!q\u0004\u0005\t\u0005\u001f\u00119\u00011\u0001\u0002\u0010\u0005QA/Y:l)>luN^3\t\u0011\tM!q\u0001a\u0001\u0003\u001f\t\u0011\"\\8wK\u0012$\u0016m]6\t\u0011\t]!q\u0001a\u0001\u00053\ta#\u001e9eCR,Gm\u0014:jO&t7i\u001c8uC&tWM\u001d\t\u0005\u0003#\u0011Y\"\u0003\u0003\u0003\u001e\u0005M!!\u0004+bg.\u001cuN\u001c;bS:,'\u000f\u0003\u0005\u0003\"\t\u001d\u0001\u0019\u0001B\r\u0003Y)\b\u000fZ1uK\u0012$\u0016M]4fi\u000e{g\u000e^1j]\u0016\u0014\b\u0006\u0002B\u0004\u0003cAqAa\n\u0001\t\u0003\u0012I#\u0001\fgS:$\u0017I\u001a4fGR,GMQ=CY\u0006\u001c7n\\;u)\u0011\tYGa\u000b\t\u0011\t5\"Q\u0005a\u0001\u0005_\t\u0001B\u00197bG.|W\u000f\u001e\t\u0005\u0005c\u00119$\u0004\u0002\u00034)!!QGA\n\u0003!\u0019\u0017\r\\3oI\u0006\u0014\u0018\u0002\u0002B\u001d\u0005g\u0011\u0001B\u00117bG.|W\u000f\u001e\u0015\u0005\u0005K\t\t\u0004C\u0004\u0003@\u0001!\tE!\u0011\u0002\u0011\u001d,G\u000fV5uY\u0016$B!a\b\u0003D!A\u0011Q\u0004B\u001f\u0001\u0004\ty\u0002\u000b\u0003\u0003>\u0005=\u0004\u0006\u0002B\u001f\u0003cA3\u0001\u0001B&!\u0011\t\tH!\u0014\n\t\t=\u00131\u000f\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlBuilder.Dialect dialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependency(Release release, Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, release, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId);
        return (T)release.getTask(CiId$.MODULE$.RichCiId(taskId).normalized());
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            String id = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Some some = (Some)option;
            TaskRow data = (TaskRow)some.value();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        this.withAllUnderlyingDependencies(task, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)d -> {
            BoxedUnit boxedUnit;
            if (d.isArchived()) {
                this.dependencyPersistence().deleteDependency((Dependency)d);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                try {
                    this.dependencyPersistence().updateDependency(task.getRelease(), (Dependency)d);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (NotFoundException e) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dependency not found when updating task ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task})), (Function0 & Serializable & scala.Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task2) {
        this.checkIsNotReferencedByDependencies(task2.getId());
        this.releasePersistence().update(task2.getRelease());
        this.withAllUnderlyingDependencies(task2, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task2.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlTaskRepository.$anonfun$delete$2(this, task);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(task2.getRelease());
    }

    private void withAllUnderlyingDependencies(Task task, Function1<Dependency, Object> action) {
        ((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$withAllUnderlyingDependencies$1(x$1)))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((GateTask)x$2).getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).foreach(action);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$3)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        Release release = createdTask.getRelease();
        this.withAllUnderlyingDependencies(createdTask, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(release, dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
            this.withAllUnderlyingDependencies(taskToMove, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
                SqlTaskRepository.$anonfun$moveTask$2(this, dependency);
                return BoxedUnit.UNIT;
            });
            Release release = movedTask.getRelease();
            this.withAllUnderlyingDependencies(movedTask, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
                this.insertDependency(release, dependency);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ void $anonfun$delete$2(SqlTaskRepository $this, Task task) {
        $this.taskPersistence().delete(task);
    }

    public static final /* synthetic */ boolean $anonfun$withAllUnderlyingDependencies$1(Task x$1) {
        return x$1 instanceof GateTask;
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$3) {
        String string = x$3.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    public static final /* synthetic */ void $anonfun$moveTask$2(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.dialect = dialect;
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

