/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.IllegalUriException$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host;
import akka.parboiled2.CharUtils$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HttpRequest$ {
    public static HttpRequest$ MODULE$;

    static {
        new HttpRequest$();
    }

    public Uri effectiveUri(Uri uri, scala.collection.immutable.Seq<HttpHeader> headers, boolean securedConnection, Host defaultHostHeader) {
        Uri uri2;
        Host hostHeader = HttpRequest$.findHost$1(headers);
        if (uri.isRelative()) {
            Host host;
            Host host2 = hostHeader;
            OptionVal$.MODULE$.None();
            Host host3 = host2;
            if (!(null != null ? !((Object)null).equals(host3) : host3 != null)) {
                if (defaultHostHeader.isEmpty()) {
                    throw HttpRequest$.fail$1("is missing a `Host` header", uri);
                }
                host = defaultHostHeader;
            } else {
                Host x;
                Host host4 = (Host)OptionVal.Some$.MODULE$.unapply((Object)host2);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)host4) && (x = (Host)OptionVal$.MODULE$.get$extension((Object)host4)).isEmpty()) {
                    if (defaultHostHeader.isEmpty()) {
                        throw HttpRequest$.fail$1("an empty `Host` header", uri);
                    }
                    host = defaultHostHeader;
                } else {
                    Host host5 = (Host)OptionVal.Some$.MODULE$.unapply((Object)host2);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)host5)) {
                        Host x2;
                        host = x2 = (Host)OptionVal$.MODULE$.get$extension((Object)host5);
                    } else {
                        throw new MatchError((Object)new OptionVal((Object)host2));
                    }
                }
            }
            Host host6 = host;
            if (host6 == null) {
                throw new MatchError((Object)host6);
            }
            Uri.Host host7 = host6.host();
            int port = host6.port();
            Tuple2 tuple2 = new Tuple2((Object)host7, (Object)BoxesRunTime.boxToInteger((int)port));
            Tuple2 tuple22 = tuple2;
            Uri.Host host8 = (Uri.Host)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            uri2 = uri.toEffectiveHttpRequestUri(host8, port2, securedConnection, uri.toEffectiveHttpRequestUri$default$4());
        } else if (OptionVal$.MODULE$.isEmpty$extension((Object)hostHeader) || uri.authority().isEmpty() && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader)).isEmpty() || ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader)).host().equalsIgnoreCase(uri.authority().host()) && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader)).port() == uri.authority().port()) {
            uri2 = uri;
        } else {
            throw IllegalUriException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'Host' header value of request to `", "` doesn't match request target authority"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Host header: ", "\\nrequest target authority: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new OptionVal((Object)hostHeader), uri.authority()})));
        }
        return uri2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyUri(Uri uri) {
        if (uri.isEmpty()) {
            throw new IllegalArgumentException("`uri` must not be empty");
        }
        int n = uri.scheme().length();
        switch (n) {
            case 0: {
                return;
            }
            case 4: {
                if (HttpRequest$.c$1(0, uri) != 'h' || HttpRequest$.c$1(1, uri) != 't' || HttpRequest$.c$1(2, uri) != 't' || HttpRequest$.c$1(3, uri) != 'p') throw new IllegalArgumentException("`uri` must have scheme \"http\", \"https\" or no scheme");
                return;
            }
            case 5: {
                if (HttpRequest$.c$1(0, uri) == 'h' && HttpRequest$.c$1(1, uri) == 't' && HttpRequest$.c$1(2, uri) == 't' && HttpRequest$.c$1(3, uri) == 'p' && HttpRequest$.c$1(4, uri) == 's') return;
            }
            default: {
                throw new IllegalArgumentException("`uri` must have scheme \"http\", \"https\" or no scheme");
            }
        }
    }

    public HttpRequest apply(HttpMethod method, Uri uri, scala.collection.immutable.Seq<HttpHeader> headers, RequestEntity entity, HttpProtocol protocol) {
        return new HttpRequest(method, uri, headers, entity, protocol);
    }

    public HttpMethod apply$default$1() {
        return HttpMethods$.MODULE$.GET();
    }

    public Uri apply$default$2() {
        return Uri$.MODULE$.$div();
    }

    public scala.collection.immutable.Seq<HttpHeader> apply$default$3() {
        return Nil$.MODULE$;
    }

    public RequestEntity apply$default$4() {
        return HttpEntity$.MODULE$.Empty();
    }

    public HttpProtocol apply$default$5() {
        return HttpProtocols$.MODULE$.HTTP$div1$u002E1();
    }

    public HttpRequest unapply(HttpRequest any) {
        return any;
    }

    private static final Host findHost$1(scala.collection.immutable.Seq headers) {
        for (HttpHeader httpHeader : headers) {
            if (httpHeader instanceof Host) {
                Host host = (Host)httpHeader;
                return (Host)OptionVal.Some$.MODULE$.apply((Object)host);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final Nothing$ fail$1(String detail, Uri uri$1) {
        throw IllegalUriException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot establish effective URI of request to `", "`, request has a relative URI and ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri$1, detail})) + "consider setting `akka.http.server.default-host-header`", IllegalUriException$.MODULE$.apply$default$2());
    }

    private static final char c$1(int i, Uri uri$2) {
        return CharUtils$.MODULE$.toLowerCase(uri$2.scheme().charAt(i));
    }

    private HttpRequest$() {
        MODULE$ = this;
    }
}

