/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.Utf8Encoder$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.ByteStringBuilder;
import scala.Predef$;
import scala.collection.immutable.StringOps$;

@InternalApi
public final class Utf8Encoder$
extends GraphStage<FlowShape<String, ByteString>> {
    public static Utf8Encoder$ MODULE$;
    private final int SurrogateFirst;
    private final int SurrogateSecond;
    private final long Utf8OneByteLimit;
    private final long Utf8TwoByteLimit;
    private final long Utf8ThreeByteLimit;
    private final Inlet<String> stringIn;
    private final Outlet<ByteString> byteStringOut;
    private final FlowShape<String, ByteString> shape;
    private final Attributes initialAttributes;

    static {
        new Utf8Encoder$();
    }

    public int SurrogateFirst() {
        return this.SurrogateFirst;
    }

    public int SurrogateSecond() {
        return this.SurrogateSecond;
    }

    public long Utf8OneByteLimit() {
        return this.Utf8OneByteLimit;
    }

    public long Utf8TwoByteLimit() {
        return this.Utf8TwoByteLimit;
    }

    public long Utf8ThreeByteLimit() {
        return this.Utf8ThreeByteLimit;
    }

    public long lowerNBitsSet(int n) {
        return (1L << n) - 1L;
    }

    public Inlet<String> stringIn() {
        return this.stringIn;
    }

    public Outlet<ByteString> byteStringOut() {
        return this.byteStringOut;
    }

    public FlowShape<String, ByteString> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return this.initialAttributes;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(){
            private int surrogateValue;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            private int surrogateValue() {
                return this.surrogateValue;
            }

            private void surrogateValue_$eq(int x$1) {
                this.surrogateValue = x$1;
            }

            private boolean inSurrogatePair() {
                return this.surrogateValue() != 0;
            }

            public void onPush() {
                ByteStringBuilder builder = new ByteStringBuilder();
                String input = (String)this.grab(Utf8Encoder$.MODULE$.stringIn());
                for (int offset = 0; offset < input.length(); ++offset) {
                    this.step$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), offset), builder);
                }
                if (builder.length() > 0) {
                    this.push(Utf8Encoder$.MODULE$.byteStringOut(), builder.result());
                } else {
                    this.pull(Utf8Encoder$.MODULE$.stringIn());
                }
            }

            public void onUpstreamFinish() {
                if (this.inSurrogatePair()) {
                    this.failStage(new IllegalArgumentException("Truncated String input (ends in the middle of surrogate pair)"));
                } else {
                    this.completeStage();
                }
            }

            public void onPull() {
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            private static final void b$1(int v, ByteStringBuilder builder$1) {
                builder$1.$plus$eq((byte)v);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void step$1(int n, ByteStringBuilder builder$1) {
                if (!this.inSurrogatePair()) {
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8OneByteLimit()) {
                        builder$1.$plus$eq((byte)n);
                        return;
                    } else if ((long)n <= Utf8Encoder$.MODULE$.Utf8TwoByteLimit()) {
                        anon.1.b$1(0xC0 | (n & 0x7C0) >> 6, builder$1);
                        anon.1.b$1(0x80 | n & 0x3F, builder$1);
                        return;
                    } else if (n >= Utf8Encoder$.MODULE$.SurrogateFirst() && n < Utf8Encoder$.MODULE$.SurrogateSecond()) {
                        this.surrogateValue_$eq(0x10000 | (n ^ Utf8Encoder$.MODULE$.SurrogateFirst()) << 10);
                        return;
                    } else {
                        if (n >= Utf8Encoder$.MODULE$.SurrogateSecond() && n < 57343) {
                            throw new IllegalArgumentException("Unexpected UTF-16 surrogate continuation");
                        }
                        if ((long)n > Utf8Encoder$.MODULE$.Utf8ThreeByteLimit()) throw new IllegalStateException("Char cannot be >= 2^16");
                        anon.1.b$1(0xE0 | (n & 0xF000) >> 12, builder$1);
                        anon.1.b$1(0x80 | (n & 0xFC0) >> 6, builder$1);
                        anon.1.b$1(0x80 | n & 0x3F, builder$1);
                    }
                    return;
                } else {
                    if (n < Utf8Encoder$.MODULE$.SurrogateSecond() || n > 57343) throw new IllegalArgumentException("Expected UTF-16 surrogate continuation");
                    this.surrogateValue_$eq(this.surrogateValue() | n & 0x3FF);
                    anon.1.b$1(0xF0 | (this.surrogateValue() & 0x1C0000) >> 18, builder$1);
                    anon.1.b$1(0x80 | (this.surrogateValue() & 0x3F000) >> 12, builder$1);
                    anon.1.b$1(0x80 | (this.surrogateValue() & 0xFC0) >> 6, builder$1);
                    anon.1.b$1(0x80 | this.surrogateValue() & 0x3F, builder$1);
                    this.surrogateValue_$eq(0);
                }
            }
            {
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.surrogateValue = 0;
                this.setHandlers(Utf8Encoder$.MODULE$.stringIn(), Utf8Encoder$.MODULE$.byteStringOut(), this);
            }
        };
    }

    public String toString() {
        return "Utf8Encoder";
    }

    private Utf8Encoder$() {
        MODULE$ = this;
        this.SurrogateFirst = 55296;
        this.SurrogateSecond = 56320;
        this.Utf8OneByteLimit = this.lowerNBitsSet(7);
        this.Utf8TwoByteLimit = this.lowerNBitsSet(11);
        this.Utf8ThreeByteLimit = this.lowerNBitsSet(16);
        this.stringIn = Inlet$.MODULE$.apply("Utf8Encoder.stringIn");
        this.byteStringOut = Outlet$.MODULE$.apply("Utf8Encoder.byteStringOut");
        this.shape = new FlowShape(this.stringIn(), this.byteStringOut());
        this.initialAttributes = Attributes$.MODULE$.name("utf8Encoder");
    }
}

