/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.Arrays;
import java.util.List;

public class RepositoryAdapter
implements Repository {
    private RepositoryService repositoryService;
    private Validator validator;
    private WorkDir workDir;

    public RepositoryAdapter(RepositoryService repositoryService, Validator validator, WorkDir workDir) {
        this.repositoryService = repositoryService;
        this.validator = validator;
        this.workDir = workDir;
    }

    public boolean exists(String id) {
        return this.repositoryService.exists(id);
    }

    public <T extends ConfigurationItem> T read(String id) {
        return this.repositoryService.read(id, this.workDir);
    }

    @SafeVarargs
    public final <T extends ConfigurationItem> void create(T ... entity) {
        this.validator.validateCis(Arrays.asList(entity));
        this.repositoryService.create((ConfigurationItem[])entity);
    }

    @SafeVarargs
    public final <T extends ConfigurationItem> void update(T ... entity) {
        this.validator.validateCis(Arrays.asList(entity));
        this.repositoryService.update((ConfigurationItem[])entity);
    }

    @SafeVarargs
    public final <T extends ConfigurationItem> void createOrUpdate(T ... entity) {
        this.validator.validateCis(Arrays.asList(entity));
        this.repositoryService.createOrUpdate((ConfigurationItem[])entity);
    }

    public void delete(String ... id) {
        this.repositoryService.delete(id);
    }

    public void move(String id, String newId) {
        this.repositoryService.move(id, newId);
    }

    public void rename(String id, String newName) {
        this.repositoryService.rename(id, newName);
    }

    public <T extends ConfigurationItem> List<T> search(Type type) {
        return this.repositoryService.listEntities(new SearchParameters().setType(type));
    }

    public <T extends ConfigurationItem> List<T> search(Type type, String parent) {
        return this.repositoryService.listEntities(new SearchParameters().setType(type).setParent(parent));
    }
}

