/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configurers.provisioning;

import java.util.ArrayList;
import java.util.List;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.UserDetailsServiceConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.UserDetailsManager;

public class UserDetailsManagerConfigurer<B extends ProviderManagerBuilder<B>, C extends UserDetailsManagerConfigurer<B, C>>
extends UserDetailsServiceConfigurer<B, C, UserDetailsManager> {
    private final List<UserDetailsBuilder> userBuilders = new ArrayList<UserDetailsBuilder>();

    protected UserDetailsManagerConfigurer(UserDetailsManager userDetailsManager) {
        super(userDetailsManager);
    }

    @Override
    protected void initUserDetailsService() throws Exception {
        for (UserDetailsBuilder userBuilder : this.userBuilders) {
            ((UserDetailsManager)this.getUserDetailsService()).createUser(userBuilder.build());
        }
    }

    public final UserDetailsBuilder withUser(String username) {
        UserDetailsBuilder userBuilder = new UserDetailsBuilder(this, this);
        userBuilder.username(username);
        this.userBuilders.add(userBuilder);
        return userBuilder;
    }

    public static class UserDetailsBuilder {
        private User.UserBuilder user;
        private final C builder;
        final /* synthetic */ UserDetailsManagerConfigurer this$0;

        private UserDetailsBuilder(C builder) {
            this.this$0 = this$0;
            this.builder = builder;
        }

        public C and() {
            return this.builder;
        }

        private UserDetailsBuilder username(String username) {
            this.user = User.withUsername((String)username);
            return this;
        }

        public UserDetailsBuilder password(String password) {
            this.user.password(password);
            return this;
        }

        public UserDetailsBuilder roles(String ... roles) {
            this.user.roles(roles);
            return this;
        }

        public UserDetailsBuilder authorities(GrantedAuthority ... authorities) {
            this.user.authorities(authorities);
            return this;
        }

        public UserDetailsBuilder authorities(List<? extends GrantedAuthority> authorities) {
            this.user.authorities(authorities);
            return this;
        }

        public UserDetailsBuilder authorities(String ... authorities) {
            this.user.authorities(authorities);
            return this;
        }

        public UserDetailsBuilder accountExpired(boolean accountExpired) {
            this.user.accountExpired(accountExpired);
            return this;
        }

        public UserDetailsBuilder accountLocked(boolean accountLocked) {
            this.user.accountLocked(accountLocked);
            return this;
        }

        public UserDetailsBuilder credentialsExpired(boolean credentialsExpired) {
            this.user.credentialsExpired(credentialsExpired);
            return this;
        }

        public UserDetailsBuilder disabled(boolean disabled) {
            this.user.disabled(disabled);
            return this;
        }

        private UserDetails build() {
            return this.user.build();
        }
    }
}

