/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.TeamCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TeamEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\tyB+Z1n\u0003\u000e$\u0018N^5us2{wmZ5oO\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005\r!\u0011\u0001C1di&4\u0018\u000e^=\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u0019IA\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051QM^3oiNL!a\u0006\u000b\u0003\u001d\u00153XM\u001c;MSN$XM\\5oOB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0006g24GG\u001b\u0006\u0002;\u0005AqM]5{u2,G-\u0003\u0002 5\t9Aj\\4hS:<\u0007\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u0011\u00154XM\u001c;CkN,\u0012a\t\t\u0003'\u0011J!!\n\u000b\u0003#ac%+\u001a7fCN,WI^3oi\n+8\u000f\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003$\u0003%)g/\u001a8u\u0005V\u001c\b\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003U\t7\r^5wSRLHj\\4SKB|7/\u001b;pef\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00020Y\t)\u0012i\u0019;jm&$\u0018\u0010T8h%\u0016\u0004xn]5u_JL\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001dI,G.Z1tKN+'O^5dKB\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\bg\u0016\u0014h/[2f\u0013\t9DG\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\u0011YTHP \u0011\u0005q\u0002Q\"\u0001\u0002\t\u000b\u0005B\u0004\u0019A\u0012\t\u000b%B\u0004\u0019\u0001\u0016\t\u000bEB\u0004\u0019\u0001\u001a)\u0005a\n\u0005C\u0001\"N\u001b\u0005\u0019%B\u0001#F\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\r\u001e\u000bqAZ1di>\u0014\u0018P\u0003\u0002I\u0013\u0006)!-Z1og*\u0011!jS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA*A\u0002pe\u001eL!AT\"\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002)\u0001\t\u0003\t\u0016aC8o)\u0016\fW.\u0012<f]R$\"AU+\u0011\u00055\u0019\u0016B\u0001+\u000f\u0005\u0011)f.\u001b;\t\u000bY{\u0005\u0019A,\u0002\u0013Q,\u0017-\\#wK:$\bC\u0001-]\u001b\u0005I&BA\u000b[\u0015\tYF!\u0001\u0004e_6\f\u0017N\\\u0005\u0003;f\u0013\u0011\u0002V3b[\u00163XM\u001c;)\u0005={\u0006C\u00011h\u001b\u0005\t'B\u00012d\u0003\u0015!(GY;t\u0015\t!W-\u0001\u0005kCZ\fG-\u001e3f\u0015\u00051\u0017A\u00018m\u0013\tA\u0017MA\u000bBY2|woQ8oGV\u0014(/\u001a8u\u000bZ,g\u000e^:)\u0005=S\u0007C\u00011l\u0013\ta\u0017MA\u0005Tk\n\u001c8M]5cK\"\u0012\u0001A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c&\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\t\u0019\bOA\u0005D_6\u0004xN\\3oi\u0002")
public class TeamActivityLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogRepository activityLogRepository;
    private final ReleaseService releaseService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TeamActivityLoggingEventHandler teamActivityLoggingEventHandler = this;
        synchronized (teamActivityLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onTeamEvent(TeamEvent teamEvent) {
        TeamEvent teamEvent2 = teamEvent;
        if (teamEvent2 instanceof TeamCreatedEvent) {
            TeamCreatedEvent teamCreatedEvent = (TeamCreatedEvent)teamEvent2;
            Release release = teamCreatedEvent.release();
            Team team = teamCreatedEvent.team();
            this.activityLogRepository.log(release.getId(), ReleaseActivity.TEAM_CREATED.create(team.getTeamName()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (teamEvent2 instanceof TeamUpdatedEvent) {
            TeamUpdatedEvent teamUpdatedEvent = (TeamUpdatedEvent)teamEvent2;
            Release release = teamUpdatedEvent.release();
            Team updatedTeam = teamUpdatedEvent.updated();
            this.activityLogRepository.log(release.getId(), ReleaseActivity.TEAM_UPDATED.create(updatedTeam.getTeamName(), updatedTeam.getMembers().toString(), updatedTeam.getRoles().toString()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (teamEvent2 instanceof TeamDeletedEvent) {
            TeamDeletedEvent teamDeletedEvent = (TeamDeletedEvent)teamEvent2;
            Release release = teamDeletedEvent.release();
            Team team = teamDeletedEvent.team();
            this.activityLogRepository.log(release.getId(), ReleaseActivity.TEAM_DELETED.create(team.getTeamName()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (teamEvent2 instanceof TeamsMergedEvent) {
            TeamsMergedEvent teamsMergedEvent = (TeamsMergedEvent)teamEvent2;
            String templateId = teamsMergedEvent.templateId();
            String folderTitle = teamsMergedEvent.folderTitle();
            this.activityLogRepository.log(templateId, ReleaseActivity.FOLDER_TEAM_MERGED.create(this.releaseService.getTitle(templateId), folderTitle));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (teamEvent2 instanceof TeamsRemovedInTemplateEvent) {
            TeamsRemovedInTemplateEvent teamsRemovedInTemplateEvent = (TeamsRemovedInTemplateEvent)teamEvent2;
            String templateId = teamsRemovedInTemplateEvent.templateId();
            String folderTitle = teamsRemovedInTemplateEvent.folderTitle();
            this.activityLogRepository.log(templateId, ReleaseActivity.REMOVE_TEMPLATE_TEAMS.create(this.releaseService.getTitle(templateId), folderTitle));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teamEvent2})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Autowired
    public TeamActivityLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogRepository activityLogRepository, ReleaseService releaseService) {
        this.eventBus = eventBus;
        this.activityLogRepository = activityLogRepository;
        this.releaseService = releaseService;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

