/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.util.MediaTypeHelper;

@PreMatching
public class AcceptParameterHttpPreprocessor
implements ContainerRequestFilter {
    private final String paramMapping;

    public AcceptParameterHttpPreprocessor(String paramMapping) {
        if (paramMapping == null || paramMapping.matches("\\s+")) {
            throw new IllegalArgumentException(Messages.MESSAGES.constructorMappingInvalid());
        }
        this.paramMapping = paramMapping;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        List accepts;
        MultivaluedMap params = request.getUriInfo().getQueryParameters(false);
        if (params != null && (accepts = (List)params.get((Object)this.paramMapping)) != null && !accepts.isEmpty()) {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            for (String accept : accepts) {
                try {
                    accept = URLDecoder.decode(accept, StandardCharsets.UTF_8.name());
                    request.getHeaders().add((Object)"Accept", (Object)accept);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                mediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
            }
        }
    }
}

