/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u0011a#R7bS2\u0014VmY5qS\u0016tGOU3t_24XM\u001d\u0006\u0003\u0007\u0011\tQ!Z7bS2T!!\u0002\u0004\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t\u0001b]3dkJLG/\u001f\u0006\u00037!\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003;a\u00111BU8mKN+'O^5dK\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\u0006uK\u0006l7+\u001a:wS\u000e,\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0007\u0003\u001d\u0019XM\u001d<jG\u0016L!!\n\u0012\u0003\u0017Q+\u0017-\\*feZL7-\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\t\t\u0013&\u0003\u0002+E\t\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001E;tKJLeNZ8SKN|GN^3s!\t\tc&\u0003\u00020E\t\u0001Rk]3s\u0013:4wNU3t_24XM\u001d\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM*dg\u000e\u001d\u0011\u0005Q\u0002Q\"\u0001\u0002\t\u000bU\u0001\u0004\u0019\u0001\f\t\u000b}\u0001\u0004\u0019\u0001\u0011\t\u000b\u001d\u0002\u0004\u0019\u0001\u0015\t\u000b1\u0002\u0004\u0019A\u0017)\u0005AR\u0004CA\u001eG\u001b\u0005a$BA\u001f?\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u007f\u0001\u000bqAZ1di>\u0014\u0018P\u0003\u0002B\u0005\u0006)!-Z1og*\u00111\tR\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ)A\u0002pe\u001eL!a\u0012\u001f\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B%\u0001\t\u0003Q\u0015!\u0005:fg>dg/\u001a*fG&\u0004\u0018.\u001a8ugR11*\u00173gQB\u00042\u0001T*W\u001d\ti\u0015\u000b\u0005\u0002O!5\tqJ\u0003\u0002Q\u0019\u00051AH]8pizJ!A\u0015\t\u0002\rA\u0013X\rZ3g\u0013\t!VKA\u0002TKRT!A\u0015\t\u0011\u00051;\u0016B\u0001-V\u0005\u0019\u0019FO]5oO\")!\f\u0013a\u00017\u0006)!o\u001c7fgB\u0019A,\u0019,\u000f\u0005u{fB\u0001(_\u0013\u0005\t\u0012B\u00011\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\t1K7\u000f\u001e\u0006\u0003ABAQ!\u001a%A\u0002m\u000b1b\u001a7pE\u0006d'k\u001c7fg\")q\r\u0013a\u00017\u0006)Qo]3sg\")\u0011\u000e\u0013a\u0001U\u0006A\u0001\u000f\\1o\u0013R,W\u000e\u0005\u0002l]6\tAN\u0003\u0002n\r\u00051Am\\7bS:L!a\u001c7\u0003\u0011Ac\u0017M\\%uK6Dq!\u001d%\u0011\u0002\u0003\u0007!/A\u0007fq\u000edW\u000fZ3BkRDwN\u001d\t\u0003\u001fML!\u0001\u001e\t\u0003\u000f\t{w\u000e\\3b]\")a\u000f\u0001C\u0005o\u0006Q\u0001/\u0019:tKJ{G.Z:\u0015\t-Chp \u0005\u0006sV\u0004\rA_\u0001\fCN\u001c\u0018n\u001a8nK:$8\u000fE\u0002]Cn\u0004\"a\u0006?\n\u0005uD\"\u0001\u0002*pY\u0016DQAW;A\u0002mCQ![;A\u0002)Dq!a\u0001\u0001\t\u0013\t)!\u0001\bqCJ\u001cX\rV1tWJ{G.Z:\u0015\u000f-\u000b9!!\u0005\u0002\u0014!A\u0011\u0011BA\u0001\u0001\u0004\tY!\u0001\u0003uCN\\\u0007cA6\u0002\u000e%\u0019\u0011q\u00027\u0003\tQ\u000b7o\u001b\u0005\u00075\u0006\u0005\u0001\u0019A.\t\re\f\t\u00011\u0001{\u0011\u001d\t9\u0002\u0001C\u0005\u00033\t\u0011\u0003]1sg\u0016\u0014V\r\\3bg\u0016\u0014v\u000e\\3t)\u001dY\u00151DA\u0013\u0003OA\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\be\u0016dW-Y:f!\rY\u0017\u0011E\u0005\u0004\u0003Ga'a\u0002*fY\u0016\f7/\u001a\u0005\u00075\u0006U\u0001\u0019A.\t\re\f)\u00021\u0001{\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\t\u0011cZ3u%\u0016dW-Y:f\u001b\u0016l'-\u001a:t)\u0019\ty#!\u000e\u00028A!q\"!\rL\u0013\r\t\u0019\u0004\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005u\u0011\u0011\u0006a\u0001\u0003?Aa!_A\u0015\u0001\u0004Q\bbBA\u001e\u0001\u0011%\u0011QH\u0001\u0011a\u0006\u00148/Z$m_\n\fGNU8mKN$RaWA \u0003\u0003Ba!_A\u001d\u0001\u0004Q\bBB3\u0002:\u0001\u00071\fC\u0004\u0002F\u0001!I!a\u0012\u0002\u001b\u001d,G/\u00117m\u001b\u0016l'-\u001a:t)\u0015Y\u0015\u0011JA*\u0011!\tY%a\u0011A\u0002\u00055\u0013\u0001\u0002;fC6\u00042a[A(\u0013\r\t\t\u0006\u001c\u0002\u0005)\u0016\fW\u000e\u0003\u0004z\u0003\u0007\u0002\rA\u001f\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033\n1D]3t_24XMU3dSBLWM\u001c;tI\u0011,g-Y;mi\u0012*TCAA.U\r\u0011\u0018QL\u0016\u0003\u0003?\u0002B!!\u0019\u0002j5\u0011\u00111\r\u0006\u0005\u0003K\n9'A\u0005v]\u000eDWmY6fI*\u0011Q\bE\u0005\u0005\u0003W\n\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D3\u0001AA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;\u0005\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005e\u00141\u000f\u0002\b'\u0016\u0014h/[2f\u0001")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final UserInfoResolver userInfoResolver;

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allUsers = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)allUsers.map((Function1 & Serializable & scala.Serializable)x$1 -> $this.userInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$2(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set<String> watchers = package$.MODULE$.TaskWithNotificationFields(task).getWatchers();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option maybeTeam = Ids.isInFolder((String)release.getId()) ? ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5))) : Option$.MODULE$.apply((Object)release.getAdminTeam());
        return maybeTeam.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.ensureCreated(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$2(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, UserInfoResolver userInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.userInfoResolver = userInfoResolver;
    }
}

