/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Notification", versioned=false)
public class NotificationTask
extends Task {
    @Property
    private Set<String> addresses;
    @Property
    private String subject;
    @Property
    private String body;

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        HashSet newAddresses = Sets.newHashSet();
        for (String address : this.addresses) {
            newAddresses.add(VariableHelper.replaceAll(address, variables, (Set<String>)unresolvedVariables, freezeEvenIfUnresolved));
        }
        this.addresses = newAddresses;
        this.setSubject(VariableHelper.replaceAll(this.getSubject(), variables, (Set<String>)unresolvedVariables, freezeEvenIfUnresolved));
        this.setBody(VariableHelper.replaceAll(this.getBody(), variables, (Set<String>)unresolvedVariables, freezeEvenIfUnresolved));
        return unresolvedVariables;
    }

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        Changes changes = super.execute(targetId, operation);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        changes.addPostStartAction(new ExecuteTaskAction(this));
        return changes;
    }

    @PublicApiMember
    public Set<String> getAddresses() {
        return this.addresses;
    }

    @PublicApiMember
    public void setAddresses(Set<String> addresses) {
        this.addresses = addresses;
    }

    @PublicApiMember
    public String getSubject() {
        return this.subject;
    }

    @PublicApiMember
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @PublicApiMember
    public String getBody() {
        return this.body;
    }

    @PublicApiMember
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, "addresses"));
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, "subject"));
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, "body"));
        return usagePoints;
    }
}

