/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RoleResource
extends AbstractSecuredResource
implements RoleService {
    @Autowired
    private com.xebialabs.deployit.security.RoleService service;

    public List<String> list() {
        return this.service.getRoles().stream().map(Role::getName).collect(Collectors.toList());
    }

    public List<String> listMyRoles() {
        return this.service.getRolesFor(Permissions.getAuthentication()).stream().map(Role::getName).collect(Collectors.toList());
    }

    public List<String> listRoles(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        return this.service.getRolesFor(username).stream().map(Role::getName).collect(Collectors.toList());
    }

    public void create(String name) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        List roles = this.service.readRoleAssignments();
        for (Role role : roles) {
            if (!role.getName().equals(name)) continue;
            return;
        }
        Role newRole = new Role(name);
        roles.add(newRole);
        this.service.writeRoleAssignments(roles);
        EventBusHolder.publish((Object)new RoleCreatedEvent(name));
    }

    public void assign(String name, String principal) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        List roles = this.service.readRoleAssignments();
        boolean found = false;
        for (Role role : roles) {
            if (!role.getName().equals(name)) continue;
            found = true;
            if (role.getPrincipals().contains(principal)) continue;
            role.getPrincipals().add(principal);
        }
        if (!found) {
            Role newRole = new Role(name);
            newRole.getPrincipals().add(principal);
            roles.add(newRole);
        }
        this.service.writeRoleAssignments(roles);
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentCreatedEvent(principal, name));
    }

    public void unassign(String name, String principal) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        List roles = this.service.readRoleAssignments();
        for (Role role : roles) {
            if (!role.getName().equals(name)) continue;
            role.getPrincipals().remove(principal);
        }
        this.service.writeRoleAssignments(roles);
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentDeletedEvent(principal, name));
    }

    public void rename(String name, String newName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        List roles = this.service.readRoleAssignments();
        for (Role role : roles) {
            if (!role.getName().equals(name)) continue;
            role.setName(newName);
        }
        this.service.writeRoleAssignments(roles);
        EventBusHolder.publish((Object)new RoleRenamedEvent(name, newName));
    }

    public void delete(String name) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        List roles = this.service.readRoleAssignments();
        Iterator iter = roles.iterator();
        while (iter.hasNext()) {
            if (!((Role)iter.next()).getName().equals(name)) continue;
            iter.remove();
        }
        this.service.writeRoleAssignments(roles);
        EventBusHolder.publish((Object)new RoleDeletedEvent(name));
    }
}

