/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.protobuf;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterHeartbeatSender;
import akka.cluster.ClusterUserAction;
import akka.cluster.Gossip;
import akka.cluster.GossipEnvelope;
import akka.cluster.GossipEnvelope$;
import akka.cluster.GossipOverview;
import akka.cluster.GossipStatus;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$InitJoin$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.MemberStatus;
import akka.cluster.MemberStatus$Down$;
import akka.cluster.MemberStatus$Exiting$;
import akka.cluster.MemberStatus$Joining$;
import akka.cluster.MemberStatus$Leaving$;
import akka.cluster.MemberStatus$Removed$;
import akka.cluster.MemberStatus$Up$;
import akka.cluster.MemberStatus$WeaklyUp$;
import akka.cluster.Reachability;
import akka.cluster.Reachability$;
import akka.cluster.Reachability$Reachable$;
import akka.cluster.Reachability$Terminated$;
import akka.cluster.Reachability$Unreachable$;
import akka.cluster.UniqueAddress;
import akka.cluster.VectorClock;
import akka.cluster.VectorClock$Node$;
import akka.cluster.protobuf.msg.ClusterMessages;
import akka.cluster.routing.ClusterRouterPool;
import akka.cluster.routing.ClusterRouterPoolSettings;
import akka.protobuf.ByteString;
import akka.protobuf.MessageLite;
import akka.routing.Pool;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.MapBuilder;
import scala.collection.package$;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B\u0001\u0003\u0001%\u0011\u0001d\u00117vgR,'/T3tg\u0006<WmU3sS\u0006d\u0017N_3s\u0015\t\u0019A!\u0001\u0005qe>$xNY;g\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u001d\tA!Y6lC\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\u001bM,'/[1mSj\fG/[8o\u0013\t)\"C\u0001\bCCN,7+\u001a:jC2L'0\u001a:\t\u0011]\u0001!Q1A\u0005\u0002a\taa]=ti\u0016lW#A\r\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011!B1di>\u0014\u0018B\u0001\u0010\u001c\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011!\u0001\u0003A!A!\u0002\u0013I\u0012aB:zgR,W\u000e\t\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00112\u0003CA\u0013\u0001\u001b\u0005\u0011\u0001\"B\f\"\u0001\u0004I\u0002\u0002C\n\u0001\u0011\u000b\u0007I\u0011\u0002\u0015\u0016\u0003%\u0002\"!\u0005\u0016\n\u0005-\u0012\"!D*fe&\fG.\u001b>bi&|g\u000eC\u0004.\u0001\t\u0007IQ\u0002\u0018\u0002\u0015\t+hMZ3s'&TX-F\u00010\u001f\u0005\u0001TD\u0001\t\u0001\u0011\u0019\u0011\u0004\u0001)A\u0007_\u0005Y!)\u001e4gKJ\u001c\u0016N_3!\u0011!!\u0004\u0001#b\u0001\n\u0013)\u0014\u0001E$pgNL\u0007\u000fV5nKR{G*\u001b<f+\u00051\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003!!WO]1uS>t'BA\u001e\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003{a\u0012aBR5oSR,G)\u001e:bi&|g\u000eC\u0004@\u0001\t\u0007I\u0011\u0002!\u0002\u001b\u0019\u0014x.\u001c\"j]\u0006\u0014\u00180T1q+\u0005\t\u0005\u0003\u0002\"H\u0013~k\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0019c\u0011AC2pY2,7\r^5p]&\u0011\u0001j\u0011\u0002\b\u0011\u0006\u001c\b.T1qa\tQE\u000bE\u0002L!Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA\u0001\\1oO*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005\u0015\u0019E.Y:t!\t\u0019F\u000b\u0004\u0001\u0005\u0013U3\u0016\u0011!A\u0001\u0006\u0003A&aA0%c!1q\u000b\u0001Q\u0001\n\u0005\u000baB\u001a:p[\nKg.\u0019:z\u001b\u0006\u0004\b%\u0005\u0002Z9B\u00111BW\u0005\u000372\u0011qAT8uQ&tw\r\u0005\u0002\f;&\u0011a\f\u0004\u0002\u0004\u0003:L\b\u0003B\u0006aE\"L!!\u0019\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0006dK&\u0011A\r\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0017\u0019L!a\u001a\u0007\u0003\t\tKH/\u001a\t\u0003\u0017&L!A\u001b'\u0003\r=\u0013'.Z2u\u0011\u0015a\u0007\u0001\"\u0001n\u0003=Ign\u00197vI\u0016l\u0015M\\5gKN$X#\u00018\u0011\u0005-y\u0017B\u00019\r\u0005\u001d\u0011un\u001c7fC:DQA\u001d\u0001\u0005\u0002M\f\u0001\u0002^8CS:\f'/\u001f\u000b\u0003ERDQ!^9A\u0002)\t1a\u001c2k\u0011\u00159\b\u0001\"\u0001y\u0003!\u0019w.\u001c9sKN\u001cHC\u00012z\u0011\u0015Qh\u000f1\u0001|\u0003\ri7o\u001a\t\u0003yzl\u0011! \u0006\u0003\u0007\u0019I!a`?\u0003\u00175+7o]1hK2KG/\u001a\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003)!WmY8naJ,7o\u001d\u000b\u0004E\u0006\u001d\u0001bBA\u0005\u0003\u0003\u0001\rAY\u0001\u0006Ef$Xm\u001d\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003)1'o\\7CS:\f'/\u001f\u000b\u0006\u0015\u0005E\u00111\u0003\u0005\b\u0003\u0013\tY\u00011\u0001c\u0011!\t)\"a\u0003A\u0002\u0005]\u0011!B2mCjT\b#B\u0006\u0002\u001a\u0005u\u0011bAA\u000e\u0019\t1q\n\u001d;j_:\u0004D!a\b\u00026A1\u0011\u0011EA\u0018\u0003gqA!a\t\u0002,A\u0019\u0011Q\u0005\u0007\u000e\u0005\u0005\u001d\"bAA\u0015\u0011\u00051AH]8pizJ1!!\f\r\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011+!\r\u000b\u0007\u00055B\u0002E\u0002T\u0003k!1\"a\u000e\u0002\u0014\u0005\u0005\t\u0011!B\u00011\n\u0019q\f\n\u001a\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\u0005\t\u0012\r\u001a3sKN\u001chI]8n\u0005&t\u0017M]=\u0015\t\u0005}\u0012Q\t\t\u00045\u0005\u0005\u0013bAA\"7\t9\u0011\t\u001a3sKN\u001c\bbBA\u0005\u0003s\u0001\rA\u0019\u0005\b\u0003\u0013\u0002A\u0011BA&\u0003])h.[9vK\u0006#GM]3tg\u001a\u0013x.\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0003\u0002N\u0005U\u0003\u0003BA(\u0003#j\u0011\u0001B\u0005\u0004\u0003'\"!!D+oSF,X-\u00113ee\u0016\u001c8\u000fC\u0004\u0002\n\u0005\u001d\u0003\u0019\u00012\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\\u0005q\u0011\r\u001a3sKN\u001cHk\u001c)s_R|G\u0003BA/\u0003o\u0002B!a\u0018\u0002r9!\u0011\u0011MA6\u001d\u0011\t\u0019'a\u001a\u000e\u0005\u0005\u0015$B\u0001>\u0003\u0013\u0011\tI'!\u001a\u0002\u001f\rcWo\u001d;fe6+7o]1hKNLA!!\u001c\u0002p\u00059\u0011\t\u001a3sKN\u001c(\u0002BA5\u0003KJA!a\u001d\u0002v\t9!)^5mI\u0016\u0014(\u0002BA7\u0003_B\u0001\"!\u001f\u0002X\u0001\u0007\u0011qH\u0001\bC\u0012$'/Z:t\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\nq#\u00193ee\u0016\u001c8\u000fV8Qe>$xNQ=uK\u0006\u0013(/Y=\u0015\u0007\t\f\t\t\u0003\u0005\u0002z\u0005m\u0004\u0019AA \u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000bA#\u001e8jcV,\u0017\t\u001a3sKN\u001cHk\u001c)s_R|G\u0003BAE\u0003+\u0003B!a#\u0002\u0012:!\u0011\u0011MAG\u0013\u0011\ty)a\u001c\u0002\u001bUs\u0017.];f\u0003\u0012$'/Z:t\u0013\u0011\t\u0019(a%\u000b\t\u0005=\u0015q\u000e\u0005\t\u0003/\u000b\u0019\t1\u0001\u0002N\u0005iQO\\5rk\u0016\fE\r\u001a:fgNDq!a'\u0001\t\u0013\ti*A\u000fv]&\fX/Z!eIJ,7o\u001d+p!J|Go\u001c\"zi\u0016\f%O]1z)\r\u0011\u0017q\u0014\u0005\t\u0003/\u000bI\n1\u0001\u0002N!9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0016!I2mkN$XM\u001d*pkR,'\u000fU8pYR{\u0007K]8u_\nKH/Z!se\u0006LHc\u00012\u0002(\"A\u0011\u0011VAQ\u0001\u0004\tY+\u0001\u0002saB!\u0011QVAZ\u001b\t\tyKC\u0002\u00022\u0012\tqA]8vi&tw-\u0003\u0003\u00026\u0006=&!E\"mkN$XM\u001d*pkR,'\u000fU8pY\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016a\u00039p_2$v\u000e\u0015:pi>$B!!0\u0002DB!\u0011\u0011MA`\u0013\u0011\t\t-a\u001c\u0003\tA{w\u000e\u001c\u0005\t\u0003\u000b\f9\f1\u0001\u0002H\u0006!\u0001o\\8m!\u0011\tI-!4\u000e\u0005\u0005-'bAAY\r%!\u0011\u0011YAf\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'\f\u0001e\u00197vgR,'OU8vi\u0016\u0014\bk\\8m'\u0016$H/\u001b8hgR{\u0007K]8u_R!\u0011Q[An!\u0011\t\t'a6\n\t\u0005e\u0017q\u000e\u0002\u001a\u00072,8\u000f^3s%>,H/\u001a:Q_>d7+\u001a;uS:<7\u000f\u0003\u0005\u0002^\u0006=\u0007\u0019AAp\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003BAW\u0003CLA!!7\u00020\"Y\u0011Q\u001d\u0001A\u0002\u0003\u0007I\u0011BAt\u00035\u0001(o\u001c;pG>d7)Y2iKV\u0011\u0011\u0011\u001e\t\u0005\u0003C\tY/\u0003\u0003\u0002n\u0006E\"AB*ue&tw\rC\u0006\u0002r\u0002\u0001\r\u00111A\u0005\n\u0005M\u0018!\u00059s_R|7m\u001c7DC\u000eDWm\u0018\u0013fcR!\u0011Q_A~!\rY\u0011q_\u0005\u0004\u0003sd!\u0001B+oSRD!\"!@\u0002p\u0006\u0005\t\u0019AAu\u0003\rAH%\r\u0005\t\u0005\u0003\u0001\u0001\u0015)\u0003\u0002j\u0006q\u0001O]8u_\u000e|GnQ1dQ\u0016\u0004\u0003\u0006BA\u0000\u0005\u000b\u00012a\u0003B\u0004\u0013\r\u0011I\u0001\u0004\u0002\tm>d\u0017\r^5mK\"Y!Q\u0002\u0001A\u0002\u0003\u0007I\u0011BAt\u0003-\u0019\u0018p\u001d;f[\u000e\u000b7\r[3\t\u0017\tE\u0001\u00011AA\u0002\u0013%!1C\u0001\u0010gf\u001cH/Z7DC\u000eDWm\u0018\u0013fcR!\u0011Q\u001fB\u000b\u0011)\tiPa\u0004\u0002\u0002\u0003\u0007\u0011\u0011\u001e\u0005\t\u00053\u0001\u0001\u0015)\u0003\u0002j\u0006a1/_:uK6\u001c\u0015m\u00195fA!\"!q\u0003B\u0003\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005C\t1bZ3u!J|Go\\2pYR!\u0011\u0011\u001eB\u0012\u0011!\tIH!\bA\u0002\t\u0015\u0002\u0003BA1\u0005OIA!a\u0011\u0002p!9!1\u0006\u0001\u0005\n\t5\u0012!C4fiNK8\u000f^3n)\u0011\tIOa\f\t\u0011\u0005e$\u0011\u0006a\u0001\u0005KAqAa\r\u0001\t\u0013\u0011)$\u0001\tbI\u0012\u0014Xm]:Ge>l\u0007K]8u_R!\u0011q\bB\u001c\u0011!\tIH!\rA\u0002\t\u0015\u0002b\u0002B\u001e\u0001\u0011%!QH\u0001\u0017k:L\u0017/^3BI\u0012\u0014Xm]:Ge>l\u0007K]8u_R!\u0011Q\nB \u0011!\t9J!\u000fA\u0002\t\u0005\u0003\u0003BA1\u0005\u0007JA!a\u0015\u0002p!I!q\t\u0001C\u0002\u0013%!\u0011J\u0001\u0012[\u0016l'-\u001a:Ti\u0006$Xo\u001d+p\u0013:$XC\u0001B&!\u0019\u0011uI!\u0014\u0003TA!\u0011q\nB(\u0013\r\u0011\t\u0006\u0002\u0002\r\u001b\u0016l'-\u001a:Ti\u0006$Xo\u001d\t\u0004\u0017\tU\u0013b\u0001B,\u0019\t\u0019\u0011J\u001c;\t\u0011\tm\u0003\u0001)A\u0005\u0005\u0017\n!#\\3nE\u0016\u00148\u000b^1ukN$v.\u00138uA!I!q\f\u0001C\u0002\u0013%!\u0011M\u0001\u0014[\u0016l'-\u001a:Ti\u0006$Xo\u001d$s_6Le\u000e^\u000b\u0003\u0005G\u0002bAQ$\u0003T\t5\u0003\u0002\u0003B4\u0001\u0001\u0006IAa\u0019\u0002)5,WNY3s'R\fG/^:Ge>l\u0017J\u001c;!\u0011%\u0011Y\u0007\u0001b\u0001\n\u0013\u0011i'A\fsK\u0006\u001c\u0007.\u00192jY&$\u0018p\u0015;biV\u001cHk\\%oiV\u0011!q\u000e\t\u0007\u0005\u001e\u0013\tHa\u0015\u0011\t\tM$\u0011\u0010\b\u0005\u0003\u001f\u0012)(C\u0002\u0003x\u0011\tABU3bG\"\f'-\u001b7jifLAAa\u001f\u0003~\t\u0011\"+Z1dQ\u0006\u0014\u0017\u000e\\5usN#\u0018\r^;t\u0015\r\u00119\b\u0002\u0005\t\u0005\u0003\u0003\u0001\u0015!\u0003\u0003p\u0005A\"/Z1dQ\u0006\u0014\u0017\u000e\\5usN#\u0018\r^;t)>Le\u000e\u001e\u0011\t\u0013\t\u0015\u0005A1A\u0005\n\t\u001d\u0015!\u0007:fC\u000eD\u0017MY5mSRL8\u000b^1ukN4%o\\7J]R,\"A!#\u0011\r\t;%1\u000bB9\u0011!\u0011i\t\u0001Q\u0001\n\t%\u0015A\u0007:fC\u000eD\u0017MY5mSRL8\u000b^1ukN4%o\\7J]R\u0004\u0003b\u0002BI\u0001\u0011%!1S\u0001\u0014[\u0006\u0004x+\u001b;i\u000bJ\u0014xN]'fgN\fw-Z\u000b\u0005\u0005+\u0013\u0019\u000b\u0006\u0005\u0003T\t]%q\u0015BV\u0011!\u0011IJa$A\u0002\tm\u0015aA7baBA\u0011\u0011\u0005BO\u0005C\u0013\u0019&\u0003\u0003\u0003 \u0006E\"aA'baB\u00191Ka)\u0005\u000f\t\u0015&q\u0012b\u00011\n\tA\u000b\u0003\u0005\u0003*\n=\u0005\u0019\u0001BQ\u0003\u00151\u0018\r\\;f\u0011!\u0011iKa$A\u0002\u0005%\u0018aB;oW:|wO\u001c\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0003-Qw.\u001b8U_B\u0013x\u000e^8\u0015\r\tU&1\u0018B`!\u0011\t\tGa.\n\t\te\u0016q\u000e\u0002\u0005\u0015>Lg\u000e\u0003\u0005\u0003>\n=\u0006\u0019AA'\u0003\u0011qw\u000eZ3\t\u0011\t\u0005'q\u0016a\u0001\u0005\u0007\fQA]8mKN\u0004b!!\t\u0003F\u0006%\u0018\u0002\u0002Bd\u0003c\u00111aU3u\u0011\u001d\u0011Y\r\u0001C\u0005\u0005\u001b\fab^3mG>lW\rV8Qe>$x\u000e\u0006\u0004\u0003P\nU'\u0011\u001c\t\u0005\u0003C\u0012\t.\u0003\u0003\u0003T\u0006=$aB,fY\u000e|W.\u001a\u0005\t\u0005/\u0014I\r1\u0001\u0002N\u0005!aM]8n\u0011!\u0011YN!3A\u0002\tu\u0017AB4pgNL\u0007\u000f\u0005\u0003\u0002P\t}\u0017b\u0001Bq\t\t1qi\\:tSBDqA!:\u0001\t\u0013\u00119/A\u0007h_N\u001c\u0018\u000e\u001d+p!J|Go\u001c\u000b\u0005\u0005S\u0014)\u0010\u0005\u0003\u0003l\nEh\u0002BA1\u0005[LAAa<\u0002p\u00051qi\\:tSBLA!a\u001d\u0003t*!!q^A8\u0011!\u0011YNa9A\u0002\tu\u0007b\u0002B}\u0001\u0011%!1`\u0001\u0013m\u0016\u001cGo\u001c:DY>\u001c7\u000eV8Qe>$x\u000e\u0006\u0004\u0003~\u000e%11\u0003\t\u0005\u0005\u007f\u001c)A\u0004\u0003\u0002b\r\u0005\u0011\u0002BB\u0002\u0003_\n1BV3di>\u00148\t\\8dW&!\u00111OB\u0004\u0015\u0011\u0019\u0019!a\u001c\t\u0011\r-!q\u001fa\u0001\u0007\u001b\tqA^3sg&|g\u000e\u0005\u0003\u0002P\r=\u0011bAB\t\t\tYa+Z2u_J\u001cEn\\2l\u0011!\u0019)Ba>A\u0002\r]\u0011a\u00035bg\"l\u0015\r\u001d9j]\u001e\u0004\u0002\"!\t\u0003\u001e\u0006%(1\u000b\u0005\b\u00077\u0001A\u0011BB\u000f\u0003U9wn]:ja\u0016sg/\u001a7pa\u0016$v\u000e\u0015:pi>$Baa\b\u0004&A!\u0011\u0011MB\u0011\u0013\u0011\u0019\u0019#a\u001c\u0003\u001d\u001d{7o]5q\u000b:4X\r\\8qK\"A1qEB\r\u0001\u0004\u0019I#\u0001\u0005f]Z,Gn\u001c9f!\u0011\tyea\u000b\n\u0007\r\rB\u0001C\u0004\u00040\u0001!Ia!\r\u0002'\u001d|7o]5q'R\fG/^:U_B\u0013x\u000e^8\u0015\t\rM2\u0011\b\t\u0005\u0003C\u001a)$\u0003\u0003\u00048\u0005=$\u0001D$pgNL\u0007o\u0015;biV\u001c\b\u0002CB\u001e\u0007[\u0001\ra!\u0010\u0002\rM$\u0018\r^;t!\u0011\tyea\u0010\n\u0007\r]B\u0001C\u0004\u0004D\u0001!Ia!\u0012\u00021\u001d|7o]5q\u000b:4X\r\\8qK\u001a\u0013x.\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0003\u0004*\r\u001d\u0003bBA\u0005\u0007\u0003\u0002\rA\u0019\u0005\b\u0007\u0017\u0002A\u0011BB'\u0003Y9wn]:jaN#\u0018\r^;t\rJ|WNQ5oCJLH\u0003BB\u001f\u0007\u001fBq!!\u0003\u0004J\u0001\u0007!\rC\u0004\u0004T\u0001!Ia!\u0016\u0002\u001f\u001d|7o]5q\rJ|W\u000e\u0015:pi>$BA!8\u0004X!A!1\\B)\u0001\u0004\u0019I\u0006\u0005\u0003\u0002b\rm\u0013\u0002\u0002Bq\u0003_Bqaa\u0018\u0001\t\u0013\u0019\t'\u0001\u000bwK\u000e$xN]\"m_\u000e\\gI]8n!J|Go\u001c\u000b\u0007\u0007\u001b\u0019\u0019g!\u001b\t\u0011\r-1Q\fa\u0001\u0007K\u0002B!!\u0019\u0004h%!1\u0011CA8\u0011!\u0019)b!\u0018A\u0002\r-\u0004#\u0002\"\u0004n\u0005%\u0018bAB8\u0007\n\u00191+Z9\t\u000f\rM\u0004\u0001\"\u0003\u0004v\u00059rm\\:tSB,eN^3m_B,gI]8n!J|Go\u001c\u000b\u0005\u0007S\u00199\b\u0003\u0005\u0004(\rE\u0004\u0019AB\u0010\u0011\u001d\u0019Y\b\u0001C\u0005\u0007{\nQcZ8tg&\u00048\u000b^1ukN4%o\\7Qe>$x\u000e\u0006\u0003\u0004>\r}\u0004\u0002CB\u001e\u0007s\u0002\raa\r\t\u000f\r\r\u0005\u0001\"\u0001\u0004\u0006\u0006Y2\r\\;ti\u0016\u0014(k\\;uKJ\u0004vn\u001c7Ge>l')\u001b8bef$B!a+\u0004\b\"9\u0011\u0011BBA\u0001\u0004\u0011\u0007bBBF\u0001\u0011%1QR\u0001\u000ea>|GN\u0012:p[B\u0013x\u000e^8\u0015\t\u0005\u001d7q\u0012\u0005\t\u0003\u000b\u001cI\t1\u0001\u0002>\"911\u0013\u0001\u0005\n\rU\u0015AI2mkN$XM\u001d*pkR,'\u000fU8pYN+G\u000f^5oON4%o\\7Qe>$x\u000e\u0006\u0003\u0002`\u000e]\u0005\u0002CBM\u0007#\u0003\r!!6\u0002\t\r\u0014\bo\u001d")
public class ClusterMessageSerializer
implements BaseSerializer {
    private Serialization serialization;
    private FiniteDuration GossipTimeToLive;
    private final ExtendedActorSystem system;
    private final HashMap<Class<?>, Function1<byte[], Object>> fromBinaryMap;
    private volatile String protocolCache;
    private volatile String systemCache;
    private final HashMap<MemberStatus, Object> memberStatusToInt;
    private final HashMap<Object, MemberStatus> memberStatusFromInt;
    private final HashMap<Reachability.ReachabilityStatus, Object> reachabilityStatusToInt;
    private final HashMap<Object, Reachability.ReachabilityStatus> reachabilityStatusFromInt;
    private final int identifier;
    private volatile byte bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        ClusterMessageSerializer clusterMessageSerializer = this;
        synchronized (clusterMessageSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private final int BufferSize() {
        return 4096;
    }

    private FiniteDuration GossipTimeToLive$lzycompute() {
        ClusterMessageSerializer clusterMessageSerializer = this;
        synchronized (clusterMessageSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.GossipTimeToLive = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system())).settings().GossipTimeToLive();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.GossipTimeToLive;
    }

    private FiniteDuration GossipTimeToLive() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.GossipTimeToLive$lzycompute() : this.GossipTimeToLive;
    }

    private HashMap<Class<?>, Function1<byte[], Object>> fromBinaryMap() {
        return this.fromBinaryMap;
    }

    public boolean includeManifest() {
        return true;
    }

    public byte[] toBinary(Object obj) {
        byte[] byArray;
        Object object = obj;
        if (object instanceof ClusterHeartbeatSender.Heartbeat) {
            ClusterHeartbeatSender.Heartbeat heartbeat = (ClusterHeartbeatSender.Heartbeat)object;
            Address from = heartbeat.from();
            byArray = this.addressToProtoByteArray(from);
        } else if (object instanceof ClusterHeartbeatSender.HeartbeatRsp) {
            ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)object;
            UniqueAddress from = heartbeatRsp.from();
            byArray = this.uniqueAddressToProtoByteArray(from);
        } else if (object instanceof GossipEnvelope) {
            GossipEnvelope gossipEnvelope = (GossipEnvelope)object;
            byArray = this.gossipEnvelopeToProto(gossipEnvelope).toByteArray();
        } else if (object instanceof GossipStatus) {
            GossipStatus gossipStatus = (GossipStatus)object;
            byArray = this.gossipStatusToProto(gossipStatus).toByteArray();
        } else if (object instanceof InternalClusterAction.Join) {
            InternalClusterAction.Join join = (InternalClusterAction.Join)object;
            UniqueAddress node = join.node();
            scala.collection.immutable.Set<String> roles = join.roles();
            byArray = this.joinToProto(node, roles).toByteArray();
        } else if (object instanceof InternalClusterAction.Welcome) {
            InternalClusterAction.Welcome welcome = (InternalClusterAction.Welcome)object;
            UniqueAddress from = welcome.from();
            Gossip gossip = welcome.gossip();
            byArray = this.compress((MessageLite)this.welcomeToProto(from, gossip));
        } else if (object instanceof ClusterUserAction.Leave) {
            ClusterUserAction.Leave leave = (ClusterUserAction.Leave)object;
            Address address = leave.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (object instanceof ClusterUserAction.Down) {
            ClusterUserAction.Down down = (ClusterUserAction.Down)object;
            Address address = down.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (InternalClusterAction$InitJoin$.MODULE$.equals(object)) {
            byArray = ClusterMessages.Empty.getDefaultInstance().toByteArray();
        } else if (object instanceof InternalClusterAction.InitJoinAck) {
            InternalClusterAction.InitJoinAck initJoinAck = (InternalClusterAction.InitJoinAck)object;
            Address address = initJoinAck.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (object instanceof InternalClusterAction.InitJoinNack) {
            InternalClusterAction.InitJoinNack initJoinNack = (InternalClusterAction.InitJoinNack)object;
            Address address = initJoinNack.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (object instanceof InternalClusterAction.ExitingConfirmed) {
            InternalClusterAction.ExitingConfirmed exitingConfirmed = (InternalClusterAction.ExitingConfirmed)object;
            UniqueAddress node = exitingConfirmed.node();
            byArray = this.uniqueAddressToProtoByteArray(node);
        } else if (object instanceof ClusterRouterPool) {
            ClusterRouterPool clusterRouterPool = (ClusterRouterPool)object;
            byArray = this.clusterRouterPoolToProtoByteArray(clusterRouterPool);
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't serialize object of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj.getClass()})));
        }
        return byArray;
    }

    public byte[] compress(MessageLite msg) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
            msg.writeTo((OutputStream)zip);
        }
        return bos.toByteArray();
    }

    public byte[] decompress(byte[] bytes) {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            this.readChunk$1(in, out, buffer);
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        Object object;
        Option<Class<?>> option = clazz;
        if (option instanceof Some) {
            Some some = (Some)option;
            Class c = (Class)some.value();
            Option option2 = this.fromBinaryMap().get((Object)c);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unimplemented deserialization of message class ", " in ClusterSerializer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c})));
                }
                throw new MatchError((Object)option2);
            }
            Some some2 = (Some)option2;
            Function1 f = (Function1)some2.value();
            object = f.apply((Object)bytes);
        } else {
            throw new IllegalArgumentException("Need a cluster message class to be able to deserialize bytes in ClusterSerializer");
        }
        Object object2 = object;
        return object2;
    }

    private Address addressFromBinary(byte[] bytes) {
        return this.addressFromProto(ClusterMessages.Address.parseFrom(bytes));
    }

    private UniqueAddress uniqueAddressFromBinary(byte[] bytes) {
        return this.uniqueAddressFromProto(ClusterMessages.UniqueAddress.parseFrom(bytes));
    }

    private ClusterMessages.Address.Builder addressToProto(Address address) {
        String host;
        Option option;
        String actorSystem;
        String protocol;
        block3: {
            block2: {
                Address address2 = address;
                if (address2 == null) break block2;
                protocol = address2.protocol();
                actorSystem = address2.system();
                Option option2 = address2.host();
                option = address2.port();
                if (!(option2 instanceof Some)) break block2;
                Some some = (Some)option2;
                host = (String)some.value();
                if (option instanceof Some) break block3;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address [", "] could not be serialized: host or port missing."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})));
        }
        Some some = (Some)option;
        int port = BoxesRunTime.unboxToInt((Object)some.value());
        ClusterMessages.Address.Builder builder = ClusterMessages.Address.newBuilder().setSystem(actorSystem).setHostname(host).setPort(port).setProtocol(protocol);
        return builder;
    }

    private byte[] addressToProtoByteArray(Address address) {
        return this.addressToProto(address).build().toByteArray();
    }

    private ClusterMessages.UniqueAddress.Builder uniqueAddressToProto(UniqueAddress uniqueAddress) {
        return ClusterMessages.UniqueAddress.newBuilder().setAddress(this.addressToProto(uniqueAddress.address())).setUid((int)uniqueAddress.longUid()).setUid2((int)(uniqueAddress.longUid() >> 32));
    }

    private byte[] uniqueAddressToProtoByteArray(UniqueAddress uniqueAddress) {
        return this.uniqueAddressToProto(uniqueAddress).build().toByteArray();
    }

    private byte[] clusterRouterPoolToProtoByteArray(ClusterRouterPool rp) {
        ClusterMessages.ClusterRouterPool.Builder builder = ClusterMessages.ClusterRouterPool.newBuilder();
        builder.setPool(this.poolToProto(rp.local()));
        builder.setSettings(this.clusterRouterPoolSettingsToProto(rp.settings()));
        return builder.build().toByteArray();
    }

    private ClusterMessages.Pool poolToProto(Pool pool) {
        ClusterMessages.Pool.Builder builder;
        ClusterMessages.Pool.Builder builder2 = ClusterMessages.Pool.newBuilder();
        Serializer serializer = this.serialization().findSerializerFor((Object)pool);
        builder2.setSerializerId(serializer.identifier()).setData(ByteString.copyFrom((byte[])serializer.toBinary((Object)pool)));
        Serializer serializer2 = serializer;
        if (serializer2 instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
            builder = builder2.setManifest(serializerWithStringManifest.manifest((Object)pool));
        } else {
            builder = builder2.setManifest(serializer.includeManifest() ? pool.getClass().getName() : "");
        }
        return builder2.build();
    }

    private ClusterMessages.ClusterRouterPoolSettings clusterRouterPoolSettingsToProto(ClusterRouterPoolSettings settings) {
        ClusterMessages.ClusterRouterPoolSettings.Builder builder = ClusterMessages.ClusterRouterPoolSettings.newBuilder();
        builder.setAllowLocalRoutees(settings.allowLocalRoutees()).setMaxInstancesPerNode(settings.maxInstancesPerNode()).setTotalInstances(settings.totalInstances()).addAllUseRoles((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter(settings.useRoles()).asJava());
        settings.useRole().foreach((Function1 & Serializable & scala.Serializable)value -> builder.setUseRole((String)value));
        return builder.build();
    }

    private String protocolCache() {
        return this.protocolCache;
    }

    private void protocolCache_$eq(String x$1) {
        this.protocolCache = x$1;
    }

    private String systemCache() {
        return this.systemCache;
    }

    private void systemCache_$eq(String x$1) {
        this.systemCache = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private String getProtocol(ClusterMessages.Address address) {
        String string;
        String pc;
        String p = address.getProtocol();
        String string2 = pc = this.protocolCache();
        String string3 = p;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = pc;
        } else {
            void var2_2;
            this.protocolCache_$eq(p);
            string = var2_2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getSystem(ClusterMessages.Address address) {
        String string;
        String sc;
        String s = address.getSystem();
        String string2 = sc = this.systemCache();
        String string3 = s;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = sc;
        } else {
            void var2_2;
            this.systemCache_$eq(s);
            string = var2_2;
        }
        return string;
    }

    private Address addressFromProto(ClusterMessages.Address address) {
        return Address$.MODULE$.apply(this.getProtocol(address), this.getSystem(address), address.getHostname(), address.getPort());
    }

    private UniqueAddress uniqueAddressFromProto(ClusterMessages.UniqueAddress uniqueAddress) {
        return new UniqueAddress(this.addressFromProto(uniqueAddress.getAddress()), uniqueAddress.hasUid2() ? (long)uniqueAddress.getUid2() << 32 | (long)uniqueAddress.getUid() & 0xFFFFFFFFL : (long)uniqueAddress.getUid());
    }

    private HashMap<MemberStatus, Object> memberStatusToInt() {
        return this.memberStatusToInt;
    }

    private HashMap<Object, MemberStatus> memberStatusFromInt() {
        return this.memberStatusFromInt;
    }

    private HashMap<Reachability.ReachabilityStatus, Object> reachabilityStatusToInt() {
        return this.reachabilityStatusToInt;
    }

    private HashMap<Object, Reachability.ReachabilityStatus> reachabilityStatusFromInt() {
        return this.reachabilityStatusFromInt;
    }

    private <T> int mapWithErrorMessage(Map<T, Object> map, T value, String unknown) {
        int x;
        Option option = map.get(value);
        if (!(option instanceof Some)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown ", " [", "] in cluster message"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unknown, value})));
        }
        Some some = (Some)option;
        int n = x = BoxesRunTime.unboxToInt((Object)some.value());
        return n;
    }

    private ClusterMessages.Join joinToProto(UniqueAddress node, scala.collection.immutable.Set<String> roles) {
        return ClusterMessages.Join.newBuilder().setNode(this.uniqueAddressToProto(node)).addAllRoles((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter(roles).asJava()).build();
    }

    private ClusterMessages.Welcome welcomeToProto(UniqueAddress from, Gossip gossip) {
        return ClusterMessages.Welcome.newBuilder().setFrom(this.uniqueAddressToProto(from)).setGossip(this.gossipToProto(gossip)).build();
    }

    private ClusterMessages.Gossip.Builder gossipToProto(Gossip gossip) {
        Vector allMembers = gossip.members().toVector();
        Vector allAddresses = (Vector)allMembers.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.uniqueAddress(), Vector$.MODULE$.canBuildFrom());
        Map addressMapping = ((TraversableOnce)allAddresses.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Vector allRoles = (Vector)((TraversableLike)allMembers.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(acc, m) -> (scala.collection.immutable.Set)acc.union(m.roles()))).to(Vector$.MODULE$.canBuildFrom());
        Map roleMapping = ((TraversableOnce)allRoles.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Vector allHashes = (Vector)gossip.version().versions().keys().to(Vector$.MODULE$.canBuildFrom());
        Map hashMapping = ((TraversableOnce)allHashes.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable reachability = this.reachabilityToProto$1(gossip.overview().reachability(), addressMapping);
        scala.collection.immutable.Set members = (scala.collection.immutable.Set)gossip.members().map((Function1 & Serializable & scala.Serializable)member -> this.memberToProto$1((Member)member, addressMapping, roleMapping), Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set seen = (scala.collection.immutable.Set)gossip.overview().seen().map((Function1 & Serializable & scala.Serializable)uniqueAddress -> this.mapUniqueAddress$1((UniqueAddress)uniqueAddress, addressMapping), Set$.MODULE$.canBuildFrom());
        ClusterMessages.GossipOverview.Builder overview = ClusterMessages.GossipOverview.newBuilder().addAllSeen((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)seen).asJava()).addAllObserverReachability((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)reachability.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.build(), scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava());
        return ClusterMessages.Gossip.newBuilder().addAllAllAddresses((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allAddresses.map((Function1 & Serializable & scala.Serializable)x$5 -> this.uniqueAddressToProto((UniqueAddress)x$5).build(), Vector$.MODULE$.canBuildFrom())).asJava()).addAllAllRoles((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allRoles).asJava()).addAllAllHashes((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allHashes).asJava()).addAllMembers((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)members.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.build(), Set$.MODULE$.canBuildFrom())).asJava()).setOverview(overview).setVersion(this.vectorClockToProto(gossip.version(), (Map<String, Object>)hashMapping));
    }

    private ClusterMessages.VectorClock.Builder vectorClockToProto(VectorClock version, Map<String, Object> hashMapping) {
        Iterable versions = (Iterable)version.versions().map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String n = (String)tuple2._1();
            long t = tuple2._2$mcJ$sp();
            ClusterMessages.VectorClock.Version.Builder builder = ClusterMessages.VectorClock.Version.newBuilder().setHashIndex(this.mapWithErrorMessage(hashMapping, n, "hash")).setTimestamp(t);
            return builder;
        }, Iterable$.MODULE$.canBuildFrom());
        return ClusterMessages.VectorClock.newBuilder().setTimestamp(0L).addAllVersions((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)versions.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.build(), scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava());
    }

    private ClusterMessages.GossipEnvelope gossipEnvelopeToProto(GossipEnvelope envelope) {
        return ClusterMessages.GossipEnvelope.newBuilder().setFrom(this.uniqueAddressToProto(envelope.from())).setTo(this.uniqueAddressToProto(envelope.to())).setSerializedGossip(ByteString.copyFrom((byte[])this.compress((MessageLite)this.gossipToProto(envelope.gossip()).build()))).build();
    }

    private ClusterMessages.GossipStatus gossipStatusToProto(GossipStatus status) {
        Vector allHashes = status.version().versions().keys().toVector();
        Map hashMapping = ((TraversableOnce)allHashes.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return ClusterMessages.GossipStatus.newBuilder().setFrom(this.uniqueAddressToProto(status.from())).addAllAllHashes((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allHashes).asJava()).setVersion(this.vectorClockToProto(status.version(), (Map<String, Object>)hashMapping)).build();
    }

    private GossipEnvelope gossipEnvelopeFromBinary(byte[] bytes) {
        return this.gossipEnvelopeFromProto(ClusterMessages.GossipEnvelope.parseFrom(bytes));
    }

    private GossipStatus gossipStatusFromBinary(byte[] bytes) {
        return this.gossipStatusFromProto(ClusterMessages.GossipStatus.parseFrom(bytes));
    }

    private Gossip gossipFromProto(ClusterMessages.Gossip gossip) {
        Vector addressMapping = (Vector)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getAllAddressesList()).asScala()).map((Function1 & Serializable & scala.Serializable)uniqueAddress -> this.uniqueAddressFromProto((ClusterMessages.UniqueAddress)uniqueAddress), package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
        Vector roleMapping = (Vector)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getAllRolesList()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
        Vector hashMapping = (Vector)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getAllHashesList()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
        SortedSet members = (SortedSet)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getMembersList()).asScala()).map((Function1 & Serializable & scala.Serializable)member -> this.memberFromProto$1((ClusterMessages.Member)member, addressMapping, roleMapping), package$.MODULE$.breakOut(SortedSet$.MODULE$.newCanBuildFrom(Member$.MODULE$.ordering())));
        Reachability reachability = this.reachabilityFromProto$1((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getOverview().getObserverReachabilityList()).asScala(), addressMapping);
        scala.collection.immutable.Set seen = (scala.collection.immutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getOverview().getSeenList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> (UniqueAddress)addressMapping.apply(Predef$.MODULE$.Integer2int(x$9)), package$.MODULE$.breakOut(Set$.MODULE$.canBuildFrom()));
        GossipOverview overview = new GossipOverview((scala.collection.immutable.Set<UniqueAddress>)seen, reachability);
        return new Gossip((SortedSet<Member>)members, overview, this.vectorClockFromProto(gossip.getVersion(), (scala.collection.immutable.Seq<String>)hashMapping));
    }

    private VectorClock vectorClockFromProto(ClusterMessages.VectorClock version, scala.collection.immutable.Seq<String> hashMapping) {
        return new VectorClock((TreeMap<String, Object>)((TreeMap)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(version.getVersionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)VectorClock$Node$.MODULE$.fromHash((String)hashMapping.apply(v.getHashIndex())), (Object)BoxesRunTime.boxToLong((long)v.getTimestamp())), package$.MODULE$.breakOut(TreeMap$.MODULE$.canBuildFrom((Ordering)Ordering.String$.MODULE$)))));
    }

    private GossipEnvelope gossipEnvelopeFromProto(ClusterMessages.GossipEnvelope envelope) {
        ByteString serializedGossip = envelope.getSerializedGossip();
        return GossipEnvelope$.MODULE$.apply(this.uniqueAddressFromProto(envelope.getFrom()), this.uniqueAddressFromProto(envelope.getTo()), Deadline$.MODULE$.now().$plus(this.GossipTimeToLive()), (Function0<Gossip>)(Function0 & Serializable & scala.Serializable)() -> this.gossipFromProto(ClusterMessages.Gossip.parseFrom(this.decompress(serializedGossip.toByteArray()))));
    }

    private GossipStatus gossipStatusFromProto(ClusterMessages.GossipStatus status) {
        return new GossipStatus(this.uniqueAddressFromProto(status.getFrom()), this.vectorClockFromProto(status.getVersion(), (scala.collection.immutable.Seq<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(status.getAllHashesList()).asScala()).toVector()));
    }

    public ClusterRouterPool clusterRouterPoolFromBinary(byte[] bytes) {
        ClusterMessages.ClusterRouterPool crp = ClusterMessages.ClusterRouterPool.parseFrom(bytes);
        return new ClusterRouterPool(this.poolFromProto(crp.getPool()), this.clusterRouterPoolSettingsFromProto(crp.getSettings()));
    }

    private Pool poolFromProto(ClusterMessages.Pool pool) {
        return (Pool)this.serialization().deserialize(pool.getData().toByteArray(), pool.getSerializerId(), pool.getManifest()).get();
    }

    private ClusterRouterPoolSettings clusterRouterPoolSettingsFromProto(ClusterMessages.ClusterRouterPoolSettings crps) {
        return new ClusterRouterPoolSettings(crps.getTotalInstances(), crps.getMaxInstancesPerNode(), crps.getAllowLocalRoutees(), (scala.collection.immutable.Set<String>)(crps.hasUseRole() ? (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(crps.getUseRolesList()).asScala()).toSet().$plus((Object)crps.getUseRole()) : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(crps.getUseRolesList()).asScala()).toSet()));
    }

    private final void readChunk$1(GZIPInputStream in$1, ByteArrayOutputStream out$1, byte[] buffer$1) {
        block3: while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                case -1: {
                    break block3;
                }
                default: {
                    out$1.write(buffer$1, 0, n);
                    break;
                }
            }
        }
    }

    private final Integer mapUniqueAddress$1(UniqueAddress uniqueAddress, Map addressMapping$1) {
        return Predef$.MODULE$.int2Integer(this.mapWithErrorMessage(addressMapping$1, uniqueAddress, "address"));
    }

    private final Integer mapRole$1(String role, Map roleMapping$1) {
        return Predef$.MODULE$.int2Integer(this.mapWithErrorMessage(roleMapping$1, role, "role"));
    }

    private final ClusterMessages.Member.Builder memberToProto$1(Member member, Map addressMapping$1, Map roleMapping$1) {
        return ClusterMessages.Member.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1(member.uniqueAddress(), addressMapping$1))).setUpNumber(member.upNumber()).setStatus(ClusterMessages.MemberStatus.valueOf(BoxesRunTime.unboxToInt((Object)this.memberStatusToInt().apply((Object)member.status())))).addAllRolesIndexes((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)member.roles().map((Function1 & Serializable & scala.Serializable)role -> this.mapRole$1((String)role, roleMapping$1), Set$.MODULE$.canBuildFrom())).asJava());
    }

    private final Iterable reachabilityToProto$1(Reachability reachability, Map addressMapping$1) {
        return (Iterable)reachability.versions().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            UniqueAddress observer = (UniqueAddress)tuple2._1();
            long version = tuple2._2$mcJ$sp();
            IndexedSeq subjectReachability = (IndexedSeq)reachability.recordsFrom(observer).map((Function1 & Serializable & scala.Serializable)r -> ClusterMessages.SubjectReachability.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1(r.subject(), addressMapping$1))).setStatus(ClusterMessages.ReachabilityStatus.valueOf(BoxesRunTime.unboxToInt((Object)this.reachabilityStatusToInt().apply((Object)r.status())))).setVersion(r.version()), IndexedSeq$.MODULE$.canBuildFrom());
            ClusterMessages.ObserverReachability.Builder builder = ClusterMessages.ObserverReachability.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1(observer, addressMapping$1))).setVersion(version).addAllSubjectReachability((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjectReachability.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.build(), IndexedSeq$.MODULE$.canBuildFrom())).asJava());
            return builder;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$gossipFromProto$4(ClusterMessageSerializer $this, Vector addressMapping$2, VectorBuilder recordBuilder$1, MapBuilder versionsBuilder$1, ClusterMessages.ObserverReachability o) {
        UniqueAddress observer = (UniqueAddress)addressMapping$2.apply(o.getAddressIndex());
        versionsBuilder$1.$plus$eq(new Tuple2((Object)observer, (Object)BoxesRunTime.boxToLong((long)o.getVersion())));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(o.getSubjectReachabilityList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            UniqueAddress subject = (UniqueAddress)addressMapping$2.apply(s.getAddressIndex());
            Reachability.Record record = new Reachability.Record(observer, subject, (Reachability.ReachabilityStatus)$this.reachabilityStatusFromInt().apply((Object)BoxesRunTime.boxToInteger((int)s.getStatus().getNumber())), s.getVersion());
            return recordBuilder$1.$plus$eq((Object)record);
        });
    }

    private final Reachability reachabilityFromProto$1(Iterable observerReachability, Vector addressMapping$2) {
        VectorBuilder recordBuilder = new VectorBuilder();
        MapBuilder versionsBuilder = new MapBuilder((GenMap)Predef$.MODULE$.Map().empty());
        observerReachability.foreach((Function1 & Serializable & scala.Serializable)o -> {
            ClusterMessageSerializer.$anonfun$gossipFromProto$4(this, addressMapping$2, recordBuilder, versionsBuilder, o);
            return BoxedUnit.UNIT;
        });
        return Reachability$.MODULE$.create((scala.collection.immutable.Seq<Reachability.Record>)recordBuilder.result(), (Map<UniqueAddress, Object>)((Map)versionsBuilder.result()));
    }

    private final Member memberFromProto$1(ClusterMessages.Member member, Vector addressMapping$2, Vector roleMapping$2) {
        return new Member((UniqueAddress)addressMapping$2.apply(member.getAddressIndex()), member.getUpNumber(), (MemberStatus)this.memberStatusFromInt().apply((Object)BoxesRunTime.boxToInteger((int)member.getStatus().getNumber())), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(member.getRolesIndexesList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> (String)roleMapping$2.apply(Predef$.MODULE$.Integer2int(x$8)), package$.MODULE$.breakOut(Set$.MODULE$.canBuildFrom()))));
    }

    public ClusterMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.fromBinaryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.Join.class), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            byte[] byArray = x0$1;
            ClusterMessages.Join m = ClusterMessages.Join.parseFrom(byArray);
            InternalClusterAction.Join join = new InternalClusterAction.Join(this.uniqueAddressFromProto(m.getNode()), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().empty().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(m.getRolesList()).asScala())));
            return join;
        }), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.Welcome.class), (Function1 & Serializable & scala.Serializable)x0$2 -> {
            byte[] byArray = x0$2;
            ClusterMessages.Welcome m = ClusterMessages.Welcome.parseFrom(this.decompress(byArray));
            InternalClusterAction.Welcome welcome = new InternalClusterAction.Welcome(this.uniqueAddressFromProto(m.getFrom()), this.gossipFromProto(m.getGossip()));
            return welcome;
        }), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterUserAction.Leave.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterUserAction.Leave(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterUserAction.Down.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterUserAction.Down(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction$InitJoin$.MODULE$.getClass()), (Function1 & Serializable & scala.Serializable)x$1 -> InternalClusterAction$InitJoin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.InitJoinAck.class), (Function1 & Serializable & scala.Serializable)bytes -> new InternalClusterAction.InitJoinAck(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.InitJoinNack.class), (Function1 & Serializable & scala.Serializable)bytes -> new InternalClusterAction.InitJoinNack(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterHeartbeatSender.Heartbeat.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterHeartbeatSender.Heartbeat(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterHeartbeatSender.HeartbeatRsp.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterHeartbeatSender.HeartbeatRsp(this.uniqueAddressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.ExitingConfirmed.class), (Function1 & Serializable & scala.Serializable)bytes -> new InternalClusterAction.ExitingConfirmed(this.uniqueAddressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(GossipStatus.class), (Function1 & Serializable & scala.Serializable)bytes -> this.gossipStatusFromBinary((byte[])bytes)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(GossipEnvelope.class), (Function1 & Serializable & scala.Serializable)bytes -> this.gossipEnvelopeFromBinary((byte[])bytes)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterRouterPool.class), (Function1 & Serializable & scala.Serializable)bytes -> this.clusterRouterPoolFromBinary((byte[])bytes))}));
        this.memberStatusToInt = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Joining$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Up$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Leaving$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Exiting$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Down$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Removed$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$WeaklyUp$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)6))}));
        this.memberStatusFromInt = (HashMap)this.memberStatusToInt().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MemberStatus a = (MemberStatus)tuple2._1();
            int b = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)b), (Object)a);
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        this.reachabilityStatusToInt = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)Reachability$Reachable$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)Reachability$Unreachable$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)Reachability$Terminated$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2))}));
        this.reachabilityStatusFromInt = (HashMap)this.reachabilityStatusToInt().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Reachability.ReachabilityStatus a = (Reachability.ReachabilityStatus)tuple2._1();
            int b = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)b), (Object)a);
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
    }
}

