/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.common;

public class SmbPath {
    private final String hostname;
    private final String shareName;
    private final String path;

    public SmbPath(String hostname) {
        this(hostname, null, null);
    }

    public SmbPath(String hostname, String shareName) {
        this(hostname, shareName, null);
    }

    public SmbPath(String hostname, String shareName, String path) {
        this.shareName = shareName;
        this.hostname = hostname;
        this.path = path;
    }

    public SmbPath(SmbPath parent, String path) {
        this.hostname = parent.hostname;
        if (parent.shareName == null) {
            throw new IllegalArgumentException("Can only make child SmbPath of fully specified SmbPath");
        }
        this.shareName = parent.shareName;
        this.path = parent.path != null ? parent.path + "\\" + path : path;
    }

    public String toUncPath() {
        StringBuilder b = new StringBuilder("\\\\");
        b.append(this.hostname);
        if (this.shareName != null) {
            if (this.shareName.charAt(0) != '\\') {
                b.append("\\");
            }
            b.append(this.shareName);
            if (this.path != null) {
                b.append("\\").append(this.path);
            }
        }
        return b.toString();
    }

    public String toString() {
        return this.toUncPath();
    }

    public static SmbPath parse(String path) {
        String[] split;
        String splitPath = path;
        if (path.charAt(0) == '\\') {
            splitPath = path.charAt(1) == '\\' ? path.substring(2) : path.substring(1);
        }
        if ((split = splitPath.split("\\\\", 3)).length == 1) {
            return new SmbPath(split[0]);
        }
        if (split.length == 2) {
            return new SmbPath(split[0], split[1]);
        }
        return new SmbPath(split[0], split[1], split[2]);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getPath() {
        return this.path;
    }
}

