/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.xebialabs.deployit.XlpJcrRepositoryConfig;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryConfigurationFactoryBean;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryInitializer;
import com.xebialabs.deployit.security.JackrabbitUserService;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import com.xebialabs.deployit.service.gc.JackrabbitGarbageCollectionService;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlrelease.actors.cluster.RepositorySyncer;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.spring.config.SharedJcrConfiguration;
import java.io.IOException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ExtendedRepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Profile(value={"jackrabbit"})
@Configuration
public class JackrabbitConfiguration
implements SharedJcrConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitConfiguration.class);
    @Autowired
    private XlrConfig xlrConfig;

    @Override
    @Bean
    public XlpJcrRepositoryConfig xlRepositoryConfig() {
        return new XlpJcrRepositoryConfig("xl-release", this.xlrConfig.repository().config());
    }

    @Bean
    public RepositoryConfig repositoryConfig() throws IOException, RepositoryException {
        try {
            return new JackrabbitRepositoryConfigurationFactoryBean((XlRepositoryConfig)this.xlRepositoryConfig(), false).getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create Jackrabbit repository config.", e);
        }
    }

    @Bean
    public JackrabbitRepositoryInitializer jcrRepositoryInitializer() {
        return new JackrabbitRepositoryInitializer((XlRepositoryConfig)this.xlRepositoryConfig());
    }

    @Override
    @Bean(name={"jcrRepository"})
    public Repository jcrRepository() {
        logger.info("Starting JCR repository");
        try {
            RepositoryConfig repositoryConfig = this.repositoryConfig();
            ExtendedRepositoryImpl extendedRepository = ExtendedRepositoryImpl.create((RepositoryConfig)repositoryConfig);
            logger.info("Started JCR repository");
            JackrabbitRepositoryInitializer repositoryInitializer = this.jcrRepositoryInitializer();
            repositoryInitializer.init((Repository)extendedRepository);
            return extendedRepository;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize Jackrabbit repository", e);
        }
    }

    @Override
    @Bean
    public RepositorySyncer repositorySyncer() {
        ExtendedRepositoryImpl repo = (ExtendedRepositoryImpl)this.jcrRepository();
        return () -> ((ExtendedRepositoryImpl)repo).sync();
    }

    @Override
    @Bean
    public UserService userService() {
        return new JackrabbitUserService(this.jcrTemplate());
    }

    @Override
    @Bean
    public GarbageCollectionService garbageCollectionService() {
        return new JackrabbitGarbageCollectionService(this.jcrRepository());
    }
}

