/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.ReleaseTriggers;
import com.xebialabs.xlrelease.repository.Releases;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseTriggerService {
    private ReleaseTriggers releaseTriggers;
    private Releases releases;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private static final Logger logger = LoggerFactory.getLogger(ReleaseTriggerService.class);

    @Autowired
    public ReleaseTriggerService(ReleaseTriggers releaseTriggers, Releases releases, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus) {
        this.releaseTriggers = releaseTriggers;
        this.releases = releases;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
    }

    public ReleaseTrigger findById(String triggerId) {
        return this.releaseTriggers.find(triggerId);
    }

    public ReleaseTrigger addTrigger(String templateId, ReleaseTrigger releaseTrigger) {
        ReleaseTrigger addedTrigger = this.releaseTriggers.create(templateId, releaseTrigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        return addedTrigger;
    }

    public void update(ReleaseTrigger releaseTrigger) {
        String triggerId = releaseTrigger.getId();
        ReleaseTrigger original = this.releaseTriggers.find(triggerId);
        this.releaseTriggers.update(releaseTrigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, releaseTrigger));
    }

    public void deleteTrigger(String triggerId) {
        ReleaseTrigger releaseTrigger = this.releaseTriggers.find(triggerId);
        this.releaseTriggers.delete(triggerId);
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(releaseTrigger));
    }

    public void updateExecutionId(ReleaseTrigger releaseTrigger) {
        this.releaseTriggers.update(releaseTrigger);
    }

    public void releaseExecuted(String originTemplateId) {
        Release template;
        try {
            template = this.releases.findById(originTemplateId);
        }
        catch (NotFoundException e) {
            logger.info("Can't find origin template: '{}' when completing triggered release : {}", (Object)originTemplateId, (Object)e.getMessage());
            return;
        }
        Release original = CiCloneHelper.cloneCi(template);
        template.decrementRunningTriggeredReleasesCount();
        this.releases.updateReleaseProperties(original, template);
        if (!template.isAllowConcurrentReleasesFromTrigger()) {
            this.releaseActorService.scheduleReleaseTriggers(template.getId());
        }
    }
}

