/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.domain.StartWelcomeReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.userdata.UserData;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserProfilesService {
    public static final List<String> ACCEPTED_DATE_FORMATS = Arrays.asList("M/d/yy", "dd/MM/yy", "yy/MM/dd");
    public static final List<String> ACCEPTED_TIME_FORMATS = Arrays.asList("HH:mm", "h:mm a");
    public static final List<Integer> ACCEPTED_FIRST_DAY_OF_WEEK_FORMATS = Arrays.asList(-1, 0, 1);
    private UserDataProvider userDataProvider;
    private UserProfiles userProfiles;
    private LicenseService licenseService;
    private SessionService sessionService;
    private XLReleaseEventBus eventBus;
    private LoadingCache<String, Optional<UserProfile>> userProfilesCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Optional<UserProfile>>(){

        public Optional<UserProfile> load(String canonicalId) throws Exception {
            List<UserProfile> profiles = UserProfilesService.this.userProfiles.findByCanonicalId(canonicalId);
            if (profiles.size() > 0) {
                return Optional.of((Object)((Object)profiles.get(0)));
            }
            return Optional.absent();
        }
    });

    @Autowired
    public UserProfilesService(UserDataProvider userDataProvider, UserProfiles userProfiles, LicenseService licenseService, SessionService sessionService, XLReleaseEventBus eventBus) {
        this.userDataProvider = userDataProvider;
        this.userProfiles = userProfiles;
        this.licenseService = licenseService;
        this.sessionService = sessionService;
        this.eventBus = eventBus;
    }

    public UserProfile findByUsername(String username) {
        try {
            return (UserProfile)((Object)((Optional)this.userProfilesCache.get((Object)this.toCanonicalId(username))).orNull());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<UserProfile> findAll() {
        return this.userProfiles.findAll();
    }

    public List<UserProfile> searchUserProfiles(String email, String fullName, Boolean loginAllowed, Long page, Long resultsPerPage) {
        return this.userProfiles.search(email, fullName, loginAllowed, page, resultsPerPage);
    }

    public boolean exists(String username) {
        return this.findByUsername(username) != null;
    }

    public void ensureCreated(String username) {
        this.getOrCreate(username, true);
    }

    public UserProfile discover(String username) {
        return this.getOrCreate(username, false);
    }

    private UserProfile getOrCreate(String username, boolean createIfNotFound) {
        if (this.exists(username)) {
            return this.findByUsername(username);
        }
        UserData userData = this.userDataProvider.getUserData(username);
        if (userData.isFound() || createIfNotFound) {
            UserProfile profile = new UserProfile(UserProfiles.buildId(username), userData.getEmail(), userData.getFullName(), true);
            this.save(profile);
            return profile;
        }
        return null;
    }

    public void save(UserProfile profile) {
        this.validate(profile);
        this.revokeLoginAllowedAccordingTo(profile, this.licenseService.getLicense());
        this.userProfiles.createOrUpdate(profile);
        this.userProfilesCache.invalidate((Object)profile.getCanonicalId());
        this.eventBus.publish(new StartWelcomeReleaseEvent(profile.getName()));
    }

    public void update(UserProfile profile) {
        this.validate(profile);
        this.revokeLoginAllowedAccordingTo(profile, this.licenseService.getLicense());
        this.userProfiles.createOrUpdate(profile);
        this.userProfilesCache.invalidate((Object)profile.getCanonicalId());
        if (!profile.isLoginAllowed()) {
            this.sessionService.disconnect(profile.getName());
        }
    }

    public void update(UserProfile ... profiles) {
        for (UserProfile userProfile : profiles) {
            this.validate(userProfile);
            this.revokeLoginAllowedAccordingTo(userProfile, this.licenseService.getLicense());
        }
        this.userProfiles.update(profiles);
        for (UserProfile userProfile : profiles) {
            this.userProfilesCache.invalidate((Object)userProfile.getCanonicalId());
            if (userProfile.isLoginAllowed()) continue;
            this.sessionService.disconnect(userProfile.getName());
        }
    }

    public void validate(UserProfile profile) {
        Checks.checkArgument((Strings.isBlank((String)profile.getDateFormat()) || ACCEPTED_DATE_FORMATS.contains(profile.getDateFormat()) ? 1 : 0) != 0, (String)"Date format '%s' is not supported", (Object[])new Object[]{profile.getDateFormat()});
        Checks.checkArgument((Strings.isBlank((String)profile.getTimeFormat()) || ACCEPTED_TIME_FORMATS.contains(profile.getTimeFormat()) ? 1 : 0) != 0, (String)"Time format '%s' is not supported", (Object[])new Object[]{profile.getTimeFormat()});
        Checks.checkArgument((profile.getFirstDayOfWeek() == null || ACCEPTED_FIRST_DAY_OF_WEEK_FORMATS.contains(profile.getFirstDayOfWeek()) ? 1 : 0) != 0, (String)"Week start value '%s' is not supported", (Object[])new Object[]{profile.getFirstDayOfWeek()});
    }

    @VisibleForTesting
    void revokeLoginAllowedAccordingTo(UserProfile profile, License license) {
        if (!profile.isLoginAllowed()) {
            return;
        }
        String maxNumberOfUsers = license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        if (maxNumberOfUsers != null && Integer.parseInt(maxNumberOfUsers) <= this.userProfiles.countUserWithLoginAllowed()) {
            profile.setLoginAllowed(false);
        }
    }

    public void delete(String username) {
        String id = UserProfiles.buildId(username);
        this.userProfiles.delete(id);
        this.userProfilesCache.invalidate((Object)this.toCanonicalId(username));
    }

    public void clearCache() {
        this.userProfilesCache.invalidateAll();
    }

    private String toCanonicalId(String username) {
        return username.toLowerCase();
    }
}

