/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.repository.Attachments;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadService.class);
    private Attachments attachments;

    @Autowired
    public UploadService(Attachments attachments) {
        this.attachments = attachments;
    }

    public List<Attachment> addAttachment(String ciId, FileItemIterator fileItems) throws IOException, FileUploadException {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            String filename = item.getName();
            String contentType = item.getContentType();
            InputStream stream = item.openStream();
            Throwable throwable = null;
            try {
                logger.debug("Attaching {} to {}", (Object)filename, (Object)ciId);
                attachmentList.add(this.attachments.attach(ciId, filename, contentType, stream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return attachmentList;
    }

    public Attachment addAttachment(String ciId, String fileName, byte[] fileByteArray) throws IOException {
        logger.debug("Attaching {} to {}", (Object)fileName, (Object)ciId);
        return this.attachments.attach(ciId, fileName, MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName), new ByteArrayInputStream(fileByteArray));
    }
}

