/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.events.ReleaseBulkAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseBulkStartedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations;
import com.xebialabs.xlrelease.repository.Attachments;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.TaskBackup;
import com.xebialabs.xlrelease.repository.TaskUpdateCommand;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.service.ChangesUpdatesConverter;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.ExecutePreconditionAction;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.service.PostStartActionVisitor;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutionService
implements PostStartActionVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionService.class);
    private Comments comments;
    private Releases releases;
    private Attachments attachments;
    private XlrRepository xlrRepository;
    private Tasks tasks;
    private DependencyService dependencyService;
    private ScriptLifeCycle scriptLifeCycle;
    private TaskBackup taskBackup;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private Map<String, ScriptService> scriptServices = new HashMap<String, ScriptService>();
    private Map<Class<? extends Task>, TaskExecutor<? extends Task>> taskExecutorsPerType = new HashMap<Class<? extends Task>, TaskExecutor<? extends Task>>();
    private InternalMetadataDecoratorService decoratorService;

    @Autowired
    public ExecutionService(Comments comments, Releases releases, Attachments attachments, XlrRepository xlrRepository, Tasks tasks, DependencyService dependencyService, ScriptLifeCycle scriptLifeCycle, TaskBackup taskBackup, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, List<? extends TaskExecutor<? extends Task>> taskExecutors, Collection<? extends ScriptService> scriptServices, InternalMetadataDecoratorService decoratorService) {
        this.comments = comments;
        this.releases = releases;
        this.attachments = attachments;
        this.xlrRepository = xlrRepository;
        this.tasks = tasks;
        this.dependencyService = dependencyService;
        this.scriptLifeCycle = scriptLifeCycle;
        this.taskBackup = taskBackup;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.decoratorService = decoratorService;
        this.setTaskExecutors(taskExecutors);
        scriptServices.forEach(scriptService -> this.scriptServices.put(scriptService.engine(), (ScriptService)scriptService));
    }

    private void setTaskExecutors(List<? extends TaskExecutor<? extends Task>> taskExecutors) {
        taskExecutors.forEach(executor -> {
            Class taskType = executor.getTaskClass();
            if (this.taskExecutorsPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two executors are registered for the same task type %s: %s and %s", taskType, this.taskExecutorsPerType.get(taskType), executor));
            }
            this.taskExecutorsPerType.put(taskType, (TaskExecutor<? extends Task>)executor);
        });
    }

    public Release start(Release release, User user) {
        this.decorateWithMetadata(release);
        Changes changes = release.start();
        this.processChangesAndPublishOperations(changes, user);
        return release;
    }

    public List<String> startReleases(List<String> releaseIds, User user) {
        ArrayList<Release> startedReleases = new ArrayList<Release>();
        ArrayList<Changes> changesList = new ArrayList<Changes>();
        for (String releaseId : releaseIds) {
            try {
                Release release = this.releases.findById(releaseId);
                this.decorateWithMetadata(release);
                Changes changes2 = release.startAsPartOfBulkOperation();
                this.publishBeforeEvents(changes2);
                this.processChanges(changes2, user);
                changesList.add(changes2);
                startedReleases.add(release);
            }
            catch (Exception ignored) {
                logger.error(String.format("Unable to start release with id: %s", releaseId), (Throwable)ignored);
            }
        }
        if (!startedReleases.isEmpty()) {
            this.eventBus.publish((XLReleaseEvent)new ReleaseBulkStartedEvent(startedReleases));
        }
        changesList.forEach(changes -> {
            this.publishAfterEvents((Changes)changes);
            this.completeDependentGates((Changes)changes);
        });
        return startedReleases.stream().map(BaseConfigurationItem::getId).collect(Collectors.toList());
    }

    public Release abort(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Preconditions.checkState((boolean)release.hasNoAutomatedTaskRunning(), (String)"The release %s could not be aborted because it has automated tasks that are in progress.", (Object[])new Object[]{release.getTitle()});
        Changes changes = release.abort();
        this.publishBeforeEvents(changes);
        this.updateCommentAndAttach(changes, User.AUTHENTICATED_USER);
        this.publishAfterEvents(changes);
        this.failDependentGates(changes, release.getTitle());
        return release;
    }

    public List<String> abortReleases(List<String> releaseIds) {
        ArrayList<Tuple> releaseChangesPair = new ArrayList<Tuple>();
        for (String releaseId : releaseIds) {
            try {
                Release release = this.releases.findById(releaseId);
                Preconditions.checkState((boolean)release.hasNoAutomatedTaskRunning(), (String)"The release %s could not be aborted because it has automated tasks that are in progress.", (Object[])new Object[]{release.getTitle()});
                Changes changes = release.abortAsPartOfBulkOperation();
                this.publishBeforeEvents(changes);
                this.updateCommentAndAttach(changes, User.AUTHENTICATED_USER);
                releaseChangesPair.add(Tuple.of((Object)release, (Object)changes));
            }
            catch (Exception ignored) {
                logger.error(String.format("Unable to abort release with id: %s", releaseId), (Throwable)ignored);
            }
        }
        List abortedReleases = releaseChangesPair.stream().map(Tuple::getA).collect(Collectors.toList());
        if (!abortedReleases.isEmpty()) {
            this.eventBus.publish((XLReleaseEvent)new ReleaseBulkAbortedEvent(abortedReleases));
        }
        releaseChangesPair.forEach(pair -> {
            this.publishAfterEvents((Changes)pair.getB());
            this.failDependentGates((Changes)pair.getB(), ((Release)pair.getA()).getTitle());
        });
        return abortedReleases.stream().map(BaseConfigurationItem::getId).collect(Collectors.toList());
    }

    public Release resume(String releaseId) {
        Release release = this.releases.findById(releaseId, false);
        Preconditions.checkState((boolean)release.isPaused(), (String)"Only paused releases may be restarted. Release '%s' is %s.", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        this.decorateWithMetadata(release);
        Changes changes = release.resume();
        this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
        return release;
    }

    public void startPendingTask(String taskId, Release release, String comment, User user) {
        boolean shouldConsiderBlackoutPeriods = User.SYSTEM.equals((Object)user);
        if (shouldConsiderBlackoutPeriods) {
            this.decorateWithMetadata(release);
        }
        Changes changes = release.startPendingTask(taskId);
        changes.addComment(release.getTask(taskId), comment);
        this.processChangesAndPublishOperations(changes, user);
    }

    @VisibleForTesting
    void executePostStartActions(Changes changes) {
        changes.getPostStartActions().forEach(action -> action.accept((PostStartActionVisitor)this));
    }

    private void publishBeforeEvents(Changes changes) {
        XLReleaseOperations.runActionInterceptors(changes.getOperations(), this.eventBus);
    }

    private void publishAfterEvents(Changes changes) {
        XLReleaseOperations.publishEvents(changes.getOperations(), this.eventBus);
    }

    public void markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, User user) {
        this.decorateWithMetadata(release);
        Task task = release.getTask(taskId);
        Changes changes = new Changes();
        if (User.LOG_OUTPUT.equals((Object)user)) {
            this.attachScriptOutput(changes, task, addedComment);
        } else {
            changes.addComment(task, addedComment);
        }
        if (targetStatus.isDoneInAdvance()) {
            changes.addAll(task.markAsDone(taskId, targetStatus));
        } else {
            changes.addAll(release.markTaskAsDone(taskId, targetStatus));
        }
        this.processChangesAndPublishOperations(changes, user);
    }

    public void scriptFailed(String taskId, String scriptFailMessage, String scriptExecutionId) {
        Object task = this.tasks.findById(taskId);
        if (task.isStillExecutingScript(scriptExecutionId)) {
            this.fail((Task)task, FailureReasons.SCRIPT_TASK_FAILED.format(new Object[]{scriptFailMessage}), User.LOG_OUTPUT, task.getRelease());
        } else {
            logger.debug("Will not fail task: '{}', it has been aborted.", (Object)task.getId());
        }
    }

    public void fail(String taskId, String addedComment, User user, Release release) {
        this.fail(release.getTask(taskId), addedComment, user, release);
    }

    public void fail(Task task, String addedComment, User user, Release release) {
        Changes changes = new Changes();
        if (User.LOG_OUTPUT.equals((Object)user)) {
            changes.addAll(release.failTask(task.getId(), ""));
            this.attachScriptOutput(changes, task, addedComment);
        } else {
            changes.addAll(release.failTask(task.getId(), addedComment));
        }
        this.publishBeforeEvents(changes);
        this.updateCommentAndAttach(changes, user);
        this.publishAfterEvents(changes);
        if (release.isAbortOnFailure() && release.isAborted()) {
            this.failDependentGates(changes, release.getTitle());
        }
    }

    public void retry(Task task, String addedComment) {
        Release release = task.getRelease();
        this.decorateWithMetadata(release);
        Changes changes = release.retryTask(task.getId());
        changes.addComment(task, addedComment);
        this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
    }

    Task startWithInput(String taskId, List<Variable> variables) {
        Object task = this.tasks.findById(taskId);
        Task updated = this.updateVariables(variables, (Task)task);
        Release release = updated.getRelease();
        this.decorateWithMetadata(release);
        this.processChangesAndPublishOperations(updated.startWithInput(), User.AUTHENTICATED_USER);
        return task;
    }

    private Task updateVariables(List<Variable> variables, Task task) {
        Task original = CiCloneHelper.cloneCi(task);
        Map inputVariablesByKey = VariableHelper.indexByKey(variables);
        task.getInputVariables().stream().filter(variable -> inputVariablesByKey.containsKey(variable.getKey())).forEach(variable -> variable.setUntypedValue(((Variable)inputVariablesByKey.get(variable.getKey())).getValue()));
        return this.xlrRepository.handle(new TaskUpdateCommand(original, task, task.getInputVariables(), Collections.emptyList(), null, Collections.emptyList()));
    }

    public void abortTask(Task task, String addedComment) {
        this.fail(task.getId(), FailureReasons.SCRIPT_TASK_ABORTED.format(new Object[]{addedComment}), User.AUTHENTICATED_USER, task.getRelease());
        this.scriptLifeCycle.tryAborting(task.getExecutionId());
    }

    public void reopenTask(Task task, String addedComment) {
        Changes changes = task.reopen();
        changes.addComment(task, addedComment);
        this.publishBeforeEvents(changes);
        this.updateCommentAndAttach(changes, User.AUTHENTICATED_USER);
        this.publishAfterEvents(changes);
    }

    private void completeDependentGates(Changes changes) {
        Collection<String> completableGateIds = this.dependencyService.getCompletableGateIds(this.toPlanItems(changes.getUpdatedItems()));
        for (String gateId : completableGateIds) {
            this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, gateId, null, User.SYSTEM);
        }
    }

    private void failDependentGates(Changes changes, String releaseTitle) {
        Collection<String> failableGateIds = this.dependencyService.getFailableGateIds(this.toPlanItems(changes.getUpdatedItems()));
        for (String gateId : failableGateIds) {
            this.releaseActorService.failTaskAsync(gateId, FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(new Object[]{releaseTitle}), User.SYSTEM);
        }
    }

    private void attachScriptOutput(Changes changes, Task task, String scriptOutput) {
        changes.addAttachment(task, scriptOutput.getBytes(Charsets.UTF_8), new SimpleDateFormat("'script_output_'yyyyMMddHHmmss'.log'").format(new Date()), "text/plain");
    }

    private Set<PlanItem> toPlanItems(Set<ConfigurationItem> updatedItems) {
        return updatedItems.stream().filter(PlanItem.class::isInstance).map(PlanItem.class::cast).collect(Collectors.toSet());
    }

    private void updateCommentAndAttach(Changes changes, User user) {
        this.xlrRepository.handle(ChangesUpdatesConverter.toCommands(changes));
        for (Map.Entry entry : changes.getCommentsByTask().entries()) {
            String addedComment = (String)entry.getValue();
            this.comments.create((Task)entry.getKey(), addedComment, user, false);
        }
        for (Map.Entry entry : changes.getAttachmentsByTask().entries()) {
            Attachment attachment = (Attachment)entry.getValue();
            Task task = (Task)entry.getKey();
            this.attachments.attach(task.getRelease(), task, attachment.getFile().getName(), attachment.getContentType(), attachment.getFile().getInputStream());
        }
    }

    public void resumeTask(String taskId) {
        this.executeTask((Task)this.tasks.findById(taskId));
    }

    public void executeTask(Task task) {
        TaskExecutor<? extends Task> taskExecutor = this.taskExecutorsPerType.get(task.getClass());
        Preconditions.checkArgument((taskExecutor != null ? 1 : 0) != 0, (String)"Cannot execute task because there is no executor defined for task type '%s'", (Object[])new Object[]{task.getType().toString()});
        taskExecutor.execute((Task)task);
    }

    public void executePrecondition(Task task) {
        this.scriptServices.get("jython").executePrecondition(task, this.getPreconditionValidCallback(task), this.getPreconditionInvalidCallback(task), this.getPreconditionExceptionCallback(task));
    }

    private ScriptCallback getPreconditionValidCallback(final Task task) {
        return new ScriptCallback(){

            @Override
            public void run() {
                ExecutionService.this.releaseActorService.taskPreconditionValidated(task.getId());
            }
        };
    }

    private ScriptCallback getPreconditionInvalidCallback(final Task task) {
        return new ScriptCallback(){

            @Override
            public void run() {
                ExecutionService.this.releaseActorService.markTaskAsDone(TaskStatus.SKIPPED, task.getId(), this.getExecutionLog(), User.LOG_OUTPUT);
            }
        };
    }

    private ScriptCallback getPreconditionExceptionCallback(final Task task) {
        return new ScriptCallback(){

            @Override
            public void run() {
                ExecutionService.this.releaseActorService.failScriptTask(task.getId(), this.getExecutionLog(), task.getExecutionId());
            }
        };
    }

    public void taskPreconditionValidated(String taskId, Release release) {
        this.decorateWithMetadata(release);
        Changes changes = release.taskPreconditionValidated(taskId);
        this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
    }

    private void processChangesAndPublishOperations(Changes changes, User user) {
        this.publishBeforeEvents(changes);
        this.processChanges(changes, user);
        this.publishAfterEvents(changes);
        this.completeDependentGates(changes);
    }

    private void processChanges(Changes changes, User user) {
        this.taskBackup.backupTasks(changes.getTasksToBackup());
        this.updateCommentAndAttach(changes, user);
        this.executePostStartActions(changes);
    }

    private void decorateWithMetadata(Release release) {
        this.decoratorService.decorate((ConfigurationItem)release, Collections.singletonList(BlackoutMetadata.BLACKOUT()));
    }

    public void visit(ExecuteTaskAction action) {
        this.executeTask(action.task());
    }

    public void visit(ExecutePreconditionAction action) {
        this.executePrecondition(action.task());
    }
}

