/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plumbing.repository.IgnoringMissingCIRepository;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.db.AttachmentInfo;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\t=s!B\u0001\u0003\u0011\u0003Y\u0011\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012A\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\f%o\u00195jm\u0016$'+\u001a7fCN,Gc\u0001\u000f#_A\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004B\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0005r\"a\u0002*fY\u0016\f7/\u001a\u0005\u0006Ge\u0001\r\u0001J\u0001\fe\u0016dW-Y:f\u0015N|g\u000e\u0005\u0002&Y9\u0011aE\u000b\t\u0003OIi\u0011\u0001\u000b\u0006\u0003S)\ta\u0001\u0010:p_Rt\u0014BA\u0016\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u0012\u0002\"\u0002\u0019\u001a\u0001\u0004\t\u0014A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011!\u0007O\u0007\u0002g)\u0011\u0001\u0007\u000e\u0006\u0003kY\n\u0001\u0002\u001d7v[\nLgn\u001a\u0006\u0003o\u0019\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003sM\u00121$S4o_JLgnZ'jgNLgnZ\"J%\u0016\u0004xn]5u_JLh\u0001\u0002\b\u0003\u0001m\u001a2A\u000f\t=!\ti$)D\u0001?\u0015\ty\u0004)A\u0003tY\u001a$$NC\u0001B\u0003!9'/\u001b>{Y\u0016$\u0017BA\"?\u0005\u001daunZ4j]\u001eD\u0001\"\u0012\u001e\u0003\u0002\u0003\u0006IAR\u0001\u0011CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0003\u0002\u0005\u0011\u0014\u0017BA&I\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7\u000f\u0003\u0005Nu\t\u0005\t\u0015!\u0003O\u0003Y\t'o\u00195jm\u0016$'+\u001a7fCN,7oU3be\u000eD\u0007CA$P\u0013\t\u0001\u0006J\u0001\fBe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i\u0011!\u0011&H!A!\u0002\u0013\u0019\u0016AH1sG\"Lg/\u001a3BGRLg/\u001b;z\u0019><7oU3sS\u0006d\u0017N_3s!\taA+\u0003\u0002V\u0005\tq\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM\u001d\u0005\tai\u0012\t\u0011)A\u0005c!A\u0001L\u000fB\u0001B\u0003%\u0011,\u0001\u0010d_6\u0004H.\u001a;fIJ+G.Z1tKN,\u0005\u0010]8siN+'O^5dKB\u0011ABW\u0005\u00037\n\u0011QdQ8na2,G/\u001a3SK2,\u0017m]3FqB|'\u000f^*feZL7-\u001a\u0005\u0006/i\"\t!\u0018\u000b\u0007=~\u0003\u0017MY2\u0011\u00051Q\u0004\"B#]\u0001\u00041\u0005\"B']\u0001\u0004q\u0005\"\u0002*]\u0001\u0004\u0019\u0006\"\u0002\u0019]\u0001\u0004\t\u0004\"\u0002-]\u0001\u0004I\u0006F\u0001/f!\t1\u0017/D\u0001h\u0015\tA\u0017.\u0001\u0006b]:|G/\u0019;j_:T!A[6\u0002\u000f\u0019\f7\r^8ss*\u0011A.\\\u0001\u0006E\u0016\fgn\u001d\u0006\u0003]>\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002a\u0006\u0019qN]4\n\u0005I<'!C!vi><\u0018N]3e\u0011\u0015!(\b\"\u0001v\u00039\t'o\u00195jm\u0016\u0014V\r\\3bg\u0016$2A^=|!\t\tr/\u0003\u0002y%\t!QK\\5u\u0011\u0015Q8\u000f1\u0001\u001d\u0003\u001d\u0011X\r\\3bg\u0016DQ\u0001`:A\u0002u\f!C]3mK\u0006\u001cX-\u0011;uC\u000eDW.\u001a8ugB)a0a\u0002\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B;uS2T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(\u0001\u0002'jgR\u00042!HA\u0007\u0013\r\tyA\b\u0002\u000b\u0003R$\u0018m\u00195nK:$\bbBA\nu\u0011\u0005\u0011QC\u0001\u000bO\u0016$(+\u001a7fCN,Gc\u0001\u000f\u0002\u0018!9\u0011\u0011DA\t\u0001\u0004!\u0013!\u0003:fY\u0016\f7/Z%e\u0011\u001d\tiB\u000fC\u0001\u0003?\tqbZ3u%\u0016dW-Y:f)&$H.\u001a\u000b\u0004I\u0005\u0005\u0002bBA\r\u00037\u0001\r\u0001\n\u0005\b\u0003KQD\u0011AA\u0014\u0003!9W\r\u001e)iCN,G\u0003BA\u0015\u0003_\u00012!HA\u0016\u0013\r\tiC\b\u0002\u0006!\"\f7/\u001a\u0005\b\u0003c\t\u0019\u00031\u0001%\u0003\u001d\u0001\b.Y:f\u0013\u0012Dq!!\u000e;\t\u0003\t9$A\u0004hKR$\u0016m]6\u0015\t\u0005e\u0012q\b\t\u0004;\u0005m\u0012bAA\u001f=\t!A+Y:l\u0011\u001d\t\t%a\rA\u0002\u0011\na\u0001^1tW&#\u0007bBA#u\u0011\u0005\u0011qI\u0001\fO\u0016$h+\u0019:jC\ndW\r\u0006\u0003\u0002J\u0005U\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=c$A\u0005wCJL\u0017M\u00197fg&!\u00111KA'\u0005!1\u0016M]5bE2,\u0007bBA,\u0003\u0007\u0002\r\u0001J\u0001\u000bm\u0006\u0014\u0018.\u00192mK&#\u0007bBA.u\u0011\u0005\u0011QL\u0001\u0007KbL7\u000f^:\u0015\t\u0005}\u0013Q\r\t\u0004#\u0005\u0005\u0014bAA2%\t9!i\\8mK\u0006t\u0007bBA4\u00033\u0002\r\u0001J\u0001\u0005G&LE\rC\u0004\u0002li\"\t!!\u001c\u0002\u0019\u0015D\u0018n\u001d;t\u0005ft\u0015-\\3\u0015\t\u0005}\u0013q\u000e\u0005\b\u0003c\nI\u00071\u0001%\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3\t\u000f\u0005U$\b\"\u0001\u0002x\u0005\u00012\r[3dW:{G/\u0011:dQ&4X\r\u001a\u000b\u0004m\u0006e\u0004bBA4\u0003g\u0002\r\u0001\n\u0005\b\u0003{RD\u0011AA@\u0003A\tG\u000f^1dQ6,g\u000e^#ySN$8\u000f\u0006\u0003\u0002`\u0005\u0005\u0005bBAB\u0003w\u0002\r\u0001J\u0001\rCR$\u0018m\u00195nK:$\u0018\n\u001a\u0005\b\u0003\u000fSD\u0011AAE\u000359W\r^!ui\u0006\u001c\u0007.\\3oiR!\u00111BAF\u0011\u001d\t\u0019)!\"A\u0002\u0011Bq!a$;\t\u0003\t\t*A\nhKR\fE\u000f^1dQ6,g\u000e^(qi&|g\u000e\u0006\u0003\u0002\u0014\u0006e\u0005#B\t\u0002\u0016\u0006-\u0011bAAL%\t1q\n\u001d;j_:Dq!a!\u0002\u000e\u0002\u0007A\u0005C\u0004\u0002\u001ej\"\t!a(\u0002\u001dM,\u0017M]2i%\u0016dW-Y:fgR!\u0011\u0011UAR!\u0011q\u0018q\u0001\u000f\t\u0011\u0005\u0015\u00161\u0014a\u0001\u0003O\u000bqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0002*\u0006=VBAAV\u0015\r\ti\u000bB\u0001\u0006m&,wo]\u0005\u0005\u0003c\u000bYKA\bSK2,\u0017m]3t\r&dG/\u001a:t\u0011\u001d\tiJ\u000fC\u0001\u0003k#\u0002\"!)\u00028\u0006e\u00161\u0019\u0005\t\u0003K\u000b\u0019\f1\u0001\u0002(\"A\u00111XAZ\u0001\u0004\ti,A\u0003mS6LG\u000fE\u0002\u0012\u0003\u007fK1!!1\u0013\u0005\u0011auN\\4\t\u0011\u0005\u0015\u00171\u0017a\u0001\u0003{\u000baa\u001c4gg\u0016$\bbBAOu\u0011%\u0011\u0011\u001a\u000b\t\u0003C\u000bY-!4\u0002R\"A\u0011QUAd\u0001\u0004\t9\u000b\u0003\u0005\u0002<\u0006\u001d\u0007\u0019AAh!\u0015\t\u0012QSA_\u0011!\t)-a2A\u0002\u0005=\u0007bBAku\u0011%\u0011q[\u0001\u0011O\u0016$(+\u001a7fCN,w\n\u001d;j_:$B!!7\u0002\\B!\u0011#!&\u001d\u0011\u001d\tI\"a5A\u0002\u0011Bq!a8;\t\u0013\t\t/\u0001\bhKR\u0004\u0006.Y:f\u001fB$\u0018n\u001c8\u0015\t\u0005\r\u0018Q\u001d\t\u0006#\u0005U\u0015\u0011\u0006\u0005\b\u0003c\ti\u000e1\u0001%\u0011\u001d\tIO\u000fC\u0005\u0003W\fQbZ3u)\u0006\u001c8n\u00149uS>tG\u0003BAw\u0003_\u0004R!EAK\u0003sAq!!\u0011\u0002h\u0002\u0007A\u0005C\u0004\u0002tj\"I!!>\u0002#\u001d,GOV1sS\u0006\u0014G.Z(qi&|g\u000e\u0006\u0003\u0002x\u0006e\b#B\t\u0002\u0016\u0006%\u0003bBA,\u0003c\u0004\r\u0001\n\u0015\u0014u\u0005u(1\u0002B\u0007\u0005#\u0011\u0019B!\b\u0003 \t%\"1\u0006\t\u0005\u0003\u007f\u00149!\u0004\u0002\u0003\u0002)\u0019\u0001Na\u0001\u000b\u0007\t\u0015Q.A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002B\u0005\u0005\u0003\u0011Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017!\u0002<bYV,\u0017E\u0001B\b\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t\u0011)\"\u0003\u0003\u0003\u0018\te\u0011\u0001\u0003*F#VK%+\u0012#\u000b\t\tm!\u0011A\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u0012!\u0011E\u0005\u0005\u0005G\u0011)#\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\t\u001d\"\u0011A\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u0012!QF\u0012\u0003\u0005_\u0001BA!\r\u0003<9!!1\u0007B\u001c\u001d\r9#QG\u0005\u0002'%\u0019!\u0011\b\n\u0002\u000fA\f7m[1hK&!!Q\bB \u0005%!\u0006N]8xC\ndWMC\u0002\u0003:IA3A\u000fB\"!\u0011\u0011)Ea\u0013\u000e\u0005\t\u001d#b\u0001B%[\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t5#q\t\u0002\b'\u0016\u0014h/[2f\u0001")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final IgnoringMissingCIRepository repository;
    private final CompletedReleaseExportService completedReleasesExportService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static Release deserializeArchivedRelease(String string, IgnoringMissingCIRepository ignoringMissingCIRepository) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, ignoringMissingCIRepository);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void archiveRelease(Release release, java.util.List<Attachment> releaseAttachments) {
        String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
        if (!release.isTutorial()) {
            String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
            this.archivedReleases.insert(release, serializedRelease, activityLogsJson);
            Buffer attachmentsInfo = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releaseAttachments).asScala()).map((Function1 & Serializable & scala.Serializable)attachment -> new AttachmentInfo(attachment.getId(), attachment.getFile().getName(), attachment.getFile().getInputStream()), Buffer$.MODULE$.canBuildFrom());
            this.archivedReleases.insertAttachments(release.getId(), (List<AttachmentInfo>)attachmentsInfo.toList());
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running release ", " through export hooks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
        this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
    }

    public Release getRelease(String releaseId) {
        return (Release)this.getReleaseOption(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases.getReleaseTitle(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    public Phase getPhase(String phaseId) {
        return (Phase)this.getPhaseOption(phaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)phaseId)})), new Object[0]);
        });
    }

    public Task getTask(String taskId) {
        return (Task)this.getTaskOption(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)taskId)})), new Object[0]);
        });
    }

    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)variableId)})), new Object[0]);
        });
    }

    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases.exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getPhaseOption(ciId).isDefined() : (Ids.isTaskId((String)ciId) ? this.getTaskOption(ciId).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    public boolean existsByName(String releaseName) {
        return this.archivedReleases.existsByName(releaseName);
    }

    public void checkNotArchived(String ciId) {
        if (this.archivedReleases.exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot perform this operation on archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)ciId)})), new Object[0]);
        }
    }

    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases.attachmentExists(attachmentId);
    }

    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived attachment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentId})), new Object[0]);
        });
    }

    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)release -> $this.archivedReleases.getAttachment(attachmentId).flatMap((Function1 & Serializable & scala.Serializable)overthereFile -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).map((Function1 & Serializable & scala.Serializable)attachment -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        filters.checkConsistency();
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repository), List$.MODULE$.canBuildFrom())).asJava();
    }

    private Option<Release> getReleaseOption(String releaseId) {
        return this.archivedReleases.getRelease(releaseId).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repository);
            Map<String, String> attachmentsFileNames = $this.archivedReleases.getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)attachment.getId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find attachment ", " of release ", " in the attachments table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), releaseId})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private Option<Phase> getPhaseOption(String phaseId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)phaseId)).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getPhase(phaseId)));
    }

    private Option<Task> getTaskOption(String taskId) {
        return this.getPhaseOption(Ids.phaseIdFrom((String)taskId)).flatMap((Function1 & Serializable & scala.Serializable)phase -> Option$.MODULE$.apply((Object)phase.getTask(taskId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId)).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$1))));
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$1) {
        String string = x$1.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, IgnoringMissingCIRepository repository, CompletedReleaseExportService completedReleasesExportService) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repository = repository;
        this.completedReleasesExportService = completedReleasesExportService;
        Logging.$init$((Logging)this);
    }
}

