/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Attachments;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.query.ArchivingReleasesStrategy;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.DependencyService;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rgaB\u0001\u0003!\u0003\r\ta\u0003\u0002\u0019\u0003J\u001c\u0007.\u001b<j]\u001e\u001c6\r[3ek2,7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oO\")1\u0004\u0001C\u00019\u00051A%\u001b8ji\u0012\"\u0012!\b\t\u0003\u001byI!a\b\b\u0003\tUs\u0017\u000e\u001e\u0005\bC\u0001\u0011\rQ\"\u0001#\u0003=\t'o\u00195jm&twmQ8oM&<W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011AB2p]\u001aLw-\u0003\u0002)K\tA\u0012I]2iSZLgnZ*fiRLgnZ:NC:\fw-\u001a:\t\u000f)\u0002!\u0019!D\u0001W\u0005\u0001\u0012M]2iSZLgnZ*feZL7-Z\u000b\u0002YA\u0011QFL\u0007\u0002\u0005%\u0011qF\u0001\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016Dq!\r\u0001C\u0002\u001b\u0005!'A\u0006biR\f7\r[7f]R\u001cX#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\"\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0001(\u000e\u0002\f\u0003R$\u0018m\u00195nK:$8\u000fC\u0004;\u0001\t\u0007i\u0011A\u001e\u0002#\u0011,\u0007/\u001a8eK:\u001c\u0017pU3sm&\u001cW-F\u0001=!\tiS(\u0003\u0002?\u0005\t\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\t\u000f\u0001\u0003!\u0019!D\u0001\u0003\u0006A!/\u001a7fCN,7/F\u0001C!\t!4)\u0003\u0002Ek\tA!+\u001a7fCN,7\u000fC\u0004G\u0001\t\u0007i\u0011A$\u0002\u0011M$(/\u0019;fOf,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017V\nQ!];fefL!!\u0014&\u00033\u0005\u00138\r[5wS:<'+\u001a7fCN,7o\u0015;sCR,w-\u001f\u0005\b\u001f\u0002\u0011\rQ\"\u0001Q\u0003\u0015!X-Y7t+\u0005\t\u0006C\u0001\u001bS\u0013\t\u0019VGA\u0003UK\u0006l7\u000fC\u0004V\u0001\t\u0007I\u0011\u0003,\u0002#%\u001c8)\u00198dK2\u0014V-];fgR,G-F\u0001X!\tA\u0016-D\u0001Z\u0015\tQ6,\u0001\u0004bi>l\u0017n\u0019\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ef\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007b\u00023\u0001\u0005\u0004%\t\"Z\u0001\u0016CJ\u001c\u0007.\u001b<f\u0013:\u0004&o\\4sKN\u001cHj\\2l+\u00051\u0007CA4k\u001b\u0005A'BA5`\u0003\u0011a\u0017M\\4\n\u0005-D'AB(cU\u0016\u001cG\u000fC\u0003n\u0001\u0019Ea.\u0001\u0010e_\u0006\u00138\r[5wK\u0016C\b/\u001b:fIJ+G.Z1tKN\f5\r^5p]R\u0011Qd\u001c\u0005\u0006a2\u0004\r!]\u0001\u0007C\u000e$\u0018n\u001c8\u0011\u00075\u0011X$\u0003\u0002t\u001d\tIa)\u001e8di&|g\u000e\r\u0005\u0006k\u0002!\tA^\u0001\u001cO\u0016$\u0018I]2iSZLgn\u001a&pE\u000e\u0013xN\\*dQ\u0016$W\u000f\\3\u0016\u0003]\u0004\"\u0001_@\u000f\u0005el\bC\u0001>\u000f\u001b\u0005Y(B\u0001?\u000b\u0003\u0019a$o\\8u}%\u0011aPD\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yt\u0001bBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u0017CJ\u001c\u0007.\u001b<f\u000bb\u0004\u0018N]3e%\u0016dW-Y:fgR\u0019Q$a\u0003\t\u0011\u00055\u0011Q\u0001a\u0001\u0003\u001f\t1C]3mK\u0006\u001cX-Q4f)>\f%o\u00195jm\u0016\u00042aZA\t\u0013\r\t\u0019\u0002\u001b\u0002\b\u0013:$XmZ3s\u0011\u0019\t9\u0001\u0001C\u00019!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011A\u00079pgR\u0004&o\\2fgN\f%o\u00195jm\u0016$'+\u001a7fCN,GcA\u000f\u0002\u001e!9\u0011qDA\f\u0001\u00049\u0018!\u0003:fY\u0016\f7/Z%e\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003K\t\u0001EZ5oI\u0006sG\r\u0015:pG\u0016\u001c8/\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:fgR!\u0011qEA\u001c)\u0011\tI#a\f\u0011\u00075\tY#C\u0002\u0002.9\u00111!\u00138u\u0011\u001d\u0001\u0018\u0011\u0005a\u0001\u0003c\u0001R!DA\u001aovI1!!\u000e\u000f\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0005\u0002:\u0005\u0005\u0002\u0019AA\u001e\u0003\u0011!\u0017\r^3\u0011\t\u0005u\u0012qH\u0007\u0002;&\u0019\u0011\u0011I/\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003=\u0001(o\\2fgN\u0014V\r\\3bg\u0016\u001cH\u0003CA%\u0003'\nI'a\u001d\u0015\t\u0005-\u0013\u0011\u000b\t\u0004\u001b\u00055\u0013bAA(\u001d\t9!i\\8mK\u0006t\u0007b\u00029\u0002D\u0001\u0007\u0011\u0011\u0007\u0005\t\u0003+\n\u0019\u00051\u0001\u0002X\u0005Q!/\u001a7fCN,\u0017\nZ:\u0011\u000b\u0005e\u00131M<\u000f\t\u0005m\u0013q\f\b\u0004u\u0006u\u0013\"A\b\n\u0007\u0005\u0005d\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\t\u0013R,'/\u00192mK*\u0019\u0011\u0011\r\b\t\u0011\u0005-\u00141\ta\u0001\u0003[\nQaY8v]R\u00042\u0001WA8\u0013\r\t\t(\u0017\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u0011\u0005U\u00141\ta\u0001\u0003o\n!C];o'R\f'\u000f\u001e+j[\u0016l\u0015\u000e\u001c7jgB\u0019Q\"!\u001f\n\u0007\u0005mdB\u0001\u0003M_:<\u0007bBA@\u0001\u0011%\u0011\u0011Q\u0001\u000faJ|7-Z:t%\u0016dW-Y:f)\ri\u00121\u0011\u0005\b\u0003?\ti\b1\u0001x\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013\u000bq#\u0019:dQ&4XmQ8na2,G/\u001a3SK2,\u0017m]3\u0015\t\u0005-\u0015Q\u0013\t\u0006\u0003\u001b\u000b\t*H\u0007\u0003\u0003\u001fS!A\u0018\b\n\t\u0005M\u0015q\u0012\u0002\u0004)JL\bbBA\u0010\u0003\u000b\u0003\ra\u001e\u0005\b\u00033\u0003A\u0011BAN\u0003E9W\r^*fCJ\u001c\u0007\u000eU1hKNK'0Z\u000b\u0003\u0003SAa!a(\u0001\t\u0013a\u0012!D:mK\u0016\u0004\u0018J\u001a(fK\u0012,G\rC\u0004\u0002$\u0002!I!!*\u0002\u0015I\fg\u000eV8p\u0019>tw\r\u0006\u0003\u0002L\u0005\u001d\u0006\u0002CA;\u0003C\u0003\r!a\u001e\t\r\u0005-\u0006\u0001\"\u0003\u001d\u0003\rygM\u001a\u0005\u0007\u0003_\u0003A\u0011\u0002\u000f\u0002\u0015A\u0014X\rR3tiJ|\u0017\u0010\u000b\u0003\u0002.\u0006M\u0006\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\u000bC:tw\u000e^1uS>t'BAA_\u0003\u0015Q\u0017M^1y\u0013\u0011\t\t-a.\u0003\u0015A\u0013X\rR3tiJ|\u0017\u0010")
public interface ArchivingScheduleService
extends Logging {
    public void com$xebialabs$xlrelease$service$ArchivingScheduleService$_setter_$isCancelRequested_$eq(AtomicBoolean var1);

    public void com$xebialabs$xlrelease$service$ArchivingScheduleService$_setter_$archiveInProgressLock_$eq(Object var1);

    public ArchivingSettingsManager archivingConfig();

    public ArchivingService archivingService();

    public Attachments attachments();

    public DependencyService dependencyService();

    public Releases releases();

    public ArchivingReleasesStrategy strategy();

    public Teams teams();

    public AtomicBoolean isCancelRequested();

    public Object archiveInProgressLock();

    public void doArchiveExpiredReleasesAction(Function0<BoxedUnit> var1);

    public static /* synthetic */ String getArchivingJobCronSchedule$(ArchivingScheduleService $this) {
        return $this.getArchivingJobCronSchedule();
    }

    default public String getArchivingJobCronSchedule() {
        return this.archivingConfig().getArchivingJobCronSchedule();
    }

    public static /* synthetic */ void archiveExpiredReleases$(ArchivingScheduleService $this, Integer releaseAgeToArchive) {
        $this.archiveExpiredReleases(releaseAgeToArchive);
    }

    default public void archiveExpiredReleases(Integer releaseAgeToArchive) {
        if (this.archivingConfig().getEnabled()) {
            long startArchiving = System.currentTimeMillis();
            Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving completed releases older than ", " hours (completed before ", ")..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseAgeToArchive, expirationDate})));
            Object object = this.archiveInProgressLock();
            synchronized (object) {
                this.doArchiveExpiredReleasesAction((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    int archivedReleasesCount = this.findAndProcessArchivableReleases(expirationDate, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                        this.processRelease(s);
                        return BoxedUnit.UNIT;
                    });
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivedReleasesCount), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startArchiving))})));
                });
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Archiving is not enabled.");
        }
    }

    public static /* synthetic */ void archiveExpiredReleases$(ArchivingScheduleService $this) {
        $this.archiveExpiredReleases();
    }

    default public void archiveExpiredReleases() {
        this.archiveExpiredReleases(this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    private void postProcessArchivedRelease(String releaseId) {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long s = System.currentTimeMillis();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Post processing archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
            this.strategy().postProcessArchivedRelease(releaseId);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Post processed archived release [", "] in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - s))})));
        }).recover((PartialFunction)new scala.Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete release [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.releaseId$2, exception.getMessage()})), (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$2 = releaseId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$postProcessArchivedRelease$4 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int findAndProcessArchivableReleases(Date date, Function1<String, BoxedUnit> action) {
        AtomicInteger count;
        block3: {
            long runStartTimeMillis = System.currentTimeMillis();
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int archivingPageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " completed or aborted releases from repository"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivingPageSize)})));
                Seq<String> releaseIds = this.strategy().findArchivableReleases(date, archivingPageSize);
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{date})));
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, action)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed only ", " finished releases on this page: we're done."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size())})));
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ", fetching the next ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.get()), date, BoxesRunTime.boxToInteger((int)archivingPageSize)})));
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.get()), date})));
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Function1<String, BoxedUnit> action) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
                ArchivingScheduleService.$anonfun$processReleases$1(this, count, runStartTimeMillis, action, object, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void processRelease(String releaseId) {
        WorkDirContext.initWorkdir();
        try {
            this.archiveCompletedRelease(releaseId).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.postProcessArchivedRelease(releaseId);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            WorkDirContext.get().delete();
            WorkDirContext.clear();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Completed cleanup after the archiving");
        }
    }

    private Try<BoxedUnit> archiveCompletedRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.archivingService().exists(releaseId)) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                long s = System.currentTimeMillis();
                Release release = this.releases().findById(releaseId);
                release.setTeams(this.teams().getEffectiveTeams(release));
                this.dependencyService().archiveAllOutgoingDependencies(release);
                Buffer releaseAttachments = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).map((Function1 & Serializable & scala.Serializable)attachment -> this.attachments().findById(attachment.getId()), Buffer$.MODULE$.canBuildFrom());
                this.archivingService().archiveRelease(release, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(releaseAttachments).asJava());
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived release [", "] in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - s))})));
            } else {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release [", "] was already archived before, skipping the archiving"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
            }
        }).recoverWith((PartialFunction)new scala.Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not archive release [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.releaseId$3, exception.getMessage()})), (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$3 = releaseId$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$archiveCompletedRelease$6 java.lang.Exception ), $anonfun$applyOrElse$4(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) > 0 ? Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) : 20;
    }

    private void sleepIfNeeded() {
        block2: {
            if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) <= 0) break block2;
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds before archiving the next release"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archivingConfig().getSleepSecondsBetweenReleases()})));
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds was interrupted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archivingConfig().getSleepSecondsBetweenReleases()})));
            }
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) > 0 ? System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) * 1000) : false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Waiting until no archiving is in progress");
        Object object = this.archiveInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Archiving done, destroying ArchivingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static /* synthetic */ void $anonfun$processReleases$1(ArchivingScheduleService $this, AtomicInteger count$2, long runStartTimeMillis$1, Function1 action$1, Object nonLocalReturnKey1$1, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (count$2.get() > 0) {
            $this.sleepIfNeeded();
        }
        action$1.apply((Object)releaseId);
        count$2.incrementAndGet();
        if ($this.ranTooLong(runStartTimeMillis$1)) {
            $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving paused because it ran for more than ", " seconds. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.archivingConfig().getMaxSecondsPerRun()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving will continue in the next run"})).s((Seq)Nil$.MODULE$));
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    public static void $init$(ArchivingScheduleService $this) {
        $this.com$xebialabs$xlrelease$service$ArchivingScheduleService$_setter_$isCancelRequested_$eq(new AtomicBoolean(false));
        $this.com$xebialabs$xlrelease$service$ArchivingScheduleService$_setter_$archiveInProgressLock_$eq(new Object());
    }
}

