/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.CreatedFromTemplate;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.Imported;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseCreateCommand;
import com.xebialabs.xlrelease.repository.ReleaseDeleteCommand;
import com.xebialabs.xlrelease.repository.ReleaseDuplicateCommand;
import com.xebialabs.xlrelease.repository.ReleaseExistsQuery;
import com.xebialabs.xlrelease.repository.ReleaseFindByCalendarTokenQuery;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseGetStatusQuery;
import com.xebialabs.xlrelease.repository.ReleaseGetTitleQuery;
import com.xebialabs.xlrelease.repository.ReleaseIdsByStatusesQuery;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseUpdateCommand;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.Variables;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyArchivingStrategy;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Releases {
    private static final Logger logger = LoggerFactory.getLogger(Releases.class);
    private XlrRepository xlrRepository;
    private XlrQueries xlrQueries;
    private CiIdService ciIdService;
    private ArchivingService archivingService;
    private Teams teams;
    private Variables variables;
    private InternalMetadataDecoratorService decoratorService;
    private XLReleaseEventBus eventBus;
    private ReleaseSearchService releaseSearchService;
    private DependencyArchivingStrategy dependencyArchivingStrategy;

    @Autowired
    public Releases(XlrRepository xlrRepository, XlrQueries xlrQueries, CiIdService ciIdService, ArchivingService archivingService, Teams teams, Variables variables, InternalMetadataDecoratorService decoratorService, XLReleaseEventBus eventBus, ReleaseSearchService releaseSearchService, DependencyArchivingStrategy dependencyArchivingStrategy) {
        this.xlrRepository = xlrRepository;
        this.xlrQueries = xlrQueries;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.teams = teams;
        this.variables = variables;
        this.decoratorService = decoratorService;
        this.eventBus = eventBus;
        this.releaseSearchService = releaseSearchService;
        this.dependencyArchivingStrategy = dependencyArchivingStrategy;
    }

    @Timed
    public boolean exists(String id) {
        return this.xlrQueries.query(new ReleaseExistsQuery(id));
    }

    @Timed
    public Release createWithoutTemplate(Release release) {
        String releaseId = this.ciIdService.getGloballyUniqueId(release.getType(), Ids.ROOT_FOLDER_ID);
        release.setId(releaseId);
        release.setStatus(ReleaseStatus.PLANNED);
        this.initReleaseCalendar(release);
        logger.info("Creating empty release " + releaseId);
        VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        return this.xlrRepository.handle(new ReleaseCreateCommand(release, (ReleaseCreationSource)new CreatedWithoutTemplate()));
    }

    @Timed
    public Release createFromTemplate(String templateId, Release releaseMetadata, boolean createdFromTrigger) {
        WorkDirContext.initWorkdir((String)"artifact");
        return (Release)WorkDirTemplate.cleanOnFinally(workDir -> {
            Release release = this.xlrRepository.handle(new ReleaseGetCommand(templateId, Integer.MAX_VALUE, false, workDir));
            this.teams.decorateWithStoredTeams(release);
            this.resolveAttachmentFiles(release);
            Date templateReferenceDate = release.getScheduledStartDate();
            this.setReleaseProperties(release, releaseMetadata, templateId, createdFromTrigger);
            this.checkRequiredOnReleaseStartVariables(release);
            String releaseId = this.rewriteWithNewId(release);
            if (templateReferenceDate == null) {
                templateReferenceDate = this.findFirstStartDate(release);
            }
            if (templateReferenceDate != null) {
                int offsetSeconds = Seconds.secondsBetween((ReadableInstant)new DateTime((Object)templateReferenceDate), (ReadableInstant)new DateTime((Object)release.getScheduledStartDate())).getSeconds();
                release.moveChildren(offsetSeconds);
            }
            release.getReleaseTriggers().clear();
            this.removeTemplateOwnerTeams(release);
            Optional<Team> teamToBeUpdated = this.configureAdminTeam(release);
            release.clearComments();
            logger.info("Creating new release " + releaseId + " from template " + templateId);
            release = this.xlrRepository.handle(new ReleaseCreateCommand(release, (ReleaseCreationSource)new CreatedFromTemplate(templateId)));
            if (teamToBeUpdated.isPresent()) {
                this.eventBus.publish((XLReleaseEvent)new TeamUpdatedEvent(release, teamToBeUpdated.get(), release.getAdminTeam()));
            }
            release.getTeams().forEach(team -> team.setId(null));
            this.teams.saveTeamsToPlatform(release);
            this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new CreatedFromTemplate(templateId)));
            this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(release.getTeams()));
            return release;
        });
    }

    private void resolveAttachmentFiles(Release release) {
        if (release.getAttachments() != null) {
            for (Attachment attachment : release.getAttachments()) {
                if (attachment.getFile() == null) continue;
                attachment.getFile().getPath();
            }
        }
    }

    private Optional<Team> configureAdminTeam(Release release) {
        Team team = release.getAdminTeam();
        if (team != null && release.getOwner() != null) {
            Team teamToBeUpdated = CiCloneHelper.cloneCi(team);
            team.addMember(release.getOwner());
            return Optional.of(teamToBeUpdated);
        }
        return Optional.empty();
    }

    private void removeTemplateOwnerTeams(Release release) {
        release.getTeams().removeIf(team -> com.google.common.base.Objects.equal((Object)team.getTeamName(), (Object)"Template Owner"));
    }

    private void checkRequiredOnReleaseStartVariables(Release release) {
        for (Variable variable : release.getVariables()) {
            if (!variable.getRequiresValue() || !variable.getShowOnReleaseStart()) continue;
            Preconditions.checkArgument((!variable.isValueEmpty() ? 1 : 0) != 0, (Object)String.format("Variable ${%s} is not provided", variable.getKey()));
        }
    }

    private Date findFirstStartDate(Release template) {
        Date result = null;
        List children = template.getChildren();
        for (PlanItem item : children) {
            Date itemStartDate = item.getScheduledStartDate();
            if (result != null && (itemStartDate == null || !itemStartDate.before(result))) continue;
            result = itemStartDate;
        }
        return result;
    }

    @Timed
    public Release createTemplate(Release template) {
        return this.createTemplate(template, null);
    }

    @Timed
    public Release createTemplate(Release template, String parentId) {
        template.setId(this.ciIdService.getGloballyUniqueId(template.getType(), parentId != null ? parentId : Ids.ROOT_FOLDER_ID));
        template.setStatus(ReleaseStatus.TEMPLATE);
        VariablePersistenceHelper.scanAndBuildNewVariables(template, (VisitableItem)template, this.ciIdService);
        template = this.xlrRepository.handle(new ReleaseCreateCommand(template, null));
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(template, null));
        this.teams.decorateWithEffectiveTeams(template);
        this.decoratorService.decorate((ConfigurationItem)template, Arrays.asList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        return template;
    }

    @Timed
    public Release copyTemplate(String templateId, Release template, boolean userHasPermissionToEditTemplate) {
        template.checkDatesValidityForTemplate();
        Release newTemplate = this.findById(templateId);
        this.rewriteWithNewId(newTemplate);
        newTemplate.setTitle(template.getTitle());
        newTemplate.setDescription(template.getDescription());
        newTemplate.setRunningTriggeredReleasesCount(0);
        newTemplate.setScriptUsername(template.getScriptUsername());
        newTemplate.setScriptUserPassword(template.getScriptUserPassword());
        for (ReleaseTrigger releaseTrigger : newTemplate.getReleaseTriggers()) {
            releaseTrigger.resetExecutionId();
            releaseTrigger.setEnabled(false);
        }
        List<Variable> newVariables = VariablePersistenceHelper.scanAndBuildNewVariables(newTemplate, (VisitableItem)newTemplate, this.ciIdService);
        if (!userHasPermissionToEditTemplate) {
            this.clearPasswordVariables(newTemplate);
            newTemplate.setScriptUserPassword(null);
            this.clearPasswordFields(newTemplate);
            this.clearTriggerPasswords(newTemplate);
        }
        newTemplate.getTeams().stream().filter(team -> team.getTeamName().equals("Template Owner")).forEach(ownerTeam -> ownerTeam.addMember(Permissions.getAuthenticatedUserName()));
        newTemplate.getTeams().forEach(t -> t.setId(null));
        Release savedTemplate = this.xlrRepository.handle(new ReleaseDuplicateCommand(templateId, newTemplate, newVariables));
        savedTemplate.getTeams().forEach(team -> team.setId(null));
        this.teams.saveTeamsToPlatform(savedTemplate);
        this.teams.decorateWithStoredTeams(savedTemplate);
        this.decoratorService.decorate((ConfigurationItem)savedTemplate, Collections.singletonList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES()));
        this.eventBus.publish((XLReleaseEvent)new ReleaseDuplicatedEvent(savedTemplate));
        return savedTemplate;
    }

    private Changes clearPasswordVariables(Release release) {
        Changes changes = new Changes();
        ArrayList copiedVariables = new ArrayList(release.getVariables());
        copiedVariables.stream().filter(Variable::isPassword).forEach(variable -> {
            ((PasswordStringVariable)variable).setValue(null);
            changes.update((ConfigurationItem)variable);
        });
        return changes;
    }

    private Changes clearTriggerPasswords(Release release) {
        Changes changes = new Changes();
        List releaseTriggers = release.getReleaseTriggers();
        releaseTriggers.forEach(trigger -> {
            changes.addAll(this.clearTriggerVariables((ReleaseTrigger)trigger));
            changes.addAll(this.clearTriggerPasswordFields((ReleaseTrigger)trigger));
        });
        return changes;
    }

    private Changes clearTriggerPasswordFields(ReleaseTrigger trigger) {
        Changes changes = new Changes();
        trigger.getType().getDescriptor().getPropertyDescriptors().stream().filter(PropertyDescriptor::isPassword).forEach(pd -> {
            if (null != trigger.getProperty(pd.getName())) {
                trigger.setProperty(pd.getName(), (Object)"");
                changes.update((ConfigurationItem)trigger);
            }
        });
        return changes;
    }

    private Changes clearTriggerVariables(ReleaseTrigger trigger) {
        Changes changes = new Changes();
        ArrayList copiedVariables = new ArrayList(trigger.getVariables());
        copiedVariables.stream().filter(Variable::isPassword).forEach(variable -> {
            ((PasswordStringVariable)variable).setValue(null);
            changes.update((ConfigurationItem)variable);
        });
        return changes;
    }

    private Changes clearPasswordFields(Release release) {
        Changes changes = new Changes();
        String flagComment = "Password was cleared when this template was copied.";
        release.getAllTasks().forEach(task -> {
            task.getTaskType().getDescriptor().getPropertyDescriptors().stream().filter(PropertyDescriptor::isPassword).forEach(pd -> {
                if (null != pd.get((ConfigurationItem)task)) {
                    task.setProperty(pd.getName(), (Object)"");
                    task.setFlagStatus(FlagStatus.ATTENTION_NEEDED);
                    task.setFlagComment("Password was cleared when this template was copied.");
                    changes.update((ConfigurationItem)task);
                }
            });
            if (task instanceof CustomScriptTask) {
                PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
                pythonScript.getInputProperties().stream().filter(PropertyDescriptor::isPassword).forEach(pd -> {
                    if (null != pd.get((ConfigurationItem)pythonScript)) {
                        pythonScript.setProperty(pd.getName(), (Object)"");
                        task.setFlagStatus(FlagStatus.ATTENTION_NEEDED);
                        task.setFlagComment("Password was cleared when this template was copied.");
                        changes.update((ConfigurationItem)pythonScript);
                        changes.update((ConfigurationItem)task);
                    }
                });
            }
        });
        return changes;
    }

    private void setReleaseProperties(Release newRelease, Release releaseMetadata, String originTemplateId, boolean createdFromTrigger) {
        newRelease.setStatus(ReleaseStatus.PLANNED);
        newRelease.setDescription(releaseMetadata.getDescription());
        newRelease.setTitle(releaseMetadata.getTitle());
        newRelease.setScheduledStartDate(releaseMetadata.getScheduledStartDate());
        newRelease.setDueDate(releaseMetadata.getDueDate());
        newRelease.setPlannedDuration(releaseMetadata.getPlannedDuration());
        newRelease.setOwner(releaseMetadata.hasOwner() ? releaseMetadata.getOwner() : Permissions.getAuthenticatedUserName());
        newRelease.setAutoStart(releaseMetadata.isAutoStart());
        if (releaseMetadata.getTags() != null) {
            newRelease.setTags(releaseMetadata.getTags());
        }
        newRelease.setFlagStatus(releaseMetadata.getFlagStatus());
        newRelease.setFlagComment(releaseMetadata.getFlagComment());
        newRelease.setOriginTemplateId(originTemplateId);
        newRelease.setCreatedFromTrigger(createdFromTrigger);
        newRelease.setScriptUsername(releaseMetadata.getScriptUsername());
        newRelease.setScriptUserPassword(releaseMetadata.getScriptUserPassword());
        newRelease.setStartedFromTaskId(releaseMetadata.getStartedFromTaskId());
        newRelease.setRootReleaseId(releaseMetadata.getRootReleaseId());
        this.initReleaseCalendar(newRelease);
        newRelease.setVariables(releaseMetadata.getVariables());
        newRelease.scanAndAddNewVariables();
        VariablePersistenceHelper.fixUpVariableIds(originTemplateId, newRelease.getVariables(), this.ciIdService);
    }

    private void initReleaseCalendar(Release newRelease) {
        Long token = UUID.randomUUID().getMostSignificantBits();
        newRelease.setCalendarLinkToken(token.toString());
        newRelease.setCalendarPublished(false);
    }

    @Timed
    public List<String> findReleaseIdsByStatus(ReleaseStatus ... statuses) {
        return this.xlrQueries.query(new ReleaseIdsByStatusesQuery(statuses));
    }

    @Timed
    public Release containingTask(String taskId) {
        return this.findByIdIncludingArchived(Ids.releaseIdFrom((String)taskId));
    }

    @Timed
    public Release containingTeam(String teamId) {
        return this.findByIdIncludingArchived(Ids.releaseIdFrom((String)teamId));
    }

    @Timed
    public Release findById(String releaseId) {
        return this.findById(releaseId, false);
    }

    @Timed
    public Release findById(String releaseId, boolean useCache) {
        return this.findById(releaseId, null, useCache);
    }

    @Timed
    public Release findById(String releaseId, WorkDir workDir, boolean useCache) {
        Release release = this.xlrRepository.handle(new ReleaseGetCommand(releaseId, Integer.MAX_VALUE, useCache, workDir));
        this.teams.decorateWithStoredTeams(release);
        this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        return release;
    }

    @Timed
    public Release findByIdInArchive(String releaseId) {
        Release release = this.archivingService.getRelease(releaseId);
        this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        return release;
    }

    @Timed
    public Release findByIdIncludingArchived(String releaseId) {
        if (this.exists(releaseId)) {
            return this.findById(releaseId);
        }
        if (this.archivingService.exists(releaseId)) {
            return this.findByIdInArchive(releaseId);
        }
        throw new NotFoundException(String.format("Release [%s] does not exist in the repository or archive. It may have been moved or deleted", releaseId), new Object[0]);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Release release = this.xlrQueries.query(new ReleaseFindByCalendarTokenQuery(calendarToken));
        if (release != null) {
            this.decoratorService.decorate((ConfigurationItem)release, Collections.singletonList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES()));
        }
        return release;
    }

    @Timed
    public boolean templateExistsWithTitle(String title) {
        Page queryPage = new Page(0L, 1L, 1);
        ReleaseStatus[] statuses = new ReleaseStatus[]{ReleaseStatus.TEMPLATE};
        List<Release> templates = this.xlrQueries.query(new ReleaseSearchByParams(queryPage, null, statuses, title, null, null, false));
        return !templates.isEmpty();
    }

    @Timed
    public List<Release> findTemplatesByTitle(String folderId, String templateTitle, int page, int resultsPerPage, int depth) {
        Page queryPage = new Page(page, resultsPerPage, depth);
        ReleaseStatus[] templates = new ReleaseStatus[]{ReleaseStatus.TEMPLATE};
        return this.xlrQueries.query(new ReleaseSearchByParams(queryPage, folderId, templates, templateTitle, null, null, false));
    }

    @Timed
    public List<Release> findReleasesByTitle(String folderId, String templateTitle, int page, int resultsPerPage, int depth) {
        Page queryPage = new Page(page, resultsPerPage, depth);
        ReleaseStatus[] activeOrPlannedReleases = EnumSet.of(ReleaseStatus.PLANNED, ReleaseStatus.ACTIVE_STATUSES).toArray(new ReleaseStatus[0]);
        List<Release> releases = this.xlrQueries.query(new ReleaseSearchByParams(queryPage, folderId, activeOrPlannedReleases, templateTitle, null, null, false));
        this.decoratorService.decorate(releases, Arrays.asList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        return releases;
    }

    @Timed
    public List<Release> findSpawnedReleases(String rootReleaseId, int maxConcurrency) {
        Page queryPage = new Page(0L, maxConcurrency + 2, 0);
        ReleaseStatus[] finishedReleases = EnumSet.complementOf(EnumSet.of(ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED)).toArray(new ReleaseStatus[2]);
        return this.xlrQueries.query(new ReleaseSearchByParams(queryPage, null, finishedReleases, null, rootReleaseId, null, false));
    }

    @Timed
    public void importTemplate(Release template, String parentId) {
        String string = parentId = Ids.isNullId((String)parentId) ? Ids.ROOT_FOLDER_ID : parentId;
        if (this.canKeepImportedId(template.getId(), parentId)) {
            logger.debug("Kept imported template ID {} because it does not exist in the repository", (Object)template.getId());
        } else {
            String originalId = template.getId();
            this.rewriteWithNewId(template, parentId);
            logger.debug("Rewritten imported template ID {} to {} because the original ID already exists in the repository or was not in the same folder", (Object)originalId, (Object)template.getId());
        }
        VariablePersistenceHelper.scanAndBuildNewVariables(template, (VisitableItem)template, this.ciIdService);
        template = this.xlrRepository.handle(new ReleaseCreateCommand(template, (ReleaseCreationSource)new Imported()));
        if (Ids.isRoot((String)parentId)) {
            template.getTeams().forEach(team -> team.setId(null));
            this.teams.saveTeamsToPlatform(template);
        }
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(template, (ReleaseCreationSource)new Imported()));
    }

    @VisibleForTesting
    boolean canKeepImportedId(String templateId, String parentId) {
        if (Ids.isNullId((String)templateId) || !Ids.isReleaseId((String)templateId)) {
            return false;
        }
        if (!Ids.getParentId((String)templateId).equals(parentId)) {
            return false;
        }
        String name = Ids.getName((String)templateId);
        return !this.releaseSearchService.existsByName(name) && !this.archivingService.existsByName(name);
    }

    @Timed
    public void importTemplate(Release template) {
        this.importTemplate(template, null);
    }

    @Timed
    public void deleteTemplate(String templateId) {
        Preconditions.checkArgument((boolean)Ids.isReleaseId((String)templateId), (Object)"You must provide a template id");
        Release template = this.xlrRepository.handle(new ReleaseGetCommand(templateId, 1, true, null));
        Preconditions.checkArgument((boolean)template.isTemplate(), (Object)"You must provide a template id");
        this.xlrRepository.handle(new ReleaseDeleteCommand(templateId));
        this.eventBus.publish((XLReleaseEvent)new ReleaseDeletedEvent(template));
    }

    @Timed
    public void delete(String releaseId) {
        Preconditions.checkArgument((boolean)Ids.isReleaseId((String)releaseId), (Object)"You must provide a release id");
        Release releaseWithStatus = this.xlrRepository.handle(new ReleaseGetCommand(releaseId, 1, false, null));
        Preconditions.checkArgument((boolean)releaseWithStatus.isDefunct(), (Object)("Release " + releaseId + " must be in a final state if it needs to be deleted"));
        try {
            this.xlrRepository.handle(new ReleaseDeleteCommand(releaseId));
        }
        catch (ItemInUseException e) {
            logger.trace(String.format("Archiving incoming dependencies for release [%s]", releaseId));
            this.dependencyArchivingStrategy.archiveAllIncomingDependencies(releaseId);
            this.xlrRepository.handle(new ReleaseDeleteCommand(releaseId));
        }
        this.eventBus.publish((XLReleaseEvent)new ReleaseDeletedEvent(releaseWithStatus));
    }

    private String rewriteWithNewId(Release release) {
        return this.rewriteWithNewId(release, Ids.getParentId((String)release.getId()));
    }

    private String rewriteWithNewId(Release release, String withParentId) {
        String newReleaseId = this.ciIdService.getGloballyUniqueId(release.getType(), withParentId);
        CiHelper.rewriteWithNewId((ConfigurationItem)release, (String)newReleaseId);
        return newReleaseId;
    }

    @Timed
    public void checkNotArchived(String ciId) {
        this.archivingService.checkNotArchived(ciId);
    }

    @Timed
    public boolean isArchived(String releaseId) {
        return this.archivingService.exists(releaseId);
    }

    @Timed
    public ReleaseStatus getStatus(String releaseId) {
        String status = this.xlrQueries.query(new ReleaseGetStatusQuery(releaseId));
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals((Object)this.getStatus(releaseId));
    }

    @Timed
    public String getTitle(String id) {
        try {
            return this.xlrQueries.query(new ReleaseGetTitleQuery(id));
        }
        catch (NotFoundException ignored) {
            if (this.archivingService.exists(id)) {
                return this.archivingService.getReleaseTitle(id);
            }
            throw new NotFoundException(String.format("Release [%s] does not exist in the repository or archive. It may have been moved or deleted", id), new Object[0]);
        }
    }

    @Timed
    public void notifyOverdueRelease(Release release) {
        this.eventBus.publish((XLReleaseEvent)new ReleaseOverdueEvent(release));
        Release original = CiCloneHelper.cloneCi(release);
        release.setOverdueNotified(true);
        this.xlrRepository.handle(new ReleaseUpdateCommand(original, release, Collections.emptyList()));
    }

    @Timed
    public void updateReleaseProperties(Release original, Release updated) {
        this.xlrRepository.handle(new ReleaseUpdateCommand(original, updated, Collections.emptyList()));
    }

    @Timed
    public Release updateRelease(String releaseId, Release toUpdate) {
        Release updated = this.findById(releaseId);
        Preconditions.checkArgument((boolean)updated.isUpdatable(), (String)"Can't update release '%s' because it is %s.", (Object[])new Object[]{updated.getTitle(), updated.getStatus()});
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(updated, toUpdate), (String)"Can't update scheduled start date on a release '%s' because it has already started.", (Object[])new Object[]{updated.getTitle()});
        Preconditions.checkArgument((boolean)this.isStartAtScheduledStartDateUpdatable(updated, toUpdate), (String)"Can't set start on scheduled start date on release '%s' because it has already started.", (Object[])new Object[]{updated.getTitle()});
        Release original = CiCloneHelper.cloneCi(updated);
        if (toUpdate.getTitle() != null) {
            Preconditions.checkArgument((!toUpdate.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Release title is required.");
            updated.setTitle(toUpdate.getTitle());
        }
        updated.setAutoStart(toUpdate.isAutoStart());
        if (toUpdate.getDescription() != null) {
            updated.setDescription(toUpdate.getDescription());
        }
        updated.updateDatesForRelease(toUpdate.getScheduledStartDate(), toUpdate.getDueDate(), toUpdate.getPlannedDuration());
        if (toUpdate.getDueDate() != null) {
            updated.setDueDate(toUpdate.getDueDate());
        }
        if (toUpdate.getScheduledStartDate() != null) {
            updated.setScheduledStartDate(toUpdate.getScheduledStartDate());
        }
        if (toUpdate.hasOwner()) {
            Preconditions.checkArgument((!toUpdate.getOwner().isEmpty() ? 1 : 0) != 0, (Object)"Release owner is required.");
            updated.setOwner(toUpdate.getOwner());
        }
        updated.setScriptUsername(toUpdate.getScriptUsername());
        updated.setScriptUserPassword(toUpdate.getScriptUserPassword());
        if (toUpdate.getTags() != null) {
            updated.setTags(toUpdate.getTags());
        }
        if (toUpdate.getFlagStatus() != null) {
            updated.setFlagStatus(toUpdate.getFlagStatus());
        }
        if (toUpdate.getFlagComment() != null) {
            updated.setFlagComment(toUpdate.getFlagComment());
        }
        updated.updateRealFlagStatus();
        updated.setCalendarPublished(toUpdate.isCalendarPublished());
        updated.setAbortOnFailure(toUpdate.isAbortOnFailure());
        updated.setAllowConcurrentReleasesFromTrigger(toUpdate.isAllowConcurrentReleasesFromTrigger());
        updated.setOverdueNotified(false);
        this.updateVariables(toUpdate, updated);
        this.xlrRepository.handle(new ReleaseUpdateCommand(original, updated, updated.getVariables()));
        this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedEvent(original, updated));
        return updated;
    }

    private void updateVariables(Release toUpdate, Release updated) {
        updated.scanAndAddNewVariables();
        Map isPasswordPartitioned = toUpdate.getVariablesByKeys().entrySet().stream().collect(Collectors.partitioningBy(e -> ((Variable)e.getValue()).isPassword(), com.xebialabs.xlrelease.utils.Collectors.toMap(Map.Entry::getKey, r -> ((Variable)r.getValue()).getValue())));
        updated.setVariableValues((Map)isPasswordPartitioned.get(false));
        updated.setPasswordVariableValues((Map)isPasswordPartitioned.get(true));
        VariablePersistenceHelper.fixUpVariableIds(updated.getId(), updated.getVariables(), this.ciIdService);
    }

    private boolean isScheduledStartDateUpdatable(Release original, Release updated) {
        return !original.hasBeenStarted() || Objects.equals(original.getScheduledStartDate(), updated.getScheduledStartDate());
    }

    private boolean isStartAtScheduledStartDateUpdatable(Release original, Release updated) {
        return !original.hasBeenStarted() || original.isAutoStart() == updated.isAutoStart();
    }

    @Timed
    public Release updateTemplate(String templateId, Release toUpdate) {
        Release updated = this.findById(templateId);
        Release original = CiCloneHelper.cloneCi(updated);
        if (toUpdate.getTitle() != null) {
            Preconditions.checkArgument((!toUpdate.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Template title is required.");
            updated.setTitle(toUpdate.getTitle());
        }
        if (toUpdate.getDescription() != null) {
            updated.setDescription(toUpdate.getDescription());
        }
        updated.setTags(toUpdate.getTags());
        updated.updateDatesForTemplate(toUpdate.getScheduledStartDate(), toUpdate.getDueDate(), toUpdate.getPlannedDuration());
        updated.setAbortOnFailure(toUpdate.isAbortOnFailure());
        updated.setAllowConcurrentReleasesFromTrigger(toUpdate.isAllowConcurrentReleasesFromTrigger());
        updated.setScriptUsername(toUpdate.getScriptUsername());
        updated.setScriptUserPassword(toUpdate.getScriptUserPassword());
        List newVariables = updated.scanAndAddNewVariables();
        VariablePersistenceHelper.fixUpVariableIds(updated.getId(), newVariables, this.ciIdService);
        this.xlrRepository.handle(new ReleaseUpdateCommand(original, updated, newVariables));
        this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedEvent(original, updated));
        return updated;
    }

    @Timed
    public Release updateReleaseVariables(String releaseId, List<Variable> variableList) {
        Release release = this.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update release '%s' because it is %s.", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        return this.variables.updateReleaseVariables(release, variableList);
    }
}

