/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.xlrelease.builder.LinkBuilder;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.LinkCreatedEvent;
import com.xebialabs.xlrelease.domain.events.LinkDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.LinkCreateCommand;
import com.xebialabs.xlrelease.repository.LinkDeleteCommand;
import com.xebialabs.xlrelease.repository.LinkGetCommand;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Option;

@Repository
public class Links {
    private static final Logger logger = LoggerFactory.getLogger(Links.class);
    private CiIdService ciIdService;
    private XlrRepository xlrRepository;
    private Tasks tasks;
    private XLReleaseEventBus eventBus;

    @Autowired
    public Links(CiIdService ciIdService, XlrRepository xlrRepository, Tasks tasks, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.xlrRepository = xlrRepository;
        this.tasks = tasks;
        this.eventBus = eventBus;
    }

    @Timed
    public Link create(String containerId, String sourceId, String targetId) {
        Task container = this.tasks.getTaskWithoutDecoration(containerId);
        Task source = this.tasks.getTaskWithoutDecoration(sourceId);
        Task target = this.tasks.getTaskWithoutDecoration(targetId);
        Link link = LinkBuilder.newLink().withId(this.ciIdService.getUniqueId(Type.valueOf(Link.class), containerId)).withSource(source).withTarget(target).build();
        Preconditions.checkArgument((boolean)(container instanceof ParallelGroup), (Object)"You can't add a link to a container that's not a parallel group.");
        Preconditions.checkState((!container.hasBeenStarted() ? 1 : 0) != 0, (Object)"You can't add a link to a container that has already been started.");
        Preconditions.checkState((boolean)this.uniqueLinkWithinContainer(container, link), (Object)"You can't add the same link twice within a parallel group.");
        Preconditions.checkArgument((boolean)source.getContainer().equals(container), (Object)"You can't add a link whose source isn't a direct child of the container.");
        Preconditions.checkArgument((boolean)target.getContainer().equals(container), (Object)"You can't add a link whose target isn't a direct child of the container.");
        ((ParallelGroup)container).getLinks().add(link);
        link.setParallelGroup((ParallelGroup)container);
        this.xlrRepository.handle(new LinkCreateCommand(link));
        this.eventBus.publish((XLReleaseEvent)new LinkCreatedEvent(link));
        return link;
    }

    @Timed
    public void delete(String linkId) {
        try {
            Link link = this.xlrRepository.handle(new LinkGetCommand(linkId));
            ParallelGroup parallelGroup = link.getParallelGroup();
            Preconditions.checkState((!parallelGroup.hasBeenStarted() ? 1 : 0) != 0, (Object)"Can't remove a link from a container that has already been started");
            Task target = link.getTarget();
            ArrayList<Object> events = new ArrayList<Object>();
            ChangeSet changeSet = new ChangeSet();
            changeSet.delete((ConfigurationItem)link);
            events.add(new LinkDeletedEvent(link));
            boolean isTargetNeedUpdate = !target.isWaitForScheduledStartDate();
            Task targetToUpdate = null;
            if (isTargetNeedUpdate) {
                Task original = CiCloneHelper.cloneCi(target);
                target.setWaitForScheduledStartDate(true);
                changeSet.update((ConfigurationItem)target);
                targetToUpdate = target;
                events.add(new TaskUpdatedEvent(original, target));
            }
            link.getParallelGroup().getLinks().remove(link);
            this.xlrRepository.handle(new LinkDeleteCommand(link, (Option<Task>)Option.apply((Object)targetToUpdate)));
            events.forEach(this.eventBus::publish);
        }
        catch (NotFoundException e) {
            logger.debug(String.format("Link with id %s not found in repository, skipping delete", linkId));
        }
    }

    private boolean uniqueLinkWithinContainer(Task container, Link newLink) {
        Set links = ((ParallelGroup)container).getLinks();
        for (Link link : links) {
            if (!Objects.equals(newLink.getSource(), link.getSource()) || !Objects.equals(newLink.getTarget(), link.getTarget())) continue;
            return false;
        }
        return true;
    }
}

