/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Configurations {
    public static final String CUSTOM_CONFIGURATION_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Custom";
    private RepositoryService repositoryService;
    private CiIdService ciIdService;

    @Autowired
    public Configurations(RepositoryService repositoryService, CiIdService ciIdService) {
        this.repositoryService = repositoryService;
        this.ciIdService = ciIdService;
    }

    public Configuration findById(String configurationInstanceId) {
        return (Configuration)this.repositoryService.read(configurationInstanceId);
    }

    public List<Configuration> findAll() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Configuration.class));
        return this.repositoryService.listEntities(query);
    }

    public List<Configuration> searchByTypeAndTitle(Type configurationType, String title) {
        return this.searchByTypeAndTitle(configurationType, title, 100L);
    }

    public List<Configuration> searchByTypeAndTitle(Type configurationType, String title, long resultsPerPage) {
        boolean typeIsConfiguration = configurationType.isSubTypeOf(Type.valueOf(Configuration.class));
        if (!typeIsConfiguration) {
            throw new IllegalArgumentException(String.format("Type '%s' is not Configuration sub-type", configurationType));
        }
        SearchParameters query = new SearchParameters().setType(configurationType).setPage(0L).setResultsPerPage(resultsPerPage).setDepth(1);
        if (Strings.isNotEmpty((String)title)) {
            query.addProperty("title", title);
        }
        return this.repositoryService.listEntities(query);
    }

    public List<Descriptor> findAllConfigurationDescriptors() {
        Type configurationType = Type.valueOf(Configuration.class);
        Collection allTypes = DescriptorRegistry.getSubtypes((Type)configurationType);
        ArrayList<Descriptor> result = new ArrayList<Descriptor>();
        for (Type type : allTypes) {
            if (type.getDescriptor().isVirtual()) continue;
            result.add(type.getDescriptor());
        }
        return result;
    }

    public Configuration updateWith(String configurationInstanceId, Configuration configuration) {
        configuration.setId(configurationInstanceId);
        this.repositoryService.update((ConfigurationItem[])new Configuration[]{configuration});
        return configuration;
    }

    public Configuration create(Configuration configuration) {
        String id = this.getUniqueId(CUSTOM_CONFIGURATION_ROOT);
        configuration.setId(id);
        this.repositoryService.create((ConfigurationItem[])new Configuration[]{configuration});
        return configuration;
    }

    public void delete(String configurationInstanceId) {
        this.repositoryService.delete(new String[]{configurationInstanceId});
    }

    public String getUniqueId(String parentId) {
        return this.ciIdService.getGloballyUniqueId(Type.valueOf(Configuration.class), parentId);
    }
}

