/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.userinput;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TaskPollingView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class UserInputTaskViewConverter
extends BaseTaskViewConverter<UserInputTask> {
    @Override
    public TaskFullView toFullView(UserInputTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setVariables(task.getVariables());
        return v;
    }

    @Override
    public TaskPollingView toPollView(UserInputTask task) {
        TaskPollingView view = super.toPollView(task);
        view.setHasEmptyVariables(task.getVariables().stream().anyMatch(Variable::isValueEmpty));
        return view;
    }

    @Override
    protected UserInputTask fromView(TaskFullView view) {
        return TaskBuilder.newUserInputTask().withVariables(view.getVariables()).build();
    }

    @Override
    protected Class<UserInputTask> getTaskClass() {
        return UserInputTask.class;
    }
}

